#!/usr/local/bin/python3.8
# -*- coding: utf-8 -*-
# Copyright 2019 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for vyos_firewall_global
"""

from __future__ import absolute_import, division, print_function

__metaclass__ = type


DOCUMENTATION = """
module: vyos_firewall_global
short_description: FIREWALL global resource module
description: This module manage global policies or configurations for firewall on
  VyOS devices.
version_added: 1.0.0
notes:
- Tested against VyOS 1.1.8 (helium).
- This module works with connection C(network_cli). See L(the VyOS OS Platform Options,../network/user_guide/platform_vyos.html).
author:
- Rohit Thakur (@rohitthakur2590)
options:
  config:
    description:
    - A dictionary of Firewall global configuration options.
    type: dict
    suboptions:
      route_redirects:
        description: -A dictionary of Firewall icmp redirect and source route global
          configuration options.
        type: list
        elements: dict
        suboptions:
          afi:
            description:
            - Specifies IP address type
            type: str
            choices:
            - ipv4
            - ipv6
            required: true
          icmp_redirects:
            description:
            - Specifies whether to allow sending/receiving of IPv4/v6 ICMP redirect
              messages.
            type: dict
            suboptions:
              send:
                description:
                - Permits or denies transmitting packets ICMP redirect messages.
                type: bool
              receive:
                description:
                - Permits or denies receiving packets ICMP redirect messages.
                type: bool
          ip_src_route:
            description:
            - Specifies whether or not to process source route IP options.
            type: bool
      ping:
        description:
        - Policy for handling of all IPv4 ICMP echo requests.
        type: dict
        suboptions:
          all:
            description:
            - Enables or disables response to all IPv4 ICMP Echo Request (ping) messages.
            - The system responds to IPv4 ICMP Echo Request messages.
            type: bool
          broadcast:
            description:
            - Enables or disables response to broadcast IPv4 ICMP Echo Request and
              Timestamp Request messages.
            - IPv4 ICMP Echo and Timestamp Request messages are not processed.
            type: bool
      config_trap:
        description:
        - SNMP trap generation on firewall configuration changes.
        type: bool
      validation:
        description:
        - Specifies a policy for source validation by reversed path, as defined in
          RFC 3704.
        - (disable) No source validation is performed.
        - (loose) Enable Loose Reverse Path Forwarding as defined in RFC3704.
        - (strict) Enable Strict Reverse Path Forwarding as defined in RFC3704.
        type: str
        choices:
        - strict
        - loose
        - disable
      group:
        description:
        - Defines a group of objects for referencing in firewall rules.
        type: dict
        suboptions:
          address_group:
            description:
            - Defines a group of IP addresses for referencing in firewall rules.
            type: list
            elements: dict
            suboptions:
              afi:
                description:
                - Specifies IP address type
                type: str
                default: ipv4
                choices:
                - ipv4
                - ipv6
                required: false
              name:
                description:
                - Name of the firewall address group.
                type: str
                required: true
              description:
                description:
                - Allows you to specify a brief description for the address group.
                type: str
              members:
                description:
                - Address-group members.
                - IPv4 address to match.
                - IPv4 range to match.
                type: list
                elements: dict
                suboptions:
                  address:
                    description: IP address.
                    type: str
          network_group:
            description:
            - Defines a group of networks for referencing in firewall rules.
            type: list
            elements: dict
            suboptions:
              afi:
                description:
                - Specifies network address type
                type: str
                default: ipv4
                choices:
                - ipv4
                - ipv6
                required: false
              name:
                description:
                - Name of the firewall network group.
                type: str
                required: true
              description:
                description:
                - Allows you to specify a brief description for the network group.
                type: str
              members:
                description:
                - Adds an IPv4 network to the specified network group.
                - The format is ip-address/prefix.
                type: list
                elements: dict
                suboptions:
                  address:
                    description: IP address.
                    type: str
          port_group:
            description:
            - Defines a group of ports for referencing in firewall rules.
            type: list
            elements: dict
            suboptions:
              name:
                description:
                - Name of the firewall port group.
                type: str
                required: true
              description:
                description:
                - Allows you to specify a brief description for the port group.
                type: str
              members:
                description:
                - Port-group member.
                type: list
                elements: dict
                suboptions:
                  port:
                    description: Defines the number.
                    type: str
      log_martians:
        description:
        - Specifies whether or not to record packets with invalid addresses in the
          log.
        - (True) Logs packets with invalid addresses.
        - (False) Does not log packets with invalid addresses.
        type: bool
      syn_cookies:
        description:
        - Specifies policy for using TCP SYN cookies with IPv4.
        - (True) Enables TCP SYN cookies with IPv4.
        - (False) Disables TCP SYN cookies with IPv4.
        type: bool
      twa_hazards_protection:
        description:
        - RFC1337 TCP TIME-WAIT assassination hazards protection.
        type: bool
      state_policy:
        description:
        - Specifies global firewall state-policy.
        type: list
        elements: dict
        suboptions:
          connection_type:
            description: Specifies connection type.
            type: str
            choices:
            - established
            - invalid
            - related
          action:
            description:
            - Action for packets part of an established connection.
            type: str
            choices:
            - accept
            - drop
            - reject
          log:
            description:
            - Enable logging of packets part of an established connection.
            type: bool
  running_config:
    description:
    - The module, by default, will connect to the remote device and retrieve the current
      running-config to use as a base for comparing against the contents of source.
      There are times when it is not desirable to have the task get the current running-config
      for every task in a playbook.  The I(running_config) argument allows the implementer
      to pass in the configuration to use as the base config for comparison. This
      value of this option should be the output received from device by executing
      command C(show configuration commands | grep 'firewall')
    type: str
  state:
    description:
    - The state the configuration should be left in.
    type: str
    choices:
    - merged
    - replaced
    - deleted
    - gathered
    - rendered
    - parsed
    default: merged

"""
EXAMPLES = """
# Using merged
#
# Before state:
# -------------
#
# vyos@vyos# run show  configuration commands | grep firewall
#
#
- name: Merge the provided configuration with the existing running configuration
  vyos.vyos.vyos_firewall_global:
    config:
      validation: strict
      config_trap: true
      log_martians: true
      syn_cookies: true
      twa_hazards_protection: true
      ping:
        all: true
        broadcast: true
      state_policy:
      - connection_type: established
        action: accept
        log: true
      - connection_type: invalid
        action: reject
      route_redirects:
      - afi: ipv4
        ip_src_route: true
        icmp_redirects:
          send: true
          receive: false
      group:
        address_group:
        - name: MGMT-HOSTS
          description: This group has the Management hosts address list
          members:
          - address: 192.0.1.1
          - address: 192.0.1.3
          - address: 192.0.1.5
        network_group:
        - name: MGMT
          description: This group has the Management network addresses
          members:
          - address: 192.0.1.0/24
    state: merged
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
# before": []
#
#    "commands": [
#        "set firewall group address-group MGMT-HOSTS address 192.0.1.1",
#        "set firewall group address-group MGMT-HOSTS address 192.0.1.3",
#        "set firewall group address-group MGMT-HOSTS address 192.0.1.5",
#        "set firewall group address-group MGMT-HOSTS description 'This group has the Management hosts address list'",
#        "set firewall group address-group MGMT-HOSTS",
#        "set firewall group network-group MGMT network 192.0.1.0/24",
#        "set firewall group network-group MGMT description 'This group has the Management network addresses'",
#        "set firewall group network-group MGMT",
#        "set firewall ip-src-route 'enable'",
#        "set firewall receive-redirects 'disable'",
#        "set firewall send-redirects 'enable'",
#        "set firewall config-trap 'enable'",
#        "set firewall state-policy established action 'accept'",
#        "set firewall state-policy established log 'enable'",
#        "set firewall state-policy invalid action 'reject'",
#        "set firewall broadcast-ping 'enable'",
#        "set firewall all-ping 'enable'",
#        "set firewall log-martians 'enable'",
#        "set firewall twa-hazards-protection 'enable'",
#        "set firewall syn-cookies 'enable'",
#        "set firewall source-validation 'strict'"
#    ]
#
# "after": {
#        "config_trap": true,
#        "group": {
#            "address_group": [
#                {
#                    "description": "This group has the Management hosts address list",
#                    "members": [
#                        {
#                            "address": "192.0.1.1"
#                        },
#                        {
#                            "address": "192.0.1.3"
#                        },
#                        {
#                            "address": "192.0.1.5"
#                        }
#                    ],
#                    "name": "MGMT-HOSTS"
#                }
#            ],
#            "network_group": [
#                {
#                    "description": "This group has the Management network addresses",
#                    "members": [
#                        {
#                            "address": "192.0.1.0/24"
#                        }
#                    ],
#                    "name": "MGMT"
#                }
#            ]
#        },
#        "log_martians": true,
#        "ping": {
#            "all": true,
#            "broadcast": true
#        },
#        "route_redirects": [
#            {
#                "afi": "ipv4",
#                "icmp_redirects": {
#                    "receive": false,
#                    "send": true
#                },
#                "ip_src_route": true
#            }
#        ],
#        "state_policy": [
#            {
#                "action": "accept",
#                "connection_type": "established",
#                "log": true
#            },
#            {
#                "action": "reject",
#                "connection_type": "invalid"
#            }
#        ],
#        "syn_cookies": true,
#        "twa_hazards_protection": true,
#        "validation": "strict"
#    }
#
# After state:
# -------------
#
# vyos@192# run show configuration commands | grep firewall
# set firewall all-ping 'enable'
# set firewall broadcast-ping 'enable'
# set firewall config-trap 'enable'
# set firewall group address-group MGMT-HOSTS address '192.0.1.1'
# set firewall group address-group MGMT-HOSTS address '192.0.1.3'
# set firewall group address-group MGMT-HOSTS address '192.0.1.5'
# set firewall group address-group MGMT-HOSTS description 'This group has the Management hosts address list'
# set firewall group network-group MGMT description 'This group has the Management network addresses'
# set firewall group network-group MGMT network '192.0.1.0/24'
# set firewall ip-src-route 'enable'
# set firewall log-martians 'enable'
# set firewall receive-redirects 'disable'
# set firewall send-redirects 'enable'
# set firewall source-validation 'strict'
# set firewall state-policy established action 'accept'
# set firewall state-policy established log 'enable'
# set firewall state-policy invalid action 'reject'
# set firewall syn-cookies 'enable'
# set firewall twa-hazards-protection 'enable'
#
#
# Using parsed
#
#
- name: Render the commands for provided  configuration
  vyos.vyos.vyos_firewall_global:
    running_config:
      "set firewall all-ping 'enable'
       set firewall broadcast-ping 'enable'
       set firewall config-trap 'enable'
       set firewall group address-group ENG-HOSTS address '192.0.3.1'
       set firewall group address-group ENG-HOSTS address '192.0.3.2'
       set firewall group address-group ENG-HOSTS description 'Sales office hosts address list'
       set firewall group address-group SALES-HOSTS address '192.0.2.1'
       set firewall group address-group SALES-HOSTS address '192.0.2.2'
       set firewall group address-group SALES-HOSTS address '192.0.2.3'
       set firewall group address-group SALES-HOSTS description 'Sales office hosts address list'
       set firewall group network-group MGMT description 'This group has the Management network addresses'
       set firewall group network-group MGMT network '192.0.1.0/24'
       set firewall ip-src-route 'enable'
       set firewall log-martians 'enable'
       set firewall receive-redirects 'disable'
       set firewall send-redirects 'enable'
       set firewall source-validation 'strict'
       set firewall state-policy established action 'accept'
       set firewall state-policy established log 'enable'
       set firewall state-policy invalid action 'reject'
       set firewall syn-cookies 'enable'
       set firewall twa-hazards-protection 'enable'"
    state: parsed
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#
# "parsed": {
#        "config_trap": true,
#        "group": {
#            "address_group": [
#                {
#                    "description": "Sales office hosts address list",
#                    "members": [
#                        {
#                            "address": "192.0.3.1"
#                        },
#                        {
#                            "address": "192.0.3.2"
#                        }
#                    ],
#                    "name": "ENG-HOSTS"
#                },
#                {
#                    "description": "Sales office hosts address list",
#                    "members": [
#                        {
#                            "address": "192.0.2.1"
#                        },
#                        {
#                            "address": "192.0.2.2"
#                        },
#                        {
#                            "address": "192.0.2.3"
#                        }
#                    ],
#                    "name": "SALES-HOSTS"
#                }
#            ],
#            "network_group": [
#                {
#                    "description": "This group has the Management network addresses",
#                    "members": [
#                        {
#                            "address": "192.0.1.0/24"
#                        }
#                    ],
#                    "name": "MGMT"
#                }
#            ]
#        },
#        "log_martians": true,
#        "ping": {
#            "all": true,
#            "broadcast": true
#        },
#        "route_redirects": [
#            {
#                "afi": "ipv4",
#                "icmp_redirects": {
#                    "receive": false,
#                    "send": true
#                },
#                "ip_src_route": true
#            }
#        ],
#        "state_policy": [
#            {
#                "action": "accept",
#                "connection_type": "established",
#                "log": true
#            },
#            {
#                "action": "reject",
#                "connection_type": "invalid"
#            }
#        ],
#        "syn_cookies": true,
#        "twa_hazards_protection": true,
#        "validation": "strict"
#    }
# }
#
#
# Using deleted
#
# Before state
# -------------
#
# vyos@192# run show configuration commands | grep firewall
# set firewall all-ping 'enable'
# set firewall broadcast-ping 'enable'
# set firewall config-trap 'enable'
# set firewall group address-group MGMT-HOSTS address '192.0.1.1'
# set firewall group address-group MGMT-HOSTS address '192.0.1.3'
# set firewall group address-group MGMT-HOSTS address '192.0.1.5'
# set firewall group address-group MGMT-HOSTS description 'This group has the Management hosts address list'
# set firewall group network-group MGMT description 'This group has the Management network addresses'
# set firewall group network-group MGMT network '192.0.1.0/24'
# set firewall ip-src-route 'enable'
# set firewall log-martians 'enable'
# set firewall receive-redirects 'disable'
# set firewall send-redirects 'enable'
# set firewall source-validation 'strict'
# set firewall state-policy established action 'accept'
# set firewall state-policy established log 'enable'
# set firewall state-policy invalid action 'reject'
# set firewall syn-cookies 'enable'
# set firewall twa-hazards-protection 'enable'
- name: Delete attributes of firewall.
  vyos.vyos.vyos_firewall_global:
    config:
      state_policy:
      config_trap:
      log_martians:
      syn_cookies:
      twa_hazards_protection:
      route_redirects:
      ping:
      group:
    state: deleted
#
#
# ------------------------
# Module Execution Results
# ------------------------
#
#    "before": {
#        "config_trap": true,
#        "group": {
#            "address_group": [
#                {
#                    "description": "This group has the Management hosts address list",
#                    "members": [
#                        {
#                            "address": "192.0.1.1"
#                        },
#                        {
#                            "address": "192.0.1.3"
#                        },
#                        {
#                            "address": "192.0.1.5"
#                        }
#                    ],
#                    "name": "MGMT-HOSTS"
#                }
#            ],
#            "network_group": [
#                {
#                    "description": "This group has the Management network addresses",
#                    "members": [
#                        {
#                            "address": "192.0.1.0/24"
#                        }
#                    ],
#                    "name": "MGMT"
#                }
#            ]
#        },
#        "log_martians": true,
#        "ping": {
#            "all": true,
#            "broadcast": true
#        },
#        "route_redirects": [
#            {
#                "afi": "ipv4",
#                "icmp_redirects": {
#                    "receive": false,
#                    "send": true
#                },
#                "ip_src_route": true
#            }
#        ],
#        "state_policy": [
#            {
#                "action": "accept",
#                "connection_type": "established",
#                "log": true
#            },
#            {
#                "action": "reject",
#                "connection_type": "invalid"
#            }
#        ],
#        "syn_cookies": true,
#        "twa_hazards_protection": true,
#        "validation": "strict"
#    }
# "commands": [
#        "delete firewall source-validation",
#        "delete firewall group",
#        "delete firewall log-martians",
#        "delete firewall ip-src-route",
#        "delete firewall receive-redirects",
#        "delete firewall send-redirects",
#        "delete firewall config-trap",
#        "delete firewall state-policy",
#        "delete firewall syn-cookies",
#        "delete firewall broadcast-ping",
#        "delete firewall all-ping",
#        "delete firewall twa-hazards-protection"
#    ]
#
# "after": []
# After state
# ------------
# vyos@192# run show configuration commands | grep firewall
# set  'firewall'
#
#
# Using replaced
#
# Before state:
# -------------
#
# vyos@vyos:~$ show configuration commands| grep firewall
# set firewall all-ping 'enable'
# set firewall broadcast-ping 'enable'
# set firewall config-trap 'enable'
# set firewall group address-group MGMT-HOSTS address '192.0.1.1'
# set firewall group address-group MGMT-HOSTS address '192.0.1.3'
# set firewall group address-group MGMT-HOSTS address '192.0.1.5'
# set firewall group address-group MGMT-HOSTS description 'This group has the Management hosts address list'
# set firewall group network-group MGMT description 'This group has the Management network addresses'
# set firewall group network-group MGMT network '192.0.1.0/24'
# set firewall ip-src-route 'enable'
# set firewall log-martians 'enable'
# set firewall receive-redirects 'disable'
# set firewall send-redirects 'enable'
# set firewall source-validation 'strict'
# set firewall state-policy established action 'accept'
# set firewall state-policy established log 'enable'
# set firewall state-policy invalid action 'reject'
# set firewall syn-cookies 'enable'
# set firewall twa-hazards-protection 'enable'
#
- name: Replace firewall global attributes configuration.
  vyos.vyos.vyos_firewall_global:
    config:
      validation: strict
      config_trap: true
      log_martians: true
      syn_cookies: true
      twa_hazards_protection: true
      ping:
      all: true
      broadcast: true
      state_policy:
      - connection_type: established
        action: accept
        log: true
      - connection_type: invalid
        action: reject
      route_redirects:
      - afi: ipv4
        ip_src_route: true
        icmp_redirects:
          send: true
          receive: false
      group:
        address_group:
        - name: SALES-HOSTS
          description: Sales office hosts address list
          members:
          - address: 192.0.2.1
          - address: 192.0.2.2
          - address: 192.0.2.3
        - name: ENG-HOSTS
          description: Sales office hosts address list
          members:
          - address: 192.0.3.1
          - address: 192.0.3.2
        network_group:
        - name: MGMT
          description: This group has the Management network addresses
          members:
          - address: 192.0.1.0/24
    state: replaced
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#    "before": {
#        "config_trap": true,
#        "group": {
#            "address_group": [
#                {
#                    "description": "This group has the Management hosts address list",
#                    "members": [
#                        {
#                            "address": "192.0.1.1"
#                        },
#                        {
#                            "address": "192.0.1.3"
#                        },
#                        {
#                            "address": "192.0.1.5"
#                        }
#                    ],
#                    "name": "MGMT-HOSTS"
#                }
#            ],
#            "network_group": [
#                {
#                    "description": "This group has the Management network addresses",
#                    "members": [
#                        {
#                            "address": "192.0.1.0/24"
#                        }
#                    ],
#                    "name": "MGMT"
#                }
#            ]
#        },
#        "log_martians": true,
#        "ping": {
#            "all": true,
#            "broadcast": true
#        },
#        "route_redirects": [
#            {
#                "afi": "ipv4",
#                "icmp_redirects": {
#                    "receive": false,
#                    "send": true
#                },
#                "ip_src_route": true
#            }
#        ],
#        "state_policy": [
#            {
#                "action": "accept",
#                "connection_type": "established",
#                "log": true
#            },
#            {
#                "action": "reject",
#                "connection_type": "invalid"
#            }
#        ],
#        "syn_cookies": true,
#        "twa_hazards_protection": true,
#        "validation": "strict"
#    }
#
# "commands": [
#        "delete firewall group address-group MGMT-HOSTS",
#        "set firewall group address-group SALES-HOSTS address 192.0.2.1",
#        "set firewall group address-group SALES-HOSTS address 192.0.2.2",
#        "set firewall group address-group SALES-HOSTS address 192.0.2.3",
#        "set firewall group address-group SALES-HOSTS description 'Sales office hosts address list'",
#        "set firewall group address-group SALES-HOSTS",
#        "set firewall group address-group ENG-HOSTS address 192.0.3.1",
#        "set firewall group address-group ENG-HOSTS address 192.0.3.2",
#        "set firewall group address-group ENG-HOSTS description 'Sales office hosts address list'",
#        "set firewall group address-group ENG-HOSTS"
#    ]
#
#    "after": {
#        "config_trap": true,
#        "group": {
#            "address_group": [
#                {
#                    "description": "Sales office hosts address list",
#                    "members": [
#                        {
#                            "address": "192.0.3.1"
#                        },
#                        {
#                            "address": "192.0.3.2"
#                        }
#                    ],
#                    "name": "ENG-HOSTS"
#                },
#                {
#                    "description": "Sales office hosts address list",
#                    "members": [
#                        {
#                            "address": "192.0.2.1"
#                        },
#                        {
#                            "address": "192.0.2.2"
#                        },
#                        {
#                            "address": "192.0.2.3"
#                        }
#                    ],
#                   "name": "SALES-HOSTS"
#                }
#            ],
#            "network_group": [
#                {
#                    "description": "This group has the Management network addresses",
#                    "members": [
#                        {
#                            "address": "192.0.1.0/24"
#                        }
#                    ],
#                    "name": "MGMT"
#                }
#            ]
#        },
#        "log_martians": true,
#        "ping": {
#            "all": true,
#            "broadcast": true
#        },
#        "route_redirects": [
#            {
#                "afi": "ipv4",
#                "icmp_redirects": {
#                    "receive": false,
#                    "send": true
#                },
#                "ip_src_route": true
#            }
#        ],
#        "state_policy": [
#            {
#                "action": "accept",
#                "connection_type": "established",
#                "log": true
#            },
#            {
#                "action": "reject",
#                "connection_type": "invalid"
#            }
#        ],
#        "syn_cookies": true,
#        "twa_hazards_protection": true,
#        "validation": "strict"
#    }
#
# After state:
# -------------
#
# vyos@192# run show configuration commands | grep firewall
# set firewall all-ping 'enable'
# set firewall broadcast-ping 'enable'
# set firewall config-trap 'enable'
# set firewall group address-group ENG-HOSTS address '192.0.3.1'
# set firewall group address-group ENG-HOSTS address '192.0.3.2'
# set firewall group address-group ENG-HOSTS description 'Sales office hosts address list'
# set firewall group address-group SALES-HOSTS address '192.0.2.1'
# set firewall group address-group SALES-HOSTS address '192.0.2.2'
# set firewall group address-group SALES-HOSTS address '192.0.2.3'
# set firewall group address-group SALES-HOSTS description 'Sales office hosts address list'
# set firewall group network-group MGMT description 'This group has the Management network addresses'
# set firewall group network-group MGMT network '192.0.1.0/24'
# set firewall ip-src-route 'enable'
# set firewall log-martians 'enable'
# set firewall receive-redirects 'disable'
# set firewall send-redirects 'enable'
# set firewall source-validation 'strict'
# set firewall state-policy established action 'accept'
# set firewall state-policy established log 'enable'
# set firewall state-policy invalid action 'reject'
# set firewall syn-cookies 'enable'
# set firewall twa-hazards-protection 'enable'
#
#
# Using gathered
#
# Before state:
# -------------
#
# vyos@192# run show configuration commands | grep firewall
# set firewall all-ping 'enable'
# set firewall broadcast-ping 'enable'
# set firewall config-trap 'enable'
# set firewall group address-group ENG-HOSTS address '192.0.3.1'
# set firewall group address-group ENG-HOSTS address '192.0.3.2'
# set firewall group address-group ENG-HOSTS description 'Sales office hosts address list'
# set firewall group address-group SALES-HOSTS address '192.0.2.1'
# set firewall group address-group SALES-HOSTS address '192.0.2.2'
# set firewall group address-group SALES-HOSTS address '192.0.2.3'
# set firewall group address-group SALES-HOSTS description 'Sales office hosts address list'
# set firewall group network-group MGMT description 'This group has the Management network addresses'
# set firewall group network-group MGMT network '192.0.1.0/24'
# set firewall ip-src-route 'enable'
# set firewall log-martians 'enable'
# set firewall receive-redirects 'disable'
# set firewall send-redirects 'enable'
# set firewall source-validation 'strict'
# set firewall state-policy established action 'accept'
# set firewall state-policy established log 'enable'
# set firewall state-policy invalid action 'reject'
# set firewall syn-cookies 'enable'
# set firewall twa-hazards-protection 'enable'
#
- name: Gather firewall global config with provided configurations
  vyos.vyos.vyos_firewall_global:
    config:
    state: gathered
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#    "gathered": [
# {
#        "config_trap": true,
#        "group": {
#            "address_group": [
#                {
#                    "description": "Sales office hosts address list",
#                    "members": [
#                        {
#                            "address": "192.0.3.1"
#                        },
#                        {
#                            "address": "192.0.3.2"
#                        }
#                    ],
#                    "name": "ENG-HOSTS"
#                },
#                {
#                    "description": "Sales office hosts address list",
#                    "members": [
#                        {
#                            "address": "192.0.2.1"
#                        },
#                        {
#                            "address": "192.0.2.2"
#                        },
#                        {
#                            "address": "192.0.2.3"
#                        }
#                    ],
#                    "name": "SALES-HOSTS"
#                }
#            ],
#            "network_group": [
#                {
#                    "description": "This group has the Management network addresses",
#                    "members": [
#                        {
#                            "address": "192.0.1.0/24"
#                        }
#                    ],
#                    "name": "MGMT"
#                }
#            ]
#        },
#        "log_martians": true,
#        "ping": {
#            "all": true,
#            "broadcast": true
#        },
#        "route_redirects": [
#            {
#                "afi": "ipv4",
#                "icmp_redirects": {
#                    "receive": false,
#                    "send": true
#                },
#                "ip_src_route": true
#            }
#        ],
#        "state_policy": [
#            {
#                "action": "accept",
#                "connection_type": "established",
#                "log": true
#            },
#            {
#                "action": "reject",
#                "connection_type": "invalid"
#            }
#        ],
#        "syn_cookies": true,
#        "twa_hazards_protection": true,
#        "validation": "strict"
#    }
#
# After state:
# -------------
#
# vyos@192# run show configuration commands | grep firewall
# set firewall all-ping 'enable'
# set firewall broadcast-ping 'enable'
# set firewall config-trap 'enable'
# set firewall group address-group ENG-HOSTS address '192.0.3.1'
# set firewall group address-group ENG-HOSTS address '192.0.3.2'
# set firewall group address-group ENG-HOSTS description 'Sales office hosts address list'
# set firewall group address-group SALES-HOSTS address '192.0.2.1'
# set firewall group address-group SALES-HOSTS address '192.0.2.2'
# set firewall group address-group SALES-HOSTS address '192.0.2.3'
# set firewall group address-group SALES-HOSTS description 'Sales office hosts address list'
# set firewall group network-group MGMT description 'This group has the Management network addresses'
# set firewall group network-group MGMT network '192.0.1.0/24'
# set firewall ip-src-route 'enable'
# set firewall log-martians 'enable'
# set firewall receive-redirects 'disable'
# set firewall send-redirects 'enable'
# set firewall source-validation 'strict'
# set firewall state-policy established action 'accept'
# set firewall state-policy established log 'enable'
# set firewall state-policy invalid action 'reject'
# set firewall syn-cookies 'enable'
# set firewall twa-hazards-protection 'enable'


# Using rendered
#
#
- name: Render the commands for provided  configuration
  vyos.vyos.vyos_firewall_global:
    config:
      validation: strict
      config_trap: true
      log_martians: true
      syn_cookies: true
      twa_hazards_protection: true
      ping:
      all: true
      broadcast: true
      state_policy:
      - connection_type: established
        action: accept
        log: true
      - connection_type: invalid
        action: reject
      route_redirects:
      - afi: ipv4
        ip_src_route: true
        icmp_redirects:
        send: true
        receive: false
      group:
        address_group:
        - name: SALES-HOSTS
          description: Sales office hosts address list
          members:
          - address: 192.0.2.1
          - address: 192.0.2.2
          - address: 192.0.2.3
        - name: ENG-HOSTS
          description: Sales office hosts address list
          members:
          - address: 192.0.3.1
          - address: 192.0.3.2
        network_group:
        - name: MGMT
          description: This group has the Management network addresses
          members:
          - address: 192.0.1.0/24
    state: rendered
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#
# "rendered": [
#        "set firewall group address-group SALES-HOSTS address 192.0.2.1",
#        "set firewall group address-group SALES-HOSTS address 192.0.2.2",
#        "set firewall group address-group SALES-HOSTS address 192.0.2.3",
#        "set firewall group address-group SALES-HOSTS description 'Sales office hosts address list'",
#        "set firewall group address-group SALES-HOSTS",
#        "set firewall group address-group ENG-HOSTS address 192.0.3.1",
#        "set firewall group address-group ENG-HOSTS address 192.0.3.2",
#        "set firewall group address-group ENG-HOSTS description 'Sales office hosts address list'",
#        "set firewall group address-group ENG-HOSTS",
#        "set firewall group network-group MGMT network 192.0.1.0/24",
#        "set firewall group network-group MGMT description 'This group has the Management network addresses'",
#        "set firewall group network-group MGMT",
#        "set firewall ip-src-route 'enable'",
#        "set firewall receive-redirects 'disable'",
#        "set firewall send-redirects 'enable'",
#        "set firewall config-trap 'enable'",
#        "set firewall state-policy established action 'accept'",
#        "set firewall state-policy established log 'enable'",
#        "set firewall state-policy invalid action 'reject'",
#        "set firewall broadcast-ping 'enable'",
#        "set firewall all-ping 'enable'",
#        "set firewall log-martians 'enable'",
#        "set firewall twa-hazards-protection 'enable'",
#        "set firewall syn-cookies 'enable'",
#        "set firewall source-validation 'strict'"
#    ]
#
#
"""
RETURN = """
before:
  description: The configuration prior to the model invocation.
  returned: always
  type: list
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
after:
  description: The resulting configuration model invocation.
  returned: when changed
  type: list
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample: ['set firewall group address-group ENG-HOSTS',
           'set firewall group address-group ENG-HOSTS address 192.0.3.1']
"""


from ansible.module_utils.basic import AnsibleModule
from ansible_collections.vyos.vyos.plugins.module_utils.network.vyos.argspec.firewall_global.firewall_global import (
    Firewall_globalArgs,
)
from ansible_collections.vyos.vyos.plugins.module_utils.network.vyos.config.firewall_global.firewall_global import (
    Firewall_global,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]
    mutually_exclusive = [("config", "running_config")]
    module = AnsibleModule(
        argument_spec=Firewall_globalArgs.argument_spec,
        required_if=required_if,
        supports_check_mode=True,
        mutually_exclusive=mutually_exclusive,
    )

    result = Firewall_global(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
