"""Generated message classes for cloudbuild version v1.

Creates and manages builds on Google Cloud Platform.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudbuild'


class ApprovalConfig(_messages.Message):
  r"""ApprovalConfig describes configuration for manual approval of a build.

  Fields:
    approvalRequired: Whether or not approval is needed. If this is set on a
      build, it will become pending when created, and will need to be
      explicitly approved to start.
  """

  approvalRequired = _messages.BooleanField(1)


class ApprovalResult(_messages.Message):
  r"""ApprovalResult describes the decision and associated metadata of a
  manual approval of a build.

  Enums:
    DecisionValueValuesEnum: Required. The decision of this manual approval.

  Fields:
    approvalTime: Output only. The time when the approval decision was made.
    approverAccount: Output only. Email of the user that called the
      ApproveBuild API to approve or reject a build at the time that the API
      was called (the user's actual email that is tied to their GAIA ID may
      have changed). This field is not stored, rather, it is calculated on the
      fly using approver_id.
    comment: Optional. An optional comment for this manual approval result.
    decision: Required. The decision of this manual approval.
    url: Optional. An optional URL tied to this manual approval result. This
      field is essentially the same as comment, except that it will be
      rendered by the UI differently. An example use case is a link to an
      external job that approved this Build.
  """

  class DecisionValueValuesEnum(_messages.Enum):
    r"""Required. The decision of this manual approval.

    Values:
      DECISION_UNSPECIFIED: Default enum type. This should not be used.
      APPROVED: Build is approved.
      REJECTED: Build is rejected.
    """
    DECISION_UNSPECIFIED = 0
    APPROVED = 1
    REJECTED = 2

  approvalTime = _messages.StringField(1)
  approverAccount = _messages.StringField(2)
  comment = _messages.StringField(3)
  decision = _messages.EnumField('DecisionValueValuesEnum', 4)
  url = _messages.StringField(5)


class ApproveBuildRequest(_messages.Message):
  r"""Request to approve or reject a pending build.

  Fields:
    approvalResult: Approval decision and metadata.
  """

  approvalResult = _messages.MessageField('ApprovalResult', 1)


class ArtifactObjects(_messages.Message):
  r"""Files in the workspace to upload to Cloud Storage upon successful
  completion of all build steps.

  Fields:
    location: Cloud Storage bucket and optional object path, in the form
      "gs://bucket/path/to/somewhere/". (see [Bucket Name
      Requirements](https://cloud.google.com/storage/docs/bucket-
      naming#requirements)). Files in the workspace matching any path pattern
      will be uploaded to Cloud Storage with this location as a prefix.
    paths: Path globs used to match files in the build's workspace.
    timing: Output only. Stores timing information for pushing all artifact
      objects.
  """

  location = _messages.StringField(1)
  paths = _messages.StringField(2, repeated=True)
  timing = _messages.MessageField('TimeSpan', 3)


class ArtifactResult(_messages.Message):
  r"""An artifact that was uploaded during a build. This is a single record in
  the artifact manifest JSON file.

  Fields:
    fileHash: The file hash of the artifact.
    location: The path of an artifact in a Google Cloud Storage bucket, with
      the generation number. For example,
      `gs://mybucket/path/to/output.jar#generation`.
  """

  fileHash = _messages.MessageField('FileHashes', 1, repeated=True)
  location = _messages.StringField(2)


class Artifacts(_messages.Message):
  r"""Artifacts produced by a build that should be uploaded upon successful
  completion of all build steps.

  Fields:
    images: A list of images to be pushed upon the successful completion of
      all build steps. The images will be pushed using the builder service
      account's credentials. The digests of the pushed images will be stored
      in the Build resource's results field. If any of the images fail to be
      pushed, the build is marked FAILURE.
    objects: A list of objects to be uploaded to Cloud Storage upon successful
      completion of all build steps. Files in the workspace matching specified
      paths globs will be uploaded to the specified Cloud Storage location
      using the builder service account's credentials. The location and
      generation of the uploaded objects will be stored in the Build
      resource's results field. If any objects fail to be pushed, the build is
      marked FAILURE.
  """

  images = _messages.StringField(1, repeated=True)
  objects = _messages.MessageField('ArtifactObjects', 2)


class Build(_messages.Message):
  r"""A build resource in the Cloud Build API. At a high level, a `Build`
  describes where to find source code, how to build it (for example, the
  builder image to run on the source), and where to store the built artifacts.
  Fields can include the following variables, which will be expanded when the
  build is created: - $PROJECT_ID: the project ID of the build. - $BUILD_ID:
  the autogenerated ID of the build. - $REPO_NAME: the source repository name
  specified by RepoSource. - $BRANCH_NAME: the branch name specified by
  RepoSource. - $TAG_NAME: the tag name specified by RepoSource. -
  $REVISION_ID or $COMMIT_SHA: the commit SHA specified by RepoSource or
  resolved from the specified branch or tag. - $SHORT_SHA: first 7 characters
  of $REVISION_ID or $COMMIT_SHA.

  Enums:
    StatusValueValuesEnum: Output only. Status of the build.

  Messages:
    SubstitutionsValue: Substitutions data for `Build` resource.
    TimingValue: Output only. Stores timing information for phases of the
      build. Valid keys are: * BUILD: time to execute all build steps * PUSH:
      time to push all specified images. * FETCHSOURCE: time to fetch source.
      If the build does not specify source or images, these keys will not be
      included.

  Fields:
    approval: Output only. Describes this build's approval configuration,
      status, and result.
    artifacts: Artifacts produced by the build that should be uploaded upon
      successful completion of all build steps.
    availableSecrets: Secrets and secret environment variables.
    buildTriggerId: Output only. The ID of the `BuildTrigger` that triggered
      this build, if it was triggered automatically.
    createTime: Output only. Time at which the request to create the build was
      received.
    finishTime: Output only. Time at which execution of the build was
      finished. The difference between finish_time and start_time is the
      duration of the build's execution.
    id: Output only. Unique identifier of the build.
    images: A list of images to be pushed upon the successful completion of
      all build steps. The images are pushed using the builder service
      account's credentials. The digests of the pushed images will be stored
      in the `Build` resource's results field. If any of the images fail to be
      pushed, the build status is marked `FAILURE`.
    logUrl: Output only. URL to logs for this build in Google Cloud Console.
    logsBucket: Google Cloud Storage bucket where logs should be written (see
      [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-
      naming#requirements)). Logs file names will be of the format
      `${logs_bucket}/log-${build_id}.txt`.
    name: Output only. The 'Build' name with format:
      `projects/{project}/locations/{location}/builds/{build}`, where {build}
      is a unique identifier generated by the service.
    options: Special options for this build.
    projectId: Output only. ID of the project.
    queueTtl: TTL in queue for this build. If provided and the build is
      enqueued longer than this value, the build will expire and the build
      status will be `EXPIRED`. The TTL starts ticking from create_time.
    results: Output only. Results of the build.
    secrets: Secrets to decrypt using Cloud Key Management Service.
    serviceAccount: IAM service account whose credentials will be used at
      build runtime. Must be of the format
      `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. ACCOUNT can be email
      address or uniqueId of the service account. This field is in beta.
    source: The location of the source files to build.
    sourceProvenance: Output only. A permanent fixed identifier for source.
    startTime: Output only. Time at which execution of the build was started.
    status: Output only. Status of the build.
    statusDetail: Output only. Customer-readable message about the current
      status.
    steps: Required. The operations to be performed on the workspace.
    substitutions: Substitutions data for `Build` resource.
    tags: Tags for annotation of a `Build`. These are not docker tags.
    timeout: Amount of time that this build should be allowed to run, to
      second granularity. If this amount of time elapses, work on the build
      will cease and the build status will be `TIMEOUT`. `timeout` starts
      ticking from `startTime`. Default time is ten minutes.
    timing: Output only. Stores timing information for phases of the build.
      Valid keys are: * BUILD: time to execute all build steps * PUSH: time to
      push all specified images. * FETCHSOURCE: time to fetch source. If the
      build does not specify source or images, these keys will not be
      included.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""Output only. Status of the build.

    Values:
      STATUS_UNKNOWN: Status of the build is unknown.
      PENDING: Build has been created and is pending execution and queuing. It
        has not been queued.
      QUEUED: Build or step is queued; work has not yet begun.
      WORKING: Build or step is being executed.
      SUCCESS: Build or step finished successfully.
      FAILURE: Build or step failed to complete successfully.
      INTERNAL_ERROR: Build or step failed due to an internal cause.
      TIMEOUT: Build or step took longer than was allowed.
      CANCELLED: Build or step was canceled by a user.
      EXPIRED: Build was enqueued for longer than the value of `queue_ttl`.
    """
    STATUS_UNKNOWN = 0
    PENDING = 1
    QUEUED = 2
    WORKING = 3
    SUCCESS = 4
    FAILURE = 5
    INTERNAL_ERROR = 6
    TIMEOUT = 7
    CANCELLED = 8
    EXPIRED = 9

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SubstitutionsValue(_messages.Message):
    r"""Substitutions data for `Build` resource.

    Messages:
      AdditionalProperty: An additional property for a SubstitutionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type SubstitutionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SubstitutionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TimingValue(_messages.Message):
    r"""Output only. Stores timing information for phases of the build. Valid
    keys are: * BUILD: time to execute all build steps * PUSH: time to push
    all specified images. * FETCHSOURCE: time to fetch source. If the build
    does not specify source or images, these keys will not be included.

    Messages:
      AdditionalProperty: An additional property for a TimingValue object.

    Fields:
      additionalProperties: Additional properties of type TimingValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TimingValue object.

      Fields:
        key: Name of the additional property.
        value: A TimeSpan attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('TimeSpan', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  approval = _messages.MessageField('BuildApproval', 1)
  artifacts = _messages.MessageField('Artifacts', 2)
  availableSecrets = _messages.MessageField('Secrets', 3)
  buildTriggerId = _messages.StringField(4)
  createTime = _messages.StringField(5)
  finishTime = _messages.StringField(6)
  id = _messages.StringField(7)
  images = _messages.StringField(8, repeated=True)
  logUrl = _messages.StringField(9)
  logsBucket = _messages.StringField(10)
  name = _messages.StringField(11)
  options = _messages.MessageField('BuildOptions', 12)
  projectId = _messages.StringField(13)
  queueTtl = _messages.StringField(14)
  results = _messages.MessageField('Results', 15)
  secrets = _messages.MessageField('Secret', 16, repeated=True)
  serviceAccount = _messages.StringField(17)
  source = _messages.MessageField('Source', 18)
  sourceProvenance = _messages.MessageField('SourceProvenance', 19)
  startTime = _messages.StringField(20)
  status = _messages.EnumField('StatusValueValuesEnum', 21)
  statusDetail = _messages.StringField(22)
  steps = _messages.MessageField('BuildStep', 23, repeated=True)
  substitutions = _messages.MessageField('SubstitutionsValue', 24)
  tags = _messages.StringField(25, repeated=True)
  timeout = _messages.StringField(26)
  timing = _messages.MessageField('TimingValue', 27)


class BuildApproval(_messages.Message):
  r"""BuildApproval describes a build's approval configuration, state, and
  result.

  Enums:
    StateValueValuesEnum: Output only. The state of this build's approval.

  Fields:
    config: Output only. Configuration for manual approval of this build.
    result: Output only. Result of manual approval for this Build.
    state: Output only. The state of this build's approval.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of this build's approval.

    Values:
      STATE_UNSPECIFIED: Default enum type. This should not be used.
      PENDING: Build approval is pending.
      APPROVED: Build approval has been approved.
      REJECTED: Build approval has been rejected.
      CANCELLED: Build was cancelled while it was still pending approval.
    """
    STATE_UNSPECIFIED = 0
    PENDING = 1
    APPROVED = 2
    REJECTED = 3
    CANCELLED = 4

  config = _messages.MessageField('ApprovalConfig', 1)
  result = _messages.MessageField('ApprovalResult', 2)
  state = _messages.EnumField('StateValueValuesEnum', 3)


class BuildOperationMetadata(_messages.Message):
  r"""Metadata for build operations.

  Fields:
    build: The build that the operation is tracking.
  """

  build = _messages.MessageField('Build', 1)


class BuildOptions(_messages.Message):
  r"""Optional arguments to enable specific features of builds.

  Enums:
    LogStreamingOptionValueValuesEnum: Option to define build log streaming
      behavior to Google Cloud Storage.
    LoggingValueValuesEnum: Option to specify the logging mode, which
      determines if and where build logs are stored.
    MachineTypeValueValuesEnum: Compute Engine machine type on which to run
      the build.
    RequestedVerifyOptionValueValuesEnum: Requested verifiability options.
    SourceProvenanceHashValueListEntryValuesEnum:
    SubstitutionOptionValueValuesEnum: Option to specify behavior when there
      is an error in the substitution checks. NOTE: this is always set to
      ALLOW_LOOSE for triggered builds and cannot be overridden in the build
      configuration file.

  Fields:
    cluster: Details about how this build should be executed on a GKE cluster.
    diskSizeGb: Requested disk size for the VM that runs the build. Note that
      this is *NOT* "disk free"; some of the space will be used by the
      operating system and build utilities. Also note that this is the minimum
      disk size that will be allocated for the build -- the build may run with
      a larger disk than requested. At present, the maximum disk size is
      1000GB; builds that request more than the maximum are rejected with an
      error.
    dynamicSubstitutions: Option to specify whether or not to apply bash style
      string operations to the substitutions. NOTE: this is always enabled for
      triggered builds and cannot be overridden in the build configuration
      file.
    env: A list of global environment variable definitions that will exist for
      all build steps in this build. If a variable is defined in both globally
      and in a build step, the variable will use the build step value. The
      elements are of the form "KEY=VALUE" for the environment variable "KEY"
      being given the value "VALUE".
    logStreamingOption: Option to define build log streaming behavior to
      Google Cloud Storage.
    logging: Option to specify the logging mode, which determines if and where
      build logs are stored.
    machineType: Compute Engine machine type on which to run the build.
    requestedVerifyOption: Requested verifiability options.
    secretEnv: A list of global environment variables, which are encrypted
      using a Cloud Key Management Service crypto key. These values must be
      specified in the build's `Secret`. These variables will be available to
      all build steps in this build.
    sourceProvenanceHash: Requested hash for SourceProvenance.
    substitutionOption: Option to specify behavior when there is an error in
      the substitution checks. NOTE: this is always set to ALLOW_LOOSE for
      triggered builds and cannot be overridden in the build configuration
      file.
    volumes: Global list of volumes to mount for ALL build steps Each volume
      is created as an empty volume prior to starting the build process. Upon
      completion of the build, volumes and their contents are discarded.
      Global volume names and paths cannot conflict with the volumes defined a
      build step. Using a global volume in a build with only one step is not
      valid as it is indicative of a build request with an incorrect
      configuration.
    workerPool: Option to specify a `WorkerPool` for the build. Format:
      projects/{project}/locations/{location}/workerPools/{workerPool} This
      field is in beta and is available only to restricted users.
  """

  class LogStreamingOptionValueValuesEnum(_messages.Enum):
    r"""Option to define build log streaming behavior to Google Cloud Storage.

    Values:
      STREAM_DEFAULT: Service may automatically determine build log streaming
        behavior.
      STREAM_ON: Build logs should be streamed to Google Cloud Storage.
      STREAM_OFF: Build logs should not be streamed to Google Cloud Storage;
        they will be written when the build is completed.
    """
    STREAM_DEFAULT = 0
    STREAM_ON = 1
    STREAM_OFF = 2

  class LoggingValueValuesEnum(_messages.Enum):
    r"""Option to specify the logging mode, which determines if and where
    build logs are stored.

    Values:
      LOGGING_UNSPECIFIED: The service determines the logging mode. The
        default is `LEGACY`. Do not rely on the default logging behavior as it
        may change in the future.
      LEGACY: Cloud Logging and Cloud Storage logging are enabled.
      GCS_ONLY: Only Cloud Storage logging is enabled.
      STACKDRIVER_ONLY: This option is the same as CLOUD_LOGGING_ONLY.
      CLOUD_LOGGING_ONLY: Only Cloud Logging is enabled. Note that logs for
        both the Cloud Console UI and Cloud SDK are based on Cloud Storage
        logs, so neither will provide logs if this option is chosen.
      NONE: Turn off all logging. No build logs will be captured.
    """
    LOGGING_UNSPECIFIED = 0
    LEGACY = 1
    GCS_ONLY = 2
    STACKDRIVER_ONLY = 3
    CLOUD_LOGGING_ONLY = 4
    NONE = 5

  class MachineTypeValueValuesEnum(_messages.Enum):
    r"""Compute Engine machine type on which to run the build.

    Values:
      UNSPECIFIED: Standard machine type.
      N1_HIGHCPU_8: Highcpu machine with 8 CPUs.
      N1_HIGHCPU_32: Highcpu machine with 32 CPUs.
      E2_HIGHCPU_8: Highcpu e2 machine with 8 CPUs.
      E2_HIGHCPU_32: Highcpu e2 machine with 32 CPUs.
    """
    UNSPECIFIED = 0
    N1_HIGHCPU_8 = 1
    N1_HIGHCPU_32 = 2
    E2_HIGHCPU_8 = 3
    E2_HIGHCPU_32 = 4

  class RequestedVerifyOptionValueValuesEnum(_messages.Enum):
    r"""Requested verifiability options.

    Values:
      NOT_VERIFIED: Not a verifiable build. (default)
      VERIFIED: Verified build.
    """
    NOT_VERIFIED = 0
    VERIFIED = 1

  class SourceProvenanceHashValueListEntryValuesEnum(_messages.Enum):
    r"""SourceProvenanceHashValueListEntryValuesEnum enum type.

    Values:
      NONE: No hash requested.
      SHA256: Use a sha256 hash.
      MD5: Use a md5 hash.
    """
    NONE = 0
    SHA256 = 1
    MD5 = 2

  class SubstitutionOptionValueValuesEnum(_messages.Enum):
    r"""Option to specify behavior when there is an error in the substitution
    checks. NOTE: this is always set to ALLOW_LOOSE for triggered builds and
    cannot be overridden in the build configuration file.

    Values:
      MUST_MATCH: Fails the build if error in substitutions checks, like
        missing a substitution in the template or in the map.
      ALLOW_LOOSE: Do not fail the build if error in substitutions checks.
    """
    MUST_MATCH = 0
    ALLOW_LOOSE = 1

  cluster = _messages.MessageField('ClusterOptions', 1)
  diskSizeGb = _messages.IntegerField(2)
  dynamicSubstitutions = _messages.BooleanField(3)
  env = _messages.StringField(4, repeated=True)
  logStreamingOption = _messages.EnumField('LogStreamingOptionValueValuesEnum', 5)
  logging = _messages.EnumField('LoggingValueValuesEnum', 6)
  machineType = _messages.EnumField('MachineTypeValueValuesEnum', 7)
  requestedVerifyOption = _messages.EnumField('RequestedVerifyOptionValueValuesEnum', 8)
  secretEnv = _messages.StringField(9, repeated=True)
  sourceProvenanceHash = _messages.EnumField('SourceProvenanceHashValueListEntryValuesEnum', 10, repeated=True)
  substitutionOption = _messages.EnumField('SubstitutionOptionValueValuesEnum', 11)
  volumes = _messages.MessageField('Volume', 12, repeated=True)
  workerPool = _messages.StringField(13)


class BuildStep(_messages.Message):
  r"""A step in the build pipeline.

  Enums:
    StatusValueValuesEnum: Output only. Status of the build step. At this
      time, build step status is only updated on build completion; step status
      is not updated in real-time as the build progresses.

  Fields:
    args: A list of arguments that will be presented to the step when it is
      started. If the image used to run the step's container has an
      entrypoint, the `args` are used as arguments to that entrypoint. If the
      image does not define an entrypoint, the first element in args is used
      as the entrypoint, and the remainder will be used as arguments.
    dir: Working directory to use when running this step's container. If this
      value is a relative path, it is relative to the build's working
      directory. If this value is absolute, it may be outside the build's
      working directory, in which case the contents of the path may not be
      persisted across build step executions, unless a `volume` for that path
      is specified. If the build specifies a `RepoSource` with `dir` and a
      step with a `dir`, which specifies an absolute path, the `RepoSource`
      `dir` is ignored for the step's execution.
    entrypoint: Entrypoint to be used instead of the build step image's
      default entrypoint. If unset, the image's default entrypoint is used.
    env: A list of environment variable definitions to be used when running a
      step. The elements are of the form "KEY=VALUE" for the environment
      variable "KEY" being given the value "VALUE".
    id: Unique identifier for this build step, used in `wait_for` to reference
      this build step as a dependency.
    name: Required. The name of the container image that will run this
      particular build step. If the image is available in the host's Docker
      daemon's cache, it will be run directly. If not, the host will attempt
      to pull the image first, using the builder service account's credentials
      if necessary. The Docker daemon's cache will already have the latest
      versions of all of the officially supported build steps
      ([https://github.com/GoogleCloudPlatform/cloud-
      builders](https://github.com/GoogleCloudPlatform/cloud-builders)). The
      Docker daemon will also have cached many of the layers for some popular
      images, like "ubuntu", "debian", but they will be refreshed at the time
      you attempt to use them. If you built an image in a previous build step,
      it will be stored in the host's Docker daemon's cache and is available
      to use as the name for a later build step.
    pullTiming: Output only. Stores timing information for pulling this build
      step's builder image only.
    secretEnv: A list of environment variables which are encrypted using a
      Cloud Key Management Service crypto key. These values must be specified
      in the build's `Secret`.
    status: Output only. Status of the build step. At this time, build step
      status is only updated on build completion; step status is not updated
      in real-time as the build progresses.
    timeout: Time limit for executing this build step. If not defined, the
      step has no time limit and will be allowed to continue to run until
      either it completes or the build itself times out.
    timing: Output only. Stores timing information for executing this build
      step.
    volumes: List of volumes to mount into the build step. Each volume is
      created as an empty volume prior to execution of the build step. Upon
      completion of the build, volumes and their contents are discarded. Using
      a named volume in only one step is not valid as it is indicative of a
      build request with an incorrect configuration.
    waitFor: The ID(s) of the step(s) that this build step depends on. This
      build step will not start until all the build steps in `wait_for` have
      completed successfully. If `wait_for` is empty, this build step will
      start when all previous build steps in the `Build.Steps` list have
      completed successfully.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""Output only. Status of the build step. At this time, build step status
    is only updated on build completion; step status is not updated in real-
    time as the build progresses.

    Values:
      STATUS_UNKNOWN: Status of the build is unknown.
      PENDING: Build has been created and is pending execution and queuing. It
        has not been queued.
      QUEUED: Build or step is queued; work has not yet begun.
      WORKING: Build or step is being executed.
      SUCCESS: Build or step finished successfully.
      FAILURE: Build or step failed to complete successfully.
      INTERNAL_ERROR: Build or step failed due to an internal cause.
      TIMEOUT: Build or step took longer than was allowed.
      CANCELLED: Build or step was canceled by a user.
      EXPIRED: Build was enqueued for longer than the value of `queue_ttl`.
    """
    STATUS_UNKNOWN = 0
    PENDING = 1
    QUEUED = 2
    WORKING = 3
    SUCCESS = 4
    FAILURE = 5
    INTERNAL_ERROR = 6
    TIMEOUT = 7
    CANCELLED = 8
    EXPIRED = 9

  args = _messages.StringField(1, repeated=True)
  dir = _messages.StringField(2)
  entrypoint = _messages.StringField(3)
  env = _messages.StringField(4, repeated=True)
  id = _messages.StringField(5)
  name = _messages.StringField(6)
  pullTiming = _messages.MessageField('TimeSpan', 7)
  secretEnv = _messages.StringField(8, repeated=True)
  status = _messages.EnumField('StatusValueValuesEnum', 9)
  timeout = _messages.StringField(10)
  timing = _messages.MessageField('TimeSpan', 11)
  volumes = _messages.MessageField('Volume', 12, repeated=True)
  waitFor = _messages.StringField(13, repeated=True)


class BuildTrigger(_messages.Message):
  r"""Configuration for an automated build in response to source repository
  changes.

  Messages:
    SubstitutionsValue: Substitutions for Build resource. The keys must match
      the following regular expression: `^_[A-Z0-9_]+$`.

  Fields:
    approvalConfig: Configuration for manual approval to start a build
      invocation of this BuildTrigger.
    build: Contents of the build template.
    createTime: Output only. Time when the trigger was created.
    cron: CronConfig describes the configuration of a trigger that creates a
      build whenever a Cloud Scheduler event is received.
    description: Human-readable description of this trigger.
    disabled: If true, the trigger will never automatically execute a build.
    filename: Path, from the source root, to a file whose contents is used for
      the template.
    gitFileSource: The file source describing the local or remote Build
      template.
    github: GitHubEventsConfig describes the configuration of a trigger that
      creates a build whenever a GitHub event is received. Mutually exclusive
      with `trigger_template`.
    id: Output only. Unique identifier of the trigger.
    ignoredFiles: ignored_files and included_files are file glob matches using
      https://golang.org/pkg/path/filepath/#Match extended with support for
      "**". If ignored_files and changed files are both empty, then they are
      not used to determine whether or not to trigger a build. If
      ignored_files is not empty, then we ignore any files that match any of
      the ignored_file globs. If the change has no files that are outside of
      the ignored_files globs, then we do not trigger a build.
    includedFiles: If any of the files altered in the commit pass the
      ignored_files filter and included_files is empty, then as far as this
      filter is concerned, we should trigger the build. If any of the files
      altered in the commit pass the ignored_files filter and included_files
      is not empty, then we make sure that at least one of those files matches
      a included_files glob. If not, then we do not trigger a build.
    name: User-assigned name of the trigger. Must be unique within the
      project. Trigger names must meet the following requirements: + They must
      contain only alphanumeric characters and dashes. + They can be 1-64
      characters long. + They must begin and end with an alphanumeric
      character.
    pubsubConfig: PubsubConfig [Experimental] describes the configuration of a
      trigger that creates a build whenever a Pub/Sub message is published.
    sourceToBuild: The repo and ref of the repository from which to build.
      This field is used only for those triggers that do not respond to SCM
      events. Triggers that respond to such events build source at whatever
      commit caused the event.
    substitutions: Substitutions for Build resource. The keys must match the
      following regular expression: `^_[A-Z0-9_]+$`.
    tags: Tags for annotation of a `BuildTrigger`
    triggerTemplate: Template describing the types of source changes to
      trigger a build. Branch and tag names in trigger templates are
      interpreted as regular expressions. Any branch or tag change that
      matches that regular expression will trigger a build. Mutually exclusive
      with `github`.
    webhookConfig: WebhookConfig [Experimental] describes the configuration of
      a trigger that creates a build whenever a webhook is sent to a trigger's
      webhook URL.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SubstitutionsValue(_messages.Message):
    r"""Substitutions for Build resource. The keys must match the following
    regular expression: `^_[A-Z0-9_]+$`.

    Messages:
      AdditionalProperty: An additional property for a SubstitutionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type SubstitutionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SubstitutionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  approvalConfig = _messages.MessageField('ApprovalConfig', 1)
  build = _messages.MessageField('Build', 2)
  createTime = _messages.StringField(3)
  cron = _messages.MessageField('CronConfig', 4)
  description = _messages.StringField(5)
  disabled = _messages.BooleanField(6)
  filename = _messages.StringField(7)
  gitFileSource = _messages.MessageField('GitFileSource', 8)
  github = _messages.MessageField('GitHubEventsConfig', 9)
  id = _messages.StringField(10)
  ignoredFiles = _messages.StringField(11, repeated=True)
  includedFiles = _messages.StringField(12, repeated=True)
  name = _messages.StringField(13)
  pubsubConfig = _messages.MessageField('PubsubConfig', 14)
  sourceToBuild = _messages.MessageField('GitRepoSource', 15)
  substitutions = _messages.MessageField('SubstitutionsValue', 16)
  tags = _messages.StringField(17, repeated=True)
  triggerTemplate = _messages.MessageField('RepoSource', 18)
  webhookConfig = _messages.MessageField('WebhookConfig', 19)


class BuiltImage(_messages.Message):
  r"""An image built by the pipeline.

  Fields:
    digest: Docker Registry 2.0 digest.
    name: Name used to push the container image to Google Container Registry,
      as presented to `docker push`.
    pushTiming: Output only. Stores timing information for pushing the
      specified image.
  """

  digest = _messages.StringField(1)
  name = _messages.StringField(2)
  pushTiming = _messages.MessageField('TimeSpan', 3)


class CancelBuildRequest(_messages.Message):
  r"""Request to cancel an ongoing build.

  Fields:
    id: Required. ID of the build.
    name: The name of the `Build` to cancel. Format:
      `projects/{project}/locations/{location}/builds/{build}`
    projectId: Required. ID of the project.
  """

  id = _messages.StringField(1)
  name = _messages.StringField(2)
  projectId = _messages.StringField(3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CloudbuildGithubInstallationsInstallationsListRequest(_messages.Message):
  r"""A CloudbuildGithubInstallationsInstallationsListRequest object.

  Fields:
    installationId: Installation ID
  """

  installationId = _messages.IntegerField(1, required=True)


class CloudbuildGithubInstallationsProjectsListRequest(_messages.Message):
  r"""A CloudbuildGithubInstallationsProjectsListRequest object.

  Fields:
    installationId: Installation ID
  """

  installationId = _messages.IntegerField(1, required=True)


class CloudbuildInstallationsInstallationsListRequest(_messages.Message):
  r"""A CloudbuildInstallationsInstallationsListRequest object.

  Fields:
    installationId: Installation ID
  """

  installationId = _messages.IntegerField(1, required=True)


class CloudbuildOauthGetRegistrationRequest(_messages.Message):
  r"""A CloudbuildOauthGetRegistrationRequest object.

  Enums:
    NamespaceValueValuesEnum: Required. The namespace that the credential
      belongs to.

  Fields:
    authUser: Optional. For users who are logged in using multiple accounts,
      specify the auth user parameter so that the registration url redirects
      back to the cloud console using the proper account.
    githubEnterpriseConfig: Optional. The full resource name of the github
      enterprise resource if applicable.
    hostUrl: Required. The host url that the oauth credentials are associated
      with. For GitHub, this would be "https://github.com". For
      GitHubEnterprise, this would be the host name of their github enterprise
      instance.
    namespace: Required. The namespace that the credential belongs to.
  """

  class NamespaceValueValuesEnum(_messages.Enum):
    r"""Required. The namespace that the credential belongs to.

    Values:
      NAMESPACE_UNSPECIFIED: The default namespace.
      GITHUB_ENTERPRISE: A credential to be used with GitHub enterprise.
    """
    NAMESPACE_UNSPECIFIED = 0
    GITHUB_ENTERPRISE = 1

  authUser = _messages.StringField(1)
  githubEnterpriseConfig = _messages.StringField(2)
  hostUrl = _messages.StringField(3)
  namespace = _messages.EnumField('NamespaceValueValuesEnum', 4)


class CloudbuildOauthProcessOAuthCallbackRequest(_messages.Message):
  r"""A CloudbuildOauthProcessOAuthCallbackRequest object.

  Fields:
    code: GitHub generated temproary authorization code.
    githubEnterpriseConfig: For github enterprise, the full resource name of
      the github enterprise resource.
    hostUrl: The host url of the site that the OAuth token is issued for.
    namespace: The namespace that the oauth callback credential should be
      processed for. This should map to the string name of the enum defined in
      the GetOAuthRegistrationURLRequest.
    state: The XSRF token that was sent as part of the initial request to
      start the OAuth flow.
  """

  code = _messages.StringField(1)
  githubEnterpriseConfig = _messages.StringField(2)
  hostUrl = _messages.StringField(3)
  namespace = _messages.StringField(4)
  state = _messages.StringField(5)


class CloudbuildOperationsCancelRequest(_messages.Message):
  r"""A CloudbuildOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudbuildOperationsGetRequest(_messages.Message):
  r"""A CloudbuildOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class CloudbuildProjectsBuildsApproveRequest(_messages.Message):
  r"""A CloudbuildProjectsBuildsApproveRequest object.

  Fields:
    approveBuildRequest: A ApproveBuildRequest resource to be passed as the
      request body.
    name: Required. Name of the target build. For example:
      "projects/{$project_id}/builds/{$build_id}"
  """

  approveBuildRequest = _messages.MessageField('ApproveBuildRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudbuildProjectsBuildsCancelRequest(_messages.Message):
  r"""A CloudbuildProjectsBuildsCancelRequest object.

  Fields:
    cancelBuildRequest: A CancelBuildRequest resource to be passed as the
      request body.
    id: Required. ID of the build.
    projectId: Required. ID of the project.
  """

  cancelBuildRequest = _messages.MessageField('CancelBuildRequest', 1)
  id = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)


class CloudbuildProjectsBuildsCreateRequest(_messages.Message):
  r"""A CloudbuildProjectsBuildsCreateRequest object.

  Fields:
    build: A Build resource to be passed as the request body.
    parent: The parent resource where this build will be created. Format:
      `projects/{project}/locations/{location}`
    projectId: Required. ID of the project.
  """

  build = _messages.MessageField('Build', 1)
  parent = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)


class CloudbuildProjectsBuildsGetRequest(_messages.Message):
  r"""A CloudbuildProjectsBuildsGetRequest object.

  Fields:
    id: Required. ID of the build.
    name: The name of the `Build` to retrieve. Format:
      `projects/{project}/locations/{location}/builds/{build}`
    projectId: Required. ID of the project.
  """

  id = _messages.StringField(1, required=True)
  name = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)


class CloudbuildProjectsBuildsListRequest(_messages.Message):
  r"""A CloudbuildProjectsBuildsListRequest object.

  Fields:
    filter: The raw filter text to constrain the results.
    pageSize: Number of results to return in the list.
    pageToken: The page token for the next page of Builds. If unspecified, the
      first page of results is returned. If the token is rejected for any
      reason, INVALID_ARGUMENT will be thrown. In this case, the token should
      be discarded, and pagination should be restarted from the first page of
      results. See https://google.aip.dev/158 for more.
    parent: The parent of the collection of `Builds`. Format:
      `projects/{project}/locations/location`
    projectId: Required. ID of the project.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4)
  projectId = _messages.StringField(5, required=True)


class CloudbuildProjectsGithubEnterpriseConfigsCreateRequest(_messages.Message):
  r"""A CloudbuildProjectsGithubEnterpriseConfigsCreateRequest object.

  Fields:
    gitHubEnterpriseConfig: A GitHubEnterpriseConfig resource to be passed as
      the request body.
    parent: Name of the parent project. For example:
      projects/{$project_number} or projects/{$project_id}
    projectId: ID of the project.
  """

  gitHubEnterpriseConfig = _messages.MessageField('GitHubEnterpriseConfig', 1)
  parent = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3)


class CloudbuildProjectsGithubEnterpriseConfigsDeleteRequest(_messages.Message):
  r"""A CloudbuildProjectsGithubEnterpriseConfigsDeleteRequest object.

  Fields:
    configId: Unique identifier of the `GitHubEnterpriseConfig`
    name: This field should contain the name of the enterprise config
      resource. For example:
      "projects/{$project_id}/githubEnterpriseConfig/{$config_id}"
    projectId: ID of the project
  """

  configId = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3)


class CloudbuildProjectsGithubEnterpriseConfigsGetAppRequest(_messages.Message):
  r"""A CloudbuildProjectsGithubEnterpriseConfigsGetAppRequest object.

  Fields:
    enterpriseConfigResource: Required. The name of the enterprise config
      resource associated with the GitHub App. For example:
      "projects/{$project_id}/githubEnterpriseConfig/{$config_id}"
  """

  enterpriseConfigResource = _messages.StringField(1, required=True)


class CloudbuildProjectsGithubEnterpriseConfigsGetRequest(_messages.Message):
  r"""A CloudbuildProjectsGithubEnterpriseConfigsGetRequest object.

  Fields:
    configId: Unique identifier of the `GitHubEnterpriseConfig`
    name: This field should contain the name of the enterprise config
      resource. For example:
      "projects/{$project_id}/githubEnterpriseConfig/{$config_id}"
    projectId: ID of the project
  """

  configId = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3)


class CloudbuildProjectsGithubEnterpriseConfigsListRequest(_messages.Message):
  r"""A CloudbuildProjectsGithubEnterpriseConfigsListRequest object.

  Fields:
    parent: Name of the parent project. For example:
      projects/{$project_number} or projects/{$project_id}
    projectId: ID of the project
  """

  parent = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2)


class CloudbuildProjectsGithubEnterpriseConfigsPatchRequest(_messages.Message):
  r"""A CloudbuildProjectsGithubEnterpriseConfigsPatchRequest object.

  Fields:
    gitHubEnterpriseConfig: A GitHubEnterpriseConfig resource to be passed as
      the request body.
    name: Optional. The full resource name for the GitHubEnterpriseConfig For
      example: "projects/{$project_id}/githubEnterpriseConfig/{$config_id}"
    updateMask: Update mask for the resource. If this is set, the server will
      only update the fields specified in the field mask. Otherwise, a full
      update of the mutable resource fields will be performed.
  """

  gitHubEnterpriseConfig = _messages.MessageField('GitHubEnterpriseConfig', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudbuildProjectsGithubInstallationsCreateRequest(_messages.Message):
  r"""A CloudbuildProjectsGithubInstallationsCreateRequest object.

  Fields:
    installation: A Installation resource to be passed as the request body.
    projectId: The project ID of the GCP project the installation is
      associated with.
    projectId1: ID of the project.
    userOauthCode: GitHub user code. If a GitHub credential is already
      associated with the user this can be omitted, else the code is used to
      exchange and store an OAuth token.
  """

  installation = _messages.MessageField('Installation', 1)
  projectId = _messages.StringField(2, required=True)
  projectId1 = _messages.StringField(3)
  userOauthCode = _messages.StringField(4)


class CloudbuildProjectsGithubInstallationsDeleteRequest(_messages.Message):
  r"""A CloudbuildProjectsGithubInstallationsDeleteRequest object.

  Fields:
    installationId: GitHub app installation ID.
    projectId: Cloud Project ID.
  """

  installationId = _messages.IntegerField(1, required=True)
  projectId = _messages.StringField(2, required=True)


class CloudbuildProjectsGithubInstallationsListRequest(_messages.Message):
  r"""A CloudbuildProjectsGithubInstallationsListRequest object.

  Fields:
    projectId: Project id
  """

  projectId = _messages.StringField(1, required=True)


class CloudbuildProjectsGithubInstallationsPatchRequest(_messages.Message):
  r"""A CloudbuildProjectsGithubInstallationsPatchRequest object.

  Fields:
    id: GitHub installation ID, created by GitHub.
    installation: A Installation resource to be passed as the request body.
    installationId: Unique identifier of the GitHub installation. Deprecated.
      Should set installation.id
    projectId: The project ID of the GCP project the installation is
      associated with.
    projectId1: ID of the project.
    updateMask: Update mask for the Installation resource. If this is set, the
      server will only update the fields specified in the field mask.
      Otherwise, a full update of the resource will be performed.
  """

  id = _messages.IntegerField(1, required=True)
  installation = _messages.MessageField('Installation', 2)
  installationId = _messages.IntegerField(3)
  projectId = _messages.StringField(4, required=True)
  projectId1 = _messages.StringField(5)
  updateMask = _messages.StringField(6)


class CloudbuildProjectsInstallationsCreateRequest(_messages.Message):
  r"""A CloudbuildProjectsInstallationsCreateRequest object.

  Fields:
    installation: A Installation resource to be passed as the request body.
    projectId: ID of the project.
    userOauthCode: GitHub user code. If a GitHub credential is already
      associated with the user this can be omitted, else the code is used to
      exchange and store an OAuth token.
  """

  installation = _messages.MessageField('Installation', 1)
  projectId = _messages.StringField(2, required=True)
  userOauthCode = _messages.StringField(3)


class CloudbuildProjectsInstallationsDeleteRequest(_messages.Message):
  r"""A CloudbuildProjectsInstallationsDeleteRequest object.

  Fields:
    installationId: GitHub app installation ID.
    projectId: Cloud Project ID.
  """

  installationId = _messages.IntegerField(1, required=True)
  projectId = _messages.StringField(2, required=True)


class CloudbuildProjectsInstallationsListRequest(_messages.Message):
  r"""A CloudbuildProjectsInstallationsListRequest object.

  Fields:
    projectId: Project id
  """

  projectId = _messages.StringField(1, required=True)


class CloudbuildProjectsInstallationsPatchRequest(_messages.Message):
  r"""A CloudbuildProjectsInstallationsPatchRequest object.

  Fields:
    id: GitHub installation ID, created by GitHub.
    installation: A Installation resource to be passed as the request body.
    installationId: Unique identifier of the GitHub installation. Deprecated.
      Should set installation.id
    projectId: ID of the project.
    projectNum: Numerical ID of the project.
    updateMask: Update mask for the Installation resource. If this is set, the
      server will only update the fields specified in the field mask.
      Otherwise, a full update of the resource will be performed.
  """

  id = _messages.IntegerField(1, required=True)
  installation = _messages.MessageField('Installation', 2)
  installationId = _messages.IntegerField(3)
  projectId = _messages.StringField(4)
  projectNum = _messages.IntegerField(5, required=True)
  updateMask = _messages.StringField(6)


class CloudbuildProjectsLocationsBuildsCreateRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsBuildsCreateRequest object.

  Fields:
    build: A Build resource to be passed as the request body.
    parent: The parent resource where this build will be created. Format:
      `projects/{project}/locations/{location}`
    projectId: Required. ID of the project.
  """

  build = _messages.MessageField('Build', 1)
  parent = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3)


class CloudbuildProjectsLocationsBuildsGetRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsBuildsGetRequest object.

  Fields:
    id: Required. ID of the build.
    name: The name of the `Build` to retrieve. Format:
      `projects/{project}/locations/{location}/builds/{build}`
    projectId: Required. ID of the project.
  """

  id = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3)


class CloudbuildProjectsLocationsBuildsListRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsBuildsListRequest object.

  Fields:
    filter: The raw filter text to constrain the results.
    pageSize: Number of results to return in the list.
    pageToken: The page token for the next page of Builds. If unspecified, the
      first page of results is returned. If the token is rejected for any
      reason, INVALID_ARGUMENT will be thrown. In this case, the token should
      be discarded, and pagination should be restarted from the first page of
      results. See https://google.aip.dev/158 for more.
    parent: The parent of the collection of `Builds`. Format:
      `projects/{project}/locations/location`
    projectId: Required. ID of the project.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  projectId = _messages.StringField(5)


class CloudbuildProjectsLocationsGithubEnterpriseConfigsCreateRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsGithubEnterpriseConfigsCreateRequest
  object.

  Fields:
    gitHubEnterpriseConfig: A GitHubEnterpriseConfig resource to be passed as
      the request body.
    parent: Name of the parent project. For example:
      projects/{$project_number} or projects/{$project_id}
    projectId: ID of the project.
  """

  gitHubEnterpriseConfig = _messages.MessageField('GitHubEnterpriseConfig', 1)
  parent = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3)


class CloudbuildProjectsLocationsGithubEnterpriseConfigsDeleteRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsGithubEnterpriseConfigsDeleteRequest
  object.

  Fields:
    configId: Unique identifier of the `GitHubEnterpriseConfig`
    name: This field should contain the name of the enterprise config
      resource. For example:
      "projects/{$project_id}/githubEnterpriseConfig/{$config_id}"
    projectId: ID of the project
  """

  configId = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3)


class CloudbuildProjectsLocationsGithubEnterpriseConfigsGetAppRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsGithubEnterpriseConfigsGetAppRequest
  object.

  Fields:
    enterpriseConfigResource: Required. The name of the enterprise config
      resource associated with the GitHub App. For example:
      "projects/{$project_id}/githubEnterpriseConfig/{$config_id}"
  """

  enterpriseConfigResource = _messages.StringField(1, required=True)


class CloudbuildProjectsLocationsGithubEnterpriseConfigsGetRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsGithubEnterpriseConfigsGetRequest object.

  Fields:
    configId: Unique identifier of the `GitHubEnterpriseConfig`
    name: This field should contain the name of the enterprise config
      resource. For example:
      "projects/{$project_id}/githubEnterpriseConfig/{$config_id}"
    projectId: ID of the project
  """

  configId = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3)


class CloudbuildProjectsLocationsGithubEnterpriseConfigsListRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsGithubEnterpriseConfigsListRequest object.

  Fields:
    parent: Name of the parent project. For example:
      projects/{$project_number} or projects/{$project_id}
    projectId: ID of the project
  """

  parent = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2)


class CloudbuildProjectsLocationsGithubEnterpriseConfigsPatchRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsGithubEnterpriseConfigsPatchRequest object.

  Fields:
    gitHubEnterpriseConfig: A GitHubEnterpriseConfig resource to be passed as
      the request body.
    name: Optional. The full resource name for the GitHubEnterpriseConfig For
      example: "projects/{$project_id}/githubEnterpriseConfig/{$config_id}"
    updateMask: Update mask for the resource. If this is set, the server will
      only update the fields specified in the field mask. Otherwise, a full
      update of the mutable resource fields will be performed.
  """

  gitHubEnterpriseConfig = _messages.MessageField('GitHubEnterpriseConfig', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudbuildProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudbuildProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class CloudbuildProjectsTriggersCreateRequest(_messages.Message):
  r"""A CloudbuildProjectsTriggersCreateRequest object.

  Fields:
    buildTrigger: A BuildTrigger resource to be passed as the request body.
    projectId: Required. ID of the project for which to configure automatic
      builds.
  """

  buildTrigger = _messages.MessageField('BuildTrigger', 1)
  projectId = _messages.StringField(2, required=True)


class CloudbuildProjectsTriggersDeleteRequest(_messages.Message):
  r"""A CloudbuildProjectsTriggersDeleteRequest object.

  Fields:
    projectId: Required. ID of the project that owns the trigger.
    triggerId: Required. ID of the `BuildTrigger` to delete.
  """

  projectId = _messages.StringField(1, required=True)
  triggerId = _messages.StringField(2, required=True)


class CloudbuildProjectsTriggersGetRequest(_messages.Message):
  r"""A CloudbuildProjectsTriggersGetRequest object.

  Fields:
    projectId: Required. ID of the project that owns the trigger.
    triggerId: Required. Identifier (`id` or `name`) of the `BuildTrigger` to
      get.
  """

  projectId = _messages.StringField(1, required=True)
  triggerId = _messages.StringField(2, required=True)


class CloudbuildProjectsTriggersListRequest(_messages.Message):
  r"""A CloudbuildProjectsTriggersListRequest object.

  Fields:
    pageSize: Number of results to return in the list.
    pageToken: Token to provide to skip to a particular spot in the list.
    projectId: Required. ID of the project for which to list BuildTriggers.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)


class CloudbuildProjectsTriggersPatchRequest(_messages.Message):
  r"""A CloudbuildProjectsTriggersPatchRequest object.

  Fields:
    buildTrigger: A BuildTrigger resource to be passed as the request body.
    projectId: Required. ID of the project that owns the trigger.
    triggerId: Required. ID of the `BuildTrigger` to update.
  """

  buildTrigger = _messages.MessageField('BuildTrigger', 1)
  projectId = _messages.StringField(2, required=True)
  triggerId = _messages.StringField(3, required=True)


class CloudbuildProjectsTriggersRunRequest(_messages.Message):
  r"""A CloudbuildProjectsTriggersRunRequest object.

  Fields:
    projectId: Required. ID of the project.
    repoSource: A RepoSource resource to be passed as the request body.
    triggerId: Required. ID of the trigger.
  """

  projectId = _messages.StringField(1, required=True)
  repoSource = _messages.MessageField('RepoSource', 2)
  triggerId = _messages.StringField(3, required=True)


class CloudbuildProjectsTriggersWebhookRequest(_messages.Message):
  r"""A CloudbuildProjectsTriggersWebhookRequest object.

  Fields:
    httpBody: A HttpBody resource to be passed as the request body.
    projectId: Project in which the specified trigger lives
    secret: Secret token used for authorization if an OAuth token isn't
      provided.
    trigger: Name of the trigger to run the payload against
  """

  httpBody = _messages.MessageField('HttpBody', 1)
  projectId = _messages.StringField(2, required=True)
  secret = _messages.StringField(3)
  trigger = _messages.StringField(4, required=True)


class ClusterOptions(_messages.Message):
  r"""Details of the GKE Cluster for builds that should execute on-cluster.

  Fields:
    name: Identifier of the GKE Cluster this build should execute on. Example:
      projects/{project_id}/locations/{location}/cluster/{cluster_name} The
      cluster's project ID must be the same project ID that is running the
      build. The cluster must exist and have the CloudBuild add-on enabled.
  """

  name = _messages.StringField(1)


class CronConfig(_messages.Message):
  r"""CronConfig describes the configuration of a trigger that creates a build
  whenever a Cloud Scheduler event is received.

  Fields:
    enterpriseConfigResource: Optional. The GitHub Enterprise config resource
      name that is associated with this installation.
    schedule: Required. Describes the schedule on which the job will be
      executed. The schedule can be either of the following types: *
      [Crontab](http://en.wikipedia.org/wiki/Cron#Overview) * English-like
      [schedule](https://cloud.google.com/scheduler/docs/configuring/cron-job-
      schedules)
    timeZone: Optional. Specifies the time zone to be used in interpreting the
      schedule. The value of this field must be a time zone name from the [tz
      database] (http://en.wikipedia.org/wiki/Tz_database). Note that some
      time zones include a provision for daylight savings time. The rules for
      daylight saving time are determined by the chosen tz. For UTC use the
      string "utc". If a time zone is not specified, the default will be in
      UTC (also known as GMT).
  """

  enterpriseConfigResource = _messages.StringField(1)
  schedule = _messages.StringField(2)
  timeZone = _messages.StringField(3)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class FileHashes(_messages.Message):
  r"""Container message for hashes of byte content of files, used in
  SourceProvenance messages to verify integrity of source input to the build.

  Fields:
    fileHash: Collection of file hashes.
  """

  fileHash = _messages.MessageField('Hash', 1, repeated=True)


class GCSLocation(_messages.Message):
  r"""Represents a storage location in Cloud Storage

  Fields:
    bucket: Google Cloud Storage bucket. See
      https://cloud.google.com/storage/docs/naming#requirements
    generation: Google Cloud Storage generation for the object. If the
      generation is omitted, the latest generation will be used.
    object: Google Cloud Storage object. See
      https://cloud.google.com/storage/docs/naming#objectnames
  """

  bucket = _messages.StringField(1)
  generation = _messages.IntegerField(2)
  object = _messages.StringField(3)


class GitFileSource(_messages.Message):
  r"""GitFileSource describes a file within a (possibly remote) code
  repository.

  Enums:
    RepoTypeValueValuesEnum: See RepoType above.

  Fields:
    path: The path of the file, with the repo root as the root of the path.
    repoType: See RepoType above.
    revision: The branch, tag, arbitrary ref, or SHA version of the repo to
      use when resolving the filename (optional). This field respects the same
      syntax/resolution as described here: https://git-
      scm.com/docs/gitrevisions If unspecified, the revision from which the
      trigger invocation originated is assumed to be the revision from which
      to read the specified path.
    uri: The URI of the repo (optional). If unspecified, the repo from which
      the trigger invocation originated is assumed to be the repo from which
      to read the specified path.
  """

  class RepoTypeValueValuesEnum(_messages.Enum):
    r"""See RepoType above.

    Values:
      UNKNOWN: The default, unknown repo type.
      CLOUD_SOURCE_REPOSITORIES: A Google Cloud Source Repositories-hosted
        repo.
      GITHUB: A GitHub-hosted repo not necessarily on "github.com" (i.e.
        GitHub Enterprise).
    """
    UNKNOWN = 0
    CLOUD_SOURCE_REPOSITORIES = 1
    GITHUB = 2

  path = _messages.StringField(1)
  repoType = _messages.EnumField('RepoTypeValueValuesEnum', 2)
  revision = _messages.StringField(3)
  uri = _messages.StringField(4)


class GitHubEnterpriseApp(_messages.Message):
  r"""RPC response object returned by the GetGitHubEnterpriseApp RPC method.

  Fields:
    name: Name of the GitHub App
    slug: Slug (URL friendly name) of the GitHub App. This can be found on the
      settings page for the GitHub App (e.g.
      https://github.com/settings/apps/:app_slug) GitHub docs:
      https://docs.github.com/en/free-pro-team@latest/rest/reference/apps#get-
      an-app
  """

  name = _messages.StringField(1)
  slug = _messages.StringField(2)


class GitHubEnterpriseConfig(_messages.Message):
  r"""GitHubEnterpriseConfig represents a configuration for a GitHub
  Enterprise server.

  Fields:
    appConfigJson: Optional. Cloud Storage location of the encrypted GitHub
      App config information.
    appId: Required. The GitHub app id of the Cloud Build app on the GitHub
      Enterprise server.
    createTime: Output only. Time when the installation was associated with
      the project.
    displayName: Optional. Name to display for this config.
    hostUrl: The URL of the github enterprise host the configuration is for.
    name: Optional. The full resource name for the GitHubEnterpriseConfig For
      example: "projects/{$project_id}/githubEnterpriseConfig/{$config_id}"
    peeredNetwork: Optional. The network to be used when reaching out to the
      GitHub Enterprise server. The VPC network must be enabled for private
      service connection. This should be set if the GitHub Enterprise server
      is hosted on-premises and not reachable by public internet. If this
      field is left empty, no network peering will occur and calls to the
      GitHub Enterprise server will be made over the public internet. Must be
      in the format `projects/{project}/global/networks/{network}`, where
      {project} is a project number or id and {network} is the name of a VPC
      network in the project.
    secrets: Optional. Names of secrets in Secret Manager.
    webhookKey: Optional. The key that should be attached to webhook calls to
      the ReceiveWebhook endpoint.
  """

  appConfigJson = _messages.MessageField('GCSLocation', 1)
  appId = _messages.IntegerField(2)
  createTime = _messages.StringField(3)
  displayName = _messages.StringField(4)
  hostUrl = _messages.StringField(5)
  name = _messages.StringField(6)
  peeredNetwork = _messages.StringField(7)
  secrets = _messages.MessageField('GitHubEnterpriseSecrets', 8)
  webhookKey = _messages.StringField(9)


class GitHubEnterpriseSecrets(_messages.Message):
  r"""GitHubEnterpriseSecrets represents the names of all necessary secrets in
  Secret Manager for a GitHub Enterprise server. Format is:
  projects//secrets/.

  Fields:
    oauthClientIdName: The resource name for the OAuth client ID secret in
      Secret Manager.
    oauthClientIdVersionName: The resource name for the OAuth client ID secret
      version in Secret Manager.
    oauthSecretName: The resource name for the OAuth secret in Secret Manager.
    oauthSecretVersionName: The resource name for the OAuth secret secret
      version in Secret Manager.
    privateKeyName: The resource name for the private key secret.
    privateKeyVersionName: The resource name for the private key secret
      version.
    webhookSecretName: The resource name for the webhook secret in Secret
      Manager.
    webhookSecretVersionName: The resource name for the webhook secret secret
      version in Secret Manager.
  """

  oauthClientIdName = _messages.StringField(1)
  oauthClientIdVersionName = _messages.StringField(2)
  oauthSecretName = _messages.StringField(3)
  oauthSecretVersionName = _messages.StringField(4)
  privateKeyName = _messages.StringField(5)
  privateKeyVersionName = _messages.StringField(6)
  webhookSecretName = _messages.StringField(7)
  webhookSecretVersionName = _messages.StringField(8)


class GitHubEventsConfig(_messages.Message):
  r"""GitHubEventsConfig describes the configuration of a trigger that creates
  a build whenever a GitHub event is received. This message is experimental.

  Fields:
    enterpriseConfig: Output only. The GitHubEnterpriseConfig enterprise
      config specified in the enterprise_config_resource_name field.
    enterpriseConfigResourceName: Optional: The resource name of the github
      enterprise config that should be applied to this installation. For
      example: "projects/{$project_id}/githubEnterpriseConfig/{$config_id}"
    installationId: The installationID that emits the GitHub event.
    name: Name of the repository. For example: The name for
      https://github.com/googlecloudplatform/cloud-builders is "cloud-
      builders".
    owner: Owner of the repository. For example: The owner for
      https://github.com/googlecloudplatform/cloud-builders is
      "googlecloudplatform".
    pullRequest: filter to match changes in pull requests.
    push: filter to match changes in refs like branches, tags.
  """

  enterpriseConfig = _messages.MessageField('GitHubEnterpriseConfig', 1)
  enterpriseConfigResourceName = _messages.StringField(2)
  installationId = _messages.IntegerField(3)
  name = _messages.StringField(4)
  owner = _messages.StringField(5)
  pullRequest = _messages.MessageField('PullRequestFilter', 6)
  push = _messages.MessageField('PushFilter', 7)


class GitHubRepositorySetting(_messages.Message):
  r"""Represents a GitHub repository setting.

  Fields:
    name: Name of the repository.
    owner: GitHub user or organization name.
  """

  name = _messages.StringField(1)
  owner = _messages.StringField(2)


class GitHubRepositorySettingList(_messages.Message):
  r"""A wrapper message for a list of GitHubRepositorySettings.

  Fields:
    repositorySettings: A list of GitHubRepositorySettings.
  """

  repositorySettings = _messages.MessageField('GitHubRepositorySetting', 1, repeated=True)


class GitRepoSource(_messages.Message):
  r"""GitRepoSource describes a repo and ref of a code repository.

  Enums:
    RepoTypeValueValuesEnum: See RepoType below.

  Fields:
    ref: The branch or tag to use. Must start with "refs/" (required).
    repoType: See RepoType below.
    uri: The URI of the repo (required).
  """

  class RepoTypeValueValuesEnum(_messages.Enum):
    r"""See RepoType below.

    Values:
      UNKNOWN: The default, unknown repo type.
      CLOUD_SOURCE_REPOSITORIES: A Google Cloud Source Repositories-hosted
        repo.
      GITHUB: A GitHub-hosted repo not necessarily on "github.com" (i.e.
        GitHub Enterprise).
    """
    UNKNOWN = 0
    CLOUD_SOURCE_REPOSITORIES = 1
    GITHUB = 2

  ref = _messages.StringField(1)
  repoType = _messages.EnumField('RepoTypeValueValuesEnum', 2)
  uri = _messages.StringField(3)


class GitSource(_messages.Message):
  r"""Location of the source in any accessible Git repository.

  Fields:
    dir: Directory, relative to the source root, in which to run the build.
      This must be a relative path. If a step's `dir` is specified and is an
      absolute path, this value is ignored for that step's execution.
    revision: The revision to fetch from the Git repository such as a branch,
      a tag, a commit SHA, or any Git ref. Cloud Build uses `git fetch` to
      fetch the revision from the Git repository; therefore make sure that the
      string you provide for `revision` is parsable by the command. For
      information on string values accepted by `git fetch`, see https://git-
      scm.com/docs/gitrevisions#_specifying_revisions. For information on `git
      fetch`, see https://git-scm.com/docs/git-fetch.
    url: Location of the Git repo to build.
  """

  dir = _messages.StringField(1)
  revision = _messages.StringField(2)
  url = _messages.StringField(3)


class HTTPDelivery(_messages.Message):
  r"""HTTPDelivery is the delivery configuration for an HTTP notification.

  Fields:
    uri: The URI to which JSON-containing HTTP POST requests should be sent.
  """

  uri = _messages.StringField(1)


class Hash(_messages.Message):
  r"""Container message for hash values.

  Enums:
    TypeValueValuesEnum: The type of hash that was performed.

  Fields:
    type: The type of hash that was performed.
    value: The hash value.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of hash that was performed.

    Values:
      NONE: No hash requested.
      SHA256: Use a sha256 hash.
      MD5: Use a md5 hash.
    """
    NONE = 0
    SHA256 = 1
    MD5 = 2

  type = _messages.EnumField('TypeValueValuesEnum', 1)
  value = _messages.BytesField(2)


class HttpBody(_messages.Message):
  r"""Message that represents an arbitrary HTTP body. It should only be used
  for payload formats that can't be represented as JSON, such as raw binary or
  an HTML page. This message can be used both in streaming and non-streaming
  API methods in the request as well as the response. It can be used as a top-
  level request field, which is convenient if one wants to extract parameters
  from either the URL or HTTP template into the request fields and also want
  access to the raw HTTP body. Example: message GetResourceRequest { // A
  unique request id. string request_id = 1; // The raw HTTP body is bound to
  this field. google.api.HttpBody http_body = 2; } service ResourceService {
  rpc GetResource(GetResourceRequest) returns (google.api.HttpBody); rpc
  UpdateResource(google.api.HttpBody) returns (google.protobuf.Empty); }
  Example with streaming methods: service CaldavService { rpc
  GetCalendar(stream google.api.HttpBody) returns (stream
  google.api.HttpBody); rpc UpdateCalendar(stream google.api.HttpBody) returns
  (stream google.api.HttpBody); } Use of this type only changes how the
  request and response bodies are handled, all other features will continue to
  work unchanged.

  Messages:
    ExtensionsValueListEntry: A ExtensionsValueListEntry object.

  Fields:
    contentType: The HTTP Content-Type header value specifying the content
      type of the body.
    data: The HTTP request/response body as raw binary.
    extensions: Application specific response metadata. Must be set in the
      first response for streaming APIs.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ExtensionsValueListEntry(_messages.Message):
    r"""A ExtensionsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a
        ExtensionsValueListEntry object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ExtensionsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  contentType = _messages.StringField(1)
  data = _messages.BytesField(2)
  extensions = _messages.MessageField('ExtensionsValueListEntry', 3, repeated=True)


class InlineSecret(_messages.Message):
  r"""Pairs a set of secret environment variables mapped to encrypted values
  with the Cloud KMS key to use to decrypt the value.

  Messages:
    EnvMapValue: Map of environment variable name to its encrypted value.
      Secret environment variables must be unique across all of a build's
      secrets, and must be used by at least one build step. Values can be at
      most 64 KB in size. There can be at most 100 secret values across all of
      a build's secrets.

  Fields:
    envMap: Map of environment variable name to its encrypted value. Secret
      environment variables must be unique across all of a build's secrets,
      and must be used by at least one build step. Values can be at most 64 KB
      in size. There can be at most 100 secret values across all of a build's
      secrets.
    kmsKeyName: Resource name of Cloud KMS crypto key to decrypt the encrypted
      value. In format: projects/*/locations/*/keyRings/*/cryptoKeys/*
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class EnvMapValue(_messages.Message):
    r"""Map of environment variable name to its encrypted value. Secret
    environment variables must be unique across all of a build's secrets, and
    must be used by at least one build step. Values can be at most 64 KB in
    size. There can be at most 100 secret values across all of a build's
    secrets.

    Messages:
      AdditionalProperty: An additional property for a EnvMapValue object.

    Fields:
      additionalProperties: Additional properties of type EnvMapValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a EnvMapValue object.

      Fields:
        key: Name of the additional property.
        value: A byte attribute.
      """

      key = _messages.StringField(1)
      value = _messages.BytesField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  envMap = _messages.MessageField('EnvMapValue', 1)
  kmsKeyName = _messages.StringField(2)


class Installation(_messages.Message):
  r"""A GitHub-app installation.

  Fields:
    createTime: Time when the installation was associated with the project.
      This field is immutable and cannot be updated.
    enterpriseConfig: Output only. The GitHubEnterpriseConfig enterprise
      config specified in the enterprise_config_resource_name field.
    enterpriseConfigResourceName: Optional: The resource name of the github
      enterprise config that should be applied to this installation. For
      example: "projects/{$project_id}/githubEnterpriseConfig/{$config_id}"
    id: GitHub installation ID, created by GitHub.
    projectId: The project ID of the GCP project the installation is
      associated with.
    projectNum: Numerical ID of the project.
    repositorySettingList: The GitHub repositories that we should respond to
      for this installation. If this is not set, we will respect the
      default_check_suite_events boolean for any repository visible for that
      installation.
  """

  createTime = _messages.StringField(1)
  enterpriseConfig = _messages.MessageField('GitHubEnterpriseConfig', 2)
  enterpriseConfigResourceName = _messages.StringField(3)
  id = _messages.IntegerField(4)
  projectId = _messages.StringField(5)
  projectNum = _messages.IntegerField(6)
  repositorySettingList = _messages.MessageField('GitHubRepositorySettingList', 7)


class ListBuildTriggersResponse(_messages.Message):
  r"""Response containing existing `BuildTriggers`.

  Fields:
    nextPageToken: Token to receive the next page of results.
    triggers: `BuildTriggers` for the project, sorted by `create_time`
      descending.
  """

  nextPageToken = _messages.StringField(1)
  triggers = _messages.MessageField('BuildTrigger', 2, repeated=True)


class ListBuildsResponse(_messages.Message):
  r"""Response including listed builds.

  Fields:
    builds: Builds will be sorted by `create_time`, descending.
    nextPageToken: Token to receive the next page of results. This will be
      absent if the end of the response list has been reached.
  """

  builds = _messages.MessageField('Build', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListGitHubInstallationsForProjectResponse(_messages.Message):
  r"""RPC response object returned by the ListGitHubInstallations RPC method.

  Fields:
    installations: Installations belonging to the specified project_id.
  """

  installations = _messages.MessageField('Installation', 1, repeated=True)


class ListGitHubInstallationsResponse(_messages.Message):
  r"""RPC response object accepted by the ListGitHubInstallations RPC method.

  Fields:
    installations: Installations matching the requested installation ID.
  """

  installations = _messages.MessageField('Installation', 1, repeated=True)


class ListGithubEnterpriseConfigsResponse(_messages.Message):
  r"""RPC response object returned by ListGithubEnterpriseConfigs RPC method.

  Fields:
    configs: A list of GitHubEnterpriseConfigs
  """

  configs = _messages.MessageField('GitHubEnterpriseConfig', 1, repeated=True)


class Notification(_messages.Message):
  r"""Notification is the container which holds the data that is relevant to
  this particular notification.

  Messages:
    StructDeliveryValue: Escape hatch for users to supply custom delivery
      configs.

  Fields:
    filter: The filter string to use for notification filtering. Currently,
      this is assumed to be a CEL program. See
      https://opensource.google/projects/cel for more.
    httpDelivery: Configuration for HTTP delivery.
    slackDelivery: Configuration for Slack delivery.
    smtpDelivery: Configuration for SMTP (email) delivery.
    structDelivery: Escape hatch for users to supply custom delivery configs.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class StructDeliveryValue(_messages.Message):
    r"""Escape hatch for users to supply custom delivery configs.

    Messages:
      AdditionalProperty: An additional property for a StructDeliveryValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a StructDeliveryValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  filter = _messages.StringField(1)
  httpDelivery = _messages.MessageField('HTTPDelivery', 2)
  slackDelivery = _messages.MessageField('SlackDelivery', 3)
  smtpDelivery = _messages.MessageField('SMTPDelivery', 4)
  structDelivery = _messages.MessageField('StructDeliveryValue', 5)


class NotifierConfig(_messages.Message):
  r"""NotifierConfig is the top-level configuration message.

  Fields:
    apiVersion: The API version of this configuration format.
    kind: The type of notifier to use (e.g. SMTPNotifier).
    metadata: Metadata for referring to/handling/deploying this notifier.
    spec: The actual configuration for this notifier.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('NotifierMetadata', 3)
  spec = _messages.MessageField('NotifierSpec', 4)


class NotifierMetadata(_messages.Message):
  r"""NotifierMetadata contains the data which can be used to reference or
  describe this notifier.

  Fields:
    name: The human-readable and user-given name for the notifier. For
      example: "repo-merge-email-notifier".
    notifier: The string representing the name and version of notifier to
      deploy. Expected to be of the form of "/:". For example: "gcr.io/my-
      project/notifiers/smtp:1.2.34".
  """

  name = _messages.StringField(1)
  notifier = _messages.StringField(2)


class NotifierSecret(_messages.Message):
  r"""NotifierSecret is the container that maps a secret name (reference) to
  its Google Cloud Secret Manager resource path.

  Fields:
    name: Name is the local name of the secret, such as the verbatim string
      "my-smtp-password".
    value: Value is interpreted to be a resource path for fetching the actual
      (versioned) secret data for this secret. For example, this would be a
      Google Cloud Secret Manager secret version resource path like:
      "projects/my-project/secrets/my-secret/versions/latest".
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class NotifierSecretRef(_messages.Message):
  r"""NotifierSecretRef contains the reference to a secret stored in the
  corresponding NotifierSpec.

  Fields:
    secretRef: The value of `secret_ref` should be a `name` that is registered
      in a `Secret` in the `secrets` list of the `Spec`.
  """

  secretRef = _messages.StringField(1)


class NotifierSpec(_messages.Message):
  r"""NotifierSpec is the configuration container for notifications.

  Fields:
    notification: The configuration of this particular notifier.
    secrets: Configurations for secret resources used by this particular
      notifier.
  """

  notification = _messages.MessageField('Notification', 1)
  secrets = _messages.MessageField('NotifierSecret', 2, repeated=True)


class OAuthRegistrationURI(_messages.Message):
  r"""RPC Response object returned by GetOAuthRegistrationURL

  Fields:
    registrationUri: The URL that the user should be redirected to in order to
      start the OAuth flow. When the user is redirected to this URL, they will
      be sent to the source provider specified in the request to authorize
      CloudBuild to access their oauth credentials. After the authorization is
      completed, the user will be redirected to the Cloud Build console.
  """

  registrationUri = _messages.StringField(1)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class PubsubConfig(_messages.Message):
  r"""PubsubConfig [Experimental] describes the configuration of a trigger
  that creates a build whenever a Pub/Sub message is published.

  Enums:
    StateValueValuesEnum: Potential issues with the underlying Pub/Sub
      subscription configuration. Only populated on get requests.

  Fields:
    serviceAccountEmail: Service account that will make the push request.
    state: Potential issues with the underlying Pub/Sub subscription
      configuration. Only populated on get requests.
    subscription: Output only. Name of the subscription. Format is
      `projects/{project}/subscriptions/{subscription}`.
    topic: The name of the topic from which this subscription is receiving
      messages. Format is `projects/{project}/topics/{topic}`.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Potential issues with the underlying Pub/Sub subscription
    configuration. Only populated on get requests.

    Values:
      STATE_UNSPECIFIED: The subscription configuration has not been checked.
      OK: The Pub/Sub subscription is properly configured.
      SUBSCRIPTION_DELETED: The subscription has been deleted.
      TOPIC_DELETED: The topic has been deleted.
      SUBSCRIPTION_MISCONFIGURED: Some of the subscription's field are
        misconfigured.
    """
    STATE_UNSPECIFIED = 0
    OK = 1
    SUBSCRIPTION_DELETED = 2
    TOPIC_DELETED = 3
    SUBSCRIPTION_MISCONFIGURED = 4

  serviceAccountEmail = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)
  subscription = _messages.StringField(3)
  topic = _messages.StringField(4)


class PullRequestFilter(_messages.Message):
  r"""PullRequestFilter contains filter properties for matching GitHub Pull
  Requests.

  Enums:
    CommentControlValueValuesEnum: Configure builds to run whether a
      repository owner or collaborator need to comment `/gcbrun`.

  Fields:
    branch: Regex of branches to match. The syntax of the regular expressions
      accepted is the syntax accepted by RE2 and described at
      https://github.com/google/re2/wiki/Syntax
    commentControl: Configure builds to run whether a repository owner or
      collaborator need to comment `/gcbrun`.
    invertRegex: If true, branches that do NOT match the git_ref will trigger
      a build.
  """

  class CommentControlValueValuesEnum(_messages.Enum):
    r"""Configure builds to run whether a repository owner or collaborator
    need to comment `/gcbrun`.

    Values:
      COMMENTS_DISABLED: Do not require comments on Pull Requests before
        builds are triggered.
      COMMENTS_ENABLED: Enforce that repository owners or collaborators must
        comment on Pull Requests before builds are triggered.
      COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY: Enforce that repository
        owners or collaborators must comment on external contributors' Pull
        Requests before builds are triggered.
    """
    COMMENTS_DISABLED = 0
    COMMENTS_ENABLED = 1
    COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY = 2

  branch = _messages.StringField(1)
  commentControl = _messages.EnumField('CommentControlValueValuesEnum', 2)
  invertRegex = _messages.BooleanField(3)


class PushFilter(_messages.Message):
  r"""Push contains filter properties for matching GitHub git pushes.

  Fields:
    branch: Regexes matching branches to build. The syntax of the regular
      expressions accepted is the syntax accepted by RE2 and described at
      https://github.com/google/re2/wiki/Syntax
    invertRegex: When true, only trigger a build if the revision regex does
      NOT match the git_ref regex.
    tag: Regexes matching tags to build. The syntax of the regular expressions
      accepted is the syntax accepted by RE2 and described at
      https://github.com/google/re2/wiki/Syntax
  """

  branch = _messages.StringField(1)
  invertRegex = _messages.BooleanField(2)
  tag = _messages.StringField(3)


class ReceiveTriggerWebhookResponse(_messages.Message):
  r"""ReceiveTriggerWebhookResponse [Experimental] is the response object for
  the ReceiveTriggerWebhook method.
  """



class RepoSource(_messages.Message):
  r"""Location of the source in a Google Cloud Source Repository.

  Messages:
    SubstitutionsValue: Substitutions to use in a triggered build. Should only
      be used with RunBuildTrigger

  Fields:
    branchName: Regex matching branches to build. The syntax of the regular
      expressions accepted is the syntax accepted by RE2 and described at
      https://github.com/google/re2/wiki/Syntax
    commitSha: Explicit commit SHA to build.
    dir: Directory, relative to the source root, in which to run the build.
      This must be a relative path. If a step's `dir` is specified and is an
      absolute path, this value is ignored for that step's execution.
    invertRegex: Only trigger a build if the revision regex does NOT match the
      revision regex.
    projectId: ID of the project that owns the Cloud Source Repository. If
      omitted, the project ID requesting the build is assumed.
    repoName: Required. Name of the Cloud Source Repository.
    substitutions: Substitutions to use in a triggered build. Should only be
      used with RunBuildTrigger
    tagName: Regex matching tags to build. The syntax of the regular
      expressions accepted is the syntax accepted by RE2 and described at
      https://github.com/google/re2/wiki/Syntax
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SubstitutionsValue(_messages.Message):
    r"""Substitutions to use in a triggered build. Should only be used with
    RunBuildTrigger

    Messages:
      AdditionalProperty: An additional property for a SubstitutionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type SubstitutionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SubstitutionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  branchName = _messages.StringField(1)
  commitSha = _messages.StringField(2)
  dir = _messages.StringField(3)
  invertRegex = _messages.BooleanField(4)
  projectId = _messages.StringField(5)
  repoName = _messages.StringField(6)
  substitutions = _messages.MessageField('SubstitutionsValue', 7)
  tagName = _messages.StringField(8)


class Results(_messages.Message):
  r"""Artifacts created by the build pipeline.

  Fields:
    artifactManifest: Path to the artifact manifest. Only populated when
      artifacts are uploaded.
    artifactTiming: Time to push all non-container artifacts.
    buildStepImages: List of build step digests, in the order corresponding to
      build step indices.
    buildStepOutputs: List of build step outputs, produced by builder images,
      in the order corresponding to build step indices. [Cloud
      Builders](https://cloud.google.com/cloud-build/docs/cloud-builders) can
      produce this output by writing to `$BUILDER_OUTPUT/output`. Only the
      first 4KB of data is stored.
    images: Container images that were built as a part of the build.
    numArtifacts: Number of artifacts uploaded. Only populated when artifacts
      are uploaded.
  """

  artifactManifest = _messages.StringField(1)
  artifactTiming = _messages.MessageField('TimeSpan', 2)
  buildStepImages = _messages.StringField(3, repeated=True)
  buildStepOutputs = _messages.BytesField(4, repeated=True)
  images = _messages.MessageField('BuiltImage', 5, repeated=True)
  numArtifacts = _messages.IntegerField(6)


class RetryBuildRequest(_messages.Message):
  r"""Specifies a build to retry.

  Fields:
    id: Required. Build ID of the original build.
    name: The name of the `Build` to retry. Format:
      `projects/{project}/locations/{location}/builds/{build}`
    projectId: Required. ID of the project.
  """

  id = _messages.StringField(1)
  name = _messages.StringField(2)
  projectId = _messages.StringField(3)


class SMTPDelivery(_messages.Message):
  r"""SMTPDelivery is the delivery configuration for an SMTP (email)
  notification.

  Fields:
    fromAddress: This is the SMTP account/email that appears in the `From:` of
      the email. If empty, it is assumed to be sender.
    password: The SMTP sender's password.
    port: The SMTP port of the server.
    recipientAddresses: This is the list of addresses to which we send the
      email (i.e. in the `To:` of the email).
    senderAddress: This is the SMTP account/email that is used to send the
      message.
    server: The address of the SMTP server.
  """

  fromAddress = _messages.StringField(1)
  password = _messages.MessageField('NotifierSecretRef', 2)
  port = _messages.StringField(3)
  recipientAddresses = _messages.StringField(4, repeated=True)
  senderAddress = _messages.StringField(5)
  server = _messages.StringField(6)


class Secret(_messages.Message):
  r"""Pairs a set of secret environment variables containing encrypted values
  with the Cloud KMS key to use to decrypt the value.

  Messages:
    SecretEnvValue: Map of environment variable name to its encrypted value.
      Secret environment variables must be unique across all of a build's
      secrets, and must be used by at least one build step. Values can be at
      most 64 KB in size. There can be at most 100 secret values across all of
      a build's secrets.

  Fields:
    kmsKeyName: Cloud KMS key name to use to decrypt these envs.
    secretEnv: Map of environment variable name to its encrypted value. Secret
      environment variables must be unique across all of a build's secrets,
      and must be used by at least one build step. Values can be at most 64 KB
      in size. There can be at most 100 secret values across all of a build's
      secrets.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SecretEnvValue(_messages.Message):
    r"""Map of environment variable name to its encrypted value. Secret
    environment variables must be unique across all of a build's secrets, and
    must be used by at least one build step. Values can be at most 64 KB in
    size. There can be at most 100 secret values across all of a build's
    secrets.

    Messages:
      AdditionalProperty: An additional property for a SecretEnvValue object.

    Fields:
      additionalProperties: Additional properties of type SecretEnvValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SecretEnvValue object.

      Fields:
        key: Name of the additional property.
        value: A byte attribute.
      """

      key = _messages.StringField(1)
      value = _messages.BytesField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  kmsKeyName = _messages.StringField(1)
  secretEnv = _messages.MessageField('SecretEnvValue', 2)


class SecretManagerSecret(_messages.Message):
  r"""Pairs a secret environment variable with a SecretVersion in Secret
  Manager.

  Fields:
    env: Environment variable name to associate with the secret. Secret
      environment variables must be unique across all of a build's secrets,
      and must be used by at least one build step.
    versionName: Resource name of the SecretVersion. In format:
      projects/*/secrets/*/versions/*
  """

  env = _messages.StringField(1)
  versionName = _messages.StringField(2)


class Secrets(_messages.Message):
  r"""Secrets and secret environment variables.

  Fields:
    inline: Secrets encrypted with KMS key and the associated secret
      environment variable.
    secretManager: Secrets in Secret Manager and associated secret environment
      variable.
  """

  inline = _messages.MessageField('InlineSecret', 1, repeated=True)
  secretManager = _messages.MessageField('SecretManagerSecret', 2, repeated=True)


class SlackDelivery(_messages.Message):
  r"""SlackDelivery is the delivery configuration for delivering Slack
  messages via webhooks. See Slack webhook documentation at:
  https://api.slack.com/messaging/webhooks.

  Fields:
    webhookUri: The secret reference for the Slack webhook URI for sending
      messages to a channel.
  """

  webhookUri = _messages.MessageField('NotifierSecretRef', 1)


class Source(_messages.Message):
  r"""Location of the source in a supported storage service.

  Fields:
    gitSource: If provided, get the source from this Git repository.
    repoSource: If provided, get the source from this location in a Cloud
      Source Repository.
    storageSource: If provided, get the source from this location in Google
      Cloud Storage.
  """

  gitSource = _messages.MessageField('GitSource', 1)
  repoSource = _messages.MessageField('RepoSource', 2)
  storageSource = _messages.MessageField('StorageSource', 3)


class SourceProvenance(_messages.Message):
  r"""Provenance of the source. Ways to find the original source, or verify
  that some source was used for this build.

  Messages:
    FileHashesValue: Output only. Hash(es) of the build source, which can be
      used to verify that the original source integrity was maintained in the
      build. Note that `FileHashes` will only be populated if `BuildOptions`
      has requested a `SourceProvenanceHash`. The keys to this map are file
      paths used as build source and the values contain the hash values for
      those files. If the build source came in a single package such as a
      gzipped tarfile (`.tar.gz`), the `FileHash` will be for the single path
      to that file.

  Fields:
    fileHashes: Output only. Hash(es) of the build source, which can be used
      to verify that the original source integrity was maintained in the
      build. Note that `FileHashes` will only be populated if `BuildOptions`
      has requested a `SourceProvenanceHash`. The keys to this map are file
      paths used as build source and the values contain the hash values for
      those files. If the build source came in a single package such as a
      gzipped tarfile (`.tar.gz`), the `FileHash` will be for the single path
      to that file.
    resolvedRepoSource: A copy of the build's `source.repo_source`, if exists,
      with any revisions resolved.
    resolvedStorageSource: A copy of the build's `source.storage_source`, if
      exists, with any generations resolved.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FileHashesValue(_messages.Message):
    r"""Output only. Hash(es) of the build source, which can be used to verify
    that the original source integrity was maintained in the build. Note that
    `FileHashes` will only be populated if `BuildOptions` has requested a
    `SourceProvenanceHash`. The keys to this map are file paths used as build
    source and the values contain the hash values for those files. If the
    build source came in a single package such as a gzipped tarfile
    (`.tar.gz`), the `FileHash` will be for the single path to that file.

    Messages:
      AdditionalProperty: An additional property for a FileHashesValue object.

    Fields:
      additionalProperties: Additional properties of type FileHashesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FileHashesValue object.

      Fields:
        key: Name of the additional property.
        value: A FileHashes attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('FileHashes', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  fileHashes = _messages.MessageField('FileHashesValue', 1)
  resolvedRepoSource = _messages.MessageField('RepoSource', 2)
  resolvedStorageSource = _messages.MessageField('StorageSource', 3)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StorageSource(_messages.Message):
  r"""Location of the source in an archive file in Google Cloud Storage.

  Fields:
    bucket: Google Cloud Storage bucket containing the source (see [Bucket
      Name Requirements](https://cloud.google.com/storage/docs/bucket-
      naming#requirements)).
    generation: Google Cloud Storage generation for the object. If the
      generation is omitted, the latest generation will be used.
    object: Google Cloud Storage object containing the source. This object
      must be a gzipped archive file (`.tar.gz`) containing source to build.
  """

  bucket = _messages.StringField(1)
  generation = _messages.IntegerField(2)
  object = _messages.StringField(3)


class TimeSpan(_messages.Message):
  r"""Start and end times for a build execution phase.

  Fields:
    endTime: End of time span.
    startTime: Start of time span.
  """

  endTime = _messages.StringField(1)
  startTime = _messages.StringField(2)


class Volume(_messages.Message):
  r"""Volume describes a Docker container volume which is mounted into build
  steps in order to persist files across build step execution.

  Fields:
    name: Name of the volume to mount. Volume names must be unique per build
      step and must be valid names for Docker volumes. Each named volume must
      be used by at least two build steps.
    path: Path at which to mount the volume. Paths must be absolute and cannot
      conflict with other volume paths on the same build step or with certain
      reserved volume paths.
  """

  name = _messages.StringField(1)
  path = _messages.StringField(2)


class WebhookConfig(_messages.Message):
  r"""WebhookConfig [Experimental] describes the configuration of a trigger
  that creates a build whenever a webhook is sent to a trigger's webhook URL.

  Enums:
    StateValueValuesEnum: Potential issues with the underlying Pub/Sub
      subscription configuration. Only populated on get requests.

  Fields:
    secret: Required. Resource name for the secret required as a URL
      parameter.
    state: Potential issues with the underlying Pub/Sub subscription
      configuration. Only populated on get requests.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Potential issues with the underlying Pub/Sub subscription
    configuration. Only populated on get requests.

    Values:
      STATE_UNSPECIFIED: The webhook auth configuration not been checked.
      OK: The auth configuration is properly setup.
      SECRET_DELETED: The secret provided in auth_method has been deleted.
    """
    STATE_UNSPECIFIED = 0
    OK = 1
    SECRET_DELETED = 2

  secret = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
