"""Generated message classes for bigquery version v2.

A data platform for customers to create, manage, share and query data.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import message_types as _message_types
from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'bigquery'


class BigQueryModelTraining(_messages.Message):
  r"""A BigQueryModelTraining object.

  Fields:
    currentIteration: [Output-only, Beta] Index of current ML training
      iteration. Updated during create model query job to show job progress.
    expectedTotalIterations: [Output-only, Beta] Expected number of iterations
      for the create model query job specified as num_iterations in the input
      query. The actual total number of iterations may be less than this
      number due to early stop.
  """

  currentIteration = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  expectedTotalIterations = _messages.IntegerField(2)


class BigqueryDatasetsDeleteRequest(_messages.Message):
  r"""A BigqueryDatasetsDeleteRequest object.

  Fields:
    datasetId: Dataset ID of dataset being deleted
    deleteContents: If True, delete all the tables in the dataset. If False
      and the dataset contains tables, the request will fail. Default is False
    projectId: Project ID of the dataset being deleted
  """

  datasetId = _messages.StringField(1, required=True)
  deleteContents = _messages.BooleanField(2)
  projectId = _messages.StringField(3, required=True)


class BigqueryDatasetsDeleteResponse(_messages.Message):
  r"""An empty BigqueryDatasetsDelete response."""


class BigqueryDatasetsGetRequest(_messages.Message):
  r"""A BigqueryDatasetsGetRequest object.

  Fields:
    datasetId: Dataset ID of the requested dataset
    projectId: Project ID of the requested dataset
  """

  datasetId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)


class BigqueryDatasetsInsertRequest(_messages.Message):
  r"""A BigqueryDatasetsInsertRequest object.

  Fields:
    dataset: A Dataset resource to be passed as the request body.
    projectId: Project ID of the new dataset
  """

  dataset = _messages.MessageField('Dataset', 1)
  projectId = _messages.StringField(2, required=True)


class BigqueryDatasetsListRequest(_messages.Message):
  r"""A BigqueryDatasetsListRequest object.

  Fields:
    all: Whether to list all datasets, including hidden ones
    filter: An expression for filtering the results of the request by label.
      The syntax is "labels.<name>[:<value>]". Multiple filters can be ANDed
      together by connecting with a space. Example:
      "labels.department:receiving labels.active". See Filtering datasets
      using labels for details.
    maxResults: The maximum number of results to return
    pageToken: Page token, returned by a previous call, to request the next
      page of results
    projectId: Project ID of the datasets to be listed
  """

  all = _messages.BooleanField(1)
  filter = _messages.StringField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32)
  pageToken = _messages.StringField(4)
  projectId = _messages.StringField(5, required=True)


class BigqueryDatasetsPatchRequest(_messages.Message):
  r"""A BigqueryDatasetsPatchRequest object.

  Fields:
    dataset: A Dataset resource to be passed as the request body.
    datasetId: Dataset ID of the dataset being updated
    projectId: Project ID of the dataset being updated
  """

  dataset = _messages.MessageField('Dataset', 1)
  datasetId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)


class BigqueryDatasetsUpdateRequest(_messages.Message):
  r"""A BigqueryDatasetsUpdateRequest object.

  Fields:
    dataset: A Dataset resource to be passed as the request body.
    datasetId: Dataset ID of the dataset being updated
    projectId: Project ID of the dataset being updated
  """

  dataset = _messages.MessageField('Dataset', 1)
  datasetId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)


class BigqueryJobsCancelRequest(_messages.Message):
  r"""A BigqueryJobsCancelRequest object.

  Fields:
    jobId: [Required] Job ID of the job to cancel
    location: The geographic location of the job. Required except for US and
      EU. See details at https://cloud.google.com/bigquery/docs/locations#spec
      ifying_your_location.
    projectId: [Required] Project ID of the job to cancel
  """

  jobId = _messages.StringField(1, required=True)
  location = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)


class BigqueryJobsGetQueryResultsRequest(_messages.Message):
  r"""A BigqueryJobsGetQueryResultsRequest object.

  Fields:
    jobId: [Required] Job ID of the query job
    location: The geographic location where the job should run. Required
      except for US and EU. See details at https://cloud.google.com/bigquery/d
      ocs/locations#specifying_your_location.
    maxResults: Maximum number of results to read
    pageToken: Page token, returned by a previous call, to request the next
      page of results
    projectId: [Required] Project ID of the query job
    startIndex: Zero-based index of the starting row
    timeoutMs: How long to wait for the query to complete, in milliseconds,
      before returning. Default is 10 seconds. If the timeout passes before
      the job completes, the 'jobComplete' field in the response will be false
  """

  jobId = _messages.StringField(1, required=True)
  location = _messages.StringField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32)
  pageToken = _messages.StringField(4)
  projectId = _messages.StringField(5, required=True)
  startIndex = _messages.IntegerField(6, variant=_messages.Variant.UINT64)
  timeoutMs = _messages.IntegerField(7, variant=_messages.Variant.UINT32)


class BigqueryJobsGetRequest(_messages.Message):
  r"""A BigqueryJobsGetRequest object.

  Fields:
    jobId: [Required] Job ID of the requested job
    location: The geographic location of the job. Required except for US and
      EU. See details at https://cloud.google.com/bigquery/docs/locations#spec
      ifying_your_location.
    projectId: [Required] Project ID of the requested job
  """

  jobId = _messages.StringField(1, required=True)
  location = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)


class BigqueryJobsInsertRequest(_messages.Message):
  r"""A BigqueryJobsInsertRequest object.

  Fields:
    job: A Job resource to be passed as the request body.
    projectId: Project ID of the project that will be billed for the job
  """

  job = _messages.MessageField('Job', 1)
  projectId = _messages.StringField(2, required=True)


class BigqueryJobsListRequest(_messages.Message):
  r"""A BigqueryJobsListRequest object.

  Enums:
    ProjectionValueValuesEnum: Restrict information returned to a set of
      selected fields
    StateFilterValueValuesEnum: Filter for job state

  Fields:
    allUsers: Whether to display jobs owned by all users in the project.
      Default false
    maxCreationTime: Max value for job creation time, in milliseconds since
      the POSIX epoch. If set, only jobs created before or at this timestamp
      are returned
    maxResults: Maximum number of results to return
    minCreationTime: Min value for job creation time, in milliseconds since
      the POSIX epoch. If set, only jobs created after or at this timestamp
      are returned
    pageToken: Page token, returned by a previous call, to request the next
      page of results
    parentJobId: If set, retrieves only jobs whose parent is this job.
      Otherwise, retrieves only jobs which have no parent
    projectId: Project ID of the jobs to list
    projection: Restrict information returned to a set of selected fields
    stateFilter: Filter for job state
  """

  class ProjectionValueValuesEnum(_messages.Enum):
    r"""Restrict information returned to a set of selected fields

    Values:
      full: Includes all job data
      minimal: Does not include the job configuration
    """
    full = 0
    minimal = 1

  class StateFilterValueValuesEnum(_messages.Enum):
    r"""Filter for job state

    Values:
      done: Finished jobs
      pending: Pending jobs
      running: Running jobs
    """
    done = 0
    pending = 1
    running = 2

  allUsers = _messages.BooleanField(1)
  maxCreationTime = _messages.IntegerField(2, variant=_messages.Variant.UINT64)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32)
  minCreationTime = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  pageToken = _messages.StringField(5)
  parentJobId = _messages.StringField(6)
  projectId = _messages.StringField(7, required=True)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 8)
  stateFilter = _messages.EnumField('StateFilterValueValuesEnum', 9, repeated=True)


class BigqueryJobsQueryRequest(_messages.Message):
  r"""A BigqueryJobsQueryRequest object.

  Fields:
    projectId: Project ID of the project billed for the query
    queryRequest: A QueryRequest resource to be passed as the request body.
  """

  projectId = _messages.StringField(1, required=True)
  queryRequest = _messages.MessageField('QueryRequest', 2)


class BigqueryProjectsGetServiceAccountRequest(_messages.Message):
  r"""A BigqueryProjectsGetServiceAccountRequest object.

  Fields:
    projectId: Project ID for which the service account is requested.
  """

  projectId = _messages.StringField(1, required=True)


class BigqueryProjectsListRequest(_messages.Message):
  r"""A BigqueryProjectsListRequest object.

  Fields:
    maxResults: Maximum number of results to return
    pageToken: Page token, returned by a previous call, to request the next
      page of results
  """

  maxResults = _messages.IntegerField(1, variant=_messages.Variant.UINT32)
  pageToken = _messages.StringField(2)


class BigqueryTabledataInsertAllRequest(_messages.Message):
  r"""A BigqueryTabledataInsertAllRequest object.

  Fields:
    datasetId: Dataset ID of the destination table.
    projectId: Project ID of the destination table.
    tableDataInsertAllRequest: A TableDataInsertAllRequest resource to be
      passed as the request body.
    tableId: Table ID of the destination table.
  """

  datasetId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  tableDataInsertAllRequest = _messages.MessageField('TableDataInsertAllRequest', 3)
  tableId = _messages.StringField(4, required=True)


class BigqueryTabledataListRequest(_messages.Message):
  r"""A BigqueryTabledataListRequest object.

  Fields:
    datasetId: Dataset ID of the table to read
    maxResults: Maximum number of results to return
    pageToken: Page token, returned by a previous call, identifying the result
      set
    projectId: Project ID of the table to read
    selectedFields: List of fields to return (comma-separated). If
      unspecified, all fields are returned
    startIndex: Zero-based index of the starting row to read
    tableId: Table ID of the table to read
  """

  datasetId = _messages.StringField(1, required=True)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32)
  pageToken = _messages.StringField(3)
  projectId = _messages.StringField(4, required=True)
  selectedFields = _messages.StringField(5)
  startIndex = _messages.IntegerField(6, variant=_messages.Variant.UINT64)
  tableId = _messages.StringField(7, required=True)


class BigqueryTablesDeleteRequest(_messages.Message):
  r"""A BigqueryTablesDeleteRequest object.

  Fields:
    datasetId: Dataset ID of the table to delete
    projectId: Project ID of the table to delete
    tableId: Table ID of the table to delete
  """

  datasetId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  tableId = _messages.StringField(3, required=True)


class BigqueryTablesDeleteResponse(_messages.Message):
  r"""An empty BigqueryTablesDelete response."""


class BigqueryTablesGetRequest(_messages.Message):
  r"""A BigqueryTablesGetRequest object.

  Fields:
    datasetId: Dataset ID of the requested table
    projectId: Project ID of the requested table
    selectedFields: List of fields to return (comma-separated). If
      unspecified, all fields are returned
    tableId: Table ID of the requested table
  """

  datasetId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  selectedFields = _messages.StringField(3)
  tableId = _messages.StringField(4, required=True)


class BigqueryTablesInsertRequest(_messages.Message):
  r"""A BigqueryTablesInsertRequest object.

  Fields:
    datasetId: Dataset ID of the new table
    projectId: Project ID of the new table
    table: A Table resource to be passed as the request body.
  """

  datasetId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  table = _messages.MessageField('Table', 3)


class BigqueryTablesListRequest(_messages.Message):
  r"""A BigqueryTablesListRequest object.

  Fields:
    datasetId: Dataset ID of the tables to list
    maxResults: Maximum number of results to return
    pageToken: Page token, returned by a previous call, to request the next
      page of results
    projectId: Project ID of the tables to list
  """

  datasetId = _messages.StringField(1, required=True)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32)
  pageToken = _messages.StringField(3)
  projectId = _messages.StringField(4, required=True)


class BigqueryTablesPatchRequest(_messages.Message):
  r"""A BigqueryTablesPatchRequest object.

  Fields:
    datasetId: Dataset ID of the table to update
    projectId: Project ID of the table to update
    table: A Table resource to be passed as the request body.
    tableId: Table ID of the table to update
  """

  datasetId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  table = _messages.MessageField('Table', 3)
  tableId = _messages.StringField(4, required=True)


class BigqueryTablesUpdateRequest(_messages.Message):
  r"""A BigqueryTablesUpdateRequest object.

  Fields:
    datasetId: Dataset ID of the table to update
    projectId: Project ID of the table to update
    table: A Table resource to be passed as the request body.
    tableId: Table ID of the table to update
  """

  datasetId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  table = _messages.MessageField('Table', 3)
  tableId = _messages.StringField(4, required=True)


class BigtableColumn(_messages.Message):
  r"""A BigtableColumn object.

  Fields:
    encoding: [Optional] The encoding of the values when the type is not
      STRING. Acceptable encoding values are: TEXT - indicates values are
      alphanumeric text strings. BINARY - indicates values are encoded using
      HBase Bytes.toBytes family of functions. 'encoding' can also be set at
      the column family level. However, the setting at this level takes
      precedence if 'encoding' is set at both levels.
    fieldName: [Optional] If the qualifier is not a valid BigQuery field
      identifier i.e. does not match [a-zA-Z][a-zA-Z0-9_]*, a valid identifier
      must be provided as the column field name and is used as field name in
      queries.
    onlyReadLatest: [Optional] If this is set, only the latest version of
      value in this column are exposed. 'onlyReadLatest' can also be set at
      the column family level. However, the setting at this level takes
      precedence if 'onlyReadLatest' is set at both levels.
    qualifierEncoded: [Required] Qualifier of the column. Columns in the
      parent column family that has this exact qualifier are exposed as .
      field. If the qualifier is valid UTF-8 string, it can be specified in
      the qualifier_string field. Otherwise, a base-64 encoded value must be
      set to qualifier_encoded. The column field name is the same as the
      column qualifier. However, if the qualifier is not a valid BigQuery
      field identifier i.e. does not match [a-zA-Z][a-zA-Z0-9_]*, a valid
      identifier must be provided as field_name.
    qualifierString: A string attribute.
    type: [Optional] The type to convert the value in cells of this column.
      The values are expected to be encoded using HBase Bytes.toBytes function
      when using the BINARY encoding value. Following BigQuery types are
      allowed (case-sensitive) - BYTES STRING INTEGER FLOAT BOOLEAN Default
      type is BYTES. 'type' can also be set at the column family level.
      However, the setting at this level takes precedence if 'type' is set at
      both levels.
  """

  encoding = _messages.StringField(1)
  fieldName = _messages.StringField(2)
  onlyReadLatest = _messages.BooleanField(3)
  qualifierEncoded = _messages.BytesField(4)
  qualifierString = _messages.StringField(5)
  type = _messages.StringField(6)


class BigtableColumnFamily(_messages.Message):
  r"""A BigtableColumnFamily object.

  Fields:
    columns: [Optional] Lists of columns that should be exposed as individual
      fields as opposed to a list of (column name, value) pairs. All columns
      whose qualifier matches a qualifier in this list can be accessed as ..
      Other columns can be accessed as a list through .Column field.
    encoding: [Optional] The encoding of the values when the type is not
      STRING. Acceptable encoding values are: TEXT - indicates values are
      alphanumeric text strings. BINARY - indicates values are encoded using
      HBase Bytes.toBytes family of functions. This can be overridden for a
      specific column by listing that column in 'columns' and specifying an
      encoding for it.
    familyId: Identifier of the column family.
    onlyReadLatest: [Optional] If this is set only the latest version of value
      are exposed for all columns in this column family. This can be
      overridden for a specific column by listing that column in 'columns' and
      specifying a different setting for that column.
    type: [Optional] The type to convert the value in cells of this column
      family. The values are expected to be encoded using HBase Bytes.toBytes
      function when using the BINARY encoding value. Following BigQuery types
      are allowed (case-sensitive) - BYTES STRING INTEGER FLOAT BOOLEAN
      Default type is BYTES. This can be overridden for a specific column by
      listing that column in 'columns' and specifying a type for it.
  """

  columns = _messages.MessageField('BigtableColumn', 1, repeated=True)
  encoding = _messages.StringField(2)
  familyId = _messages.StringField(3)
  onlyReadLatest = _messages.BooleanField(4)
  type = _messages.StringField(5)


class BigtableOptions(_messages.Message):
  r"""A BigtableOptions object.

  Fields:
    columnFamilies: [Optional] List of column families to expose in the table
      schema along with their types. This list restricts the column families
      that can be referenced in queries and specifies their value types. You
      can use this list to do type conversions - see the 'type' field for more
      details. If you leave this list empty, all column families are present
      in the table schema and their values are read as BYTES. During a query
      only the column families referenced in that query are read from
      Bigtable.
    ignoreUnspecifiedColumnFamilies: [Optional] If field is true, then the
      column families that are not specified in columnFamilies list are not
      exposed in the table schema. Otherwise, they are read with BYTES type
      values. The default value is false.
    readRowkeyAsString: [Optional] If field is true, then the rowkey column
      families will be read and converted to string. Otherwise they are read
      with BYTES type values and users need to manually cast them with CAST if
      necessary. The default value is false.
  """

  columnFamilies = _messages.MessageField('BigtableColumnFamily', 1, repeated=True)
  ignoreUnspecifiedColumnFamilies = _messages.BooleanField(2)
  readRowkeyAsString = _messages.BooleanField(3)


class BqmlIterationResult(_messages.Message):
  r"""A BqmlIterationResult object.

  Fields:
    durationMs: [Output-only, Beta] Time taken to run the training iteration
      in milliseconds.
    evalLoss: [Output-only, Beta] Eval loss computed on the eval data at the
      end of the iteration. The eval loss is used for early stopping to avoid
      overfitting. No eval loss if eval_split_method option is specified as
      no_split or auto_split with input data size less than 500 rows.
    index: [Output-only, Beta] Index of the ML training iteration, starting
      from zero for each training run.
    learnRate: [Output-only, Beta] Learning rate used for this iteration, it
      varies for different training iterations if learn_rate_strategy option
      is not constant.
    trainingLoss: [Output-only, Beta] Training loss computed on the training
      data at the end of the iteration. The training loss function is defined
      by model type.
  """

  durationMs = _messages.IntegerField(1)
  evalLoss = _messages.FloatField(2)
  index = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  learnRate = _messages.FloatField(4)
  trainingLoss = _messages.FloatField(5)


class BqmlTrainingRun(_messages.Message):
  r"""A BqmlTrainingRun object.

  Messages:
    TrainingOptionsValue: [Output-only, Beta] Training options used by this
      training run. These options are mutable for subsequent training runs.
      Default values are explicitly stored for options not specified in the
      input query of the first training run. For subsequent training runs, any
      option not explicitly specified in the input query will be copied from
      the previous training run.

  Fields:
    iterationResults: [Output-only, Beta] List of each iteration results.
    startTime: [Output-only, Beta] Training run start time in milliseconds
      since the epoch.
    state: [Output-only, Beta] Different state applicable for a training run.
      IN PROGRESS: Training run is in progress. FAILED: Training run ended due
      to a non-retryable failure. SUCCEEDED: Training run successfully
      completed. CANCELLED: Training run cancelled by the user.
    trainingOptions: [Output-only, Beta] Training options used by this
      training run. These options are mutable for subsequent training runs.
      Default values are explicitly stored for options not specified in the
      input query of the first training run. For subsequent training runs, any
      option not explicitly specified in the input query will be copied from
      the previous training run.
  """

  class TrainingOptionsValue(_messages.Message):
    r"""[Output-only, Beta] Training options used by this training run. These
    options are mutable for subsequent training runs. Default values are
    explicitly stored for options not specified in the input query of the
    first training run. For subsequent training runs, any option not
    explicitly specified in the input query will be copied from the previous
    training run.

    Fields:
      earlyStop: A boolean attribute.
      l1Reg: A number attribute.
      l2Reg: A number attribute.
      learnRate: A number attribute.
      learnRateStrategy: A string attribute.
      lineSearchInitLearnRate: A number attribute.
      maxIteration: A string attribute.
      minRelProgress: A number attribute.
      warmStart: A boolean attribute.
    """

    earlyStop = _messages.BooleanField(1)
    l1Reg = _messages.FloatField(2)
    l2Reg = _messages.FloatField(3)
    learnRate = _messages.FloatField(4)
    learnRateStrategy = _messages.StringField(5)
    lineSearchInitLearnRate = _messages.FloatField(6)
    maxIteration = _messages.IntegerField(7)
    minRelProgress = _messages.FloatField(8)
    warmStart = _messages.BooleanField(9)

  iterationResults = _messages.MessageField('BqmlIterationResult', 1, repeated=True)
  startTime = _message_types.DateTimeField(2)
  state = _messages.StringField(3)
  trainingOptions = _messages.MessageField('TrainingOptionsValue', 4)


class Clustering(_messages.Message):
  r"""A Clustering object.

  Fields:
    fields: [Repeated] One or more fields on which data should be clustered.
      Only top-level, non-repeated, simple-type fields are supported. When you
      cluster a table using multiple columns, the order of columns you specify
      is important. The order of the specified columns determines the sort
      order of the data.
  """

  fields = _messages.StringField(1, repeated=True)


class ConnectionProperty(_messages.Message):
  r"""A ConnectionProperty object.

  Fields:
    key: [Required] Name of the connection property to set.
    value: [Required] Value of the connection property.
  """

  key = _messages.StringField(1)
  value = _messages.StringField(2)


class CsvOptions(_messages.Message):
  r"""A CsvOptions object.

  Fields:
    allowJaggedRows: [Optional] Indicates if BigQuery should accept rows that
      are missing trailing optional columns. If true, BigQuery treats missing
      trailing columns as null values. If false, records with missing trailing
      columns are treated as bad records, and if there are too many bad
      records, an invalid error is returned in the job result. The default
      value is false.
    allowQuotedNewlines: [Optional] Indicates if BigQuery should allow quoted
      data sections that contain newline characters in a CSV file. The default
      value is false.
    encoding: [Optional] The character encoding of the data. The supported
      values are UTF-8 or ISO-8859-1. The default value is UTF-8. BigQuery
      decodes the data after the raw, binary data has been split using the
      values of the quote and fieldDelimiter properties.
    fieldDelimiter: [Optional] The separator for fields in a CSV file.
      BigQuery converts the string to ISO-8859-1 encoding, and then uses the
      first byte of the encoded string to split the data in its raw, binary
      state. BigQuery also supports the escape sequence "\t" to specify a tab
      separator. The default value is a comma (',').
    quote: [Optional] The value that is used to quote data sections in a CSV
      file. BigQuery converts the string to ISO-8859-1 encoding, and then uses
      the first byte of the encoded string to split the data in its raw,
      binary state. The default value is a double-quote ('"'). If your data
      does not contain quoted sections, set the property value to an empty
      string. If your data contains quoted newline characters, you must also
      set the allowQuotedNewlines property to true.
    skipLeadingRows: [Optional] The number of rows at the top of a CSV file
      that BigQuery will skip when reading the data. The default value is 0.
      This property is useful if you have header rows in the file that should
      be skipped. When autodetect is on, the behavior is the following: *
      skipLeadingRows unspecified - Autodetect tries to detect headers in the
      first row. If they are not detected, the row is read as data. Otherwise
      data is read starting from the second row. * skipLeadingRows is 0 -
      Instructs autodetect that there are no headers and data should be read
      starting from the first row. * skipLeadingRows = N > 0 - Autodetect
      skips N-1 rows and tries to detect headers in row N. If headers are not
      detected, row N is just skipped. Otherwise row N is used to extract
      column names for the detected schema.
  """

  allowJaggedRows = _messages.BooleanField(1)
  allowQuotedNewlines = _messages.BooleanField(2)
  encoding = _messages.StringField(3)
  fieldDelimiter = _messages.StringField(4)
  quote = _messages.StringField(5, default='"')
  skipLeadingRows = _messages.IntegerField(6)


class Dataset(_messages.Message):
  r"""A Dataset object.

  Messages:
    AccessValueListEntry: A AccessValueListEntry object.
    LabelsValue: The labels associated with this dataset. You can use these to
      organize and group your datasets. You can set this property when
      inserting or updating a dataset. See Creating and Updating Dataset
      Labels for more information.

  Fields:
    access: [Optional] An array of objects that define dataset access for one
      or more entities. You can set this property when inserting or updating a
      dataset in order to control who is allowed to access the data. If
      unspecified at dataset creation time, BigQuery adds default dataset
      access for the following entities: access.specialGroup: projectReaders;
      access.role: READER; access.specialGroup: projectWriters; access.role:
      WRITER; access.specialGroup: projectOwners; access.role: OWNER;
      access.userByEmail: [dataset creator email]; access.role: OWNER;
    creationTime: [Output-only] The time when this dataset was created, in
      milliseconds since the epoch.
    datasetReference: [Required] A reference that identifies the dataset.
    defaultEncryptionConfiguration: A EncryptionConfiguration attribute.
    defaultPartitionExpirationMs: [Optional] The default partition expiration
      for all partitioned tables in the dataset, in milliseconds. Once this
      property is set, all newly-created partitioned tables in the dataset
      will have an expirationMs property in the timePartitioning settings set
      to this value, and changing the value will only affect new tables, not
      existing ones. The storage in a partition will have an expiration time
      of its partition time plus this value. Setting this property overrides
      the use of defaultTableExpirationMs for partitioned tables: only one of
      defaultTableExpirationMs and defaultPartitionExpirationMs will be used
      for any new partitioned table. If you provide an explicit
      timePartitioning.expirationMs when creating or updating a partitioned
      table, that value takes precedence over the default partition expiration
      time indicated by this property.
    defaultTableExpirationMs: [Optional] The default lifetime of all tables in
      the dataset, in milliseconds. The minimum value is 3600000 milliseconds
      (one hour). Once this property is set, all newly-created tables in the
      dataset will have an expirationTime property set to the creation time
      plus the value in this property, and changing the value will only affect
      new tables, not existing ones. When the expirationTime for a given table
      is reached, that table will be deleted automatically. If a table's
      expirationTime is modified or removed before the table expires, or if
      you provide an explicit expirationTime when creating a table, that value
      takes precedence over the default expiration time indicated by this
      property.
    description: [Optional] A user-friendly description of the dataset.
    etag: [Output-only] A hash of the resource.
    friendlyName: [Optional] A descriptive name for the dataset.
    id: [Output-only] The fully-qualified unique name of the dataset in the
      format projectId:datasetId. The dataset name without the project name is
      given in the datasetId field. When creating a new dataset, leave this
      field blank, and instead specify the datasetId field.
    kind: [Output-only] The resource type.
    labels: The labels associated with this dataset. You can use these to
      organize and group your datasets. You can set this property when
      inserting or updating a dataset. See Creating and Updating Dataset
      Labels for more information.
    lastModifiedTime: [Output-only] The date when this dataset or any of its
      tables was last modified, in milliseconds since the epoch.
    location: The geographic location where the dataset should reside. The
      default value is US. See details at
      https://cloud.google.com/bigquery/docs/locations.
    satisfiesPZS: [Output-only] Reserved for future use.
    selfLink: [Output-only] A URL that can be used to access the resource
      again. You can use this URL in Get or Update requests to the resource.
  """

  class AccessValueListEntry(_messages.Message):
    r"""A AccessValueListEntry object.

    Fields:
      domain: [Pick one] A domain to grant access to. Any users signed in with
        the domain specified will be granted the specified access. Example:
        "example.com". Maps to IAM policy member "domain:DOMAIN".
      groupByEmail: [Pick one] An email address of a Google Group to grant
        access to. Maps to IAM policy member "group:GROUP".
      iamMember: [Pick one] Some other type of member that appears in the IAM
        Policy but isn't a user, group, domain, or special group.
      role: [Required] An IAM role ID that should be granted to the user,
        group, or domain specified in this access entry. The following legacy
        mappings will be applied: OWNER  roles/bigquery.dataOwner WRITER
        roles/bigquery.dataEditor READER  roles/bigquery.dataViewer This field
        will accept any of the above formats, but will return only the legacy
        format. For example, if you set this field to
        "roles/bigquery.dataOwner", it will be returned back as "OWNER".
      routine: [Pick one] A routine from a different dataset to grant access
        to. Queries executed against that routine will have read access to
        views/tables/routines in this dataset. Only UDF is supported for now.
        The role field is not required when this field is set. If that routine
        is updated by any user, access to the routine needs to be granted
        again via an update operation.
      specialGroup: [Pick one] A special group to grant access to. Possible
        values include: projectOwners: Owners of the enclosing project.
        projectReaders: Readers of the enclosing project. projectWriters:
        Writers of the enclosing project. allAuthenticatedUsers: All
        authenticated BigQuery users. Maps to similarly-named IAM members.
      userByEmail: [Pick one] An email address of a user to grant access to.
        For example: fred@example.com. Maps to IAM policy member "user:EMAIL"
        or "serviceAccount:EMAIL".
      view: [Pick one] A view from a different dataset to grant access to.
        Queries executed against that view will have read access to tables in
        this dataset. The role field is not required when this field is set.
        If that view is updated by any user, access to the view needs to be
        granted again via an update operation.
    """

    domain = _messages.StringField(1)
    groupByEmail = _messages.StringField(2)
    iamMember = _messages.StringField(3)
    role = _messages.StringField(4)
    routine = _messages.MessageField('RoutineReference', 5)
    specialGroup = _messages.StringField(6)
    userByEmail = _messages.StringField(7)
    view = _messages.MessageField('TableReference', 8)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels associated with this dataset. You can use these to organize
    and group your datasets. You can set this property when inserting or
    updating a dataset. See Creating and Updating Dataset Labels for more
    information.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  access = _messages.MessageField('AccessValueListEntry', 1, repeated=True)
  creationTime = _messages.IntegerField(2)
  datasetReference = _messages.MessageField('DatasetReference', 3)
  defaultEncryptionConfiguration = _messages.MessageField('EncryptionConfiguration', 4)
  defaultPartitionExpirationMs = _messages.IntegerField(5)
  defaultTableExpirationMs = _messages.IntegerField(6)
  description = _messages.StringField(7)
  etag = _messages.StringField(8)
  friendlyName = _messages.StringField(9)
  id = _messages.StringField(10)
  kind = _messages.StringField(11, default='bigquery#dataset')
  labels = _messages.MessageField('LabelsValue', 12)
  lastModifiedTime = _messages.IntegerField(13)
  location = _messages.StringField(14)
  satisfiesPZS = _messages.BooleanField(15)
  selfLink = _messages.StringField(16)


class DatasetList(_messages.Message):
  r"""A DatasetList object.

  Messages:
    DatasetsValueListEntry: A DatasetsValueListEntry object.

  Fields:
    datasets: An array of the dataset resources in the project. Each resource
      contains basic information. For full information about a particular
      dataset resource, use the Datasets: get method. This property is omitted
      when there are no datasets in the project.
    etag: A hash value of the results page. You can use this property to
      determine if the page has changed since the last request.
    kind: The list type. This property always returns the value
      "bigquery#datasetList".
    nextPageToken: A token that can be used to request the next results page.
      This property is omitted on the final results page.
  """

  class DatasetsValueListEntry(_messages.Message):
    r"""A DatasetsValueListEntry object.

    Messages:
      LabelsValue: The labels associated with this dataset. You can use these
        to organize and group your datasets.

    Fields:
      datasetReference: The dataset reference. Use this property to access
        specific parts of the dataset's ID, such as project ID or dataset ID.
      friendlyName: A descriptive name for the dataset, if one exists.
      id: The fully-qualified, unique, opaque ID of the dataset.
      kind: The resource type. This property always returns the value
        "bigquery#dataset".
      labels: The labels associated with this dataset. You can use these to
        organize and group your datasets.
      location: The geographic location where the data resides.
    """

    @encoding.MapUnrecognizedFields('additionalProperties')
    class LabelsValue(_messages.Message):
      r"""The labels associated with this dataset. You can use these to
      organize and group your datasets.

      Messages:
        AdditionalProperty: An additional property for a LabelsValue object.

      Fields:
        additionalProperties: Additional properties of type LabelsValue
      """

      class AdditionalProperty(_messages.Message):
        r"""An additional property for a LabelsValue object.

        Fields:
          key: Name of the additional property.
          value: A string attribute.
        """

        key = _messages.StringField(1)
        value = _messages.StringField(2)

      additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

    datasetReference = _messages.MessageField('DatasetReference', 1)
    friendlyName = _messages.StringField(2)
    id = _messages.StringField(3)
    kind = _messages.StringField(4, default='bigquery#dataset')
    labels = _messages.MessageField('LabelsValue', 5)
    location = _messages.StringField(6)

  datasets = _messages.MessageField('DatasetsValueListEntry', 1, repeated=True)
  etag = _messages.StringField(2)
  kind = _messages.StringField(3, default='bigquery#datasetList')
  nextPageToken = _messages.StringField(4)


class DatasetReference(_messages.Message):
  r"""A DatasetReference object.

  Fields:
    datasetId: [Required] A unique ID for this dataset, without the project
      name. The ID must contain only letters (a-z, A-Z), numbers (0-9), or
      underscores (_). The maximum length is 1,024 characters.
    projectId: [Optional] The ID of the project containing this dataset.
  """

  datasetId = _messages.StringField(1)
  projectId = _messages.StringField(2)


class DestinationTableProperties(_messages.Message):
  r"""A DestinationTableProperties object.

  Messages:
    LabelsValue: [Optional] The labels associated with this table. You can use
      these to organize and group your tables. This will only be used if the
      destination table is newly created. If the table already exists and
      labels are different than the current labels are provided, the job will
      fail.

  Fields:
    description: [Optional] The description for the destination table. This
      will only be used if the destination table is newly created. If the
      table already exists and a value different than the current description
      is provided, the job will fail.
    friendlyName: [Optional] The friendly name for the destination table. This
      will only be used if the destination table is newly created. If the
      table already exists and a value different than the current friendly
      name is provided, the job will fail.
    labels: [Optional] The labels associated with this table. You can use
      these to organize and group your tables. This will only be used if the
      destination table is newly created. If the table already exists and
      labels are different than the current labels are provided, the job will
      fail.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""[Optional] The labels associated with this table. You can use these to
    organize and group your tables. This will only be used if the destination
    table is newly created. If the table already exists and labels are
    different than the current labels are provided, the job will fail.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  description = _messages.StringField(1)
  friendlyName = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)


class EncryptionConfiguration(_messages.Message):
  r"""A EncryptionConfiguration object.

  Fields:
    kmsKeyName: [Optional] Describes the Cloud KMS encryption key that will be
      used to protect destination BigQuery table. The BigQuery Service Account
      associated with your project requires access to this encryption key.
  """

  kmsKeyName = _messages.StringField(1)


class ErrorProto(_messages.Message):
  r"""A ErrorProto object.

  Fields:
    debugInfo: Debugging information. This property is internal to Google and
      should not be used.
    location: Specifies where the error occurred, if present.
    message: A human-readable description of the error.
    reason: A short error code that summarizes the error.
  """

  debugInfo = _messages.StringField(1)
  location = _messages.StringField(2)
  message = _messages.StringField(3)
  reason = _messages.StringField(4)


class ExplainQueryStage(_messages.Message):
  r"""A ExplainQueryStage object.

  Fields:
    completedParallelInputs: Number of parallel input segments completed.
    computeMsAvg: Milliseconds the average shard spent on CPU-bound tasks.
    computeMsMax: Milliseconds the slowest shard spent on CPU-bound tasks.
    computeRatioAvg: Relative amount of time the average shard spent on CPU-
      bound tasks.
    computeRatioMax: Relative amount of time the slowest shard spent on CPU-
      bound tasks.
    endMs: Stage end time represented as milliseconds since epoch.
    id: Unique ID for stage within plan.
    inputStages: IDs for stages that are inputs to this stage.
    name: Human-readable name for stage.
    parallelInputs: Number of parallel input segments to be processed.
    readMsAvg: Milliseconds the average shard spent reading input.
    readMsMax: Milliseconds the slowest shard spent reading input.
    readRatioAvg: Relative amount of time the average shard spent reading
      input.
    readRatioMax: Relative amount of time the slowest shard spent reading
      input.
    recordsRead: Number of records read into the stage.
    recordsWritten: Number of records written by the stage.
    shuffleOutputBytes: Total number of bytes written to shuffle.
    shuffleOutputBytesSpilled: Total number of bytes written to shuffle and
      spilled to disk.
    slotMs: Slot-milliseconds used by the stage.
    startMs: Stage start time represented as milliseconds since epoch.
    status: Current status for the stage.
    steps: List of operations within the stage in dependency order
      (approximately chronological).
    waitMsAvg: Milliseconds the average shard spent waiting to be scheduled.
    waitMsMax: Milliseconds the slowest shard spent waiting to be scheduled.
    waitRatioAvg: Relative amount of time the average shard spent waiting to
      be scheduled.
    waitRatioMax: Relative amount of time the slowest shard spent waiting to
      be scheduled.
    writeMsAvg: Milliseconds the average shard spent on writing output.
    writeMsMax: Milliseconds the slowest shard spent on writing output.
    writeRatioAvg: Relative amount of time the average shard spent on writing
      output.
    writeRatioMax: Relative amount of time the slowest shard spent on writing
      output.
  """

  completedParallelInputs = _messages.IntegerField(1)
  computeMsAvg = _messages.IntegerField(2)
  computeMsMax = _messages.IntegerField(3)
  computeRatioAvg = _messages.FloatField(4)
  computeRatioMax = _messages.FloatField(5)
  endMs = _messages.IntegerField(6)
  id = _messages.IntegerField(7)
  inputStages = _messages.IntegerField(8, repeated=True)
  name = _messages.StringField(9)
  parallelInputs = _messages.IntegerField(10)
  readMsAvg = _messages.IntegerField(11)
  readMsMax = _messages.IntegerField(12)
  readRatioAvg = _messages.FloatField(13)
  readRatioMax = _messages.FloatField(14)
  recordsRead = _messages.IntegerField(15)
  recordsWritten = _messages.IntegerField(16)
  shuffleOutputBytes = _messages.IntegerField(17)
  shuffleOutputBytesSpilled = _messages.IntegerField(18)
  slotMs = _messages.IntegerField(19)
  startMs = _messages.IntegerField(20)
  status = _messages.StringField(21)
  steps = _messages.MessageField('ExplainQueryStep', 22, repeated=True)
  waitMsAvg = _messages.IntegerField(23)
  waitMsMax = _messages.IntegerField(24)
  waitRatioAvg = _messages.FloatField(25)
  waitRatioMax = _messages.FloatField(26)
  writeMsAvg = _messages.IntegerField(27)
  writeMsMax = _messages.IntegerField(28)
  writeRatioAvg = _messages.FloatField(29)
  writeRatioMax = _messages.FloatField(30)


class ExplainQueryStep(_messages.Message):
  r"""A ExplainQueryStep object.

  Fields:
    kind: Machine-readable operation type.
    substeps: Human-readable stage descriptions.
  """

  kind = _messages.StringField(1)
  substeps = _messages.StringField(2, repeated=True)


class ExternalDataConfiguration(_messages.Message):
  r"""A ExternalDataConfiguration object.

  Fields:
    autodetect: Try to detect schema and format options automatically. Any
      option specified explicitly will be honored.
    bigtableOptions: [Optional] Additional options if sourceFormat is set to
      BIGTABLE.
    compression: [Optional] The compression type of the data source. Possible
      values include GZIP and NONE. The default value is NONE. This setting is
      ignored for Google Cloud Bigtable, Google Cloud Datastore backups and
      Avro formats.
    connectionId: [Optional, Trusted Tester] Connection for external data
      source.
    csvOptions: Additional properties to set if sourceFormat is set to CSV.
    googleSheetsOptions: [Optional] Additional options if sourceFormat is set
      to GOOGLE_SHEETS.
    hivePartitioningOptions: [Optional] Options to configure hive partitioning
      support.
    ignoreUnknownValues: [Optional] Indicates if BigQuery should allow extra
      values that are not represented in the table schema. If true, the extra
      values are ignored. If false, records with extra columns are treated as
      bad records, and if there are too many bad records, an invalid error is
      returned in the job result. The default value is false. The sourceFormat
      property determines what BigQuery treats as an extra value: CSV:
      Trailing columns JSON: Named values that don't match any column names
      Google Cloud Bigtable: This setting is ignored. Google Cloud Datastore
      backups: This setting is ignored. Avro: This setting is ignored.
    maxBadRecords: [Optional] The maximum number of bad records that BigQuery
      can ignore when reading data. If the number of bad records exceeds this
      value, an invalid error is returned in the job result. This is only
      valid for CSV, JSON, and Google Sheets. The default value is 0, which
      requires that all records are valid. This setting is ignored for Google
      Cloud Bigtable, Google Cloud Datastore backups and Avro formats.
    schema: [Optional] The schema for the data. Schema is required for CSV and
      JSON formats. Schema is disallowed for Google Cloud Bigtable, Cloud
      Datastore backups, and Avro formats.
    sourceFormat: [Required] The data format. For CSV files, specify "CSV".
      For Google sheets, specify "GOOGLE_SHEETS". For newline-delimited JSON,
      specify "NEWLINE_DELIMITED_JSON". For Avro files, specify "AVRO". For
      Google Cloud Datastore backups, specify "DATASTORE_BACKUP". [Beta] For
      Google Cloud Bigtable, specify "BIGTABLE".
    sourceUris: [Required] The fully-qualified URIs that point to your data in
      Google Cloud. For Google Cloud Storage URIs: Each URI can contain one
      '*' wildcard character and it must come after the 'bucket' name. Size
      limits related to load jobs apply to external data sources. For Google
      Cloud Bigtable URIs: Exactly one URI can be specified and it has be a
      fully specified and valid HTTPS URL for a Google Cloud Bigtable table.
      For Google Cloud Datastore backups, exactly one URI can be specified.
      Also, the '*' wildcard character is not allowed.
  """

  autodetect = _messages.BooleanField(1)
  bigtableOptions = _messages.MessageField('BigtableOptions', 2)
  compression = _messages.StringField(3)
  connectionId = _messages.StringField(4)
  csvOptions = _messages.MessageField('CsvOptions', 5)
  googleSheetsOptions = _messages.MessageField('GoogleSheetsOptions', 6)
  hivePartitioningOptions = _messages.MessageField('HivePartitioningOptions', 7)
  ignoreUnknownValues = _messages.BooleanField(8)
  maxBadRecords = _messages.IntegerField(9, variant=_messages.Variant.INT32)
  schema = _messages.MessageField('TableSchema', 10)
  sourceFormat = _messages.StringField(11)
  sourceUris = _messages.StringField(12, repeated=True)


class GetQueryResultsResponse(_messages.Message):
  r"""A GetQueryResultsResponse object.

  Fields:
    cacheHit: Whether the query result was fetched from the query cache.
    errors: [Output-only] The first errors or warnings encountered during the
      running of the job. The final message includes the number of errors that
      caused the process to stop. Errors here do not necessarily mean that the
      job has completed or was unsuccessful.
    etag: A hash of this response.
    jobComplete: Whether the query has completed or not. If rows or totalRows
      are present, this will always be true. If this is false, totalRows will
      not be available.
    jobReference: Reference to the BigQuery Job that was created to run the
      query. This field will be present even if the original request timed
      out, in which case GetQueryResults can be used to read the results once
      the query has completed. Since this API only returns the first page of
      results, subsequent pages can be fetched via the same mechanism
      (GetQueryResults).
    kind: The resource type of the response.
    numDmlAffectedRows: [Output-only] The number of rows affected by a DML
      statement. Present only for DML statements INSERT, UPDATE or DELETE.
    pageToken: A token used for paging results.
    rows: An object with as many results as can be contained within the
      maximum permitted reply size. To get any additional rows, you can call
      GetQueryResults and specify the jobReference returned above. Present
      only when the query completes successfully.
    schema: The schema of the results. Present only when the query completes
      successfully.
    totalBytesProcessed: The total number of bytes processed for this query.
    totalRows: The total number of rows in the complete query result set,
      which can be more than the number of rows in this single page of
      results. Present only when the query completes successfully.
  """

  cacheHit = _messages.BooleanField(1)
  errors = _messages.MessageField('ErrorProto', 2, repeated=True)
  etag = _messages.StringField(3)
  jobComplete = _messages.BooleanField(4)
  jobReference = _messages.MessageField('JobReference', 5)
  kind = _messages.StringField(6, default='bigquery#getQueryResultsResponse')
  numDmlAffectedRows = _messages.IntegerField(7)
  pageToken = _messages.StringField(8)
  rows = _messages.MessageField('TableRow', 9, repeated=True)
  schema = _messages.MessageField('TableSchema', 10)
  totalBytesProcessed = _messages.IntegerField(11)
  totalRows = _messages.IntegerField(12, variant=_messages.Variant.UINT64)


class GetServiceAccountResponse(_messages.Message):
  r"""A GetServiceAccountResponse object.

  Fields:
    email: The service account email address.
    kind: The resource type of the response.
  """

  email = _messages.StringField(1)
  kind = _messages.StringField(2, default='bigquery#getServiceAccountResponse')


class GoogleSheetsOptions(_messages.Message):
  r"""A GoogleSheetsOptions object.

  Fields:
    range: [Optional] Range of a sheet to query from. Only used when non-
      empty. Typical format: sheet_name!top_left_cell_id:bottom_right_cell_id
      For example: sheet1!A1:B20
    skipLeadingRows: [Optional] The number of rows at the top of a sheet that
      BigQuery will skip when reading the data. The default value is 0. This
      property is useful if you have header rows that should be skipped. When
      autodetect is on, behavior is the following: * skipLeadingRows
      unspecified - Autodetect tries to detect headers in the first row. If
      they are not detected, the row is read as data. Otherwise data is read
      starting from the second row. * skipLeadingRows is 0 - Instructs
      autodetect that there are no headers and data should be read starting
      from the first row. * skipLeadingRows = N > 0 - Autodetect skips N-1
      rows and tries to detect headers in row N. If headers are not detected,
      row N is just skipped. Otherwise row N is used to extract column names
      for the detected schema.
  """

  range = _messages.StringField(1)
  skipLeadingRows = _messages.IntegerField(2)


class HivePartitioningOptions(_messages.Message):
  r"""A HivePartitioningOptions object.

  Fields:
    mode: [Optional] When set, what mode of hive partitioning to use when
      reading data. The following modes are supported. (1) AUTO: automatically
      infer partition key name(s) and type(s). (2) STRINGS: automatically
      infer partition key name(s). All types are interpreted as strings. (3)
      CUSTOM: partition key schema is encoded in the source URI prefix. Not
      all storage formats support hive partitioning. Requesting hive
      partitioning on an unsupported format will lead to an error. Currently
      supported types include: AVRO, CSV, JSON, ORC and Parquet.
    requirePartitionFilter: [Optional] If set to true, queries over this table
      require a partition filter that can be used for partition elimination to
      be specified. Note that this field should only be true when creating a
      permanent external table or querying a temporary external table. Hive-
      partitioned loads with requirePartitionFilter explicitly set to true
      will fail.
    sourceUriPrefix: [Optional] When hive partition detection is requested, a
      common prefix for all source uris should be supplied. The prefix must
      end immediately before the partition key encoding begins. For example,
      consider files following this data layout.
      gs://bucket/path_to_table/dt=2019-01-01/country=BR/id=7/file.avro
      gs://bucket/path_to_table/dt=2018-12-31/country=CA/id=3/file.avro When
      hive partitioning is requested with either AUTO or STRINGS detection,
      the common prefix can be either of gs://bucket/path_to_table or
      gs://bucket/path_to_table/ (trailing slash does not matter).
  """

  mode = _messages.StringField(1)
  requirePartitionFilter = _messages.BooleanField(2)
  sourceUriPrefix = _messages.StringField(3)


class Job(_messages.Message):
  r"""A Job object.

  Fields:
    configuration: [Required] Describes the job configuration.
    etag: [Output-only] A hash of this resource.
    id: [Output-only] Opaque ID field of the job
    jobReference: [Optional] Reference describing the unique-per-user name of
      the job.
    kind: [Output-only] The type of the resource.
    selfLink: [Output-only] A URL that can be used to access this resource
      again.
    statistics: [Output-only] Information about the job, including starting
      time and ending time of the job.
    status: [Output-only] The status of this job. Examine this value when
      polling an asynchronous job to see if the job is complete.
    user_email: [Output-only] Email address of the user who ran the job.
  """

  configuration = _messages.MessageField('JobConfiguration', 1)
  etag = _messages.StringField(2)
  id = _messages.StringField(3)
  jobReference = _messages.MessageField('JobReference', 4)
  kind = _messages.StringField(5, default='bigquery#job')
  selfLink = _messages.StringField(6)
  statistics = _messages.MessageField('JobStatistics', 7)
  status = _messages.MessageField('JobStatus', 8)
  user_email = _messages.StringField(9)


class JobCancelResponse(_messages.Message):
  r"""A JobCancelResponse object.

  Fields:
    job: The final state of the job.
    kind: The resource type of the response.
  """

  job = _messages.MessageField('Job', 1)
  kind = _messages.StringField(2, default='bigquery#jobCancelResponse')


class JobConfiguration(_messages.Message):
  r"""A JobConfiguration object.

  Messages:
    LabelsValue: The labels associated with this job. You can use these to
      organize and group your jobs. Label keys and values can be no longer
      than 63 characters, can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. Label values are optional. Label keys must start with a letter
      and each label in the list must have a different key.

  Fields:
    copy: [Pick one] Copies a table.
    dryRun: [Optional] If set, don't actually run this job. A valid query will
      return a mostly empty response with some processing statistics, while an
      invalid query will return the same error it would if it wasn't a dry
      run. Behavior of non-query jobs is undefined.
    extract: [Pick one] Configures an extract job.
    jobTimeoutMs: [Optional] Job timeout in milliseconds. If this time limit
      is exceeded, BigQuery may attempt to terminate the job.
    jobType: [Output-only] The type of the job. Can be QUERY, LOAD, EXTRACT,
      COPY or UNKNOWN.
    labels: The labels associated with this job. You can use these to organize
      and group your jobs. Label keys and values can be no longer than 63
      characters, can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. Label
      values are optional. Label keys must start with a letter and each label
      in the list must have a different key.
    load: [Pick one] Configures a load job.
    query: [Pick one] Configures a query job.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels associated with this job. You can use these to organize and
    group your jobs. Label keys and values can be no longer than 63
    characters, can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. Label values
    are optional. Label keys must start with a letter and each label in the
    list must have a different key.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  copy = _messages.MessageField('JobConfigurationTableCopy', 1)
  dryRun = _messages.BooleanField(2)
  extract = _messages.MessageField('JobConfigurationExtract', 3)
  jobTimeoutMs = _messages.IntegerField(4)
  jobType = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  load = _messages.MessageField('JobConfigurationLoad', 7)
  query = _messages.MessageField('JobConfigurationQuery', 8)


class JobConfigurationExtract(_messages.Message):
  r"""A JobConfigurationExtract object.

  Fields:
    compression: [Optional] The compression type to use for exported files.
      Possible values include GZIP, DEFLATE, SNAPPY, and NONE. The default
      value is NONE. DEFLATE and SNAPPY are only supported for Avro. Not
      applicable when extracting models.
    destinationFormat: [Optional] The exported file format. Possible values
      include CSV, NEWLINE_DELIMITED_JSON, PARQUET or AVRO for tables and
      ML_TF_SAVED_MODEL or ML_XGBOOST_BOOSTER for models. The default value
      for tables is CSV. Tables with nested or repeated fields cannot be
      exported as CSV. The default value for models is ML_TF_SAVED_MODEL.
    destinationUri: [Pick one] DEPRECATED: Use destinationUris instead,
      passing only one URI as necessary. The fully-qualified Google Cloud
      Storage URI where the extracted table should be written.
    destinationUris: [Pick one] A list of fully-qualified Google Cloud Storage
      URIs where the extracted table should be written.
    fieldDelimiter: [Optional] Delimiter to use between fields in the exported
      data. Default is ','. Not applicable when extracting models.
    printHeader: [Optional] Whether to print out a header row in the results.
      Default is true. Not applicable when extracting models.
    sourceModel: A reference to the model being exported.
    sourceTable: A reference to the table being exported.
    useAvroLogicalTypes: [Optional] If destinationFormat is set to "AVRO",
      this flag indicates whether to enable extracting applicable column types
      (such as TIMESTAMP) to their corresponding AVRO logical types
      (timestamp-micros), instead of only using their raw types (avro-long).
      Not applicable when extracting models.
  """

  compression = _messages.StringField(1)
  destinationFormat = _messages.StringField(2)
  destinationUri = _messages.StringField(3)
  destinationUris = _messages.StringField(4, repeated=True)
  fieldDelimiter = _messages.StringField(5)
  printHeader = _messages.BooleanField(6, default=True)
  sourceModel = _messages.MessageField('ModelReference', 7)
  sourceTable = _messages.MessageField('TableReference', 8)
  useAvroLogicalTypes = _messages.BooleanField(9)


class JobConfigurationLoad(_messages.Message):
  r"""A JobConfigurationLoad object.

  Fields:
    allowJaggedRows: [Optional] Accept rows that are missing trailing optional
      columns. The missing values are treated as nulls. If false, records with
      missing trailing columns are treated as bad records, and if there are
      too many bad records, an invalid error is returned in the job result.
      The default value is false. Only applicable to CSV, ignored for other
      formats.
    allowQuotedNewlines: Indicates if BigQuery should allow quoted data
      sections that contain newline characters in a CSV file. The default
      value is false.
    autodetect: [Optional] Indicates if we should automatically infer the
      options and schema for CSV and JSON sources.
    clustering: [Beta] Clustering specification for the destination table.
      Must be specified with time-based partitioning, data in the table will
      be first partitioned and subsequently clustered.
    createDisposition: [Optional] Specifies whether the job is allowed to
      create new tables. The following values are supported: CREATE_IF_NEEDED:
      If the table does not exist, BigQuery creates the table. CREATE_NEVER:
      The table must already exist. If it does not, a 'notFound' error is
      returned in the job result. The default value is CREATE_IF_NEEDED.
      Creation, truncation and append actions occur as one atomic update upon
      job completion.
    decimalTargetTypes: Defines the list of possible SQL data types to which
      the source decimal values are converted. This list and the precision and
      the scale parameters of the decimal field determine the target type. In
      the order of NUMERIC, BIGNUMERIC ([Preview](/products/#product-launch-
      stages)), and STRING, a type is picked if it is in the specified list
      and if it supports the precision and the scale. STRING supports all
      precision and scale values. If none of the listed types supports the
      precision and the scale, the type supporting the widest range in the
      specified list is picked, and if a value exceeds the supported range
      when reading the data, an error will be thrown. Example: Suppose the
      value of this field is ["NUMERIC", "BIGNUMERIC"]. If (precision,scale)
      is: * (38,9) -> NUMERIC; * (39,9) -> BIGNUMERIC (NUMERIC cannot hold 30
      integer digits); * (38,10) -> BIGNUMERIC (NUMERIC cannot hold 10
      fractional digits); * (76,38) -> BIGNUMERIC; * (77,38) -> BIGNUMERIC
      (error if value exeeds supported range). This field cannot contain
      duplicate types. The order of the types in this field is ignored. For
      example, ["BIGNUMERIC", "NUMERIC"] is the same as ["NUMERIC",
      "BIGNUMERIC"] and NUMERIC always takes precedence over BIGNUMERIC.
      Defaults to ["NUMERIC", "STRING"] for ORC and ["NUMERIC"] for the other
      file formats.
    destinationEncryptionConfiguration: Custom encryption configuration (e.g.,
      Cloud KMS keys).
    destinationTable: [Required] The destination table to load the data into.
    destinationTableProperties: [Beta] [Optional] Properties with which to
      create the destination table if it is new.
    encoding: [Optional] The character encoding of the data. The supported
      values are UTF-8 or ISO-8859-1. The default value is UTF-8. BigQuery
      decodes the data after the raw, binary data has been split using the
      values of the quote and fieldDelimiter properties.
    fieldDelimiter: [Optional] The separator for fields in a CSV file. The
      separator can be any ISO-8859-1 single-byte character. To use a
      character in the range 128-255, you must encode the character as UTF8.
      BigQuery converts the string to ISO-8859-1 encoding, and then uses the
      first byte of the encoded string to split the data in its raw, binary
      state. BigQuery also supports the escape sequence "\t" to specify a tab
      separator. The default value is a comma (',').
    hivePartitioningOptions: [Optional] Options to configure hive partitioning
      support.
    ignoreUnknownValues: [Optional] Indicates if BigQuery should allow extra
      values that are not represented in the table schema. If true, the extra
      values are ignored. If false, records with extra columns are treated as
      bad records, and if there are too many bad records, an invalid error is
      returned in the job result. The default value is false. The sourceFormat
      property determines what BigQuery treats as an extra value: CSV:
      Trailing columns JSON: Named values that don't match any column names
    jsonExtension: [Optional] If sourceFormat is set to newline-delimited
      JSON, indicates whether it should be processed as a JSON variant such as
      GeoJSON. For a sourceFormat other than JSON, omit this field. If the
      sourceFormat is newline-delimited JSON: - for newline-delimited GeoJSON:
      set to GEOJSON.
    maxBadRecords: [Optional] The maximum number of bad records that BigQuery
      can ignore when running the job. If the number of bad records exceeds
      this value, an invalid error is returned in the job result. This is only
      valid for CSV and JSON. The default value is 0, which requires that all
      records are valid.
    nullMarker: [Optional] Specifies a string that represents a null value in
      a CSV file. For example, if you specify "\\N", BigQuery interprets "\\N"
      as a null value when loading a CSV file. The default value is the empty
      string. If you set this property to a custom value, BigQuery throws an
      error if an empty string is present for all data types except for STRING
      and BYTE. For STRING and BYTE columns, BigQuery interprets the empty
      string as an empty value.
    projectionFields: If sourceFormat is set to "DATASTORE_BACKUP", indicates
      which entity properties to load into BigQuery from a Cloud Datastore
      backup. Property names are case sensitive and must be top-level
      properties. If no properties are specified, BigQuery loads all
      properties. If any named property isn't found in the Cloud Datastore
      backup, an invalid error is returned in the job result.
    quote: [Optional] The value that is used to quote data sections in a CSV
      file. BigQuery converts the string to ISO-8859-1 encoding, and then uses
      the first byte of the encoded string to split the data in its raw,
      binary state. The default value is a double-quote ('"'). If your data
      does not contain quoted sections, set the property value to an empty
      string. If your data contains quoted newline characters, you must also
      set the allowQuotedNewlines property to true.
    rangePartitioning: [TrustedTester] Range partitioning specification for
      this table. Only one of timePartitioning and rangePartitioning should be
      specified.
    schema: [Optional] The schema for the destination table. The schema can be
      omitted if the destination table already exists, or if you're loading
      data from Google Cloud Datastore.
    schemaInline: [Deprecated] The inline schema. For CSV schemas, specify as
      "Field1:Type1[,Field2:Type2]*". For example, "foo:STRING, bar:INTEGER,
      baz:FLOAT".
    schemaInlineFormat: [Deprecated] The format of the schemaInline property.
    schemaUpdateOptions: Allows the schema of the destination table to be
      updated as a side effect of the load job if a schema is autodetected or
      supplied in the job configuration. Schema update options are supported
      in two cases: when writeDisposition is WRITE_APPEND; when
      writeDisposition is WRITE_TRUNCATE and the destination table is a
      partition of a table, specified by partition decorators. For normal
      tables, WRITE_TRUNCATE will always overwrite the schema. One or more of
      the following values are specified: ALLOW_FIELD_ADDITION: allow adding a
      nullable field to the schema. ALLOW_FIELD_RELAXATION: allow relaxing a
      required field in the original schema to nullable.
    skipLeadingRows: [Optional] The number of rows at the top of a CSV file
      that BigQuery will skip when loading the data. The default value is 0.
      This property is useful if you have header rows in the file that should
      be skipped.
    sourceFormat: [Optional] The format of the data files. For CSV files,
      specify "CSV". For datastore backups, specify "DATASTORE_BACKUP". For
      newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro,
      specify "AVRO". For parquet, specify "PARQUET". For orc, specify "ORC".
      The default value is CSV.
    sourceUris: [Required] The fully-qualified URIs that point to your data in
      Google Cloud. For Google Cloud Storage URIs: Each URI can contain one
      '*' wildcard character and it must come after the 'bucket' name. Size
      limits related to load jobs apply to external data sources. For Google
      Cloud Bigtable URIs: Exactly one URI can be specified and it has be a
      fully specified and valid HTTPS URL for a Google Cloud Bigtable table.
      For Google Cloud Datastore backups: Exactly one URI can be specified.
      Also, the '*' wildcard character is not allowed.
    timePartitioning: Time-based partitioning specification for the
      destination table. Only one of timePartitioning and rangePartitioning
      should be specified.
    useAvroLogicalTypes: [Optional] If sourceFormat is set to "AVRO",
      indicates whether to enable interpreting logical types into their
      corresponding types (ie. TIMESTAMP), instead of only using their raw
      types (ie. INTEGER).
    writeDisposition: [Optional] Specifies the action that occurs if the
      destination table already exists. The following values are supported:
      WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the
      table data. WRITE_APPEND: If the table already exists, BigQuery appends
      the data to the table. WRITE_EMPTY: If the table already exists and
      contains data, a 'duplicate' error is returned in the job result. The
      default value is WRITE_APPEND. Each action is atomic and only occurs if
      BigQuery is able to complete the job successfully. Creation, truncation
      and append actions occur as one atomic update upon job completion.
  """

  allowJaggedRows = _messages.BooleanField(1)
  allowQuotedNewlines = _messages.BooleanField(2)
  autodetect = _messages.BooleanField(3)
  clustering = _messages.MessageField('Clustering', 4)
  createDisposition = _messages.StringField(5)
  decimalTargetTypes = _messages.StringField(6, repeated=True)
  destinationEncryptionConfiguration = _messages.MessageField('EncryptionConfiguration', 7)
  destinationTable = _messages.MessageField('TableReference', 8)
  destinationTableProperties = _messages.MessageField('DestinationTableProperties', 9)
  encoding = _messages.StringField(10)
  fieldDelimiter = _messages.StringField(11)
  hivePartitioningOptions = _messages.MessageField('HivePartitioningOptions', 12)
  ignoreUnknownValues = _messages.BooleanField(13)
  jsonExtension = _messages.StringField(14)
  maxBadRecords = _messages.IntegerField(15, variant=_messages.Variant.INT32)
  nullMarker = _messages.StringField(16)
  projectionFields = _messages.StringField(17, repeated=True)
  quote = _messages.StringField(18, default='"')
  rangePartitioning = _messages.MessageField('RangePartitioning', 19)
  schema = _messages.MessageField('TableSchema', 20)
  schemaInline = _messages.StringField(21)
  schemaInlineFormat = _messages.StringField(22)
  schemaUpdateOptions = _messages.StringField(23, repeated=True)
  skipLeadingRows = _messages.IntegerField(24, variant=_messages.Variant.INT32)
  sourceFormat = _messages.StringField(25)
  sourceUris = _messages.StringField(26, repeated=True)
  timePartitioning = _messages.MessageField('TimePartitioning', 27)
  useAvroLogicalTypes = _messages.BooleanField(28)
  writeDisposition = _messages.StringField(29)


class JobConfigurationQuery(_messages.Message):
  r"""A JobConfigurationQuery object.

  Messages:
    TableDefinitionsValue: [Optional] If querying an external data source
      outside of BigQuery, describes the data format, location and other
      properties of the data source. By defining these properties, the data
      source can then be queried as if it were a standard BigQuery table.

  Fields:
    allowLargeResults: [Optional] If true and query uses legacy SQL dialect,
      allows the query to produce arbitrarily large result tables at a slight
      cost in performance. Requires destinationTable to be set. For standard
      SQL queries, this flag is ignored and large results are always allowed.
      However, you must still set destinationTable when result size exceeds
      the allowed maximum response size.
    clustering: [Beta] Clustering specification for the destination table.
      Must be specified with time-based partitioning, data in the table will
      be first partitioned and subsequently clustered.
    connectionProperties: Connection properties.
    createDisposition: [Optional] Specifies whether the job is allowed to
      create new tables. The following values are supported: CREATE_IF_NEEDED:
      If the table does not exist, BigQuery creates the table. CREATE_NEVER:
      The table must already exist. If it does not, a 'notFound' error is
      returned in the job result. The default value is CREATE_IF_NEEDED.
      Creation, truncation and append actions occur as one atomic update upon
      job completion.
    defaultDataset: [Optional] Specifies the default dataset to use for
      unqualified table names in the query. Note that this does not alter
      behavior of unqualified dataset names.
    destinationEncryptionConfiguration: Custom encryption configuration (e.g.,
      Cloud KMS keys).
    destinationTable: [Optional] Describes the table where the query results
      should be stored. If not present, a new table will be created to store
      the results. This property must be set for large results that exceed the
      maximum response size.
    flattenResults: [Optional] If true and query uses legacy SQL dialect,
      flattens all nested and repeated fields in the query results.
      allowLargeResults must be true if this is set to false. For standard SQL
      queries, this flag is ignored and results are never flattened.
    maximumBillingTier: [Optional] Limits the billing tier for this job.
      Queries that have resource usage beyond this tier will fail (without
      incurring a charge). If unspecified, this will be set to your project
      default.
    maximumBytesBilled: [Optional] Limits the bytes billed for this job.
      Queries that will have bytes billed beyond this limit will fail (without
      incurring a charge). If unspecified, this will be set to your project
      default.
    parameterMode: Standard SQL only. Set to POSITIONAL to use positional (?)
      query parameters or to NAMED to use named (@myparam) query parameters in
      this query.
    preserveNulls: [Deprecated] This property is deprecated.
    priority: [Optional] Specifies a priority for the query. Possible values
      include INTERACTIVE and BATCH. The default value is INTERACTIVE.
    query: [Required] SQL query text to execute. The useLegacySql field can be
      used to indicate whether the query uses legacy SQL or standard SQL.
    queryParameters: Query parameters for standard SQL queries.
    rangePartitioning: [TrustedTester] Range partitioning specification for
      this table. Only one of timePartitioning and rangePartitioning should be
      specified.
    schemaUpdateOptions: Allows the schema of the destination table to be
      updated as a side effect of the query job. Schema update options are
      supported in two cases: when writeDisposition is WRITE_APPEND; when
      writeDisposition is WRITE_TRUNCATE and the destination table is a
      partition of a table, specified by partition decorators. For normal
      tables, WRITE_TRUNCATE will always overwrite the schema. One or more of
      the following values are specified: ALLOW_FIELD_ADDITION: allow adding a
      nullable field to the schema. ALLOW_FIELD_RELAXATION: allow relaxing a
      required field in the original schema to nullable.
    tableDefinitions: [Optional] If querying an external data source outside
      of BigQuery, describes the data format, location and other properties of
      the data source. By defining these properties, the data source can then
      be queried as if it were a standard BigQuery table.
    timePartitioning: Time-based partitioning specification for the
      destination table. Only one of timePartitioning and rangePartitioning
      should be specified.
    useLegacySql: Specifies whether to use BigQuery's legacy SQL dialect for
      this query. The default value is true. If set to false, the query will
      use BigQuery's standard SQL: https://cloud.google.com/bigquery/sql-
      reference/ When useLegacySql is set to false, the value of
      flattenResults is ignored; query will be run as if flattenResults is
      false.
    useQueryCache: [Optional] Whether to look for the result in the query
      cache. The query cache is a best-effort cache that will be flushed
      whenever tables in the query are modified. Moreover, the query cache is
      only available when a query does not have a destination table specified.
      The default value is true.
    userDefinedFunctionResources: Describes user-defined function resources
      used in the query.
    writeDisposition: [Optional] Specifies the action that occurs if the
      destination table already exists. The following values are supported:
      WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the
      table data and uses the schema from the query result. WRITE_APPEND: If
      the table already exists, BigQuery appends the data to the table.
      WRITE_EMPTY: If the table already exists and contains data, a
      'duplicate' error is returned in the job result. The default value is
      WRITE_EMPTY. Each action is atomic and only occurs if BigQuery is able
      to complete the job successfully. Creation, truncation and append
      actions occur as one atomic update upon job completion.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TableDefinitionsValue(_messages.Message):
    r"""[Optional] If querying an external data source outside of BigQuery,
    describes the data format, location and other properties of the data
    source. By defining these properties, the data source can then be queried
    as if it were a standard BigQuery table.

    Messages:
      AdditionalProperty: An additional property for a TableDefinitionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        TableDefinitionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TableDefinitionsValue object.

      Fields:
        key: Name of the additional property.
        value: A ExternalDataConfiguration attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ExternalDataConfiguration', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  allowLargeResults = _messages.BooleanField(1, default=False)
  clustering = _messages.MessageField('Clustering', 2)
  connectionProperties = _messages.MessageField('ConnectionProperty', 3, repeated=True)
  createDisposition = _messages.StringField(4)
  defaultDataset = _messages.MessageField('DatasetReference', 5)
  destinationEncryptionConfiguration = _messages.MessageField('EncryptionConfiguration', 6)
  destinationTable = _messages.MessageField('TableReference', 7)
  flattenResults = _messages.BooleanField(8, default=True)
  maximumBillingTier = _messages.IntegerField(9, variant=_messages.Variant.INT32, default=1)
  maximumBytesBilled = _messages.IntegerField(10)
  parameterMode = _messages.StringField(11)
  preserveNulls = _messages.BooleanField(12)
  priority = _messages.StringField(13)
  query = _messages.StringField(14)
  queryParameters = _messages.MessageField('QueryParameter', 15, repeated=True)
  rangePartitioning = _messages.MessageField('RangePartitioning', 16)
  schemaUpdateOptions = _messages.StringField(17, repeated=True)
  tableDefinitions = _messages.MessageField('TableDefinitionsValue', 18)
  timePartitioning = _messages.MessageField('TimePartitioning', 19)
  useLegacySql = _messages.BooleanField(20, default=True)
  useQueryCache = _messages.BooleanField(21, default=True)
  userDefinedFunctionResources = _messages.MessageField('UserDefinedFunctionResource', 22, repeated=True)
  writeDisposition = _messages.StringField(23)


class JobConfigurationTableCopy(_messages.Message):
  r"""A JobConfigurationTableCopy object.

  Fields:
    createDisposition: [Optional] Specifies whether the job is allowed to
      create new tables. The following values are supported: CREATE_IF_NEEDED:
      If the table does not exist, BigQuery creates the table. CREATE_NEVER:
      The table must already exist. If it does not, a 'notFound' error is
      returned in the job result. The default value is CREATE_IF_NEEDED.
      Creation, truncation and append actions occur as one atomic update upon
      job completion.
    destinationEncryptionConfiguration: Custom encryption configuration (e.g.,
      Cloud KMS keys).
    destinationExpirationTime: [Optional] The time when the destination table
      expires. Expired tables will be deleted and their storage reclaimed.
    destinationTable: [Required] The destination table
    operationType: [Optional] Supported operation types in table copy job.
    sourceTable: [Pick one] Source table to copy.
    sourceTables: [Pick one] Source tables to copy.
    writeDisposition: [Optional] Specifies the action that occurs if the
      destination table already exists. The following values are supported:
      WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the
      table data. WRITE_APPEND: If the table already exists, BigQuery appends
      the data to the table. WRITE_EMPTY: If the table already exists and
      contains data, a 'duplicate' error is returned in the job result. The
      default value is WRITE_EMPTY. Each action is atomic and only occurs if
      BigQuery is able to complete the job successfully. Creation, truncation
      and append actions occur as one atomic update upon job completion.
  """

  createDisposition = _messages.StringField(1)
  destinationEncryptionConfiguration = _messages.MessageField('EncryptionConfiguration', 2)
  destinationExpirationTime = _messages.MessageField('extra_types.JsonValue', 3)
  destinationTable = _messages.MessageField('TableReference', 4)
  operationType = _messages.StringField(5)
  sourceTable = _messages.MessageField('TableReference', 6)
  sourceTables = _messages.MessageField('TableReference', 7, repeated=True)
  writeDisposition = _messages.StringField(8)


class JobList(_messages.Message):
  r"""A JobList object.

  Messages:
    JobsValueListEntry: A JobsValueListEntry object.

  Fields:
    etag: A hash of this page of results.
    jobs: List of jobs that were requested.
    kind: The resource type of the response.
    nextPageToken: A token to request the next page of results.
  """

  class JobsValueListEntry(_messages.Message):
    r"""A JobsValueListEntry object.

    Fields:
      configuration: [Full-projection-only] Specifies the job configuration.
      errorResult: A result object that will be present only if the job has
        failed.
      id: Unique opaque ID of the job.
      jobReference: Job reference uniquely identifying the job.
      kind: The resource type.
      state: Running state of the job. When the state is DONE, errorResult can
        be checked to determine whether the job succeeded or failed.
      statistics: [Output-only] Information about the job, including starting
        time and ending time of the job.
      status: [Full-projection-only] Describes the state of the job.
      user_email: [Full-projection-only] Email address of the user who ran the
        job.
    """

    configuration = _messages.MessageField('JobConfiguration', 1)
    errorResult = _messages.MessageField('ErrorProto', 2)
    id = _messages.StringField(3)
    jobReference = _messages.MessageField('JobReference', 4)
    kind = _messages.StringField(5, default='bigquery#job')
    state = _messages.StringField(6)
    statistics = _messages.MessageField('JobStatistics', 7)
    status = _messages.MessageField('JobStatus', 8)
    user_email = _messages.StringField(9)

  etag = _messages.StringField(1)
  jobs = _messages.MessageField('JobsValueListEntry', 2, repeated=True)
  kind = _messages.StringField(3, default='bigquery#jobList')
  nextPageToken = _messages.StringField(4)


class JobReference(_messages.Message):
  r"""A JobReference object.

  Fields:
    jobId: [Required] The ID of the job. The ID must contain only letters
      (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-). The maximum
      length is 1,024 characters.
    location: The geographic location of the job. See details at
      https://cloud.google.com/bigquery/docs/locations#specifying_your_locatio
      n.
    projectId: [Required] The ID of the project containing this job.
  """

  jobId = _messages.StringField(1)
  location = _messages.StringField(2)
  projectId = _messages.StringField(3)


class JobStatistics(_messages.Message):
  r"""A JobStatistics object.

  Messages:
    ReservationUsageValueListEntry: A ReservationUsageValueListEntry object.

  Fields:
    completionRatio: [TrustedTester] [Output-only] Job progress (0.0 -> 1.0)
      for LOAD and EXTRACT jobs.
    creationTime: [Output-only] Creation time of this job, in milliseconds
      since the epoch. This field will be present on all jobs.
    endTime: [Output-only] End time of this job, in milliseconds since the
      epoch. This field will be present whenever a job is in the DONE state.
    extract: [Output-only] Statistics for an extract job.
    load: [Output-only] Statistics for a load job.
    numChildJobs: [Output-only] Number of child jobs executed.
    parentJobId: [Output-only] If this is a child job, the id of the parent.
    query: [Output-only] Statistics for a query job.
    quotaDeferments: [Output-only] Quotas which delayed this job's start time.
    reservationUsage: [Output-only] Job resource usage breakdown by
      reservation.
    reservation_id: [Output-only] Name of the primary reservation assigned to
      this job. Note that this could be different than reservations reported
      in the reservation usage field if parent reservations were used to
      execute this job.
    rowLevelSecurityStatistics: [Output-only] [Preview] Statistics for row-
      level security. Present only for query and extract jobs.
    scriptStatistics: [Output-only] Statistics for a child job of a script.
    startTime: [Output-only] Start time of this job, in milliseconds since the
      epoch. This field will be present when the job transitions from the
      PENDING state to either RUNNING or DONE.
    totalBytesProcessed: [Output-only] [Deprecated] Use the bytes processed in
      the query statistics instead.
    totalSlotMs: [Output-only] Slot-milliseconds for the job.
    transactionInfoTemplate: [Output-only] [Alpha] Information of the multi-
      statement transaction if this job is part of one.
  """

  class ReservationUsageValueListEntry(_messages.Message):
    r"""A ReservationUsageValueListEntry object.

    Fields:
      name: [Output-only] Reservation name or "unreserved" for on-demand
        resources usage.
      slotMs: [Output-only] Slot-milliseconds the job spent in the given
        reservation.
    """

    name = _messages.StringField(1)
    slotMs = _messages.IntegerField(2)

  completionRatio = _messages.FloatField(1)
  creationTime = _messages.IntegerField(2)
  endTime = _messages.IntegerField(3)
  extract = _messages.MessageField('JobStatistics4', 4)
  load = _messages.MessageField('JobStatistics3', 5)
  numChildJobs = _messages.IntegerField(6)
  parentJobId = _messages.StringField(7)
  query = _messages.MessageField('JobStatistics2', 8)
  quotaDeferments = _messages.StringField(9, repeated=True)
  reservationUsage = _messages.MessageField('ReservationUsageValueListEntry', 10, repeated=True)
  reservation_id = _messages.StringField(11)
  rowLevelSecurityStatistics = _messages.MessageField('RowLevelSecurityStatistics', 12)
  scriptStatistics = _messages.MessageField('ScriptStatistics', 13)
  startTime = _messages.IntegerField(14)
  totalBytesProcessed = _messages.IntegerField(15)
  totalSlotMs = _messages.IntegerField(16)
  transactionInfoTemplate = _messages.MessageField('TransactionInfo', 17)


class JobStatistics2(_messages.Message):
  r"""A JobStatistics2 object.

  Messages:
    ReservationUsageValueListEntry: A ReservationUsageValueListEntry object.

  Fields:
    billingTier: [Output-only] Billing tier for the job.
    cacheHit: [Output-only] Whether the query result was fetched from the
      query cache.
    ddlAffectedRowAccessPolicyCount: [Output-only] [Preview] The number of row
      access policies affected by a DDL statement. Present only for DROP ALL
      ROW ACCESS POLICIES queries.
    ddlOperationPerformed: The DDL operation performed, possibly dependent on
      the pre-existence of the DDL target. Possible values (new values might
      be added in the future): "CREATE": The query created the DDL target.
      "SKIP": No-op. Example cases: the query is CREATE TABLE IF NOT EXISTS
      while the table already exists, or the query is DROP TABLE IF EXISTS
      while the table does not exist. "REPLACE": The query replaced the DDL
      target. Example case: the query is CREATE OR REPLACE TABLE, and the
      table already exists. "DROP": The query deleted the DDL target.
    ddlTargetRoutine: The DDL target routine. Present only for CREATE/DROP
      FUNCTION/PROCEDURE queries.
    ddlTargetRowAccessPolicy: [Output-only] [Preview] The DDL target row
      access policy. Present only for CREATE/DROP ROW ACCESS POLICY queries.
    ddlTargetTable: [Output-only] The DDL target table. Present only for
      CREATE/DROP TABLE/VIEW and DROP ALL ROW ACCESS POLICIES queries.
    estimatedBytesProcessed: [Output-only] The original estimate of bytes
      processed for the job.
    modelTraining: [Output-only, Beta] Information about create model query
      job progress.
    modelTrainingCurrentIteration: [Output-only, Beta] Deprecated; do not use.
    modelTrainingExpectedTotalIteration: [Output-only, Beta] Deprecated; do
      not use.
    numDmlAffectedRows: [Output-only] The number of rows affected by a DML
      statement. Present only for DML statements INSERT, UPDATE or DELETE.
    queryPlan: [Output-only] Describes execution plan for the query.
    referencedRoutines: [Output-only] Referenced routines (persistent user-
      defined functions and stored procedures) for the job.
    referencedTables: [Output-only] Referenced tables for the job. Queries
      that reference more than 50 tables will not have a complete list.
    reservationUsage: [Output-only] Job resource usage breakdown by
      reservation.
    schema: [Output-only] The schema of the results. Present only for
      successful dry run of non-legacy SQL queries.
    statementType: The type of query statement, if valid. Possible values (new
      values might be added in the future): "SELECT": SELECT query. "INSERT":
      INSERT query; see
      https://cloud.google.com/bigquery/docs/reference/standard-sql/data-
      manipulation-language. "UPDATE": UPDATE query; see
      https://cloud.google.com/bigquery/docs/reference/standard-sql/data-
      manipulation-language. "DELETE": DELETE query; see
      https://cloud.google.com/bigquery/docs/reference/standard-sql/data-
      manipulation-language. "MERGE": MERGE query; see
      https://cloud.google.com/bigquery/docs/reference/standard-sql/data-
      manipulation-language. "ALTER_TABLE": ALTER TABLE query. "ALTER_VIEW":
      ALTER VIEW query. "ASSERT": ASSERT condition AS 'description'.
      "CREATE_FUNCTION": CREATE FUNCTION query. "CREATE_MODEL": CREATE [OR
      REPLACE] MODEL ... AS SELECT ... . "CREATE_PROCEDURE": CREATE PROCEDURE
      query. "CREATE_TABLE": CREATE [OR REPLACE] TABLE without AS SELECT.
      "CREATE_TABLE_AS_SELECT": CREATE [OR REPLACE] TABLE ... AS SELECT ... .
      "CREATE_VIEW": CREATE [OR REPLACE] VIEW ... AS SELECT ... .
      "DROP_FUNCTION" : DROP FUNCTION query. "DROP_PROCEDURE": DROP PROCEDURE
      query. "DROP_TABLE": DROP TABLE query. "DROP_VIEW": DROP VIEW query.
    timeline: [Output-only] [Beta] Describes a timeline of job execution.
    totalBytesBilled: [Output-only] Total bytes billed for the job.
    totalBytesProcessed: [Output-only] Total bytes processed for the job.
    totalBytesProcessedAccuracy: [Output-only] For dry-run jobs,
      totalBytesProcessed is an estimate and this field specifies the accuracy
      of the estimate. Possible values can be: UNKNOWN: accuracy of the
      estimate is unknown. PRECISE: estimate is precise. LOWER_BOUND: estimate
      is lower bound of what the query would cost. UPPER_BOUND: estimate is
      upper bound of what the query would cost.
    totalPartitionsProcessed: [Output-only] Total number of partitions
      processed from all partitioned tables referenced in the job.
    totalSlotMs: [Output-only] Slot-milliseconds for the job.
    undeclaredQueryParameters: Standard SQL only: list of undeclared query
      parameters detected during a dry run validation.
  """

  class ReservationUsageValueListEntry(_messages.Message):
    r"""A ReservationUsageValueListEntry object.

    Fields:
      name: [Output-only] Reservation name or "unreserved" for on-demand
        resources usage.
      slotMs: [Output-only] Slot-milliseconds the job spent in the given
        reservation.
    """

    name = _messages.StringField(1)
    slotMs = _messages.IntegerField(2)

  billingTier = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  cacheHit = _messages.BooleanField(2)
  ddlAffectedRowAccessPolicyCount = _messages.IntegerField(3)
  ddlOperationPerformed = _messages.StringField(4)
  ddlTargetRoutine = _messages.MessageField('RoutineReference', 5)
  ddlTargetRowAccessPolicy = _messages.MessageField('RowAccessPolicyReference', 6)
  ddlTargetTable = _messages.MessageField('TableReference', 7)
  estimatedBytesProcessed = _messages.IntegerField(8)
  modelTraining = _messages.MessageField('BigQueryModelTraining', 9)
  modelTrainingCurrentIteration = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  modelTrainingExpectedTotalIteration = _messages.IntegerField(11)
  numDmlAffectedRows = _messages.IntegerField(12)
  queryPlan = _messages.MessageField('ExplainQueryStage', 13, repeated=True)
  referencedRoutines = _messages.MessageField('RoutineReference', 14, repeated=True)
  referencedTables = _messages.MessageField('TableReference', 15, repeated=True)
  reservationUsage = _messages.MessageField('ReservationUsageValueListEntry', 16, repeated=True)
  schema = _messages.MessageField('TableSchema', 17)
  statementType = _messages.StringField(18)
  timeline = _messages.MessageField('QueryTimelineSample', 19, repeated=True)
  totalBytesBilled = _messages.IntegerField(20)
  totalBytesProcessed = _messages.IntegerField(21)
  totalBytesProcessedAccuracy = _messages.StringField(22)
  totalPartitionsProcessed = _messages.IntegerField(23)
  totalSlotMs = _messages.IntegerField(24)
  undeclaredQueryParameters = _messages.MessageField('QueryParameter', 25, repeated=True)


class JobStatistics3(_messages.Message):
  r"""A JobStatistics3 object.

  Fields:
    badRecords: [Output-only] The number of bad records encountered. Note that
      if the job has failed because of more bad records encountered than the
      maximum allowed in the load job configuration, then this number can be
      less than the total number of bad records present in the input data.
    inputFileBytes: [Output-only] Number of bytes of source data in a load
      job.
    inputFiles: [Output-only] Number of source files in a load job.
    outputBytes: [Output-only] Size of the loaded data in bytes. Note that
      while a load job is in the running state, this value may change.
    outputRows: [Output-only] Number of rows imported in a load job. Note that
      while an import job is in the running state, this value may change.
  """

  badRecords = _messages.IntegerField(1)
  inputFileBytes = _messages.IntegerField(2)
  inputFiles = _messages.IntegerField(3)
  outputBytes = _messages.IntegerField(4)
  outputRows = _messages.IntegerField(5)


class JobStatistics4(_messages.Message):
  r"""A JobStatistics4 object.

  Fields:
    destinationUriFileCounts: [Output-only] Number of files per destination
      URI or URI pattern specified in the extract configuration. These values
      will be in the same order as the URIs specified in the 'destinationUris'
      field.
    inputBytes: [Output-only] Number of user bytes extracted into the result.
      This is the byte count as computed by BigQuery for billing purposes.
  """

  destinationUriFileCounts = _messages.IntegerField(1, repeated=True)
  inputBytes = _messages.IntegerField(2)


class JobStatus(_messages.Message):
  r"""A JobStatus object.

  Fields:
    errorResult: [Output-only] Final error result of the job. If present,
      indicates that the job has completed and was unsuccessful.
    errors: [Output-only] The first errors encountered during the running of
      the job. The final message includes the number of errors that caused the
      process to stop. Errors here do not necessarily mean that the job has
      completed or was unsuccessful.
    state: [Output-only] Running state of the job.
  """

  errorResult = _messages.MessageField('ErrorProto', 1)
  errors = _messages.MessageField('ErrorProto', 2, repeated=True)
  state = _messages.StringField(3)


@encoding.MapUnrecognizedFields('additionalProperties')
class JsonObject(_messages.Message):
  r"""Represents a single JSON object.

  Messages:
    AdditionalProperty: An additional property for a JsonObject object.

  Fields:
    additionalProperties: Additional properties of type JsonObject
  """

  class AdditionalProperty(_messages.Message):
    r"""An additional property for a JsonObject object.

    Fields:
      key: Name of the additional property.
      value: A JsonValue attribute.
    """

    key = _messages.StringField(1)
    value = _messages.MessageField('JsonValue', 2)

  additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)


JsonValue = extra_types.JsonValue


class MaterializedViewDefinition(_messages.Message):
  r"""A MaterializedViewDefinition object.

  Fields:
    enableRefresh: [Optional] [TrustedTester] Enable automatic refresh of the
      materialized view when the base table is updated. The default value is
      "true".
    lastRefreshTime: [Output-only] [TrustedTester] The time when this
      materialized view was last modified, in milliseconds since the epoch.
    query: [Required] A query whose result is persisted.
    refreshIntervalMs: [Optional] [TrustedTester] The maximum frequency at
      which this materialized view will be refreshed. The default value is
      "1800000" (30 minutes).
  """

  enableRefresh = _messages.BooleanField(1)
  lastRefreshTime = _messages.IntegerField(2)
  query = _messages.StringField(3)
  refreshIntervalMs = _messages.IntegerField(4)


class ModelDefinition(_messages.Message):
  r"""A ModelDefinition object.

  Messages:
    ModelOptionsValue: [Output-only, Beta] Model options used for the first
      training run. These options are immutable for subsequent training runs.
      Default values are used for any options not specified in the input
      query.

  Fields:
    modelOptions: [Output-only, Beta] Model options used for the first
      training run. These options are immutable for subsequent training runs.
      Default values are used for any options not specified in the input
      query.
    trainingRuns: [Output-only, Beta] Information about ml training runs, each
      training run comprises of multiple iterations and there may be multiple
      training runs for the model if warm start is used or if a user decides
      to continue a previously cancelled query.
  """

  class ModelOptionsValue(_messages.Message):
    r"""[Output-only, Beta] Model options used for the first training run.
    These options are immutable for subsequent training runs. Default values
    are used for any options not specified in the input query.

    Fields:
      labels: A string attribute.
      lossType: A string attribute.
      modelType: A string attribute.
    """

    labels = _messages.StringField(1, repeated=True)
    lossType = _messages.StringField(2)
    modelType = _messages.StringField(3)

  modelOptions = _messages.MessageField('ModelOptionsValue', 1)
  trainingRuns = _messages.MessageField('BqmlTrainingRun', 2, repeated=True)


class ModelReference(_messages.Message):
  r"""A ModelReference object.

  Fields:
    datasetId: [Required] The ID of the dataset containing this model.
    modelId: [Required] The ID of the model. The ID must contain only letters
      (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is
      1,024 characters.
    projectId: [Required] The ID of the project containing this model.
  """

  datasetId = _messages.StringField(1)
  modelId = _messages.StringField(2)
  projectId = _messages.StringField(3)


class ProjectList(_messages.Message):
  r"""A ProjectList object.

  Messages:
    ProjectsValueListEntry: A ProjectsValueListEntry object.

  Fields:
    etag: A hash of the page of results
    kind: The type of list.
    nextPageToken: A token to request the next page of results.
    projects: Projects to which you have at least READ access.
    totalItems: The total number of projects in the list.
  """

  class ProjectsValueListEntry(_messages.Message):
    r"""A ProjectsValueListEntry object.

    Fields:
      friendlyName: A descriptive name for this project.
      id: An opaque ID of this project.
      kind: The resource type.
      numericId: The numeric ID of this project.
      projectReference: A unique reference to this project.
    """

    friendlyName = _messages.StringField(1)
    id = _messages.StringField(2)
    kind = _messages.StringField(3, default='bigquery#project')
    numericId = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
    projectReference = _messages.MessageField('ProjectReference', 5)

  etag = _messages.StringField(1)
  kind = _messages.StringField(2, default='bigquery#projectList')
  nextPageToken = _messages.StringField(3)
  projects = _messages.MessageField('ProjectsValueListEntry', 4, repeated=True)
  totalItems = _messages.IntegerField(5, variant=_messages.Variant.INT32)


class ProjectReference(_messages.Message):
  r"""A ProjectReference object.

  Fields:
    projectId: [Required] ID of the project. Can be either the numeric ID or
      the assigned ID of the project.
  """

  projectId = _messages.StringField(1)


class QueryParameter(_messages.Message):
  r"""A QueryParameter object.

  Fields:
    name: [Optional] If unset, this is a positional parameter. Otherwise,
      should be unique within a query.
    parameterType: [Required] The type of this parameter.
    parameterValue: [Required] The value of this parameter.
  """

  name = _messages.StringField(1)
  parameterType = _messages.MessageField('QueryParameterType', 2)
  parameterValue = _messages.MessageField('QueryParameterValue', 3)


class QueryParameterType(_messages.Message):
  r"""A QueryParameterType object.

  Messages:
    StructTypesValueListEntry: A StructTypesValueListEntry object.

  Fields:
    arrayType: [Optional] The type of the array's elements, if this is an
      array.
    structTypes: [Optional] The types of the fields of this struct, in order,
      if this is a struct.
    type: [Required] The top level type of this field.
  """

  class StructTypesValueListEntry(_messages.Message):
    r"""A StructTypesValueListEntry object.

    Fields:
      description: [Optional] Human-oriented description of the field.
      name: [Optional] The name of this field.
      type: [Required] The type of this field.
    """

    description = _messages.StringField(1)
    name = _messages.StringField(2)
    type = _messages.MessageField('QueryParameterType', 3)

  arrayType = _messages.MessageField('QueryParameterType', 1)
  structTypes = _messages.MessageField('StructTypesValueListEntry', 2, repeated=True)
  type = _messages.StringField(3)


class QueryParameterValue(_messages.Message):
  r"""A QueryParameterValue object.

  Messages:
    StructValuesValue: [Optional] The struct field values, in order of the
      struct type's declaration.

  Fields:
    arrayValues: [Optional] The array values, if this is an array type.
    structValues: [Optional] The struct field values, in order of the struct
      type's declaration.
    value: [Optional] The value of this value, if a simple scalar type.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class StructValuesValue(_messages.Message):
    r"""[Optional] The struct field values, in order of the struct type's
    declaration.

    Messages:
      AdditionalProperty: An additional property for a StructValuesValue
        object.

    Fields:
      additionalProperties: Additional properties of type StructValuesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a StructValuesValue object.

      Fields:
        key: Name of the additional property.
        value: A QueryParameterValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('QueryParameterValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  arrayValues = _messages.MessageField('QueryParameterValue', 1, repeated=True)
  structValues = _messages.MessageField('StructValuesValue', 2)
  value = _messages.StringField(3)


class QueryRequest(_messages.Message):
  r"""A QueryRequest object.

  Messages:
    LabelsValue: The labels associated with this job. You can use these to
      organize and group your jobs. Label keys and values can be no longer
      than 63 characters, can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. Label values are optional. Label keys must start with a letter
      and each label in the list must have a different key.

  Fields:
    connectionProperties: Connection properties.
    defaultDataset: [Optional] Specifies the default datasetId and projectId
      to assume for any unqualified table names in the query. If not set, all
      table names in the query string must be qualified in the format
      'datasetId.tableId'.
    dryRun: [Optional] If set to true, BigQuery doesn't run the job. Instead,
      if the query is valid, BigQuery returns statistics about the job such as
      how many bytes would be processed. If the query is invalid, an error
      returns. The default value is false.
    kind: The resource type of the request.
    labels: The labels associated with this job. You can use these to organize
      and group your jobs. Label keys and values can be no longer than 63
      characters, can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. Label
      values are optional. Label keys must start with a letter and each label
      in the list must have a different key.
    location: The geographic location where the job should run. See details at
      https://cloud.google.com/bigquery/docs/locations#specifying_your_locatio
      n.
    maxResults: [Optional] The maximum number of rows of data to return per
      page of results. Setting this flag to a small value such as 1000 and
      then paging through results might improve reliability when the query
      result set is large. In addition to this limit, responses are also
      limited to 10 MB. By default, there is no maximum row count, and only
      the byte limit applies.
    maximumBytesBilled: [Optional] Limits the bytes billed for this job.
      Queries that will have bytes billed beyond this limit will fail (without
      incurring a charge). If unspecified, this will be set to your project
      default.
    parameterMode: Standard SQL only. Set to POSITIONAL to use positional (?)
      query parameters or to NAMED to use named (@myparam) query parameters in
      this query.
    preserveNulls: [Deprecated] This property is deprecated.
    query: [Required] A query string, following the BigQuery query syntax, of
      the query to execute. Example: "SELECT count(f1) FROM
      [myProjectId:myDatasetId.myTableId]".
    queryParameters: Query parameters for Standard SQL queries.
    requestId: A unique user provided identifier to ensure idempotent behavior
      for queries. Note that this is different from the job_id. It has the
      following properties: 1. It is case-sensitive, limited to up to 36 ASCII
      characters. A UUID is recommended. 2. Read only queries can ignore this
      token since they are nullipotent by definition. 3. For the purposes of
      idempotency ensured by the request_id, a request is considered duplicate
      of another only if they have the same request_id and are actually
      duplicates. When determining whether a request is a duplicate of the
      previous request, all parameters in the request that may affect the
      behavior are considered. For example, query, connection_properties,
      query_parameters, use_legacy_sql are parameters that affect the result
      and are considered when determining whether a request is a duplicate,
      but properties like timeout_ms don't affect the result and are thus not
      considered. Dry run query requests are never considered duplicate of
      another request. 4. When a duplicate mutating query request is detected,
      it returns: a. the results of the mutation if it completes successfully
      within the timeout. b. the running operation if it is still in progress
      at the end of the timeout. 5. Its lifetime is limited to 15 minutes. In
      other words, if two requests are sent with the same request_id, but more
      than 15 minutes apart, idempotency is not guaranteed.
    timeoutMs: [Optional] How long to wait for the query to complete, in
      milliseconds, before the request times out and returns. Note that this
      is only a timeout for the request, not the query. If the query takes
      longer to run than the timeout value, the call returns without any
      results and with the 'jobComplete' flag set to false. You can call
      GetQueryResults() to wait for the query to complete and read the
      results. The default value is 10000 milliseconds (10 seconds).
    useLegacySql: Specifies whether to use BigQuery's legacy SQL dialect for
      this query. The default value is true. If set to false, the query will
      use BigQuery's standard SQL: https://cloud.google.com/bigquery/sql-
      reference/ When useLegacySql is set to false, the value of
      flattenResults is ignored; query will be run as if flattenResults is
      false.
    useQueryCache: [Optional] Whether to look for the result in the query
      cache. The query cache is a best-effort cache that will be flushed
      whenever tables in the query are modified. The default value is true.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels associated with this job. You can use these to organize and
    group your jobs. Label keys and values can be no longer than 63
    characters, can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. Label values
    are optional. Label keys must start with a letter and each label in the
    list must have a different key.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  connectionProperties = _messages.MessageField('ConnectionProperty', 1, repeated=True)
  defaultDataset = _messages.MessageField('DatasetReference', 2)
  dryRun = _messages.BooleanField(3)
  kind = _messages.StringField(4, default='bigquery#queryRequest')
  labels = _messages.MessageField('LabelsValue', 5)
  location = _messages.StringField(6)
  maxResults = _messages.IntegerField(7, variant=_messages.Variant.UINT32)
  maximumBytesBilled = _messages.IntegerField(8)
  parameterMode = _messages.StringField(9)
  preserveNulls = _messages.BooleanField(10)
  query = _messages.StringField(11)
  queryParameters = _messages.MessageField('QueryParameter', 12, repeated=True)
  requestId = _messages.StringField(13)
  timeoutMs = _messages.IntegerField(14, variant=_messages.Variant.UINT32)
  useLegacySql = _messages.BooleanField(15, default=True)
  useQueryCache = _messages.BooleanField(16, default=True)


class QueryResponse(_messages.Message):
  r"""A QueryResponse object.

  Fields:
    cacheHit: Whether the query result was fetched from the query cache.
    errors: [Output-only] The first errors or warnings encountered during the
      running of the job. The final message includes the number of errors that
      caused the process to stop. Errors here do not necessarily mean that the
      job has completed or was unsuccessful.
    jobComplete: Whether the query has completed or not. If rows or totalRows
      are present, this will always be true. If this is false, totalRows will
      not be available.
    jobReference: Reference to the Job that was created to run the query. This
      field will be present even if the original request timed out, in which
      case GetQueryResults can be used to read the results once the query has
      completed. Since this API only returns the first page of results,
      subsequent pages can be fetched via the same mechanism
      (GetQueryResults).
    kind: The resource type.
    numDmlAffectedRows: [Output-only] The number of rows affected by a DML
      statement. Present only for DML statements INSERT, UPDATE or DELETE.
    pageToken: A token used for paging results.
    rows: An object with as many results as can be contained within the
      maximum permitted reply size. To get any additional rows, you can call
      GetQueryResults and specify the jobReference returned above.
    schema: The schema of the results. Present only when the query completes
      successfully.
    totalBytesProcessed: The total number of bytes processed for this query.
      If this query was a dry run, this is the number of bytes that would be
      processed if the query were run.
    totalRows: The total number of rows in the complete query result set,
      which can be more than the number of rows in this single page of
      results.
  """

  cacheHit = _messages.BooleanField(1)
  errors = _messages.MessageField('ErrorProto', 2, repeated=True)
  jobComplete = _messages.BooleanField(3)
  jobReference = _messages.MessageField('JobReference', 4)
  kind = _messages.StringField(5, default='bigquery#queryResponse')
  numDmlAffectedRows = _messages.IntegerField(6)
  pageToken = _messages.StringField(7)
  rows = _messages.MessageField('TableRow', 8, repeated=True)
  schema = _messages.MessageField('TableSchema', 9)
  totalBytesProcessed = _messages.IntegerField(10)
  totalRows = _messages.IntegerField(11, variant=_messages.Variant.UINT64)


class QueryTimelineSample(_messages.Message):
  r"""A QueryTimelineSample object.

  Fields:
    activeUnits: Total number of units currently being processed by workers.
      This does not correspond directly to slot usage. This is the largest
      value observed since the last sample.
    completedUnits: Total parallel units of work completed by this query.
    elapsedMs: Milliseconds elapsed since the start of query execution.
    pendingUnits: Total parallel units of work remaining for the active
      stages.
    totalSlotMs: Cumulative slot-ms consumed by the query.
  """

  activeUnits = _messages.IntegerField(1)
  completedUnits = _messages.IntegerField(2)
  elapsedMs = _messages.IntegerField(3)
  pendingUnits = _messages.IntegerField(4)
  totalSlotMs = _messages.IntegerField(5)


class RangePartitioning(_messages.Message):
  r"""A RangePartitioning object.

  Messages:
    RangeValue: [TrustedTester] [Required] Defines the ranges for range
      partitioning.

  Fields:
    field: [TrustedTester] [Required] The table is partitioned by this field.
      The field must be a top-level NULLABLE/REQUIRED field. The only
      supported type is INTEGER/INT64.
    range: [TrustedTester] [Required] Defines the ranges for range
      partitioning.
  """

  class RangeValue(_messages.Message):
    r"""[TrustedTester] [Required] Defines the ranges for range partitioning.

    Fields:
      end: [TrustedTester] [Required] The end of range partitioning,
        exclusive.
      interval: [TrustedTester] [Required] The width of each interval.
      start: [TrustedTester] [Required] The start of range partitioning,
        inclusive.
    """

    end = _messages.IntegerField(1)
    interval = _messages.IntegerField(2)
    start = _messages.IntegerField(3)

  field = _messages.StringField(1)
  range = _messages.MessageField('RangeValue', 2)


class RoutineReference(_messages.Message):
  r"""A RoutineReference object.

  Fields:
    datasetId: [Required] The ID of the dataset containing this routine.
    projectId: [Required] The ID of the project containing this routine.
    routineId: [Required] The ID of the routine. The ID must contain only
      letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum
      length is 256 characters.
  """

  datasetId = _messages.StringField(1)
  projectId = _messages.StringField(2)
  routineId = _messages.StringField(3)


class RowAccessPolicyReference(_messages.Message):
  r"""A RowAccessPolicyReference object.

  Fields:
    datasetId: [Required] The ID of the dataset containing this row access
      policy.
    policyId: [Required] The ID of the row access policy. The ID must contain
      only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum
      length is 256 characters.
    projectId: [Required] The ID of the project containing this row access
      policy.
    tableId: [Required] The ID of the table containing this row access policy.
  """

  datasetId = _messages.StringField(1)
  policyId = _messages.StringField(2)
  projectId = _messages.StringField(3)
  tableId = _messages.StringField(4)


class RowLevelSecurityStatistics(_messages.Message):
  r"""A RowLevelSecurityStatistics object.

  Fields:
    rowLevelSecurityApplied: [Output-only] [Preview] Whether any accessed data
      was protected by row access policies.
  """

  rowLevelSecurityApplied = _messages.BooleanField(1)


class ScriptStackFrame(_messages.Message):
  r"""A ScriptStackFrame object.

  Fields:
    endColumn: [Output-only] One-based end column.
    endLine: [Output-only] One-based end line.
    procedureId: [Output-only] Name of the active procedure, empty if in a
      top-level script.
    startColumn: [Output-only] One-based start column.
    startLine: [Output-only] One-based start line.
    text: [Output-only] Text of the current statement/expression.
  """

  endColumn = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  endLine = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  procedureId = _messages.StringField(3)
  startColumn = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  startLine = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  text = _messages.StringField(6)


class ScriptStatistics(_messages.Message):
  r"""A ScriptStatistics object.

  Fields:
    evaluationKind: [Output-only] Whether this child job was a statement or
      expression.
    stackFrames: Stack trace showing the line/column/procedure name of each
      frame on the stack at the point where the current evaluation happened.
      The leaf frame is first, the primary script is last. Never empty.
  """

  evaluationKind = _messages.StringField(1)
  stackFrames = _messages.MessageField('ScriptStackFrame', 2, repeated=True)


class SnapshotDefinition(_messages.Message):
  r"""A SnapshotDefinition object.

  Fields:
    baseTableReference: [Required] Reference describing the ID of the table
      that is snapshotted.
    snapshotTime: [Required] The time at which the base table was snapshot.
  """

  baseTableReference = _messages.MessageField('TableReference', 1)
  snapshotTime = _message_types.DateTimeField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    AltValueValuesEnum: Data format for the response.

  Fields:
    alt: Data format for the response.
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: An opaque string that represents a user for quota purposes.
      Must not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    userIp: Deprecated. Please use quotaUser instead.
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for the response.

    Values:
      json: Responses with Content-Type of application/json
    """
    json = 0

  alt = _messages.EnumField('AltValueValuesEnum', 1, default='json')
  fields = _messages.StringField(2)
  key = _messages.StringField(3)
  oauth_token = _messages.StringField(4)
  prettyPrint = _messages.BooleanField(5, default=True)
  quotaUser = _messages.StringField(6)
  trace = _messages.StringField(7)
  userIp = _messages.StringField(8)


class Streamingbuffer(_messages.Message):
  r"""A Streamingbuffer object.

  Fields:
    estimatedBytes: [Output-only] A lower-bound estimate of the number of
      bytes currently in the streaming buffer.
    estimatedRows: [Output-only] A lower-bound estimate of the number of rows
      currently in the streaming buffer.
    oldestEntryTime: [Output-only] Contains the timestamp of the oldest entry
      in the streaming buffer, in milliseconds since the epoch, if the
      streaming buffer is available.
  """

  estimatedBytes = _messages.IntegerField(1, variant=_messages.Variant.UINT64)
  estimatedRows = _messages.IntegerField(2, variant=_messages.Variant.UINT64)
  oldestEntryTime = _messages.IntegerField(3, variant=_messages.Variant.UINT64)


class Table(_messages.Message):
  r"""A Table object.

  Messages:
    LabelsValue: The labels associated with this table. You can use these to
      organize and group your tables. Label keys and values can be no longer
      than 63 characters, can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. Label values are optional. Label keys must start with a letter
      and each label in the list must have a different key.

  Fields:
    clustering: [Beta] Clustering specification for the table. Must be
      specified with partitioning, data in the table will be first partitioned
      and subsequently clustered.
    creationTime: [Output-only] The time when this table was created, in
      milliseconds since the epoch.
    description: [Optional] A user-friendly description of this table.
    encryptionConfiguration: Custom encryption configuration (e.g., Cloud KMS
      keys).
    etag: [Output-only] A hash of the table metadata. Used to ensure there
      were no concurrent modifications to the resource when attempting an
      update. Not guaranteed to change when the table contents or the fields
      numRows, numBytes, numLongTermBytes or lastModifiedTime change.
    expirationTime: [Optional] The time when this table expires, in
      milliseconds since the epoch. If not present, the table will persist
      indefinitely. Expired tables will be deleted and their storage
      reclaimed. The defaultTableExpirationMs property of the encapsulating
      dataset can be used to set a default expirationTime on newly created
      tables.
    externalDataConfiguration: [Optional] Describes the data format, location,
      and other properties of a table stored outside of BigQuery. By defining
      these properties, the data source can then be queried as if it were a
      standard BigQuery table.
    friendlyName: [Optional] A descriptive name for this table.
    id: [Output-only] An opaque ID uniquely identifying the table.
    kind: [Output-only] The type of the resource.
    labels: The labels associated with this table. You can use these to
      organize and group your tables. Label keys and values can be no longer
      than 63 characters, can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. Label values are optional. Label keys must start with a letter
      and each label in the list must have a different key.
    lastModifiedTime: [Output-only] The time when this table was last
      modified, in milliseconds since the epoch.
    location: [Output-only] The geographic location where the table resides.
      This value is inherited from the dataset.
    materializedView: [Optional] Materialized view definition.
    model: [Output-only, Beta] Present iff this table represents a ML model.
      Describes the training information for the model, and it is required to
      run 'PREDICT' queries.
    numBytes: [Output-only] The size of this table in bytes, excluding any
      data in the streaming buffer.
    numLongTermBytes: [Output-only] The number of bytes in the table that are
      considered "long-term storage".
    numPhysicalBytes: [Output-only] [TrustedTester] The physical size of this
      table in bytes, excluding any data in the streaming buffer. This
      includes compression and storage used for time travel.
    numRows: [Output-only] The number of rows of data in this table, excluding
      any data in the streaming buffer.
    rangePartitioning: [TrustedTester] Range partitioning specification for
      this table. Only one of timePartitioning and rangePartitioning should be
      specified.
    requirePartitionFilter: [Optional] If set to true, queries over this table
      require a partition filter that can be used for partition elimination to
      be specified.
    schema: [Optional] Describes the schema of this table.
    selfLink: [Output-only] A URL that can be used to access this resource
      again.
    snapshotDefinition: [Output-only] Snapshot definition.
    streamingBuffer: [Output-only] Contains information regarding this table's
      streaming buffer, if one is present. This field will be absent if the
      table is not being streamed to or if there is no data in the streaming
      buffer.
    tableReference: [Required] Reference describing the ID of this table.
    timePartitioning: Time-based partitioning specification for this table.
      Only one of timePartitioning and rangePartitioning should be specified.
    type: [Output-only] Describes the table type. The following values are
      supported: TABLE: A normal BigQuery table. VIEW: A virtual table defined
      by a SQL query. SNAPSHOT: An immutable, read-only table that is a copy
      of another table. [TrustedTester] MATERIALIZED_VIEW: SQL query whose
      result is persisted. EXTERNAL: A table that references data stored in an
      external storage system, such as Google Cloud Storage. The default value
      is TABLE.
    view: [Optional] The view definition.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels associated with this table. You can use these to organize
    and group your tables. Label keys and values can be no longer than 63
    characters, can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. Label values
    are optional. Label keys must start with a letter and each label in the
    list must have a different key.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clustering = _messages.MessageField('Clustering', 1)
  creationTime = _messages.IntegerField(2)
  description = _messages.StringField(3)
  encryptionConfiguration = _messages.MessageField('EncryptionConfiguration', 4)
  etag = _messages.StringField(5)
  expirationTime = _messages.IntegerField(6)
  externalDataConfiguration = _messages.MessageField('ExternalDataConfiguration', 7)
  friendlyName = _messages.StringField(8)
  id = _messages.StringField(9)
  kind = _messages.StringField(10, default='bigquery#table')
  labels = _messages.MessageField('LabelsValue', 11)
  lastModifiedTime = _messages.IntegerField(12, variant=_messages.Variant.UINT64)
  location = _messages.StringField(13)
  materializedView = _messages.MessageField('MaterializedViewDefinition', 14)
  model = _messages.MessageField('ModelDefinition', 15)
  numBytes = _messages.IntegerField(16)
  numLongTermBytes = _messages.IntegerField(17)
  numPhysicalBytes = _messages.IntegerField(18)
  numRows = _messages.IntegerField(19, variant=_messages.Variant.UINT64)
  rangePartitioning = _messages.MessageField('RangePartitioning', 20)
  requirePartitionFilter = _messages.BooleanField(21, default=False)
  schema = _messages.MessageField('TableSchema', 22)
  selfLink = _messages.StringField(23)
  snapshotDefinition = _messages.MessageField('SnapshotDefinition', 24)
  streamingBuffer = _messages.MessageField('Streamingbuffer', 25)
  tableReference = _messages.MessageField('TableReference', 26)
  timePartitioning = _messages.MessageField('TimePartitioning', 27)
  type = _messages.StringField(28)
  view = _messages.MessageField('ViewDefinition', 29)


class TableCell(_messages.Message):
  r"""A TableCell object.

  Fields:
    v: A extra_types.JsonValue attribute.
  """

  v = _messages.MessageField('extra_types.JsonValue', 1)


class TableDataInsertAllRequest(_messages.Message):
  r"""A TableDataInsertAllRequest object.

  Messages:
    RowsValueListEntry: A RowsValueListEntry object.

  Fields:
    ignoreUnknownValues: [Optional] Accept rows that contain values that do
      not match the schema. The unknown values are ignored. Default is false,
      which treats unknown values as errors.
    kind: The resource type of the response.
    rows: The rows to insert.
    skipInvalidRows: [Optional] Insert all valid rows of a request, even if
      invalid rows exist. The default value is false, which causes the entire
      request to fail if any invalid rows exist.
    templateSuffix: If specified, treats the destination table as a base
      template, and inserts the rows into an instance table named
      "{destination}{templateSuffix}". BigQuery will manage creation of the
      instance table, using the schema of the base template table. See
      https://cloud.google.com/bigquery/streaming-data-into-bigquery#template-
      tables for considerations when working with templates tables.
  """

  class RowsValueListEntry(_messages.Message):
    r"""A RowsValueListEntry object.

    Fields:
      insertId: [Optional] A unique ID for each row. BigQuery uses this
        property to detect duplicate insertion requests on a best-effort
        basis.
      json: [Required] A JSON object that contains a row of data. The object's
        properties and values must match the destination table's schema.
    """

    insertId = _messages.StringField(1)
    json = _messages.MessageField('JsonObject', 2)

  ignoreUnknownValues = _messages.BooleanField(1)
  kind = _messages.StringField(2, default='bigquery#tableDataInsertAllRequest')
  rows = _messages.MessageField('RowsValueListEntry', 3, repeated=True)
  skipInvalidRows = _messages.BooleanField(4)
  templateSuffix = _messages.StringField(5)


class TableDataInsertAllResponse(_messages.Message):
  r"""A TableDataInsertAllResponse object.

  Messages:
    InsertErrorsValueListEntry: A InsertErrorsValueListEntry object.

  Fields:
    insertErrors: An array of errors for rows that were not inserted.
    kind: The resource type of the response.
  """

  class InsertErrorsValueListEntry(_messages.Message):
    r"""A InsertErrorsValueListEntry object.

    Fields:
      errors: Error information for the row indicated by the index property.
      index: The index of the row that error applies to.
    """

    errors = _messages.MessageField('ErrorProto', 1, repeated=True)
    index = _messages.IntegerField(2, variant=_messages.Variant.UINT32)

  insertErrors = _messages.MessageField('InsertErrorsValueListEntry', 1, repeated=True)
  kind = _messages.StringField(2, default='bigquery#tableDataInsertAllResponse')


class TableDataList(_messages.Message):
  r"""A TableDataList object.

  Fields:
    etag: A hash of this page of results.
    kind: The resource type of the response.
    pageToken: A token used for paging results. Providing this token instead
      of the startIndex parameter can help you retrieve stable results when an
      underlying table is changing.
    rows: Rows of results.
    totalRows: The total number of rows in the complete table.
  """

  etag = _messages.StringField(1)
  kind = _messages.StringField(2, default='bigquery#tableDataList')
  pageToken = _messages.StringField(3)
  rows = _messages.MessageField('TableRow', 4, repeated=True)
  totalRows = _messages.IntegerField(5)


class TableFieldSchema(_messages.Message):
  r"""A TableFieldSchema object.

  Messages:
    CategoriesValue: [Optional] The categories attached to this field, used
      for field-level access control.
    PolicyTagsValue: A PolicyTagsValue object.

  Fields:
    categories: [Optional] The categories attached to this field, used for
      field-level access control.
    description: [Optional] The field description. The maximum length is 1,024
      characters.
    fields: [Optional] Describes the nested schema fields if the type property
      is set to RECORD.
    mode: [Optional] The field mode. Possible values include NULLABLE,
      REQUIRED and REPEATED. The default value is NULLABLE.
    name: [Required] The field name. The name must contain only letters (a-z,
      A-Z), numbers (0-9), or underscores (_), and must start with a letter or
      underscore. The maximum length is 128 characters.
    policyTags: A PolicyTagsValue attribute.
    type: [Required] The field data type. Possible values include STRING,
      BYTES, INTEGER, INT64 (same as INTEGER), FLOAT, FLOAT64 (same as FLOAT),
      NUMERIC, BIGNUMERIC, BOOLEAN, BOOL (same as BOOLEAN), TIMESTAMP, DATE,
      TIME, DATETIME, RECORD (where RECORD indicates that the field contains a
      nested schema) or STRUCT (same as RECORD).
  """

  class CategoriesValue(_messages.Message):
    r"""[Optional] The categories attached to this field, used for field-level
    access control.

    Fields:
      names: A list of category resource names. For example,
        "projects/1/taxonomies/2/categories/3". At most 5 categories are
        allowed.
    """

    names = _messages.StringField(1, repeated=True)

  class PolicyTagsValue(_messages.Message):
    r"""A PolicyTagsValue object.

    Fields:
      names: A list of category resource names. For example,
        "projects/1/location/eu/taxonomies/2/policyTags/3". At most 1 policy
        tag is allowed.
    """

    names = _messages.StringField(1, repeated=True)

  categories = _messages.MessageField('CategoriesValue', 1)
  description = _messages.StringField(2)
  fields = _messages.MessageField('TableFieldSchema', 3, repeated=True)
  mode = _messages.StringField(4)
  name = _messages.StringField(5)
  policyTags = _messages.MessageField('PolicyTagsValue', 6)
  type = _messages.StringField(7)


class TableList(_messages.Message):
  r"""A TableList object.

  Messages:
    TablesValueListEntry: A TablesValueListEntry object.

  Fields:
    etag: A hash of this page of results.
    kind: The type of list.
    nextPageToken: A token to request the next page of results.
    tables: Tables in the requested dataset.
    totalItems: The total number of tables in the dataset.
  """

  class TablesValueListEntry(_messages.Message):
    r"""A TablesValueListEntry object.

    Messages:
      LabelsValue: The labels associated with this table. You can use these to
        organize and group your tables.
      ViewValue: Additional details for a view.

    Fields:
      clustering: [Beta] Clustering specification for this table, if
        configured.
      creationTime: The time when this table was created, in milliseconds
        since the epoch.
      expirationTime: [Optional] The time when this table expires, in
        milliseconds since the epoch. If not present, the table will persist
        indefinitely. Expired tables will be deleted and their storage
        reclaimed.
      friendlyName: The user-friendly name for this table.
      id: An opaque ID of the table
      kind: The resource type.
      labels: The labels associated with this table. You can use these to
        organize and group your tables.
      rangePartitioning: The range partitioning specification for this table,
        if configured.
      tableReference: A reference uniquely identifying the table.
      timePartitioning: The time-based partitioning specification for this
        table, if configured.
      type: The type of table. Possible values are: TABLE, VIEW.
      view: Additional details for a view.
    """

    @encoding.MapUnrecognizedFields('additionalProperties')
    class LabelsValue(_messages.Message):
      r"""The labels associated with this table. You can use these to organize
      and group your tables.

      Messages:
        AdditionalProperty: An additional property for a LabelsValue object.

      Fields:
        additionalProperties: Additional properties of type LabelsValue
      """

      class AdditionalProperty(_messages.Message):
        r"""An additional property for a LabelsValue object.

        Fields:
          key: Name of the additional property.
          value: A string attribute.
        """

        key = _messages.StringField(1)
        value = _messages.StringField(2)

      additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

    class ViewValue(_messages.Message):
      r"""Additional details for a view.

      Fields:
        useLegacySql: True if view is defined in legacy SQL dialect, false if
          in standard SQL.
      """

      useLegacySql = _messages.BooleanField(1)

    clustering = _messages.MessageField('Clustering', 1)
    creationTime = _messages.IntegerField(2)
    expirationTime = _messages.IntegerField(3)
    friendlyName = _messages.StringField(4)
    id = _messages.StringField(5)
    kind = _messages.StringField(6, default='bigquery#table')
    labels = _messages.MessageField('LabelsValue', 7)
    rangePartitioning = _messages.MessageField('RangePartitioning', 8)
    tableReference = _messages.MessageField('TableReference', 9)
    timePartitioning = _messages.MessageField('TimePartitioning', 10)
    type = _messages.StringField(11)
    view = _messages.MessageField('ViewValue', 12)

  etag = _messages.StringField(1)
  kind = _messages.StringField(2, default='bigquery#tableList')
  nextPageToken = _messages.StringField(3)
  tables = _messages.MessageField('TablesValueListEntry', 4, repeated=True)
  totalItems = _messages.IntegerField(5, variant=_messages.Variant.INT32)


class TableReference(_messages.Message):
  r"""A TableReference object.

  Fields:
    datasetId: [Required] The ID of the dataset containing this table.
    projectId: [Required] The ID of the project containing this table.
    tableId: [Required] The ID of the table. The ID must contain only letters
      (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is
      1,024 characters.
  """

  datasetId = _messages.StringField(1)
  projectId = _messages.StringField(2)
  tableId = _messages.StringField(3)


class TableRow(_messages.Message):
  r"""A TableRow object.

  Fields:
    f: Represents a single row in the result set, consisting of one or more
      fields.
  """

  f = _messages.MessageField('TableCell', 1, repeated=True)


class TableSchema(_messages.Message):
  r"""A TableSchema object.

  Fields:
    fields: Describes the fields in a table.
  """

  fields = _messages.MessageField('TableFieldSchema', 1, repeated=True)


class TimePartitioning(_messages.Message):
  r"""A TimePartitioning object.

  Fields:
    expirationMs: [Optional] Number of milliseconds for which to keep the
      storage for partitions in the table. The storage in a partition will
      have an expiration time of its partition time plus this value.
    field: [Beta] [Optional] If not set, the table is partitioned by pseudo
      column, referenced via either '_PARTITIONTIME' as TIMESTAMP type, or
      '_PARTITIONDATE' as DATE type. If field is specified, the table is
      instead partitioned by this field. The field must be a top-level
      TIMESTAMP or DATE field. Its mode must be NULLABLE or REQUIRED.
    requirePartitionFilter: A boolean attribute.
    type: [Required] The supported types are DAY, HOUR, MONTH, and YEAR, which
      will generate one partition per day, hour, month, and year,
      respectively. When the type is not specified, the default behavior is
      DAY.
  """

  expirationMs = _messages.IntegerField(1)
  field = _messages.StringField(2)
  requirePartitionFilter = _messages.BooleanField(3)
  type = _messages.StringField(4)


class TransactionInfo(_messages.Message):
  r"""A TransactionInfo object.

  Fields:
    transactionId: [Output-only] // [Alpha] Id of the transaction.
  """

  transactionId = _messages.StringField(1)


class UserDefinedFunctionResource(_messages.Message):
  r"""This is used for defining User Defined Function (UDF) resources only
  when using legacy SQL. Users of Standard SQL should leverage either DDL
  (e.g. CREATE [TEMPORARY] FUNCTION ... ) or the Routines API to define UDF
  resources. For additional information on migrating, see:
  https://cloud.google.com/bigquery/docs/reference/standard-sql/migrating-
  from-legacy-sql#differences_in_user-defined_javascript_functions

  Fields:
    inlineCode: [Pick one] An inline resource that contains code for a user-
      defined function (UDF). Providing a inline code resource is equivalent
      to providing a URI for a file containing the same code.
    resourceUri: [Pick one] A code resource to load from a Google Cloud
      Storage URI (gs://bucket/path).
  """

  inlineCode = _messages.StringField(1)
  resourceUri = _messages.StringField(2)


class ViewDefinition(_messages.Message):
  r"""A ViewDefinition object.

  Fields:
    query: [Required] A query that BigQuery executes when the view is
      referenced.
    useLegacySql: Specifies whether to use BigQuery's legacy SQL for this
      view. The default value is true. If set to false, the view will use
      BigQuery's standard SQL: https://cloud.google.com/bigquery/sql-
      reference/ Queries and views that reference this view must use the same
      flag value.
    userDefinedFunctionResources: Describes user-defined function resources
      used in the query.
  """

  query = _messages.StringField(1)
  useLegacySql = _messages.BooleanField(2)
  userDefinedFunctionResources = _messages.MessageField('UserDefinedFunctionResource', 3, repeated=True)


