/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.fix.Java50Fix;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.sef.SelfEncapsulateFieldRefactoring;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.fix.Java50CleanUp;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.refactoring.sef.SelfEncapsulateFieldWizard;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.ChangeCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.FixCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.JavadocTagsSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.ModifierChangeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.correction.QuickAssistProcessor;
import org.eclipse.jdt.internal.ui.text.correction.UnresolvedElementsSubProcessor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ModifierCorrectionSubProcessor {
    public static final int TO_STATIC = 1;
    public static final int TO_VISIBLE = 2;
    public static final int TO_NON_PRIVATE = 3;
    public static final int TO_NON_STATIC = 4;
    public static final int TO_NON_FINAL = 5;
    private static final String KEY_MODIFIER = "modifier";

    public static void addNonAccessibleReferenceProposal(IInvocationContext context, IProblemLocation problem, Collection proposals, int kind, int relevance) throws CoreException {
        String name;
        IMethodBinding bindingDecl;
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return;
        }
        IBinding binding = null;
        switch (selectedNode.getNodeType()) {
            case 42: {
                binding = ((SimpleName)selectedNode).resolveBinding();
                break;
            }
            case 40: {
                binding = ((QualifiedName)selectedNode).resolveBinding();
                break;
            }
            case 43: {
                binding = ((SimpleType)selectedNode).resolveBinding();
                break;
            }
            case 32: {
                binding = ((MethodInvocation)selectedNode).getName().resolveBinding();
                break;
            }
            case 48: {
                binding = ((SuperMethodInvocation)selectedNode).getName().resolveBinding();
                break;
            }
            case 22: {
                binding = ((FieldAccess)selectedNode).getName().resolveBinding();
                break;
            }
            case 47: {
                binding = ((SuperFieldAccess)selectedNode).getName().resolveBinding();
                break;
            }
            case 14: {
                binding = ((ClassInstanceCreation)selectedNode).resolveConstructorBinding();
                break;
            }
            case 46: {
                binding = ((SuperConstructorInvocation)selectedNode).resolveConstructorBinding();
                break;
            }
            default: {
                return;
            }
        }
        ITypeBinding typeBinding = null;
        boolean isLocalVar = false;
        if (binding instanceof IMethodBinding) {
            IMethodBinding methodDecl = (IMethodBinding)binding;
            bindingDecl = methodDecl.getMethodDeclaration();
            typeBinding = methodDecl.getDeclaringClass();
            name = String.valueOf(methodDecl.getName()) + "()";
        } else if (binding instanceof IVariableBinding) {
            IVariableBinding varDecl = (IVariableBinding)binding;
            typeBinding = varDecl.getDeclaringClass();
            name = binding.getName();
            isLocalVar = !varDecl.isField();
            bindingDecl = varDecl.getVariableDeclaration();
        } else if (binding instanceof ITypeBinding) {
            typeBinding = (ITypeBinding)binding;
            bindingDecl = typeBinding.getTypeDeclaration();
            name = binding.getName();
        } else {
            return;
        }
        if (typeBinding != null && typeBinding.isFromSource() || isLocalVar) {
            ICompilationUnit targetCU;
            String label;
            int includedModifiers = 0;
            int excludedModifiers = 0;
            switch (kind) {
                case 2: {
                    excludedModifiers = 7;
                    includedModifiers = ModifierCorrectionSubProcessor.getNeededVisibility(selectedNode, typeBinding);
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changevisibility_description, new String[]{name, ModifierCorrectionSubProcessor.getVisibilityString(includedModifiers)});
                    break;
                }
                case 1: {
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertostatic_description, name);
                    includedModifiers = 8;
                    break;
                }
                case 4: {
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertononstatic_description, name);
                    excludedModifiers = 8;
                    break;
                }
                case 3: {
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertodefault_description, name);
                    excludedModifiers = 2;
                    break;
                }
                case 5: {
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertononfinal_description, name);
                    excludedModifiers = 16;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("not supported");
                }
            }
            ICompilationUnit iCompilationUnit = targetCU = isLocalVar ? cu : ASTResolving.findCompilationUnitForBinding(cu, context.getASTRoot(), typeBinding.getTypeDeclaration());
            if (targetCU != null) {
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                proposals.add(new ModifierChangeCompletionProposal(label, targetCU, (IBinding)bindingDecl, selectedNode, includedModifiers, excludedModifiers, relevance, image));
            }
        }
        if (kind == 2 && bindingDecl.getKind() == 3) {
            UnresolvedElementsSubProcessor.getVariableProposals(context, problem, (IVariableBinding)bindingDecl, proposals);
        }
    }

    public static void addChangeOverriddenModfierProposal(IInvocationContext context, IProblemLocation problem, Collection proposals, int kind) throws JavaModelException {
        IMethodBinding defining;
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        IMethodBinding method = ((MethodDeclaration)selectedNode).resolveBinding();
        ITypeBinding curr = method.getDeclaringClass();
        if (kind == 2 && problem.getProblemId() != 67109274 && (defining = Bindings.findOverriddenMethod(method, false)) != null) {
            int excludedModifiers = 7;
            int includedModifiers = JdtFlags.getVisibilityCode((IBinding)defining);
            String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemethodvisibility_description, new String[]{ModifierCorrectionSubProcessor.getVisibilityString(includedModifiers)});
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            proposals.add(new ModifierChangeCompletionProposal(label, cu, (IBinding)method, selectedNode, includedModifiers, excludedModifiers, 8, image));
        }
        IMethodBinding overriddenInClass = null;
        while (overriddenInClass == null && curr.getSuperclass() != null) {
            curr = curr.getSuperclass();
            overriddenInClass = Bindings.findOverriddenMethodInType(curr, method);
        }
        if (overriddenInClass != null) {
            IMethodBinding overriddenDecl = overriddenInClass.getMethodDeclaration();
            ICompilationUnit targetCU = ASTResolving.findCompilationUnitForBinding(cu, context.getASTRoot(), overriddenDecl.getDeclaringClass());
            if (targetCU != null) {
                String label;
                int includedModifiers;
                int excludedModifiers;
                String methodName = String.valueOf(curr.getName()) + '.' + overriddenInClass.getName();
                switch (kind) {
                    case 2: {
                        excludedModifiers = 7;
                        includedModifiers = JdtFlags.getVisibilityCode((IBinding)method);
                        label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changeoverriddenvisibility_description, new String[]{methodName, ModifierCorrectionSubProcessor.getVisibilityString(includedModifiers)});
                        break;
                    }
                    case 5: {
                        label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemethodtononfinal_description, methodName);
                        excludedModifiers = 16;
                        includedModifiers = 0;
                        break;
                    }
                    case 4: {
                        label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemethodtononstatic_description, methodName);
                        excludedModifiers = 8;
                        includedModifiers = 0;
                        break;
                    }
                    default: {
                        Assert.isTrue((boolean)false, (String)"not supported");
                        return;
                    }
                }
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                proposals.add(new ModifierChangeCompletionProposal(label, targetCU, (IBinding)overriddenDecl, selectedNode, includedModifiers, excludedModifiers, 7, image));
            }
        }
    }

    public static void addNonFinalLocalProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        IBinding binding = ((SimpleName)selectedNode).resolveBinding();
        if (binding instanceof IVariableBinding) {
            binding = ((IVariableBinding)binding).getVariableDeclaration();
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertofinal_description, binding.getName());
            proposals.add(new ModifierChangeCompletionProposal(label, cu, binding, selectedNode, 16, 0, 5, image));
        }
    }

    public static void addRemoveInvalidModfiersProposal(IInvocationContext context, IProblemLocation problem, Collection proposals, int relevance) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode instanceof MethodDeclaration) {
            selectedNode = ((MethodDeclaration)selectedNode).getName();
        }
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        IBinding binding = ((SimpleName)selectedNode).resolveBinding();
        if (binding != null) {
            ASTNode parentType;
            ITypeBinding declClass;
            String methodName = binding.getName();
            String label = null;
            int problemId = problem.getProblemId();
            int excludedModifiers = 0;
            int includedModifiers = 0;
            switch (problemId) {
                case 67109225: 
                case 67109271: {
                    excludedModifiers = 8;
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemethodtononstatic_description, methodName);
                    break;
                }
                case 33554778: {
                    excludedModifiers = 8;
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changefieldmodifiertononstatic_description, methodName);
                    break;
                }
                case 33554777: {
                    excludedModifiers = 64;
                    label = CorrectionMessages.ModifierCorrectionSubProcessor_removevolatile_description;
                    break;
                }
                case 67109223: {
                    excludedModifiers = -1026;
                    break;
                }
                case 16777519: {
                    excludedModifiers = -3074;
                    break;
                }
                case 16777518: {
                    excludedModifiers = -3090;
                    break;
                }
                case 33554775: {
                    excludedModifiers = -1042;
                    break;
                }
                case 0x1000131: 
                case 16777525: {
                    excludedModifiers = -2058;
                    break;
                }
                case 0x1000130: {
                    excludedModifiers = -3104;
                    break;
                }
                case 16777522: {
                    excludedModifiers = -3089;
                    break;
                }
                case 67109220: {
                    excludedModifiers = -17;
                    break;
                }
                case 33554774: {
                    excludedModifiers = -224;
                    break;
                }
                case 67109222: {
                    excludedModifiers = -3360;
                    if (!((IMethodBinding)binding).isConstructor()) break;
                    excludedModifiers |= 8;
                    break;
                }
                case 67109260: {
                    excludedModifiers = -17;
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"not supported");
                    return;
                }
            }
            if (label == null) {
                label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_removeinvalidmodifiers_description, methodName);
            }
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            proposals.add(new ModifierChangeCompletionProposal(label, cu, binding, selectedNode, includedModifiers, excludedModifiers, relevance, image));
            if (problemId == 33554777) {
                proposals.add(new ModifierChangeCompletionProposal(CorrectionMessages.ModifierCorrectionSubProcessor_removefinal_description, cu, binding, selectedNode, 0, 16, relevance + 1, image));
            }
            if (problemId == 33554778 && binding instanceof IVariableBinding && (declClass = ((IVariableBinding)binding).getDeclaringClass()).isMember()) {
                proposals.add(new ModifierChangeCompletionProposal(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertostaticfinal_description, cu, binding, selectedNode, 16, 64, relevance + 1, image));
                parentType = context.getASTRoot().findDeclaringNode((IBinding)declClass);
                if (parentType != null) {
                    proposals.add(new ModifierChangeCompletionProposal(CorrectionMessages.ModifierCorrectionSubProcessor_addstatictoparenttype_description, cu, (IBinding)declClass, parentType, 8, 0, relevance - 1, image));
                }
            }
            if (problemId == 67109225 && binding instanceof IMethodBinding && (declClass = ((IMethodBinding)binding).getDeclaringClass()).isMember() && (parentType = context.getASTRoot().findDeclaringNode((IBinding)declClass)) != null) {
                proposals.add(new ModifierChangeCompletionProposal(CorrectionMessages.ModifierCorrectionSubProcessor_addstatictoparenttype_description, cu, (IBinding)declClass, parentType, 8, 0, relevance - 1, image));
            }
        }
    }

    private static String getVisibilityString(int code) {
        if (Modifier.isPublic((int)code)) {
            return "public";
        }
        if (Modifier.isProtected((int)code)) {
            return "protected";
        }
        if (Modifier.isPrivate((int)code)) {
            return "private";
        }
        return CorrectionMessages.ModifierCorrectionSubProcessor_default;
    }

    private static int getNeededVisibility(ASTNode currNode, ITypeBinding targetType) {
        ITypeBinding currNodeBinding = Bindings.getBindingOfParentType(currNode);
        if (currNodeBinding == null) {
            return 1;
        }
        if (Bindings.isSuperType(targetType, currNodeBinding)) {
            return 4;
        }
        if (currNodeBinding.getPackage().getKey().equals(targetType.getPackage().getKey())) {
            return 0;
        }
        return 1;
    }

    public static void addAbstractMethodProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        boolean hasNoBody;
        MethodDeclaration decl;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        if (selectedNode instanceof SimpleName) {
            decl = (MethodDeclaration)selectedNode.getParent();
        } else if (selectedNode instanceof MethodDeclaration) {
            decl = (MethodDeclaration)selectedNode;
        } else {
            return;
        }
        ASTNode parentType = ASTResolving.findParentType((ASTNode)decl);
        TypeDeclaration parentTypeDecl = null;
        boolean parentIsAbstractClass = false;
        if (parentType instanceof TypeDeclaration) {
            parentTypeDecl = (TypeDeclaration)parentType;
            parentIsAbstractClass = !parentTypeDecl.isInterface() && Modifier.isAbstract((int)parentTypeDecl.getModifiers());
        }
        boolean bl = hasNoBody = decl.getBody() == null;
        if (problem.getProblemId() == 67109227 || parentIsAbstractClass) {
            AST ast = astRoot.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            Modifier modifierNode = ASTNodes.findModifierNode(1024, decl.modifiers());
            if (modifierNode != null) {
                rewrite.remove((ASTNode)modifierNode, null);
            }
            if (hasNoBody) {
                Block newBody = ast.newBlock();
                rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)MethodDeclaration.BODY_PROPERTY, (Object)newBody, null);
                Expression expr = ASTNodeFactory.newDefaultExpression(ast, decl.getReturnType2(), decl.getExtraDimensions());
                if (expr != null) {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression(expr);
                    newBody.statements().add(returnStatement);
                }
            }
            String label = CorrectionMessages.ModifierCorrectionSubProcessor_removeabstract_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 6, image);
            proposals.add(proposal);
        }
        if (!hasNoBody && problem.getProblemId() == 603979889) {
            ASTRewrite rewrite = ASTRewrite.create((AST)decl.getAST());
            rewrite.remove((ASTNode)decl.getBody(), null);
            String label = CorrectionMessages.ModifierCorrectionSubProcessor_removebody_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal2 = new ASTRewriteCorrectionProposal(label, cu, rewrite, 5, image);
            proposals.add(proposal2);
        }
        if (problem.getProblemId() == 67109227 && parentTypeDecl != null) {
            ASTRewriteCorrectionProposal proposal = ModifierCorrectionSubProcessor.getMakeTypeAbstractProposal(cu, parentTypeDecl, 5);
            proposals.add(proposal);
        }
    }

    public static void addNativeMethodProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        MethodDeclaration decl;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        if (selectedNode instanceof SimpleName) {
            decl = (MethodDeclaration)selectedNode.getParent();
        } else if (selectedNode instanceof MethodDeclaration) {
            decl = (MethodDeclaration)selectedNode;
        } else {
            return;
        }
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Modifier modifierNode = ASTNodes.findModifierNode(256, decl.modifiers());
        if (modifierNode != null) {
            rewrite.remove((ASTNode)modifierNode, null);
        }
        Block newBody = ast.newBlock();
        rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)MethodDeclaration.BODY_PROPERTY, (Object)newBody, null);
        Expression expr = ASTNodeFactory.newDefaultExpression(ast, decl.getReturnType2(), decl.getExtraDimensions());
        if (expr != null) {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(expr);
            newBody.statements().add(returnStatement);
        }
        String label = CorrectionMessages.ModifierCorrectionSubProcessor_removenative_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 6, image);
        proposals.add(proposal);
        if (decl.getBody() != null) {
            ASTRewrite rewrite2 = ASTRewrite.create((AST)decl.getAST());
            rewrite2.remove((ASTNode)decl.getBody(), null);
            String label2 = CorrectionMessages.ModifierCorrectionSubProcessor_removebody_description;
            Image image2 = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal2 = new ASTRewriteCorrectionProposal(label2, cu, rewrite2, 5, image2);
            proposals.add(proposal2);
        }
    }

    public static ASTRewriteCorrectionProposal getMakeTypeAbstractProposal(ICompilationUnit cu, TypeDeclaration typeDeclaration, int relevance) {
        AST ast = typeDeclaration.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Modifier newModifier = ast.newModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
        rewrite.getListRewrite((ASTNode)typeDeclaration, TypeDeclaration.MODIFIERS2_PROPERTY).insertLast((ASTNode)newModifier, null);
        String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_addabstract_description, typeDeclaration.getName().getIdentifier());
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, cu, rewrite, relevance, image);
        proposal.addLinkedPosition(rewrite.track((ASTNode)newModifier), true, KEY_MODIFIER);
        return proposal;
    }

    public static void addMethodRequiresBodyProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        Type returnType;
        Expression expression;
        ICompilationUnit cu = context.getCompilationUnit();
        AST ast = context.getASTRoot().getAST();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        MethodDeclaration decl = (MethodDeclaration)selectedNode;
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Modifier modifierNode = ASTNodes.findModifierNode(1024, decl.modifiers());
        if (modifierNode != null) {
            rewrite.remove((ASTNode)modifierNode, null);
        }
        Block body = ast.newBlock();
        rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)MethodDeclaration.BODY_PROPERTY, (Object)body, null);
        if (!decl.isConstructor() && (expression = ASTNodeFactory.newDefaultExpression(ast, returnType = decl.getReturnType2(), decl.getExtraDimensions())) != null) {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(expression);
            body.statements().add(returnStatement);
        }
        String label = CorrectionMessages.ModifierCorrectionSubProcessor_addmissingbody_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 9, image);
        proposals.add(proposal);
        rewrite = ASTRewrite.create((AST)ast);
        Modifier newModifier = ast.newModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
        rewrite.getListRewrite((ASTNode)decl, MethodDeclaration.MODIFIERS2_PROPERTY).insertLast((ASTNode)newModifier, null);
        String label2 = CorrectionMessages.ModifierCorrectionSubProcessor_setmethodabstract_description;
        Image image2 = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal2 = new LinkedCorrectionProposal(label2, cu, rewrite, 8, image2);
        proposal2.addLinkedPosition(rewrite.track((ASTNode)newModifier), true, KEY_MODIFIER);
        proposals.add(proposal2);
    }

    public static void addNeedToEmulateProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        IBinding binding = ((SimpleName)selectedNode).resolveBinding();
        if (binding instanceof IVariableBinding) {
            binding = ((IVariableBinding)binding).getVariableDeclaration();
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertofinal_description, binding.getName());
            proposals.add(new ModifierChangeCompletionProposal(label, cu, binding, selectedNode, 16, 0, 5, image));
        }
    }

    public static void addOverrideAnnotationProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        Java50Fix fix = Java50Fix.createAddOverrideAnnotationFix(context.getASTRoot(), problem);
        if (fix != null) {
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            Hashtable<String, String> options = new Hashtable<String, String>();
            options.put("cleanup.add_missing_annotations", "true");
            options.put("cleanup.add_missing_override_annotations", "true");
            FixCorrectionProposal proposal = new FixCorrectionProposal(fix, new Java50CleanUp(options), 5, image, context);
            proposals.add(proposal);
        }
    }

    public static void addDeprecatedAnnotationProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        Java50Fix fix = Java50Fix.createAddDeprectatedAnnotation(context.getASTRoot(), problem);
        if (fix != null) {
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            Hashtable<String, String> options = new Hashtable<String, String>();
            options.put("cleanup.add_missing_annotations", "true");
            options.put("cleanup.add_missing_deprecated_annotations", "true");
            FixCorrectionProposal proposal = new FixCorrectionProposal(fix, new Java50CleanUp(options), 5, image, context);
            proposals.add(proposal);
        }
    }

    public static void addOverridingDeprecatedMethodProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        Javadoc javadoc;
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        boolean is50OrHigher = JavaModelUtil.is50OrHigher(cu.getJavaProject());
        MethodDeclaration methodDecl = (MethodDeclaration)selectedNode;
        AST ast = methodDecl.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        if (is50OrHigher) {
            MarkerAnnotation annot = ast.newMarkerAnnotation();
            annot.setTypeName(ast.newName("Deprecated"));
            rewrite.getListRewrite((ASTNode)methodDecl, methodDecl.getModifiersProperty()).insertFirst((ASTNode)annot, null);
        }
        if ((javadoc = methodDecl.getJavadoc()) != null || !is50OrHigher) {
            if (!is50OrHigher) {
                javadoc = ast.newJavadoc();
                rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)MethodDeclaration.JAVADOC_PROPERTY, (Object)javadoc, null);
            }
            TagElement newTag = ast.newTagElement();
            newTag.setTagName("@deprecated");
            JavadocTagsSubProcessor.insertTag(rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY), newTag, null);
        }
        String label = CorrectionMessages.ModifierCorrectionSubProcessor_overrides_deprecated_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 15, image);
        proposals.add(proposal);
    }

    public static void removeOverrideAnnotationProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        MethodDeclaration methodDecl = (MethodDeclaration)selectedNode;
        Annotation annot = ModifierCorrectionSubProcessor.findAnnotation("java.lang.Override", methodDecl.modifiers());
        if (annot != null) {
            ASTRewrite rewrite = ASTRewrite.create((AST)annot.getAST());
            rewrite.remove((ASTNode)annot, null);
            String label = CorrectionMessages.ModifierCorrectionSubProcessor_remove_override;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 6, image);
            proposals.add(proposal);
            QuickAssistProcessor.getCreateInSuperClassProposals(context, (ASTNode)methodDecl.getName(), proposals);
        }
    }

    public static void installLinkedVisibilityProposals(LinkedProposalModel linkedProposalModel, ASTRewrite rewrite, List modifiers, boolean inInterface) {
        Modifier modifier = ModifierCorrectionSubProcessor.findVisibilityModifier(modifiers);
        if (modifier != null) {
            int[] nArray;
            int selected = modifier.getKeyword().toFlagValue();
            LinkedProposalPositionGroup positionGroup = linkedProposalModel.getPositionGroup(KEY_MODIFIER, true);
            positionGroup.addPosition(rewrite.track((ASTNode)modifier), false);
            positionGroup.addProposal(new ModifierLinkedModeProposal(selected, 10));
            if (inInterface) {
                int[] nArray2 = new int[2];
                nArray = nArray2;
                nArray2[0] = 1;
            } else {
                int[] nArray3 = new int[4];
                nArray3[0] = 1;
                nArray3[2] = 4;
                nArray = nArray3;
                nArray3[3] = 2;
            }
            int[] flagValues = nArray;
            int i = 0;
            while (i < flagValues.length) {
                if (flagValues[i] != selected) {
                    positionGroup.addProposal(new ModifierLinkedModeProposal(flagValues[i], 9 - i));
                }
                ++i;
            }
        }
    }

    private static Modifier findVisibilityModifier(List modifiers) {
        int i = 0;
        while (i < modifiers.size()) {
            Modifier modifier;
            Modifier.ModifierKeyword keyword;
            Object curr = modifiers.get(i);
            if (curr instanceof Modifier && ((keyword = (modifier = (Modifier)curr).getKeyword()) == Modifier.ModifierKeyword.PUBLIC_KEYWORD || keyword == Modifier.ModifierKeyword.PROTECTED_KEYWORD || keyword == Modifier.ModifierKeyword.PRIVATE_KEYWORD)) {
                return modifier;
            }
            ++i;
        }
        return null;
    }

    private static Annotation findAnnotation(String qualifiedTypeName, List modifiers) {
        int i = 0;
        while (i < modifiers.size()) {
            Annotation annot;
            ITypeBinding binding;
            Object curr = modifiers.get(i);
            if (curr instanceof Annotation && (binding = (annot = (Annotation)curr).getTypeName().resolveTypeBinding()) != null && qualifiedTypeName.equals(binding.getQualifiedName())) {
                return annot;
            }
            ++i;
        }
        return null;
    }

    public static void addGetterSetterProposal(IInvocationContext context, IProblemLocation problem, Collection proposals, int relevance) {
        ASTNode coveringNode = problem.getCoveringNode(context.getASTRoot());
        ICompilationUnit compilationUnit = context.getCompilationUnit();
        if (coveringNode instanceof SimpleName) {
            SimpleName sn = (SimpleName)coveringNode;
            if (sn.isDeclaration()) {
                return;
            }
            IVariableBinding variableBinding = (IVariableBinding)sn.resolveBinding();
            if (variableBinding == null || !variableBinding.isField()) {
                return;
            }
            ChangeCorrectionProposal proposal = ModifierCorrectionSubProcessor.getProposal(compilationUnit, sn, variableBinding, relevance);
            if (proposal != null) {
                proposals.add(proposal);
            }
        }
    }

    private static ChangeCorrectionProposal getProposal(ICompilationUnit cu, SimpleName sn, IVariableBinding variableBinding, int relevance) {
        SimpleName accessNode = sn;
        Name qualifier = null;
        AST ast = sn.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        boolean useSuper = false;
        boolean writeAccess = ASTResolving.isWriteAccess((Name)sn);
        ASTNode parent = sn.getParent();
        switch (parent.getNodeType()) {
            case 40: {
                accessNode = (Expression)parent;
                qualifier = ((QualifiedName)parent).getQualifier();
                break;
            }
            case 47: {
                accessNode = (Expression)parent;
                qualifier = ((SuperFieldAccess)parent).getQualifier();
                useSuper = true;
            }
        }
        ProposalParameter gspc = new ProposalParameter(useSuper, cu, rewrite, (Expression)accessNode, (Expression)qualifier, variableBinding);
        if (writeAccess) {
            return ModifierCorrectionSubProcessor.addSetterProposal(gspc, relevance);
        }
        return ModifierCorrectionSubProcessor.addGetterProposal(gspc, relevance);
    }

    private static ChangeCorrectionProposal addGetterProposal(ProposalParameter context, int relevance) {
        IMethodBinding method = ModifierCorrectionSubProcessor.findGetter(context);
        if (method != null) {
            Expression mi = ModifierCorrectionSubProcessor.createMethodInvocation(context, method, null);
            context.astRewrite.replace((ASTNode)context.accessNode, (ASTNode)mi, null);
            String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_replacewithgetter_description, context.accessNode);
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.compilationUnit, context.astRewrite, relevance, image);
            return proposal;
        }
        IJavaElement element = context.variableBinding.getJavaElement();
        if (element instanceof IField) {
            IField field = (IField)element;
            try {
                if (RefactoringAvailabilityTester.isSelfEncapsulateAvailable(field)) {
                    return new SelfEncapsulateFieldProposal(relevance, field, true);
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return null;
    }

    private static IMethodBinding findGetter(ProposalParameter context) {
        ITypeBinding returnType = context.variableBinding.getType();
        String getterName = GetterSetterUtil.getGetterName(context.variableBinding, context.compilationUnit.getJavaProject(), null, ModifierCorrectionSubProcessor.isBoolean(context));
        ITypeBinding declaringType = context.variableBinding.getDeclaringClass();
        IMethodBinding getter = Bindings.findMethodInHierarchy(declaringType, getterName, new ITypeBinding[0]);
        if (getter != null && getter.getReturnType().isAssignmentCompatible(returnType) && Modifier.isStatic((int)getter.getModifiers()) == Modifier.isStatic((int)context.variableBinding.getModifiers())) {
            return getter;
        }
        return null;
    }

    private static Expression createMethodInvocation(ProposalParameter context, IMethodBinding method, Expression argument) {
        AST ast = context.astRewrite.getAST();
        Expression qualifier = context.qualifier;
        if (context.useSuper) {
            SuperMethodInvocation invocation = ast.newSuperMethodInvocation();
            invocation.setName(ast.newSimpleName(method.getName()));
            if (qualifier != null) {
                invocation.setQualifier((Name)context.astRewrite.createCopyTarget((ASTNode)qualifier));
            }
            if (argument != null) {
                invocation.arguments().add(argument);
            }
            return invocation;
        }
        MethodInvocation invocation = ast.newMethodInvocation();
        invocation.setName(ast.newSimpleName(method.getName()));
        if (qualifier != null) {
            invocation.setExpression((Expression)context.astRewrite.createCopyTarget((ASTNode)qualifier));
        }
        if (argument != null) {
            invocation.arguments().add(argument);
        }
        return invocation;
    }

    private static ChangeCorrectionProposal addSetterProposal(ProposalParameter context, int relevance) {
        boolean isBoolean = ModifierCorrectionSubProcessor.isBoolean(context);
        String setterName = GetterSetterUtil.getSetterName(context.variableBinding, context.compilationUnit.getJavaProject(), null, isBoolean);
        ITypeBinding declaringType = context.variableBinding.getDeclaringClass();
        IMethodBinding method = Bindings.findMethodInHierarchy(declaringType, setterName, new ITypeBinding[]{context.variableBinding.getType()});
        if (method != null && Bindings.isVoidType(method.getReturnType()) && Modifier.isStatic((int)method.getModifiers()) == Modifier.isStatic((int)context.variableBinding.getModifiers())) {
            Expression assignedValue = ModifierCorrectionSubProcessor.getAssignedValue(context);
            if (assignedValue == null) {
                return null;
            }
            Expression mi = ModifierCorrectionSubProcessor.createMethodInvocation(context, method, assignedValue);
            context.astRewrite.replace(context.accessNode.getParent(), (ASTNode)mi, null);
            String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_replacewithsetter_description, context.accessNode);
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.compilationUnit, context.astRewrite, relevance, image);
            return proposal;
        }
        IJavaElement element = context.variableBinding.getJavaElement();
        if (element instanceof IField) {
            IField field = (IField)element;
            try {
                if (RefactoringAvailabilityTester.isSelfEncapsulateAvailable(field)) {
                    return new SelfEncapsulateFieldProposal(relevance, field, false);
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return null;
    }

    private static boolean isBoolean(ProposalParameter context) {
        boolean isBoolean;
        AST ast = context.astRewrite.getAST();
        boolean bl = isBoolean = ast.resolveWellKnownType("boolean") == context.variableBinding.getType();
        if (!isBoolean) {
            isBoolean = ast.resolveWellKnownType("java.lang.Boolean") == context.variableBinding.getType();
        }
        return isBoolean;
    }

    private static Expression getAssignedValue(ProposalParameter context) {
        ASTNode parent = context.accessNode.getParent();
        AST ast = context.astRewrite.getAST();
        switch (parent.getNodeType()) {
            case 7: {
                Assignment assignment = (Assignment)parent;
                Expression rightHandSide = assignment.getRightHandSide();
                Expression copiedRightOp = (Expression)context.astRewrite.createCopyTarget((ASTNode)rightHandSide);
                if (ModifierCorrectionSubProcessor.isNotInBlock(parent)) break;
                if (assignment.getOperator() == Assignment.Operator.ASSIGN) {
                    ITypeBinding rightHandSideType = rightHandSide.resolveTypeBinding();
                    copiedRightOp = ModifierCorrectionSubProcessor.checkForNarrowCast(context, copiedRightOp, true, rightHandSideType);
                    return copiedRightOp;
                }
                IMethodBinding getter = ModifierCorrectionSubProcessor.findGetter(context);
                if (getter == null) break;
                InfixExpression infix = ast.newInfixExpression();
                infix.setLeftOperand(ModifierCorrectionSubProcessor.createMethodInvocation(context, getter, null));
                infix.setOperator(ASTNodes.convertToInfixOperator(assignment.getOperator()));
                infix.setRightOperand(copiedRightOp);
                ITypeBinding infixType = infix.resolveTypeBinding();
                return ModifierCorrectionSubProcessor.checkForNarrowCast(context, (Expression)infix, true, infixType);
            }
            case 37: {
                PostfixExpression po = (PostfixExpression)parent;
                if (ModifierCorrectionSubProcessor.isNotInBlock(parent)) break;
                InfixExpression.Operator postfixOp = null;
                if (po.getOperator() == PostfixExpression.Operator.INCREMENT) {
                    postfixOp = InfixExpression.Operator.PLUS;
                }
                if (po.getOperator() == PostfixExpression.Operator.DECREMENT) {
                    postfixOp = InfixExpression.Operator.MINUS;
                }
                if (postfixOp == null) break;
                return ModifierCorrectionSubProcessor.createInfixInvocationFromPostPrefixExpression(context, postfixOp);
            }
            case 38: {
                PrefixExpression pe = (PrefixExpression)parent;
                if (ModifierCorrectionSubProcessor.isNotInBlock(parent)) break;
                InfixExpression.Operator prefixOp = null;
                if (pe.getOperator() == PrefixExpression.Operator.INCREMENT) {
                    prefixOp = InfixExpression.Operator.PLUS;
                }
                if (pe.getOperator() == PrefixExpression.Operator.DECREMENT) {
                    prefixOp = InfixExpression.Operator.MINUS;
                }
                if (prefixOp == null) break;
                return ModifierCorrectionSubProcessor.createInfixInvocationFromPostPrefixExpression(context, prefixOp);
            }
        }
        return null;
    }

    private static boolean isNotInBlock(ASTNode parent) {
        ASTNode grandParent = parent.getParent();
        return grandParent.getNodeType() != 21 || grandParent.getParent().getNodeType() != 8;
    }

    private static Expression createInfixInvocationFromPostPrefixExpression(ProposalParameter context, InfixExpression.Operator operator) {
        AST ast = context.astRewrite.getAST();
        IMethodBinding getter = ModifierCorrectionSubProcessor.findGetter(context);
        if (getter != null) {
            InfixExpression infix = ast.newInfixExpression();
            infix.setLeftOperand(ModifierCorrectionSubProcessor.createMethodInvocation(context, getter, null));
            infix.setOperator(operator);
            NumberLiteral number = ast.newNumberLiteral();
            number.setToken("1");
            infix.setRightOperand((Expression)number);
            ITypeBinding infixType = infix.resolveTypeBinding();
            return ModifierCorrectionSubProcessor.checkForNarrowCast(context, (Expression)infix, true, infixType);
        }
        return null;
    }

    private static Expression checkForNarrowCast(ProposalParameter context, Expression expression, boolean parenthesize, ITypeBinding expressionType) {
        PrimitiveType castTo = null;
        ITypeBinding type = context.variableBinding.getType();
        if (type.isEqualTo((IBinding)expressionType)) {
            return expression;
        }
        AST ast = context.astRewrite.getAST();
        if (JavaModelUtil.is50OrHigher(context.compilationUnit.getJavaProject())) {
            if (ast.resolveWellKnownType("java.lang.Character").isEqualTo((IBinding)type)) {
                castTo = ast.newPrimitiveType(PrimitiveType.CHAR);
            }
            if (ast.resolveWellKnownType("java.lang.Byte").isEqualTo((IBinding)type)) {
                castTo = ast.newPrimitiveType(PrimitiveType.BYTE);
            }
            if (ast.resolveWellKnownType("java.lang.Short").isEqualTo((IBinding)type)) {
                castTo = ast.newPrimitiveType(PrimitiveType.SHORT);
            }
        }
        if (ast.resolveWellKnownType("char").isEqualTo((IBinding)type)) {
            castTo = ast.newPrimitiveType(PrimitiveType.CHAR);
        }
        if (ast.resolveWellKnownType("byte").isEqualTo((IBinding)type)) {
            castTo = ast.newPrimitiveType(PrimitiveType.BYTE);
        }
        if (ast.resolveWellKnownType("short").isEqualTo((IBinding)type)) {
            castTo = ast.newPrimitiveType(PrimitiveType.SHORT);
        }
        if (castTo != null) {
            CastExpression cast = ast.newCastExpression();
            if (parenthesize) {
                ParenthesizedExpression parenthesized = ast.newParenthesizedExpression();
                parenthesized.setExpression(expression);
                cast.setExpression((Expression)parenthesized);
            } else {
                cast.setExpression(expression);
            }
            cast.setType((Type)castTo);
            return cast;
        }
        return expression;
    }

    private static class ModifierLinkedModeProposal
    extends LinkedProposalPositionGroup.Proposal {
        private final int fModifier;

        public ModifierLinkedModeProposal(int modifier, int relevance) {
            super(null, null, relevance);
            this.fModifier = modifier;
        }

        public String getAdditionalProposalInfo() {
            return this.getDisplayString();
        }

        public String getDisplayString() {
            if (this.fModifier == 0) {
                return CorrectionMessages.ModifierCorrectionSubProcessor_default_visibility_label;
            }
            return Modifier.ModifierKeyword.fromFlagValue((int)this.fModifier).toString();
        }

        public TextEdit computeEdits(int offset, LinkedPosition currentPosition, char trigger, int stateMask, LinkedModeModel model) throws CoreException {
            try {
                IDocument document = currentPosition.getDocument();
                MultiTextEdit edit = new MultiTextEdit();
                int documentLen = document.getLength();
                if (this.fModifier == 0) {
                    int end;
                    int k = end = currentPosition.offset + currentPosition.length;
                    while (k < documentLen && IndentManipulation.isIndentChar((char)document.getChar(k))) {
                        ++k;
                    }
                    edit.addChild((TextEdit)new ReplaceEdit(end, k - end, new String()));
                    edit.addChild((TextEdit)new ReplaceEdit(currentPosition.offset, currentPosition.length, new String()));
                } else {
                    edit.addChild((TextEdit)new ReplaceEdit(currentPosition.offset, currentPosition.length, Modifier.ModifierKeyword.fromFlagValue((int)this.fModifier).toString()));
                    int end = currentPosition.offset + currentPosition.length;
                    if (end < documentLen && !Character.isWhitespace(document.getChar(end))) {
                        edit.addChild((TextEdit)new ReplaceEdit(end, 0, String.valueOf(' ')));
                    }
                }
                return edit;
            }
            catch (BadLocationException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", 4, e.getMessage(), (Throwable)e));
            }
        }
    }

    private static class ProposalParameter {
        public final boolean useSuper;
        public final ICompilationUnit compilationUnit;
        public final ASTRewrite astRewrite;
        public final Expression accessNode;
        public final Expression qualifier;
        public final IVariableBinding variableBinding;

        public ProposalParameter(boolean useSuper, ICompilationUnit compilationUnit, ASTRewrite rewrite, Expression accessNode, Expression qualifier, IVariableBinding variableBinding) {
            this.useSuper = useSuper;
            this.compilationUnit = compilationUnit;
            this.astRewrite = rewrite;
            this.accessNode = accessNode;
            this.qualifier = qualifier;
            this.variableBinding = variableBinding;
        }
    }

    public static class SelfEncapsulateFieldProposal
    extends ChangeCorrectionProposal {
        private IField fField;
        private boolean fNoDialog;

        public SelfEncapsulateFieldProposal(int relevance, IField field, boolean isReadAccess) {
            super(SelfEncapsulateFieldProposal.getDescription(isReadAccess), null, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
            this.fField = field;
            this.fNoDialog = false;
        }

        public void setNoDialog(boolean noDialog) {
            this.fNoDialog = noDialog;
        }

        private static String getDescription(boolean getter) {
            if (getter) {
                return CorrectionMessages.ModifierCorrectionSubProcessor_creategetterunsingencapsulatefield_description;
            }
            return CorrectionMessages.ModifierCorrectionSubProcessor_createsetterusingencapsulatefield_description;
        }

        public void apply(IDocument document) {
            try {
                SelfEncapsulateFieldRefactoring refactoring = new SelfEncapsulateFieldRefactoring(this.fField);
                refactoring.setVisibility(1);
                refactoring.setConsiderVisibility(false);
                if (this.fNoDialog) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    RefactoringExecutionHelper helper = new RefactoringExecutionHelper(refactoring, 3, 4, JavaPlugin.getActiveWorkbenchShell(), (IRunnableContext)window);
                    if (Display.getCurrent() != null) {
                        try {
                            helper.perform(false, false);
                        }
                        catch (InterruptedException e) {
                            JavaPlugin.log(e);
                        }
                        catch (InvocationTargetException e) {
                            JavaPlugin.log(e);
                        }
                    } else {
                        Display.getDefault().syncExec(new Runnable(this, helper){
                            final /* synthetic */ SelfEncapsulateFieldProposal this$1;
                            private final /* synthetic */ RefactoringExecutionHelper val$helper;
                            {
                                this.this$1 = selfEncapsulateFieldProposal;
                                this.val$helper = refactoringExecutionHelper;
                            }

                            public void run() {
                                try {
                                    this.val$helper.perform(false, false);
                                }
                                catch (InterruptedException e) {
                                    JavaPlugin.log(e);
                                }
                                catch (InvocationTargetException e) {
                                    JavaPlugin.log(e);
                                }
                            }
                        });
                    }
                } else {
                    new RefactoringStarter().activate(refactoring, new SelfEncapsulateFieldWizard(refactoring), JavaPlugin.getActiveWorkbenchShell(), "", 4);
                }
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), CorrectionMessages.ModifierCorrectionSubProcessor_encapsulate_field_error_title, CorrectionMessages.ModifierCorrectionSubProcessor_encapsulate_field_error_message);
            }
        }
    }
}

