/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class JavaElementInfoPage
extends PropertyPage {
    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.java_element_info_page_context");
    }

    protected Control createContents(Composite parent) {
        Composite composite;
        block21: {
            this.noDefaultAndApplyButton();
            IJavaElement element = (IJavaElement)this.getElement();
            IResource resource = element.getResource();
            composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(272));
            Label nameLabel = new Label(composite, 0);
            nameLabel.setText(PreferencesMessages.JavaElementInfoPage_nameLabel);
            Label nameValueLabel = new Label(composite, 0);
            nameValueLabel.setText(element.getElementName());
            if (resource != null) {
                Label pathLabel = new Label(composite, 0);
                pathLabel.setText(PreferencesMessages.JavaElementInfoPage_resource_path);
                Label pathValueLabel = new Label(composite, 0);
                pathValueLabel.setText(resource.getFullPath().toString());
            }
            if (element instanceof ICompilationUnit) {
                ICompilationUnit unit = (ICompilationUnit)element;
                Label packageLabel = new Label(composite, 0);
                packageLabel.setText(PreferencesMessages.JavaElementInfoPage_package);
                Label packageName = new Label(composite, 0);
                packageName.setText(unit.getParent().getElementName());
            } else if (element instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)element;
                Label packageContents = new Label(composite, 0);
                packageContents.setText(PreferencesMessages.JavaElementInfoPage_package_contents);
                Label packageContentsType = new Label(composite, 0);
                try {
                    if (packageFragment.getKind() == 1) {
                        packageContentsType.setText(PreferencesMessages.JavaElementInfoPage_source);
                        break block21;
                    }
                    packageContentsType.setText(PreferencesMessages.JavaElementInfoPage_binary);
                }
                catch (JavaModelException javaModelException) {
                    packageContentsType.setText(PreferencesMessages.JavaElementInfoPage_not_present);
                }
            } else if (element instanceof IPackageFragmentRoot) {
                Label rootContents = new Label(composite, 0);
                rootContents.setText(PreferencesMessages.JavaElementInfoPage_classpath_entry_kind);
                Label rootContentsType = new Label(composite, 0);
                try {
                    IClasspathEntry entry = ((IPackageFragmentRoot)element).getRawClasspathEntry();
                    if (entry != null) {
                        switch (entry.getEntryKind()) {
                            case 3: {
                                rootContentsType.setText(PreferencesMessages.JavaElementInfoPage_source);
                                break;
                            }
                            case 2: {
                                rootContentsType.setText(PreferencesMessages.JavaElementInfoPage_project);
                                break;
                            }
                            case 1: {
                                rootContentsType.setText(PreferencesMessages.JavaElementInfoPage_library);
                                break;
                            }
                            case 4: {
                                rootContentsType.setText(PreferencesMessages.JavaElementInfoPage_variable);
                                Label varPath = new Label(composite, 0);
                                varPath.setText(PreferencesMessages.JavaElementInfoPage_variable_path);
                                Label varPathVar = new Label(composite, 0);
                                varPathVar.setText(entry.getPath().makeRelative().toString());
                            }
                        }
                        break block21;
                    }
                    rootContentsType.setText(PreferencesMessages.JavaElementInfoPage_not_present);
                }
                catch (JavaModelException javaModelException) {
                    rootContentsType.setText(PreferencesMessages.JavaElementInfoPage_not_present);
                }
            } else if (element instanceof IJavaProject) {
                Label packageLabel = new Label(composite, 0);
                packageLabel.setText(PreferencesMessages.JavaElementInfoPage_location);
                String location = Resources.getLocationString((IResource)((IJavaProject)element).getProject());
                if (location != null) {
                    Label packageName = new Label(composite, 0);
                    packageName.setText(location);
                }
            }
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }
}

