/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.internal.junit.launcher.ITestFinder;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;

public class JUnit3TestFinder
implements ITestFinder {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void findTestsInContainer(IJavaElement element, Set result, IProgressMonitor pm) throws CoreException {
        if (element == null || result == null) {
            throw new IllegalArgumentException();
        }
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask(JUnitMessages.TestSearchEngine_message_searching, 10);
        try {
            if (element instanceof IType) {
                if (this.isTest((IType)element)) {
                    result.add(element);
                }
            } else if (element instanceof ICompilationUnit) {
                IType[] types = ((ICompilationUnit)element).getAllTypes();
                int i = 0;
                while (i < types.length) {
                    IType type = types[i];
                    if (this.isTest(types[i])) {
                        result.add(type);
                    }
                    ++i;
                }
            } else {
                JUnit3TestFinder.findTestCases(element, result, (IProgressMonitor)new SubProgressMonitor(pm, 7));
                if (pm.isCanceled()) {
                    return;
                }
                TestSearchEngine.findSuiteMethods(element, result, (IProgressMonitor)new SubProgressMonitor(pm, 3));
            }
            if (!pm.isCanceled()) return;
            return;
        }
        finally {
            pm.done();
        }
    }

    private static void findTestCases(IJavaElement element, Set result, IProgressMonitor pm) throws JavaModelException {
        IJavaProject javaProject = element.getJavaProject();
        IType testCaseType = javaProject.findType("junit.framework.Test");
        if (testCaseType == null) {
            return;
        }
        IRegion region = TestSearchEngine.getRegion(element);
        ITypeHierarchy typeHierarchy = javaProject.newTypeHierarchy(testCaseType, region, pm);
        TestSearchEngine.findTestImplementorClasses(typeHierarchy, testCaseType, region, result);
    }

    public boolean isTest(ITypeBinding type) throws JavaModelException {
        if (!type.isClass() || !Modifier.isPublic((int)type.getModifiers())) {
            return false;
        }
        IMethodBinding[] declaredMethods = type.getDeclaredMethods();
        int i = 0;
        while (i < declaredMethods.length) {
            int flags;
            IMethodBinding curr = declaredMethods[i];
            if ("suite".equals(curr.getName()) && Modifier.isPublic((int)(flags = curr.getModifiers())) && Modifier.isStatic((int)flags) && curr.getParameterTypes().length == 0 && "Test".equals(curr.getReturnType().getQualifiedName())) {
                return true;
            }
            ++i;
        }
        return TestSearchEngine.isTestImplementor(type);
    }

    public boolean isTest(IType type) throws JavaModelException {
        return TestSearchEngine.isAccessibleClass(type) && (TestSearchEngine.hasSuiteMethod(type) || JUnit3TestFinder.isTestImplementor(type));
    }

    private static boolean isTestImplementor(IType type) throws JavaModelException {
        return !Flags.isAbstract((int)type.getFlags()) && TestSearchEngine.isTestImplementor(type);
    }
}

