/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.variables;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.model.elements.VariableLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDIModelPresentation;
import org.eclipse.jdt.internal.debug.ui.variables.JavaVariableColumnPresentation;

public class JavaVariableLabelProvider
extends VariableLabelProvider
implements Preferences.IPropertyChangeListener {
    public static JDIModelPresentation fLabelProvider = new JDIModelPresentation();
    private Map fQualifiedNameSettings = new HashMap();
    private boolean fQualifiedNames = false;

    public JavaVariableLabelProvider() {
        JDIDebugUIPlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    protected String getValueText(IVariable variable, IValue value, IPresentationContext context) throws CoreException {
        if (value instanceof IJavaValue) {
            return this.escapeSpecialChars(fLabelProvider.getFormattedValueText((IJavaValue)value));
        }
        return super.getValueText(variable, value, context);
    }

    protected String getValueTypeName(IVariable variable, IValue value, IPresentationContext context) throws CoreException {
        String typeName = DebugUIMessages.JDIModelPresentation_unknown_type__2;
        try {
            typeName = value.getReferenceTypeName();
            if (!this.fQualifiedNames) {
                return fLabelProvider.removeQualifierFromGenericName(typeName);
            }
        }
        catch (DebugException debugException) {}
        return typeName;
    }

    protected String getVariableTypeName(IVariable variable, IPresentationContext context) throws CoreException {
        String typeName = DebugUIMessages.JDIModelPresentation_unknown_type__2;
        try {
            typeName = variable.getReferenceTypeName();
            if (!this.fQualifiedNames) {
                return fLabelProvider.removeQualifierFromGenericName(typeName);
            }
        }
        catch (DebugException debugException) {}
        return typeName;
    }

    private Boolean isShowQualfiiedNames(IPresentationContext context) {
        Boolean qualified = (Boolean)this.fQualifiedNameSettings.get(context.getId());
        if (qualified == null) {
            qualified = JDIDebugUIPlugin.getDefault().getPluginPreferences().getBoolean(String.valueOf(context.getId()) + '.' + IJDIPreferencesConstants.PREF_SHOW_QUALIFIED_NAMES);
            this.fQualifiedNameSettings.put(context.getId(), qualified);
        }
        return qualified;
    }

    protected String getColumnText(IVariable variable, IValue value, IPresentationContext context, String columnId) throws CoreException {
        if (JavaVariableColumnPresentation.COLUMN_INSTANCE_ID.equals(columnId)) {
            long uniqueId;
            if (value instanceof JDIObjectValue && (uniqueId = ((JDIObjectValue)value).getUniqueId()) >= 0L) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(uniqueId);
                return buffer.toString();
            }
            return "";
        }
        return super.getColumnText(variable, value, context, columnId);
    }

    protected void retrieveLabel(ILabelUpdate update) throws CoreException {
        Boolean showQ = this.isShowQualfiiedNames(update.getPresentationContext());
        this.fQualifiedNames = showQ;
        fLabelProvider.setAttribute("DISPLAY_QUALIFIED_NAMES", showQ);
        super.retrieveLabel(update);
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (event.getProperty().endsWith(IJDIPreferencesConstants.PREF_SHOW_QUALIFIED_NAMES)) {
            this.fQualifiedNameSettings.clear();
        }
    }

    protected boolean requiresUIJob(ILabelUpdate[] updates) {
        return !JDIModelPresentation.isInitialized();
    }
}

