/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectHierarchyUtils;
import org.gradle.api.tasks.diagnostics.AbstractProjectBasedReportTask;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.plugin.software.internal.SoftwareTypeImplementation;
import org.gradle.plugin.software.internal.SoftwareTypeRegistry;
import org.gradle.util.Path;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
public abstract class ProjectReportTask
extends AbstractProjectBasedReportTask<ProjectReportModel> {
    private final TextReportRenderer renderer = new TextReportRenderer();

    @Override
    protected TextReportRenderer getRenderer() {
        return this.renderer;
    }

    @Inject
    public BuildStateRegistry getBuildStateRegistry() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected abstract SoftwareTypeRegistry getSoftwareTypeRegistry();

    @Override
    protected ProjectReportModel calculateReportModelFor(Project project) {
        return new ProjectReportModel(ProjectDetails.of(project), this.calculateChildrenProjectsFor(project), this.getSoftwareTypesForProject(project), project == project.getRootProject(), project.absoluteProjectPath("tasks"), project.getRootProject().absoluteProjectPath("projects"), this.calculateIncludedBuildIdentityPaths());
    }

    private List<SoftwareTypeImplementation<?>> getSoftwareTypesForProject(Project project) {
        ArrayList results = new ArrayList(1);
        this.getSoftwareTypeRegistry().getSoftwareTypeImplementations().forEach(registeredType -> {
            Class softwareType = registeredType.getModelPublicType();
            if (project.getExtensions().findByType(softwareType) != null) {
                results.add((SoftwareTypeImplementation<?>)registeredType);
            }
        });
        return results;
    }

    private List<ProjectReportModel> calculateChildrenProjectsFor(Project project) {
        List childProjects = CollectionUtils.sort((Iterable)ProjectHierarchyUtils.getChildProjectsForInternalUse((Project)project));
        ArrayList<ProjectReportModel> children = new ArrayList<ProjectReportModel>(childProjects.size());
        for (Project childProject : childProjects) {
            children.add(this.calculateReportModelFor(childProject));
        }
        return children;
    }

    private List<Path> calculateIncludedBuildIdentityPaths() {
        Collection includedBuilds = this.getBuildStateRegistry().getIncludedBuilds();
        ArrayList<Path> includedBuildIdentityPaths = new ArrayList<Path>(includedBuilds.size());
        for (IncludedBuildState includedBuild : includedBuilds) {
            includedBuildIdentityPaths.add(includedBuild.getIdentityPath());
        }
        return includedBuildIdentityPaths;
    }

    @Override
    protected void generateReportHeaderFor(Map<ProjectDetails, ProjectReportModel> modelsByProjectDetails) {
        this.renderSoftwareTypeInfo(modelsByProjectDetails);
        this.renderSectionTitle("Projects");
    }

    private void renderSectionTitle(String sectionName) {
        StyledTextOutput styledTextOutput = this.getRenderer().getTextOutput();
        styledTextOutput.println();
        styledTextOutput.withStyle(StyledTextOutput.Style.Header).append((CharSequence)sectionName).append((CharSequence)":");
        styledTextOutput.println();
    }

    @Override
    protected void generateReportFor(ProjectDetails project, ProjectReportModel model) {
        this.renderProjectTree(model);
        this.renderIncludedBuilds(model);
        this.renderHelp(model);
    }

    private void renderSoftwareTypeInfo(Map<ProjectDetails, ProjectReportModel> modelsByProjectDetails) {
        List<SoftwareTypeImplementation> softwareTypes = modelsByProjectDetails.values().stream().flatMap(model -> ((ProjectReportModel)model).getAllSoftwareTypes().stream()).sorted(Comparator.comparing(SoftwareTypeImplementation::getSoftwareType)).collect(Collectors.toList());
        StyledTextOutput styledTextOutput = this.getRenderer().getTextOutput();
        if (!softwareTypes.isEmpty()) {
            this.renderSectionTitle("Available software types");
            styledTextOutput.println();
            softwareTypes.forEach(type -> {
                styledTextOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)type.getSoftwareType());
                styledTextOutput.append((CharSequence)" (").append((CharSequence)type.getModelPublicType().getName()).append((CharSequence)")").println();
                styledTextOutput.append((CharSequence)"        ").append((CharSequence)"Defined in: ").append((CharSequence)type.getPluginClass().getName()).println();
                styledTextOutput.append((CharSequence)"        ").append((CharSequence)"Registered by: ").append((CharSequence)type.getRegisteringPluginClass().getName()).println();
            });
        }
    }

    private void renderProjectTree(ProjectReportModel model) {
        StyledTextOutput textOutput = this.getRenderer().getTextOutput();
        this.renderProject(model, new GraphRenderer(textOutput), true, textOutput);
        if (model.children.isEmpty()) {
            textOutput.withStyle(StyledTextOutput.Style.Info).text((Object)"No sub-projects");
            textOutput.println();
        }
    }

    private void renderProject(ProjectReportModel model, GraphRenderer renderer, boolean lastChild, StyledTextOutput textOutput) {
        renderer.visit(styledTextOutput -> {
            styledTextOutput.text((Object)StringUtils.capitalize((String)model.project.getDisplayName()));
            this.renderProjectType(model, textOutput);
            this.renderProjectDescription(model, textOutput);
        }, lastChild);
        renderer.startChildren();
        Iterator iterator = model.children.iterator();
        while (iterator.hasNext()) {
            ProjectReportModel child;
            this.renderProject(child, renderer, (child = (ProjectReportModel)iterator.next()) == model.children.get(model.children.size() - 1), textOutput);
        }
        renderer.completeChildren();
    }

    private void renderProjectType(ProjectReportModel model, StyledTextOutput textOutput) {
        if (!model.softwareTypes.isEmpty()) {
            assert (model.softwareTypes.size() == 1);
            textOutput.append((CharSequence)" (").append((CharSequence)((SoftwareTypeImplementation)model.softwareTypes.get(0)).getSoftwareType()).append((CharSequence)")");
        }
    }

    private void renderProjectDescription(ProjectReportModel model, StyledTextOutput textOutput) {
        String projectDescription = model.project.getDescription();
        if (projectDescription != null && !projectDescription.isEmpty()) {
            String description = projectDescription.trim();
            int newlineInDescription = description.indexOf(10);
            if (newlineInDescription > 0) {
                textOutput.withStyle(StyledTextOutput.Style.Description).text((Object)(" - " + description.substring(0, newlineInDescription) + "..."));
            } else {
                textOutput.withStyle(StyledTextOutput.Style.Description).text((Object)(" - " + description));
            }
        }
    }

    private void renderIncludedBuilds(ProjectReportModel model) {
        StyledTextOutput textOutput = this.getRenderer().getTextOutput();
        if (model.isRootProject) {
            int index = 0;
            if (!model.includedBuildIdentityPaths.isEmpty()) {
                GraphRenderer renderer = new GraphRenderer(textOutput);
                this.renderSectionTitle("Included builds");
                textOutput.println();
                renderer.startChildren();
                for (Path includedBuildIdentityPath : model.includedBuildIdentityPaths) {
                    renderer.visit(text -> textOutput.text((Object)("Included build '" + includedBuildIdentityPath + "'")), index + 1 == model.includedBuildIdentityPaths.size());
                    ++index;
                }
                renderer.completeChildren();
            }
        }
    }

    private void renderHelp(ProjectReportModel model) {
        BuildClientMetaData metaData = this.getClientMetaData();
        StyledTextOutput textOutput = this.getRenderer().getTextOutput();
        textOutput.println();
        textOutput.text((Object)"To see a list of the tasks of a project, run ");
        metaData.describeCommand((Appendable)textOutput.withStyle(StyledTextOutput.Style.UserInput), new String[]{"<project-path>:tasks"});
        textOutput.println();
        textOutput.text((Object)"For example, try running ");
        ProjectReportModel exampleProject = model.children.isEmpty() ? model : (ProjectReportModel)model.children.get(0);
        metaData.describeCommand((Appendable)textOutput.withStyle(StyledTextOutput.Style.UserInput), new String[]{exampleProject.tasksTaskPath});
        textOutput.println();
        if (!model.isRootProject) {
            textOutput.println();
            textOutput.text((Object)"To see a list of all the projects in this build, run ");
            metaData.describeCommand((Appendable)textOutput.withStyle(StyledTextOutput.Style.UserInput), new String[]{model.rootProjectProjectsTaskPath});
            textOutput.println();
        }
    }

    @Incubating
    public static final class ProjectReportModel {
        private final ProjectDetails project;
        private final List<ProjectReportModel> children;
        private final List<SoftwareTypeImplementation<?>> softwareTypes;
        private final boolean isRootProject;
        private final String tasksTaskPath;
        private final String rootProjectProjectsTaskPath;
        private final List<Path> includedBuildIdentityPaths;

        private ProjectReportModel(ProjectDetails project, List<ProjectReportModel> children, List<SoftwareTypeImplementation<?>> softwareTypes, boolean isRootProject, String tasksTaskPath, String rootProjectProjectsTaskPath, List<Path> includedBuildIdentityPaths) {
            this.project = project;
            this.children = children;
            this.softwareTypes = softwareTypes;
            this.isRootProject = isRootProject;
            this.tasksTaskPath = tasksTaskPath;
            this.rootProjectProjectsTaskPath = rootProjectProjectsTaskPath;
            this.includedBuildIdentityPaths = includedBuildIdentityPaths;
        }

        private Set<SoftwareTypeImplementation<?>> getAllSoftwareTypes() {
            HashSet allSoftwareTypes = new HashSet(this.softwareTypes);
            this.children.forEach(p -> allSoftwareTypes.addAll(p.getAllSoftwareTypes()));
            return allSoftwareTypes;
        }
    }
}

