/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.component.ResolutionFailureHandler;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.local.model.ConfigurationMetadataFactory;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalConfigurationGraphResolveMetadata;
import org.gradle.internal.component.model.AbstractComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.component.model.ConfigurationGraphResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveState;
import org.gradle.internal.component.model.ImmutableModuleSources;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantArtifactGraphResolveMetadata;
import org.gradle.internal.component.model.VariantArtifactResolveState;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueCache;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.resolve.resolver.VariantArtifactResolver;

public class DefaultLocalComponentGraphResolveState
extends AbstractComponentGraphResolveState<LocalComponentGraphResolveMetadata>
implements LocalComponentGraphResolveState {
    private final ComponentIdGenerator idGenerator;
    private final boolean adHoc;
    private final ConfigurationMetadataFactory configurationFactory;
    private final Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifactTransformer;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final CalculatedValueCache<String, DefaultLocalConfigurationGraphResolveState> configurations;
    private final AtomicReference<CalculatedValue<LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates>> graphSelectionCandidates = new AtomicReference();
    private final AtomicReference<CalculatedValue<List<ResolvedVariantResult>>> selectableVariantResults = new AtomicReference();

    public DefaultLocalComponentGraphResolveState(long instanceId, LocalComponentGraphResolveMetadata metadata, AttributeDesugaring attributeDesugaring, ComponentIdGenerator idGenerator, boolean adHoc, ConfigurationMetadataFactory configurationFactory, CalculatedValueContainerFactory calculatedValueContainerFactory, @Nullable Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifactTransformer) {
        super(instanceId, metadata, attributeDesugaring);
        this.idGenerator = idGenerator;
        this.adHoc = adHoc;
        this.configurationFactory = configurationFactory;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.artifactTransformer = artifactTransformer;
        this.configurations = calculatedValueContainerFactory.createCache(Describables.of((Object)"configurations"));
        this.initCalculatedValues();
    }

    @Override
    public void reevaluate() {
        this.configurations.clear();
        this.configurationFactory.invalidate();
        this.initCalculatedValues();
    }

    private void initCalculatedValues() {
        this.graphSelectionCandidates.set((CalculatedValue<LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates>)this.calculatedValueContainerFactory.create(Describables.of((Object)"variants of", this.getMetadata()), context -> DefaultLocalComponentGraphResolveState.computeGraphSelectionCandidates(this, this.idGenerator, this.configurationFactory, this.calculatedValueContainerFactory, this.artifactTransformer)));
        this.selectableVariantResults.set((CalculatedValue<List<ResolvedVariantResult>>)this.calculatedValueContainerFactory.create(Describables.of((Object)"public variants of", this.getMetadata()), context -> DefaultLocalComponentGraphResolveState.computeSelectableVariantResults(this)));
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        return ((LocalComponentGraphResolveMetadata)this.getMetadata()).getModuleVersionId();
    }

    @Override
    public boolean isAdHoc() {
        return this.adHoc;
    }

    @Override
    public LocalComponentGraphResolveState copy(ComponentIdentifier newComponentId, Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformer) {
        HashMap transformedArtifacts = new HashMap();
        Transformer cachedTransformer = oldArtifact -> transformedArtifacts.computeIfAbsent(oldArtifact, arg_0 -> ((Transformer)transformer).transform(arg_0));
        LocalComponentGraphResolveMetadata originalMetadata = (LocalComponentGraphResolveMetadata)this.getMetadata();
        LocalComponentGraphResolveMetadata copiedMetadata = new LocalComponentGraphResolveMetadata(originalMetadata.getModuleVersionId(), newComponentId, originalMetadata.getStatus(), originalMetadata.getAttributesSchema());
        return new DefaultLocalComponentGraphResolveState(this.idGenerator.nextComponentId(), copiedMetadata, this.getAttributeDesugaring(), this.idGenerator, this.adHoc, this.configurationFactory, this.calculatedValueContainerFactory, (Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata>)cachedTransformer);
    }

    @Override
    public ComponentArtifactResolveMetadata getArtifactMetadata() {
        return new LocalComponentArtifactResolveMetadata((ComponentGraphResolveMetadata)this.getMetadata());
    }

    @Override
    public LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates getCandidatesForGraphVariantSelection() {
        CalculatedValue<LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates> value = this.graphSelectionCandidates.get();
        value.finalizeIfNotAlready();
        return (LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates)value.get();
    }

    private static LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates computeGraphSelectionCandidates(DefaultLocalComponentGraphResolveState component, ComponentIdGenerator idGenerator, ConfigurationMetadataFactory configurationFactory, CalculatedValueContainerFactory calculatedValueContainerFactory, @Nullable Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifactTransformer) {
        ImmutableList.Builder configurationsWithAttributes = new ImmutableList.Builder();
        ImmutableMap.Builder configurationByName = ImmutableMap.builder();
        configurationFactory.visitConsumableConfigurations(configuration -> {
            if (artifactTransformer != null) {
                configuration = configuration.copyWithTransformedArtifacts(artifactTransformer);
            }
            VariantGraphResolveState variantState = new DefaultLocalConfigurationGraphResolveState(idGenerator.nextVariantId(), component, (ComponentGraphResolveMetadata)component.getMetadata(), (LocalConfigurationGraphResolveMetadata)configuration, calculatedValueContainerFactory).asVariant();
            if (!configuration.getAttributes().isEmpty()) {
                configurationsWithAttributes.add((Object)variantState);
            }
            configurationByName.put((Object)configuration.getName(), (Object)variantState);
        });
        return new DefaultLocalComponentGraphSelectionCandidates((List<? extends VariantGraphResolveState>)configurationsWithAttributes.build(), (Map<String, ? extends VariantGraphResolveState>)configurationByName.build(), component);
    }

    @Override
    public List<ResolvedVariantResult> getAllSelectableVariantResults() {
        CalculatedValue<List<ResolvedVariantResult>> value = this.selectableVariantResults.get();
        value.finalizeIfNotAlready();
        return (List)value.get();
    }

    private static List<ResolvedVariantResult> computeSelectableVariantResults(DefaultLocalComponentGraphResolveState component) {
        return component.getCandidatesForGraphVariantSelection().getVariantsForAttributeMatching().stream().flatMap(variant -> variant.prepareForArtifactResolution().getArtifactVariants().stream()).map(variant -> new DefaultResolvedVariantResult(component.getId(), Describables.of((Object)variant.getName()), (AttributeContainer)component.getAttributeDesugaring().desugar(variant.getAttributes().asImmutable()), component.capabilitiesFor(variant.getCapabilities()), null)).collect(Collectors.toList());
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.configurationFactory.getConfigurationNames();
    }

    @Override
    @Nullable
    public ConfigurationGraphResolveState getConfiguration(String configurationName) {
        return (ConfigurationGraphResolveState)this.configurations.computeIfAbsent((Object)configurationName, n -> {
            LocalConfigurationGraphResolveMetadata md = this.configurationFactory.getConfiguration(configurationName);
            if (md == null) {
                return null;
            }
            if (this.artifactTransformer != null) {
                md = md.copyWithTransformedArtifacts(this.artifactTransformer);
            }
            return new DefaultLocalConfigurationGraphResolveState(this.idGenerator.nextVariantId(), this, (ComponentGraphResolveMetadata)this.getMetadata(), md, this.calculatedValueContainerFactory);
        });
    }

    private static class DefaultLocalComponentGraphSelectionCandidates
    implements LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates {
        private final List<? extends VariantGraphResolveState> variantsWithAttributes;
        private final Map<String, ? extends VariantGraphResolveState> variantsByConfigurationName;
        private final AbstractComponentGraphResolveState<?> component;

        public DefaultLocalComponentGraphSelectionCandidates(List<? extends VariantGraphResolveState> variantsWithAttributes, Map<String, ? extends VariantGraphResolveState> variantsByConfigurationName, AbstractComponentGraphResolveState<?> component) {
            this.variantsWithAttributes = variantsWithAttributes;
            this.variantsByConfigurationName = variantsByConfigurationName;
            this.component = component;
        }

        @Override
        public List<? extends VariantGraphResolveState> getVariantsForAttributeMatching() {
            return this.variantsWithAttributes;
        }

        @Override
        @Nullable
        public VariantGraphResolveState getVariantByConfigurationName(String name, ResolutionFailureHandler failureHandler) {
            VariantGraphResolveState variant = this.variantsByConfigurationName.get(name);
            if (variant != null) {
                return variant;
            }
            ConfigurationGraphResolveState conf = this.component.getConfiguration(name);
            if (conf == null) {
                return null;
            }
            assert (!conf.getMetadata().isCanBeConsumed()) : "Expected configuration to be non-consumable";
            throw failureHandler.nonConsumableConfigurationFailure(name, this.component.getId());
        }

        @Override
        public List<VariantGraphResolveState> getAllSelectableVariants() {
            HashSet<String> configurationNames = new HashSet<String>(this.variantsByConfigurationName.keySet());
            for (VariantGraphResolveState variantGraphResolveState : this.variantsWithAttributes) {
                configurationNames.remove(variantGraphResolveState.getName());
            }
            ArrayList<VariantGraphResolveState> result = new ArrayList<VariantGraphResolveState>(this.variantsWithAttributes);
            for (String configurationName : configurationNames) {
                result.add(this.variantsByConfigurationName.get(configurationName));
            }
            return result;
        }
    }

    private static class LocalComponentArtifactResolveMetadata
    implements ComponentArtifactResolveMetadata {
        private final ComponentGraphResolveMetadata metadata;

        public LocalComponentArtifactResolveMetadata(ComponentGraphResolveMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public ComponentIdentifier getId() {
            return this.metadata.getId();
        }

        @Override
        public ModuleVersionIdentifier getModuleVersionId() {
            return this.metadata.getModuleVersionId();
        }

        @Override
        public ModuleSources getSources() {
            return ImmutableModuleSources.of();
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return ImmutableAttributes.EMPTY;
        }

        @Override
        public AttributesSchemaInternal getAttributesSchema() {
            return this.metadata.getAttributesSchema();
        }
    }

    private static class DefaultLocalConfigurationArtifactResolveState
    implements VariantArtifactResolveState,
    VariantArtifactGraphResolveMetadata {
        private final ComponentGraphResolveMetadata component;
        private final LocalConfigurationGraphResolveMetadata graphSelectedConfiguration;
        private final Set<? extends VariantResolveMetadata> variants;

        public DefaultLocalConfigurationArtifactResolveState(ComponentGraphResolveMetadata component, LocalConfigurationGraphResolveMetadata graphSelectedConfiguration, Set<? extends VariantResolveMetadata> variants) {
            this.component = component;
            this.graphSelectedConfiguration = graphSelectedConfiguration;
            this.variants = variants;
        }

        @Override
        public List<? extends ComponentArtifactMetadata> getArtifacts() {
            return this.graphSelectedConfiguration.prepareToResolveArtifacts().getArtifacts();
        }

        @Override
        public ResolvedVariant resolveAdhocVariant(VariantArtifactResolver variantResolver, List<IvyArtifactName> dependencyArtifacts) {
            ImmutableList.Builder artifacts = ImmutableList.builderWithExpectedSize((int)dependencyArtifacts.size());
            for (IvyArtifactName dependencyArtifact : dependencyArtifacts) {
                artifacts.add((Object)this.graphSelectedConfiguration.prepareToResolveArtifacts().artifact(dependencyArtifact));
            }
            return variantResolver.resolveAdhocVariant(new LocalComponentArtifactResolveMetadata(this.component), (ImmutableList<? extends ComponentArtifactMetadata>)artifacts.build());
        }

        @Override
        public Set<? extends VariantResolveMetadata> getArtifactVariants() {
            return this.variants;
        }
    }

    private static class DefaultLocalConfigurationGraphResolveState
    extends AbstractComponentGraphResolveState.AbstractVariantGraphResolveState
    implements VariantGraphResolveState,
    ConfigurationGraphResolveState {
        private final long instanceId;
        private final LocalConfigurationGraphResolveMetadata configuration;
        private final CalculatedValue<DefaultLocalConfigurationArtifactResolveState> artifactResolveState;

        public DefaultLocalConfigurationGraphResolveState(long instanceId, AbstractComponentGraphResolveState<?> componentState, ComponentGraphResolveMetadata component, LocalConfigurationGraphResolveMetadata configuration, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            super(componentState);
            this.instanceId = instanceId;
            this.configuration = configuration;
            this.artifactResolveState = calculatedValueContainerFactory.create(Describables.of((Object)"artifacts of", (Object)configuration), context -> {
                Set<? extends VariantResolveMetadata> legacyVariants = configuration.prepareToResolveArtifacts().getVariants();
                return new DefaultLocalConfigurationArtifactResolveState(component, configuration, legacyVariants);
            });
        }

        @Override
        public long getInstanceId() {
            return this.instanceId;
        }

        @Override
        public String getName() {
            return this.configuration.getName();
        }

        public String toString() {
            return this.configuration.toString();
        }

        @Override
        public ConfigurationGraphResolveMetadata getMetadata() {
            return this.configuration;
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.configuration.getAttributes();
        }

        @Override
        public ImmutableCapabilities getCapabilities() {
            return this.configuration.getCapabilities();
        }

        @Override
        public VariantGraphResolveState asVariant() {
            return this;
        }

        @Override
        public VariantArtifactGraphResolveMetadata resolveArtifacts() {
            this.artifactResolveState.finalizeIfNotAlready();
            return (VariantArtifactGraphResolveMetadata)this.artifactResolveState.get();
        }

        @Override
        public VariantArtifactResolveState prepareForArtifactResolution() {
            this.artifactResolveState.finalizeIfNotAlready();
            return (VariantArtifactResolveState)this.artifactResolveState.get();
        }
    }
}

