/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.events;

import org.gradle.api.logging.LogLevel;
import org.gradle.internal.Either;
import org.gradle.internal.logging.events.InteractiveEvent;
import org.gradle.internal.logging.events.RenderableOutputEvent;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.operations.OperationIdentifier;

public class PromptOutputEvent
extends RenderableOutputEvent
implements InteractiveEvent {
    private final String prompt;
    private final boolean newQuestion;

    public PromptOutputEvent(long timestamp, String prompt, boolean newQuestion) {
        super(timestamp, "prompt", LogLevel.QUIET, null);
        this.prompt = prompt;
        this.newQuestion = newQuestion;
    }

    @Override
    public void render(StyledTextOutput output) {
        if (this.newQuestion) {
            output.println();
        }
        output.text((Object)this.prompt);
    }

    public Either<?, String> convert(String text) {
        return Either.left((Object)text);
    }

    public String getPrompt() {
        return this.prompt;
    }

    public boolean isNewQuestion() {
        return this.newQuestion;
    }

    public String toString() {
        return "[" + this.getLogLevel() + "] [" + this.getCategory() + "] '" + this.prompt + "'";
    }

    @Override
    public RenderableOutputEvent withBuildOperationId(OperationIdentifier buildOperationId) {
        throw new UnsupportedOperationException();
    }
}

