/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.CompilerApiData;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.DependentSetSerializer;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.DependentsSet;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.HierarchicalNameSerializer;
import org.gradle.internal.serialize.IntSetSerializer;

public class ClassSetAnalysisData {
    static final String MODULE_INFO = "module-info";
    static final String PACKAGE_INFO = "package-info";
    private final Map<String, HashCode> classHashes;
    private final Map<String, DependentsSet> dependents;
    private final Map<String, IntSet> classesToConstants;
    private final String fullRebuildCause;

    public static ClassSetAnalysisData merge(List<ClassSetAnalysisData> datas) {
        int classCount = 0;
        int constantsCount = 0;
        int dependentsCount = 0;
        for (ClassSetAnalysisData data : datas) {
            classCount += data.classHashes.size();
            constantsCount += data.classesToConstants.size();
            dependentsCount += data.dependents.size();
        }
        HashMap<String, HashCode> classHashes = new HashMap<String, HashCode>(classCount);
        HashMap<String, IntSet> classesToConstants = new HashMap<String, IntSet>(constantsCount);
        ArrayListMultimap dependents = ArrayListMultimap.create((int)dependentsCount, (int)10);
        String fullRebuildCause = null;
        for (ClassSetAnalysisData data : Lists.reverse(datas)) {
            classHashes.putAll(data.classHashes);
            classesToConstants.putAll(data.classesToConstants);
            data.dependents.forEach((arg_0, arg_1) -> ((Multimap)dependents).put(arg_0, arg_1));
            if (fullRebuildCause != null) continue;
            fullRebuildCause = data.fullRebuildCause;
        }
        ImmutableMap.Builder mergedDependents = ImmutableMap.builderWithExpectedSize((int)dependents.size());
        for (Map.Entry entry : dependents.asMap().entrySet()) {
            mergedDependents.put((Object)((String)entry.getKey()), (Object)DependentsSet.merge((Collection)entry.getValue()));
        }
        return new ClassSetAnalysisData(classHashes, (Map<String, DependentsSet>)mergedDependents.build(), classesToConstants, fullRebuildCause);
    }

    public ClassSetAnalysisData() {
        this(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), null);
    }

    public ClassSetAnalysisData(Map<String, HashCode> classHashes, Map<String, DependentsSet> dependents, Map<String, IntSet> classesToConstants, String fullRebuildCause) {
        this.classHashes = classHashes;
        this.dependents = dependents;
        this.classesToConstants = classesToConstants;
        this.fullRebuildCause = fullRebuildCause;
    }

    public ClassSetAnalysisData reduceToTypesAffecting(ClassSetAnalysisData other, CompilerApiData compilerApiData) {
        if (this.fullRebuildCause != null) {
            return this;
        }
        HashSet<String> usedClasses = new HashSet<String>(this.classHashes.size());
        for (Map.Entry<String, DependentsSet> entry : this.dependents.entrySet()) {
            if (!entry.getValue().isDependencyToAll()) continue;
            usedClasses.add(entry.getKey());
        }
        for (String cls : this.classHashes.keySet()) {
            if (!cls.endsWith(PACKAGE_INFO)) continue;
            usedClasses.add(cls);
        }
        usedClasses.addAll(other.dependents.keySet());
        Multimap<String, String> dependencies = this.getForwardDependencyView();
        HashSet<String> visited = new HashSet<String>(usedClasses.size());
        ArrayDeque pending = new ArrayDeque(usedClasses);
        while (!pending.isEmpty()) {
            String cls = (String)pending.poll();
            if (!visited.add(cls)) continue;
            usedClasses.add(cls);
            pending.addAll(dependencies.get((Object)cls));
        }
        Set<String> usedConstantSources = compilerApiData.isSupportsConstantsMapping() ? compilerApiData.getConstantToClassMapping().getConstantDependents().keySet() : this.classesToConstants.keySet();
        usedClasses.addAll(usedConstantSources);
        HashMap<String, HashCode> classHashes = new HashMap<String, HashCode>(usedClasses.size());
        HashMap<String, DependentsSet> dependents = new HashMap<String, DependentsSet>(usedClasses.size());
        HashMap<String, IntSet> classesToConstants = new HashMap<String, IntSet>(usedClasses.size());
        for (String usedClass : usedClasses) {
            IntSet constants;
            HashCode hash = this.classHashes.get(usedClass);
            if (hash == null) continue;
            classHashes.put(usedClass, hash);
            DependentsSet dependentsSet = this.dependents.get(usedClass);
            if (dependentsSet != null) {
                if (dependentsSet.isDependencyToAll()) {
                    dependents.put(usedClass, dependentsSet);
                } else {
                    HashSet<String> usedAccessibleClasses = new HashSet<String>(dependentsSet.getAccessibleDependentClasses());
                    usedAccessibleClasses.retainAll(usedClasses);
                    if (!usedAccessibleClasses.isEmpty()) {
                        dependents.put(usedClass, DependentsSet.dependentClasses(Collections.emptySet(), usedAccessibleClasses));
                    }
                }
            }
            if ((constants = this.classesToConstants.get(usedClass)) == null || !usedConstantSources.contains(usedClass)) continue;
            classesToConstants.put(usedClass, constants);
        }
        return new ClassSetAnalysisData(classHashes, dependents, classesToConstants, null);
    }

    private Multimap<String, String> getForwardDependencyView() {
        ArrayListMultimap dependencies = ArrayListMultimap.create((int)this.dependents.size(), (int)10);
        for (Map.Entry<String, DependentsSet> entry : this.dependents.entrySet()) {
            if (entry.getValue().isDependencyToAll()) continue;
            for (String dependent : entry.getValue().getAccessibleDependentClasses()) {
                dependencies.put((Object)dependent, (Object)entry.getKey());
            }
        }
        return dependencies;
    }

    public DependentsSet getChangedClassesSince(ClassSetAnalysisData other) {
        DependentsSet dependents;
        if (this.fullRebuildCause != null) {
            return DependentsSet.dependencyToAll(this.fullRebuildCause);
        }
        if (other.fullRebuildCause != null) {
            return DependentsSet.dependencyToAll(other.fullRebuildCause);
        }
        ImmutableSet.Builder changed = ImmutableSet.builder();
        for (String added : Sets.difference(this.classHashes.keySet(), other.classHashes.keySet())) {
            dependents = this.getDependents(added);
            if (dependents.isDependencyToAll()) {
                return dependents;
            }
            if (!added.endsWith(PACKAGE_INFO)) continue;
            changed.add((Object)added);
        }
        for (Map.Entry removedOrChanged : Sets.difference(other.classHashes.entrySet(), this.classHashes.entrySet())) {
            dependents = this.getDependents((String)removedOrChanged.getKey());
            if (dependents.isDependencyToAll()) {
                return dependents;
            }
            changed.add((Object)((String)removedOrChanged.getKey()));
        }
        return DependentsSet.dependentClasses((Set<String>)ImmutableSet.of(), (Set<String>)changed.build());
    }

    public DependentsSet getDependents(String className) {
        if (this.fullRebuildCause != null) {
            return DependentsSet.dependencyToAll(this.fullRebuildCause);
        }
        if (className.equals(MODULE_INFO)) {
            return DependentsSet.dependencyToAll("module-info has changed");
        }
        if (className.endsWith(PACKAGE_INFO)) {
            String packageName = className.equals(PACKAGE_INFO) ? null : StringUtils.removeEnd((String)className, (String)".package-info");
            return this.getDependentsOfPackage(packageName);
        }
        DependentsSet dependentsSet = this.dependents.get(className);
        return dependentsSet == null ? DependentsSet.empty() : dependentsSet;
    }

    private DependentsSet getDependentsOfPackage(String packageName) {
        HashSet<String> typesInPackage = new HashSet<String>();
        for (String type : this.classHashes.keySet()) {
            int i = type.lastIndexOf(".");
            if ((i >= 0 || packageName != null) && (i <= 0 || !type.substring(0, i).equals(packageName))) continue;
            typesInPackage.add(type);
        }
        return DependentsSet.dependentClasses(Collections.emptySet(), typesInPackage);
    }

    public IntSet getConstants(String className) {
        IntSet integers = this.classesToConstants.get(className);
        if (integers == null) {
            return IntSets.EMPTY_SET;
        }
        return integers;
    }

    public static class Serializer
    extends AbstractSerializer<ClassSetAnalysisData> {
        private final Supplier<HierarchicalNameSerializer> classNameSerializerSupplier;
        private final HashCodeSerializer hashCodeSerializer = new HashCodeSerializer();

        public Serializer(Supplier<HierarchicalNameSerializer> classNameSerializerSupplier) {
            this.classNameSerializerSupplier = classNameSerializerSupplier;
        }

        public ClassSetAnalysisData read(Decoder decoder) throws Exception {
            HierarchicalNameSerializer hierarchicalNameSerializer = this.classNameSerializerSupplier.get();
            DependentSetSerializer dependentSetSerializer = new DependentSetSerializer(() -> hierarchicalNameSerializer);
            int count = decoder.readSmallInt();
            ImmutableMap.Builder classHashes = ImmutableMap.builderWithExpectedSize((int)count);
            for (int i = 0; i < count; ++i) {
                String className = hierarchicalNameSerializer.read(decoder);
                HashCode hashCode = this.hashCodeSerializer.read(decoder);
                classHashes.put((Object)className, (Object)hashCode);
            }
            count = decoder.readSmallInt();
            ImmutableMap.Builder dependentsBuilder = ImmutableMap.builderWithExpectedSize((int)count);
            for (int i = 0; i < count; ++i) {
                String className = hierarchicalNameSerializer.read(decoder);
                DependentsSet dependents = dependentSetSerializer.read(decoder);
                dependentsBuilder.put((Object)className, (Object)dependents);
            }
            count = decoder.readSmallInt();
            ImmutableMap.Builder classesToConstantsBuilder = ImmutableMap.builderWithExpectedSize((int)count);
            for (int i = 0; i < count; ++i) {
                String className = hierarchicalNameSerializer.read(decoder);
                IntSet constants = IntSetSerializer.INSTANCE.read(decoder);
                classesToConstantsBuilder.put((Object)className, (Object)constants);
            }
            String fullRebuildCause = decoder.readNullableString();
            return new ClassSetAnalysisData((Map<String, HashCode>)classHashes.build(), (Map<String, DependentsSet>)dependentsBuilder.build(), (Map<String, IntSet>)classesToConstantsBuilder.build(), fullRebuildCause);
        }

        public void write(Encoder encoder, ClassSetAnalysisData value) throws Exception {
            HierarchicalNameSerializer hierarchicalNameSerializer = this.classNameSerializerSupplier.get();
            DependentSetSerializer dependentSetSerializer = new DependentSetSerializer(() -> hierarchicalNameSerializer);
            encoder.writeSmallInt(value.classHashes.size());
            for (Map.Entry entry : value.classHashes.entrySet()) {
                hierarchicalNameSerializer.write(encoder, (String)entry.getKey());
                this.hashCodeSerializer.write(encoder, (HashCode)entry.getValue());
            }
            encoder.writeSmallInt(value.dependents.size());
            for (Map.Entry entry : value.dependents.entrySet()) {
                hierarchicalNameSerializer.write(encoder, (String)entry.getKey());
                dependentSetSerializer.write(encoder, (DependentsSet)entry.getValue());
            }
            encoder.writeSmallInt(value.classesToConstants.size());
            for (Map.Entry entry : value.classesToConstants.entrySet()) {
                hierarchicalNameSerializer.write(encoder, (String)entry.getKey());
                IntSetSerializer.INSTANCE.write(encoder, (IntSet)entry.getValue());
            }
            encoder.writeNullableString((CharSequence)value.fullRebuildCause);
        }
    }
}

