/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.annotations.VisibleForTesting;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.gradle.api.problems.ProblemReporter;
import org.gradle.api.problems.ProblemSpec;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;

public class DiagnosticToProblemListener
implements DiagnosticListener<JavaFileObject> {
    private final ProblemReporter problemReporter;

    public DiagnosticToProblemListener(ProblemReporter problemReporter) {
        this.problemReporter = problemReporter;
    }

    @Override
    public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
        this.problemReporter.reporting(spec -> DiagnosticToProblemListener.buildProblem(diagnostic, spec));
    }

    @VisibleForTesting
    static void buildProblem(Diagnostic<? extends JavaFileObject> diagnostic, ProblemSpec spec) {
        spec.id(DiagnosticToProblemListener.mapKindToId(diagnostic.getKind()), DiagnosticToProblemListener.mapKindToLabel(diagnostic.getKind()), GradleCoreProblemGroup.compilation().java());
        spec.severity(DiagnosticToProblemListener.mapKindToSeverity(diagnostic.getKind()));
        DiagnosticToProblemListener.addDetails(spec, diagnostic.getMessage(Locale.getDefault()));
        DiagnosticToProblemListener.addLocations(spec, diagnostic);
    }

    private static void addDetails(ProblemSpec spec, @Nullable String diagnosticMessage) {
        if (diagnosticMessage != null) {
            spec.details(diagnosticMessage);
        }
    }

    private static void addLocations(ProblemSpec spec, Diagnostic<? extends JavaFileObject> diagnostic) {
        String resourceName = diagnostic.getSource() != null ? DiagnosticToProblemListener.getPath(diagnostic.getSource()) : null;
        int line = DiagnosticToProblemListener.clampLocation(diagnostic.getLineNumber());
        int column = DiagnosticToProblemListener.clampLocation(diagnostic.getColumnNumber());
        int start = DiagnosticToProblemListener.clampLocation(diagnostic.getStartPosition());
        int end = DiagnosticToProblemListener.clampLocation(diagnostic.getEndPosition());
        if (resourceName != null) {
            spec.fileLocation(resourceName);
            if (line > 0) {
                if (column > 0) {
                    if (0 < start && start <= end) {
                        spec.lineInFileLocation(resourceName, line, column, end - start);
                    } else {
                        spec.lineInFileLocation(resourceName, line, column);
                    }
                } else {
                    spec.lineInFileLocation(resourceName, line);
                }
            }
            if (0 < start && start <= end) {
                spec.offsetInFileLocation(resourceName, start, end - start);
            }
        }
    }

    private static int clampLocation(long value) {
        if (value > Integer.MAX_VALUE) {
            return Math.toIntExact(-1L);
        }
        return (int)value;
    }

    private static String getPath(JavaFileObject fileObject) {
        return fileObject.getName();
    }

    private static String mapKindToId(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return "java-compilation-error";
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                return "java-compilation-warning";
            }
            case NOTE: {
                return "java-compilation-note";
            }
            case OTHER: {
                return "java-compilation-problem";
            }
        }
        return "unknown-java-compilation-problem";
    }

    private static String mapKindToLabel(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return "Java compilation error";
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                return "Java compilation warning";
            }
            case NOTE: {
                return "Java compilation note";
            }
            case OTHER: {
                return "Java compilation problem";
            }
        }
        return "Unknown java compilation problem";
    }

    private static Severity mapKindToSeverity(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return Severity.ERROR;
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                return Severity.WARNING;
            }
        }
        return Severity.ADVICE;
    }
}

