/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import java.util.Collections;
import java.util.List;
import org.gradle.api.problems.ProblemReporter;
import org.gradle.api.problems.internal.DefaultProblemReporter;
import org.gradle.api.problems.internal.InternalProblemReporter;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.problems.internal.ProblemEmitter;
import org.gradle.api.problems.internal.ProblemTransformer;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildTree.class})
public class DefaultProblems
implements InternalProblems {
    private final CurrentBuildOperationRef currentBuildOperationRef;
    private final ProblemEmitter emitter;
    private final List<ProblemTransformer> transformers;
    private final InternalProblemReporter internalReporter;

    public DefaultProblems(ProblemEmitter emitter, CurrentBuildOperationRef currentBuildOperationRef) {
        this(emitter, Collections.emptyList(), currentBuildOperationRef);
    }

    public DefaultProblems(ProblemEmitter emitter) {
        this(emitter, Collections.emptyList(), CurrentBuildOperationRef.instance());
    }

    public DefaultProblems(ProblemEmitter emitter, List<ProblemTransformer> transformers, CurrentBuildOperationRef currentBuildOperationRef) {
        this.emitter = emitter;
        this.transformers = transformers;
        this.currentBuildOperationRef = currentBuildOperationRef;
        this.internalReporter = this.createReporter(emitter, transformers);
    }

    @Override
    public ProblemReporter forNamespace(String namespace) {
        if ("org.gradle".equals(namespace)) {
            throw new IllegalStateException("Cannot use org.gradle namespace.");
        }
        return this.createReporter(this.emitter, this.transformers);
    }

    private DefaultProblemReporter createReporter(ProblemEmitter emitter, List<ProblemTransformer> transformers) {
        return new DefaultProblemReporter(emitter, transformers, this.currentBuildOperationRef);
    }

    @Override
    public InternalProblemReporter getInternalReporter() {
        return this.internalReporter;
    }
}

