/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.JavaForkOptionsInternal;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.KeepAliveMode;

public class DaemonForkOptions {
    private final JavaForkOptionsInternal forkOptions;
    private final KeepAliveMode keepAliveMode;
    private final ClassLoaderStructure classLoaderStructure;

    DaemonForkOptions(JavaForkOptionsInternal forkOptions, KeepAliveMode keepAliveMode, ClassLoaderStructure classLoaderStructure) {
        this.forkOptions = forkOptions;
        this.keepAliveMode = keepAliveMode;
        this.classLoaderStructure = classLoaderStructure;
    }

    public KeepAliveMode getKeepAliveMode() {
        return this.keepAliveMode;
    }

    public JavaForkOptions getJavaForkOptions() {
        return this.forkOptions;
    }

    public ClassLoaderStructure getClassLoaderStructure() {
        return this.classLoaderStructure;
    }

    public boolean isCompatibleWith(DaemonForkOptions other) {
        return this.forkOptions.isCompatibleWith((JavaForkOptions)other.forkOptions) && this.keepAliveMode == other.getKeepAliveMode() && Objects.equal((Object)this.classLoaderStructure, (Object)other.getClassLoaderStructure());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("executable", (Object)this.forkOptions.getExecutable()).add("minHeapSize", (Object)this.forkOptions.getMinHeapSize()).add("maxHeapSize", (Object)this.forkOptions.getMaxHeapSize()).add("jvmArgs", (Object)this.forkOptions.getJvmArgs()).add("keepAliveMode", (Object)this.keepAliveMode).toString();
    }
}

