/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.plugins;

import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.repositories.DefaultMavenArtifactRepository;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.provider.MissingValueException;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.versionmapping.DefaultVersionMappingStrategy;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.artifact.MavenArtifactNotationParserFactory;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.publish.maven.tasks.PublishToMavenLocal;
import org.gradle.api.publish.maven.tasks.PublishToMavenRepository;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.api.publish.tasks.GenerateModuleMetadata;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

public abstract class MavenPublishPlugin
implements Plugin<Project> {
    public static final String PUBLISH_LOCAL_LIFECYCLE_TASK_NAME = "publishToMavenLocal";
    private final InstantiatorFactory instantiatorFactory;
    private final ObjectFactory objectFactory;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final FileResolver fileResolver;
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private final ProviderFactory providerFactory;
    private final TaskDependencyFactory taskDependencyFactory;

    @Inject
    public MavenPublishPlugin(InstantiatorFactory instantiatorFactory, ObjectFactory objectFactory, DependencyMetaDataProvider dependencyMetaDataProvider, FileResolver fileResolver, ImmutableAttributesFactory immutableAttributesFactory, ProviderFactory providerFactory, TaskDependencyFactory taskDependencyFactory) {
        this.instantiatorFactory = instantiatorFactory;
        this.objectFactory = objectFactory;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
        this.fileResolver = fileResolver;
        this.immutableAttributesFactory = immutableAttributesFactory;
        this.providerFactory = providerFactory;
        this.taskDependencyFactory = taskDependencyFactory;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(PublishingPlugin.class);
        TaskContainer tasks = project.getTasks();
        tasks.register(PUBLISH_LOCAL_LIFECYCLE_TASK_NAME, publish -> {
            publish.setDescription("Publishes all Maven publications produced by this project to the local Maven cache.");
            publish.setGroup("publishing");
        });
        project.getExtensions().configure(PublishingExtension.class, extension -> {
            extension.getPublications().registerFactory(MavenPublication.class, (NamedDomainObjectFactory)new MavenPublicationFactory(this.dependencyMetaDataProvider, (Instantiator)this.instantiatorFactory.decorateLenient(), this.fileResolver));
            this.realizePublishingTasksLater(project, (PublishingExtension)extension);
        });
    }

    private void realizePublishingTasksLater(Project project, PublishingExtension extension) {
        NamedDomainObjectSet mavenPublications = extension.getPublications().withType(MavenPublicationInternal.class);
        TaskContainer tasks = project.getTasks();
        DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        TaskProvider publishLifecycleTask = tasks.named("publish");
        TaskProvider publishLocalLifecycleTask = tasks.named(PUBLISH_LOCAL_LIFECYCLE_TASK_NAME);
        NamedDomainObjectList repositories = extension.getRepositories().withType(MavenArtifactRepository.class);
        repositories.all(repository -> tasks.register(this.publishAllToSingleRepoTaskName((MavenArtifactRepository)repository), publish -> {
            publish.setDescription("Publishes all Maven publications produced by this project to the " + repository.getName() + " repository.");
            publish.setGroup("publishing");
        }));
        mavenPublications.all(publication -> {
            this.createGenerateMetadataTask(tasks, (MavenPublicationInternal)publication, (Set<? extends MavenPublicationInternal>)mavenPublications, buildDirectory);
            this.createGeneratePomTask(tasks, (MavenPublicationInternal)publication, buildDirectory);
            this.createLocalInstallTask(tasks, (TaskProvider<Task>)publishLocalLifecycleTask, (MavenPublicationInternal)publication);
            this.createPublishTasksForEachMavenRepo(project, tasks, (TaskProvider<Task>)publishLifecycleTask, (MavenPublicationInternal)publication, (NamedDomainObjectList<MavenArtifactRepository>)repositories);
        });
    }

    private String publishAllToSingleRepoTaskName(MavenArtifactRepository repository) {
        return "publishAllPublicationsTo" + StringUtils.capitalize((String)repository.getName()) + "Repository";
    }

    private void createPublishTasksForEachMavenRepo(Project project, TaskContainer tasks, TaskProvider<Task> publishLifecycleTask, MavenPublicationInternal publication, NamedDomainObjectList<MavenArtifactRepository> repositories) {
        String publicationName = publication.getName();
        repositories.all(repository -> {
            String repositoryName = repository.getName();
            String publishTaskName = "publish" + StringUtils.capitalize((String)publicationName) + "PublicationTo" + StringUtils.capitalize((String)repositoryName) + "Repository";
            tasks.register(publishTaskName, PublishToMavenRepository.class, publishTask -> {
                publishTask.setPublication(publication);
                publishTask.setRepository((MavenArtifactRepository)repository);
                publishTask.setGroup("publishing");
                publishTask.setDescription("Publishes Maven publication '" + publicationName + "' to Maven repository '" + repositoryName + "'.");
                project.getGradle().getTaskGraph().whenReady(graph -> {
                    if (graph.hasTask((Task)publishTask)) {
                        MavenPublishPlugin.validateCredentialsSetup(project, publishTask);
                    }
                });
            });
            publishLifecycleTask.configure(task -> task.dependsOn(new Object[]{publishTaskName}));
            tasks.named(this.publishAllToSingleRepoTaskName((MavenArtifactRepository)repository), publish -> publish.dependsOn(new Object[]{publishTaskName}));
        });
    }

    private static void validateCredentialsSetup(Project project, PublishToMavenRepository publishToMavenRepository) {
        Credentials creds;
        DefaultMavenArtifactRepository repository = (DefaultMavenArtifactRepository)publishToMavenRepository.getRepository();
        try {
            creds = (Credentials)repository.getConfiguredCredentials().getOrNull();
        }
        catch (Exception e) {
            creds = null;
        }
        if (creds != null && !MavenPublishPlugin.isUsingCredentialsProvider((ProjectInternal)project, repository.getName(), creds)) {
            publishToMavenRepository.notCompatibleWithConfigurationCache("Publishing to a repository without a credentials provider is not yet supported for the configuration cache");
        }
    }

    private static boolean isUsingCredentialsProvider(ProjectInternal project, String identity, Credentials toCheck) {
        Credentials referenceCredentials;
        ProviderFactory providerFactory = (ProviderFactory)project.getServices().get(ProviderFactory.class);
        try {
            Provider credentialsProvider;
            try {
                credentialsProvider = providerFactory.credentials(toCheck.getClass(), identity);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            referenceCredentials = (Credentials)credentialsProvider.get();
        }
        catch (MissingValueException e) {
            return false;
        }
        return EqualsBuilder.reflectionEquals((Object)toCheck, (Object)referenceCredentials);
    }

    private void createLocalInstallTask(TaskContainer tasks, TaskProvider<Task> publishLocalLifecycleTask, MavenPublicationInternal publication) {
        String publicationName = publication.getName();
        String installTaskName = "publish" + StringUtils.capitalize((String)publicationName) + "PublicationToMavenLocal";
        tasks.register(installTaskName, PublishToMavenLocal.class, publishLocalTask -> {
            publishLocalTask.setPublication(publication);
            publishLocalTask.setGroup("publishing");
            publishLocalTask.setDescription("Publishes Maven publication '" + publicationName + "' to the local Maven repository.");
        });
        publishLocalLifecycleTask.configure(task -> task.dependsOn(new Object[]{installTaskName}));
    }

    private void createGeneratePomTask(TaskContainer tasks, MavenPublicationInternal publication, DirectoryProperty buildDir) {
        String publicationName = publication.getName();
        String descriptorTaskName = "generatePomFileFor" + StringUtils.capitalize((String)publicationName) + "Publication";
        TaskProvider generatorTask = tasks.register(descriptorTaskName, GenerateMavenPom.class, generatePomTask -> {
            generatePomTask.setDescription("Generates the Maven POM file for publication '" + publicationName + "'.");
            generatePomTask.setGroup("publishing");
            generatePomTask.setPom(publication.getPom());
            if (generatePomTask.getDestination() == null) {
                generatePomTask.setDestination(buildDir.file("publications/" + publication.getName() + "/pom-default.xml"));
            }
        });
        publication.setPomGenerator((TaskProvider<? extends Task>)generatorTask);
    }

    private void createGenerateMetadataTask(TaskContainer tasks, MavenPublicationInternal publication, Set<? extends MavenPublicationInternal> publications, DirectoryProperty buildDir) {
        String publicationName = publication.getName();
        String descriptorTaskName = "generateMetadataFileFor" + StringUtils.capitalize((String)publicationName) + "Publication";
        TaskProvider generatorTask = tasks.register(descriptorTaskName, GenerateModuleMetadata.class, generateTask -> {
            generateTask.setDescription("Generates the Gradle metadata file for publication '" + publicationName + "'.");
            generateTask.setGroup("publishing");
            generateTask.getPublication().set((Object)publication);
            generateTask.getPublications().set((Iterable)publications);
            generateTask.getOutputFile().convention(buildDir.file("publications/" + publication.getName() + "/module.json"));
        });
        publication.setModuleDescriptorGenerator((TaskProvider<? extends Task>)generatorTask);
    }

    private class MavenPublicationFactory
    implements NamedDomainObjectFactory<MavenPublication> {
        private final Instantiator instantiator;
        private final DependencyMetaDataProvider dependencyMetaDataProvider;
        private final FileResolver fileResolver;

        private MavenPublicationFactory(DependencyMetaDataProvider dependencyMetaDataProvider, Instantiator instantiator, FileResolver fileResolver) {
            this.dependencyMetaDataProvider = dependencyMetaDataProvider;
            this.instantiator = instantiator;
            this.fileResolver = fileResolver;
        }

        public MavenPublication create(String name) {
            NotationParser<Object, MavenArtifact> artifactNotationParser = new MavenArtifactNotationParserFactory(this.instantiator, this.fileResolver, MavenPublishPlugin.this.taskDependencyFactory).create();
            VersionMappingStrategyInternal versionMappingStrategy = (VersionMappingStrategyInternal)MavenPublishPlugin.this.objectFactory.newInstance(DefaultVersionMappingStrategy.class, new Object[0]);
            return (MavenPublication)MavenPublishPlugin.this.objectFactory.newInstance(DefaultMavenPublication.class, new Object[]{name, this.dependencyMetaDataProvider, artifactNotationParser, versionMappingStrategy});
        }
    }
}

