/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.EvaluationContext;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;

class OrElseValueProducer
implements ValueSupplier.ValueProducer {
    private final EvaluationContext.EvaluationOwner owner;
    private final ProviderInternal<?> left;
    @Nullable
    private final ProviderInternal<?> right;
    private final ValueSupplier.ValueProducer leftProducer;
    private final ValueSupplier.ValueProducer rightProducer;

    public OrElseValueProducer(EvaluationContext.ScopeContext context, ProviderInternal<?> left) {
        this(context, left, null, ValueSupplier.ValueProducer.unknown());
    }

    public OrElseValueProducer(EvaluationContext.ScopeContext context, ProviderInternal<?> left, ProviderInternal<?> right) {
        this(context, left, right, right.getProducer());
    }

    private OrElseValueProducer(EvaluationContext.ScopeContext context, ProviderInternal<?> left, @Nullable ProviderInternal<?> right, ValueSupplier.ValueProducer rightProducer) {
        this.owner = context.getOwner();
        this.left = left;
        this.right = right;
        this.leftProducer = left.getProducer();
        this.rightProducer = rightProducer;
    }

    @Override
    public boolean isKnown() {
        return this.leftProducer.isKnown() || this.rightProducer.isKnown();
    }

    @Override
    public void visitProducerTasks(Action<? super Task> visitor) {
        try (EvaluationContext.ScopeContext ignored = EvaluationContext.current().open(this.owner);){
            if (this.mayHaveValue(this.left)) {
                if (this.leftProducer.isKnown()) {
                    this.leftProducer.visitProducerTasks(visitor);
                }
                return;
            }
            if (this.right != null && this.rightProducer.isKnown() && this.mayHaveValue(this.right)) {
                this.rightProducer.visitProducerTasks(visitor);
            }
        }
    }

    private boolean mayHaveValue(ProviderInternal<?> provider) {
        return !provider.calculateExecutionTimeValue().isMissing();
    }
}

