/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.file.collections.ListBackedFileSet;
import org.gradle.api.internal.file.collections.ManagedFactories;
import org.gradle.api.internal.file.collections.UnpackingVisitor;
import org.gradle.api.internal.provider.HasConfigurableValueInternal;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.provider.ValueState;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.provider.support.LazyGroovySupport;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.state.Managed;
import org.jetbrains.annotations.Nullable;

public class DefaultConfigurableFileCollection
extends CompositeFileCollection
implements ConfigurableFileCollection,
Managed,
HasConfigurableValueInternal,
LazyGroovySupport {
    private static final EmptyCollector EMPTY_COLLECTOR = new EmptyCollector();
    private final PathSet filesWrapper;
    private final String displayName;
    private final PathToFileResolver resolver;
    private final TaskDependencyFactory dependencyFactory;
    private final PropertyHost host;
    private final DefaultTaskDependency buildDependency;
    private ValueCollector value = EMPTY_COLLECTOR;
    private ValueState<ValueCollector> valueState;

    public DefaultConfigurableFileCollection(@javax.annotation.Nullable String displayName, PathToFileResolver fileResolver, TaskDependencyFactory dependencyFactory, Factory<PatternSet> patternSetFactory, PropertyHost host) {
        super(dependencyFactory, patternSetFactory);
        this.displayName = displayName;
        this.resolver = fileResolver;
        this.dependencyFactory = dependencyFactory;
        this.host = host;
        this.valueState = ValueState.newState((PropertyHost)host);
        this.filesWrapper = new PathSet();
        this.buildDependency = dependencyFactory.configurableDependency();
    }

    public boolean isImmutable() {
        return false;
    }

    public Class<?> publicType() {
        return ConfigurableFileCollection.class;
    }

    public Object unpackState() {
        return this.getFiles();
    }

    public void finalizeValue() {
        if (this.valueState.shouldFinalize(this::displayNameForThisCollection, null)) {
            this.finalizeNow();
        }
    }

    private void finalizeNow() {
        this.calculateFinalizedValue();
        this.valueState = this.valueState.finalState();
    }

    public boolean isFinalizing() {
        return this.valueState.isFinalizing();
    }

    public void disallowChanges() {
        this.valueState.disallowChanges();
    }

    public void finalizeValueOnRead() {
        this.valueState.finalizeOnNextGet();
    }

    public void implicitFinalizeValue() {
        this.valueState.finalizeOnNextGet();
    }

    public void disallowUnsafeRead() {
        this.valueState.disallowUnsafeRead();
    }

    public int getFactoryId() {
        return ManagedFactories.ConfigurableFileCollectionManagedFactory.FACTORY_ID;
    }

    @Override
    public String getDisplayName() {
        return this.displayName == null ? "file collection" : this.displayName;
    }

    @Override
    protected void appendContents(TreeFormatter formatter) {
        if (this.displayName != null) {
            formatter.node("display name: " + this.displayName);
        }
        ArrayList<Object> paths = new ArrayList<Object>();
        this.value.collectSource(paths);
        if (!paths.isEmpty()) {
            formatter.node("contents");
            formatter.startChildren();
            for (Object e : paths) {
                if (e instanceof FileCollectionInternal) {
                    ((FileCollectionInternal)e).describeContents(formatter);
                    continue;
                }
                formatter.node(e.toString());
            }
            formatter.endChildren();
        }
    }

    public Set<Object> getFrom() {
        return this.filesWrapper;
    }

    public void setFromAnyValue(Object object) {
        FileCollectionInternal fileCollection = (FileCollectionInternal)Cast.castNullable(FileCollectionInternal.class, (Object)((FileCollection)Cast.castNullable(FileCollection.class, (Object)object)));
        fileCollection.visitStructure(new FileCollectionStructureVisitor(){

            @Override
            public boolean startVisit(FileCollectionInternal.Source source, FileCollectionInternal fileCollection) {
                if (DefaultConfigurableFileCollection.this == fileCollection) {
                    throw new UnsupportedOperationException("Self-referencing ConfigurableFileCollections are not supported. Use the from() method to add to a ConfigurableFileCollection.");
                }
                return true;
            }

            @Override
            public FileCollectionStructureVisitor.VisitType prepareForVisit(FileCollectionInternal.Source source) {
                return FileCollectionStructureVisitor.VisitType.NoContents;
            }

            @Override
            public void visitCollection(FileCollectionInternal.Source source, Iterable<File> contents) {
            }

            @Override
            public void visitFileTree(File root, PatternSet patterns, FileTreeInternal fileTree) {
            }

            @Override
            public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
            }
        });
        this.setFrom((Iterable)Cast.castNullable(FileCollection.class, (Object)object));
    }

    @Override
    public FileCollection plus(FileCollection collection) {
        return new UnionFileCollection(this.taskDependencyFactory, this, (FileCollectionInternal)collection);
    }

    public void setFrom(Iterable<?> path) {
        this.assertMutable();
        this.value = this.value.setFrom(this, this.resolver, (Factory<PatternSet>)this.patternSetFactory, this.dependencyFactory, this.host, path);
    }

    public void setFrom(Object ... paths) {
        this.assertMutable();
        this.value = paths.length > 0 ? this.value.setFrom(this, this.resolver, (Factory<PatternSet>)this.patternSetFactory, this.dependencyFactory, this.host, paths) : EMPTY_COLLECTOR;
    }

    public ConfigurableFileCollection from(Object ... paths) {
        this.assertMutable();
        if (paths.length > 0) {
            this.value = this.value.plus(this, this.resolver, (Factory<PatternSet>)this.patternSetFactory, this.dependencyFactory, this.host, paths);
        }
        return this;
    }

    @Override
    public FileCollectionInternal replace(FileCollectionInternal original, Supplier<FileCollectionInternal> supplier) {
        if (original == this) {
            return supplier.get();
        }
        List<Object> newItems = this.value.replace(original, supplier);
        if (newItems == null) {
            return this;
        }
        DefaultConfigurableFileCollection newFiles = new DefaultConfigurableFileCollection(null, this.resolver, this.dependencyFactory, (Factory<PatternSet>)this.patternSetFactory, this.host);
        newFiles.from(newItems);
        return newFiles;
    }

    private void assertMutable() {
        this.valueState.beforeMutate(this::displayNameForThisCollection);
    }

    private String displayNameForThisCollection() {
        return this.displayName == null ? "this file collection" : this.displayName;
    }

    public ConfigurableFileCollection builtBy(Object ... tasks) {
        this.buildDependency.add(tasks);
        return this;
    }

    public Set<Object> getBuiltBy() {
        return this.buildDependency.getMutableValues();
    }

    public ConfigurableFileCollection setBuiltBy(Iterable<?> tasks) {
        this.buildDependency.setValues(tasks);
        return this;
    }

    private void calculateFinalizedValue() {
        final ImmutableList.Builder builder = ImmutableList.builder();
        this.value.visitContents((FileCollectionInternal child) -> child.visitStructure(new FileCollectionStructureVisitor(){

            @Override
            public void visitCollection(FileCollectionInternal.Source source, Iterable<File> contents) {
                ImmutableSet files = ImmutableSet.copyOf(contents);
                if (!files.isEmpty()) {
                    builder.add((Object)new FileCollectionAdapter(new ListBackedFileSet((ImmutableSet<File>)files), DefaultConfigurableFileCollection.this.taskDependencyFactory, (Factory<PatternSet>)DefaultConfigurableFileCollection.this.patternSetFactory));
                }
            }

            @Override
            public void visitFileTree(File root, PatternSet patterns, FileTreeInternal fileTree) {
                builder.add((Object)fileTree);
            }

            @Override
            public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                builder.add((Object)fileTree);
            }
        }));
        this.value = new ResolvedItemsCollector((ImmutableList<FileCollectionInternal>)builder.build());
    }

    @Override
    protected void visitChildren(Consumer<FileCollectionInternal> visitor) {
        this.valueState.finalizeOnReadIfNeeded(this::displayNameForThisCollection, null, ValueSupplier.ValueConsumer.IgnoreUnsafeRead, unused -> this.finalizeNow());
        this.value.visitContents(visitor);
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        context.add((Object)this.buildDependency);
        super.visitDependencies(context);
    }

    public FileCollectionInternal shallowCopy() {
        DefaultConfigurableFileCollection result = new DefaultConfigurableFileCollection(null, this.resolver, this.taskDependencyFactory, (Factory<PatternSet>)this.patternSetFactory, this.host);
        result.buildDependency.setValues((Iterable)this.buildDependency.getMutableValues());
        result.setFrom(new ArrayList<Object>(this.getFrom()));
        return result;
    }

    public void update(Transformer<? extends @Nullable FileCollection, ? super FileCollection> transform) {
        FileCollection newValue = (FileCollection)transform.transform((Object)this.shallowCopy());
        if (newValue != null) {
            this.setFrom((Iterable<?>)newValue);
        } else {
            this.setFrom(new Object[0]);
        }
    }

    private class PathSet
    extends AbstractSet<Object> {
        private PathSet() {
        }

        private Set<Object> delegate() {
            LinkedHashSet<Object> sources = new LinkedHashSet<Object>();
            DefaultConfigurableFileCollection.this.value.collectSource(sources);
            return sources;
        }

        @Override
        public Iterator<Object> iterator() {
            final Iterator<Object> iterator = this.delegate().iterator();
            return new Iterator<Object>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Object next() {
                    return iterator.next();
                }

                @Override
                public void remove() {
                    DefaultConfigurableFileCollection.this.assertMutable();
                    iterator.remove();
                }
            };
        }

        @Override
        public int size() {
            return this.delegate().size();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate().contains(o);
        }

        @Override
        public boolean add(Object o) {
            DefaultConfigurableFileCollection.this.assertMutable();
            if (!this.delegate().contains(o)) {
                DefaultConfigurableFileCollection.this.value = DefaultConfigurableFileCollection.this.value.plus(DefaultConfigurableFileCollection.this, DefaultConfigurableFileCollection.this.resolver, (Factory<PatternSet>)DefaultConfigurableFileCollection.this.patternSetFactory, DefaultConfigurableFileCollection.this.dependencyFactory, DefaultConfigurableFileCollection.this.host, o);
                return true;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            DefaultConfigurableFileCollection.this.assertMutable();
            return DefaultConfigurableFileCollection.this.value.remove(o);
        }

        @Override
        public void clear() {
            DefaultConfigurableFileCollection.this.assertMutable();
            DefaultConfigurableFileCollection.this.value = EMPTY_COLLECTOR;
        }
    }

    private static class ResolvedItemsCollector
    implements ValueCollector {
        private final ImmutableList<FileCollectionInternal> fileCollections;

        public ResolvedItemsCollector(ImmutableList<FileCollectionInternal> fileCollections) {
            this.fileCollections = fileCollections;
        }

        @Override
        public void collectSource(Collection<Object> dest) {
            dest.addAll((Collection<Object>)this.fileCollections);
        }

        @Override
        public void visitContents(Consumer<FileCollectionInternal> visitor) {
            for (FileCollectionInternal fileCollection : this.fileCollections) {
                visitor.accept(fileCollection);
            }
        }

        @Override
        public ValueCollector setFrom(DefaultConfigurableFileCollection owner, PathToFileResolver resolver, Factory<PatternSet> patternSetFactory, TaskDependencyFactory taskDependencyFactory, PropertyHost propertyHost, Iterable<?> path) {
            throw new UnsupportedOperationException("Should not be called");
        }

        @Override
        public ValueCollector setFrom(DefaultConfigurableFileCollection owner, PathToFileResolver resolver, Factory<PatternSet> patternSetFactory, TaskDependencyFactory taskDependencyFactory, PropertyHost propertyHost, Object[] paths) {
            throw new UnsupportedOperationException("Should not be called");
        }

        @Override
        public ValueCollector plus(DefaultConfigurableFileCollection owner, PathToFileResolver resolver, Factory<PatternSet> patternSetFactory, TaskDependencyFactory taskDependencyFactory, PropertyHost propertyHost, Object ... paths) {
            throw new UnsupportedOperationException("Should not be called");
        }

        @Override
        public boolean remove(Object source) {
            throw new UnsupportedOperationException("Should not be called");
        }

        @Override
        @javax.annotation.Nullable
        public List<Object> replace(FileCollectionInternal original, Supplier<FileCollectionInternal> supplier) {
            return null;
        }
    }

    private static class UnresolvedItemsCollector
    implements ValueCollector {
        private final PathToFileResolver resolver;
        private final Factory<PatternSet> patternSetFactory;
        private final TaskDependencyFactory taskDependencyFactory;
        private final Set<Object> items = new LinkedHashSet<Object>();

        public UnresolvedItemsCollector(DefaultConfigurableFileCollection owner, PathToFileResolver resolver, Factory<PatternSet> patternSetFactory, TaskDependencyFactory taskDependencyFactory, PropertyHost propertyHost, Iterable<?> item) {
            this.resolver = resolver;
            this.patternSetFactory = patternSetFactory;
            this.taskDependencyFactory = taskDependencyFactory;
            this.setFrom(owner, resolver, patternSetFactory, taskDependencyFactory, propertyHost, item);
        }

        public UnresolvedItemsCollector(PathToFileResolver resolver, TaskDependencyFactory taskDependencyFactory, Factory<PatternSet> patternSetFactory, Object[] item) {
            this.resolver = resolver;
            this.taskDependencyFactory = taskDependencyFactory;
            this.patternSetFactory = patternSetFactory;
            Collections.addAll(this.items, item);
        }

        @Override
        public void collectSource(Collection<Object> dest) {
            dest.addAll(this.items);
        }

        @Override
        public void visitContents(Consumer<FileCollectionInternal> visitor) {
            UnpackingVisitor nested = new UnpackingVisitor(visitor, this.resolver, this.taskDependencyFactory, this.patternSetFactory);
            for (Object item : this.items) {
                nested.add(item);
            }
        }

        @Override
        public boolean remove(Object source) {
            return this.items.remove(source);
        }

        @Override
        public ValueCollector setFrom(DefaultConfigurableFileCollection owner, PathToFileResolver resolver, Factory<PatternSet> patternSetFactory, TaskDependencyFactory taskDependencyFactory, PropertyHost propertyHost, Iterable<?> path) {
            ImmutableList oldItems = ImmutableList.copyOf(this.items);
            this.items.clear();
            this.addItem(owner, resolver, patternSetFactory, taskDependencyFactory, propertyHost, path, (ImmutableList<Object>)oldItems);
            return this;
        }

        @Override
        public ValueCollector setFrom(DefaultConfigurableFileCollection owner, PathToFileResolver resolver, Factory<PatternSet> patternSetFactory, TaskDependencyFactory taskDependencyFactory, PropertyHost propertyHost, Object[] paths) {
            ImmutableList oldItems = ImmutableList.copyOf(this.items);
            this.items.clear();
            for (Object path : paths) {
                this.addItem(owner, resolver, patternSetFactory, taskDependencyFactory, propertyHost, path, (ImmutableList<Object>)oldItems);
            }
            return this;
        }

        @Override
        public ValueCollector plus(DefaultConfigurableFileCollection owner, PathToFileResolver resolver, Factory<PatternSet> patternSetFactory, TaskDependencyFactory taskDependencyFactory, PropertyHost propertyHost, Object ... paths) {
            ImmutableList oldItems = ImmutableList.copyOf(this.items);
            for (Object path : paths) {
                this.addItem(owner, resolver, patternSetFactory, taskDependencyFactory, propertyHost, path, (ImmutableList<Object>)oldItems);
            }
            return this;
        }

        private void addItem(DefaultConfigurableFileCollection owner, PathToFileResolver resolver, Factory<PatternSet> patternSetFactory, TaskDependencyFactory taskDependencyFactory, PropertyHost propertyHost, Object path, ImmutableList<Object> oldItems) {
            if (path instanceof FileCollectionInternal) {
                path = ((FileCollectionInternal)path).replace(owner, () -> {
                    if (oldItems.size() == 1 && oldItems.get(0) instanceof FileCollectionInternal) {
                        return (FileCollectionInternal)oldItems.get(0);
                    }
                    DefaultConfigurableFileCollection oldFiles = new DefaultConfigurableFileCollection(null, resolver, taskDependencyFactory, patternSetFactory, propertyHost);
                    oldFiles.from(oldItems);
                    return oldFiles;
                });
            }
            this.items.add(path);
        }

        @Override
        @javax.annotation.Nullable
        public List<Object> replace(FileCollectionInternal original, Supplier<FileCollectionInternal> supplier) {
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.items.size());
            boolean hasChanges = false;
            for (Object candidate : this.items) {
                if (candidate instanceof FileCollectionInternal) {
                    FileCollectionInternal newCollection = ((FileCollectionInternal)candidate).replace(original, supplier);
                    hasChanges |= newCollection != candidate;
                    builder.add((Object)newCollection);
                    continue;
                }
                builder.add(candidate);
            }
            if (hasChanges) {
                return builder.build();
            }
            return null;
        }
    }

    private static class EmptyCollector
    implements ValueCollector {
        private EmptyCollector() {
        }

        @Override
        public void collectSource(Collection<Object> dest) {
        }

        @Override
        public void visitContents(Consumer<FileCollectionInternal> visitor) {
        }

        @Override
        public boolean remove(Object source) {
            return false;
        }

        @Override
        public ValueCollector setFrom(DefaultConfigurableFileCollection owner, PathToFileResolver resolver, Factory<PatternSet> patternSetFactory, TaskDependencyFactory taskDependencyFactory, PropertyHost propertyHost, Iterable<?> path) {
            return new UnresolvedItemsCollector(owner, resolver, patternSetFactory, taskDependencyFactory, propertyHost, path);
        }

        @Override
        public ValueCollector setFrom(DefaultConfigurableFileCollection owner, PathToFileResolver resolver, Factory<PatternSet> patternSetFactory, TaskDependencyFactory taskDependencyFactory, PropertyHost propertyHost, Object[] paths) {
            return new UnresolvedItemsCollector(resolver, taskDependencyFactory, patternSetFactory, paths);
        }

        @Override
        public ValueCollector plus(DefaultConfigurableFileCollection owner, PathToFileResolver resolver, Factory<PatternSet> patternSetFactory, TaskDependencyFactory taskDependencyFactory, PropertyHost propertyHost, Object ... paths) {
            return this.setFrom(owner, resolver, patternSetFactory, taskDependencyFactory, propertyHost, paths);
        }

        @Override
        @javax.annotation.Nullable
        public List<Object> replace(FileCollectionInternal original, Supplier<FileCollectionInternal> supplier) {
            return null;
        }
    }

    private static interface ValueCollector {
        public void collectSource(Collection<Object> var1);

        public void visitContents(Consumer<FileCollectionInternal> var1);

        public boolean remove(Object var1);

        public ValueCollector setFrom(DefaultConfigurableFileCollection var1, PathToFileResolver var2, Factory<PatternSet> var3, TaskDependencyFactory var4, PropertyHost var5, Iterable<?> var6);

        public ValueCollector setFrom(DefaultConfigurableFileCollection var1, PathToFileResolver var2, Factory<PatternSet> var3, TaskDependencyFactory var4, PropertyHost var5, Object[] var6);

        public ValueCollector plus(DefaultConfigurableFileCollection var1, PathToFileResolver var2, Factory<PatternSet> var3, TaskDependencyFactory var4, PropertyHost var5, Object ... var6);

        @javax.annotation.Nullable
        public List<Object> replace(FileCollectionInternal var1, Supplier<FileCollectionInternal> var2);
    }
}

