/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal.transformers;

import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.Problem;
import org.gradle.api.problems.internal.ProblemTransformer;
import org.gradle.problems.Location;
import org.gradle.problems.ProblemDiagnostics;
import org.gradle.problems.buildtree.ProblemStream;

public class StackLocationTransformer
implements ProblemTransformer {
    private final ProblemStream problemStream;

    public StackLocationTransformer(ProblemStream problemStream) {
        this.problemStream = problemStream;
    }

    public Problem transform(InternalProblem problem) {
        if (problem.getException() == null) {
            return problem;
        }
        ProblemDiagnostics problemDiagnostics = this.problemStream.forCurrentCaller((Throwable)problem.getException());
        Location loc = problemDiagnostics.getLocation();
        if (loc != null) {
            return problem.toBuilder().lineInFileLocation(loc.getSourceLongDisplayName().getDisplayName(), loc.getLineNumber()).build();
        }
        return problem;
    }
}

