/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.gradle.api.NonNullApi;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.GlobalCacheLocations;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.internal.Either;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.agents.AgentStatus;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.ClasspathFileTransformer;
import org.gradle.internal.classpath.ClasspathTransformerCacheFactory;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.classpath.CopyingClasspathFileTransformer;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.classpath.InstrumentingClasspathFileTransformer;
import org.gradle.internal.classpath.TransformedClassPath;
import org.gradle.internal.classpath.transforms.ClassTransform;
import org.gradle.internal.classpath.transforms.ClasspathElementTransformFactory;
import org.gradle.internal.classpath.transforms.ClasspathElementTransformFactoryForAgent;
import org.gradle.internal.classpath.transforms.ClasspathElementTransformFactoryForLegacy;
import org.gradle.internal.classpath.transforms.CompositeClassTransform;
import org.gradle.internal.classpath.transforms.InstrumentingClassTransform;
import org.gradle.internal.classpath.types.DefaultInstrumentingTypeRegistryFactory;
import org.gradle.internal.classpath.types.GradleCoreInstrumentingTypeRegistry;
import org.gradle.internal.classpath.types.InstrumentingTypeRegistry;
import org.gradle.internal.classpath.types.InstrumentingTypeRegistryFactory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.file.FileAccessTracker;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.classpath.ClasspathFingerprinter;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.vfs.FileSystemAccess;

public class DefaultCachedClasspathTransformer
implements CachedClasspathTransformer,
Closeable {
    private final PersistentCache cache;
    private final FileAccessTracker fileAccessTracker;
    private final ClasspathFingerprinter classpathFingerprinter;
    private final FileSystemAccess fileSystemAccess;
    private final GlobalCacheLocations globalCacheLocations;
    private final FileLockManager fileLockManager;
    private final AgentStatus agentStatus;
    private final ManagedExecutor executor;
    private final ParallelTransformExecutor parallelTransformExecutor;
    private final InstrumentingTypeRegistryFactory typeRegistryFactory;
    private final GradleCoreInstrumentingTypeRegistry gradleCoreInstrumentingRegistry;
    private final ClasspathElementTransformFactoryForAgent classpathElementTransformFactoryForAgent;
    private final ClasspathElementTransformFactoryForLegacy classpathElementTransformFactoryForLegacy;

    public DefaultCachedClasspathTransformer(GlobalScopedCacheBuilderFactory cacheBuilderFactory, ClasspathTransformerCacheFactory classpathTransformerCacheFactory, FileAccessTimeJournal fileAccessTimeJournal, ClasspathWalker classpathWalker, ClasspathFingerprinter classpathFingerprinter, FileSystemAccess fileSystemAccess, ExecutorFactory executorFactory, GlobalCacheLocations globalCacheLocations, FileLockManager fileLockManager, AgentStatus agentStatus, GradleCoreInstrumentingTypeRegistry gradleCoreInstrumentingRegistry, ClasspathElementTransformFactoryForAgent classpathElementTransformFactoryForAgent, ClasspathElementTransformFactoryForLegacy classpathElementTransformFactoryForLegacy) {
        this.classpathFingerprinter = classpathFingerprinter;
        this.fileSystemAccess = fileSystemAccess;
        this.globalCacheLocations = globalCacheLocations;
        this.fileLockManager = fileLockManager;
        this.agentStatus = agentStatus;
        this.cache = classpathTransformerCacheFactory.createCache(cacheBuilderFactory, fileAccessTimeJournal);
        this.fileAccessTracker = classpathTransformerCacheFactory.createFileAccessTracker(this.cache, fileAccessTimeJournal);
        this.executor = executorFactory.create("jar transforms", Runtime.getRuntime().availableProcessors());
        this.parallelTransformExecutor = new ParallelTransformExecutor(this.cache, this.executor);
        this.gradleCoreInstrumentingRegistry = gradleCoreInstrumentingRegistry;
        this.typeRegistryFactory = new DefaultInstrumentingTypeRegistryFactory(gradleCoreInstrumentingRegistry, this.cache, this.parallelTransformExecutor, classpathWalker, fileSystemAccess);
        this.classpathElementTransformFactoryForAgent = classpathElementTransformFactoryForAgent;
        this.classpathElementTransformFactoryForLegacy = classpathElementTransformFactoryForLegacy;
    }

    @Override
    public void close() {
        CompositeStoppable.stoppable((Object[])new Object[]{this.executor, this.cache}).stop();
    }

    @Override
    public ClassPath transform(ClassPath classPath, CachedClasspathTransformer.StandardTransform transform) {
        if (classPath.isEmpty()) {
            return classPath;
        }
        return this.transformPipelineFor(transform).transform(classPath);
    }

    private TransformPipeline transformPipelineFor(CachedClasspathTransformer.StandardTransform transform) {
        switch (transform) {
            case None: {
                return this.copyingPipeline();
            }
            case BuildLogic: {
                if (!this.agentStatus.isAgentInstrumentationEnabled()) {
                    return this.instrumentingPipeline(this.classpathElementTransformFactoryForLegacy);
                }
                return this.agentInstrumentingPipeline(this.copyingPipeline(), this.instrumentingPipeline(this.classpathElementTransformFactoryForAgent));
            }
        }
        throw new IllegalArgumentException();
    }

    private TransformPipeline copyingPipeline() {
        return cp -> this.transformFiles(cp, new CopyingClasspathFileTransformer(this.globalCacheLocations));
    }

    private TransformPipeline instrumentingPipeline(ClasspathElementTransformFactory classpathElementTransformFactory) {
        return cp -> this.transformFiles(cp, this.instrumentingClasspathFileTransformerFor(classpathElementTransformFactory, new InstrumentingClassTransform()));
    }

    private TransformPipeline agentInstrumentingPipeline(TransformPipeline originalsPipeline, TransformPipeline transformedPipeline) {
        return classPath -> {
            ClassPath copiedClassPath = originalsPipeline.transform(classPath);
            ClassPath transformedClassPath = transformedPipeline.transform(classPath);
            List copiedOriginalJars = copiedClassPath.getAsFiles();
            List transformedJars = transformedClassPath.getAsFiles();
            int size = copiedOriginalJars.size();
            assert (size == transformedJars.size());
            TransformedClassPath.Builder result = TransformedClassPath.builderWithExactSize((int)size);
            for (int i = 0; i < size; ++i) {
                result.add((File)copiedOriginalJars.get(i), (File)transformedJars.get(i));
            }
            return result.build();
        };
    }

    @Override
    public ClassPath transform(ClassPath classPath, CachedClasspathTransformer.StandardTransform transform, ClassTransform additional) {
        if (classPath.isEmpty()) {
            return classPath;
        }
        return this.transformFiles(classPath, this.instrumentingClasspathFileTransformerFor(this.classpathElementTransformFactoryForLegacy, new CompositeClassTransform(additional, this.transformerFor(transform))));
    }

    public List<URL> transform(Collection<URL> urls, CachedClasspathTransformer.StandardTransform transform) {
        if (urls.isEmpty()) {
            return ImmutableList.of();
        }
        ClasspathFileTransformer transformer = this.fileTransformerFor(transform);
        InstrumentingTypeRegistry typeRegistry = this.typeRegistryFactory.createFor(urls, transformer);
        return this.parallelTransformExecutor.transformAll(urls, (url, seen) -> this.cachedURL((URL)url, transformer, seen, typeRegistry));
    }

    private ClassPath transformFiles(ClassPath classPath, ClasspathFileTransformer transformer) {
        InstrumentingTypeRegistry typeRegistry = this.typeRegistryFactory.createFor(classPath.getAsFiles(), transformer);
        return DefaultClassPath.of(this.parallelTransformExecutor.transformAll(classPath.getAsFiles(), (file, seen) -> this.cachedFile((File)file, transformer, seen, typeRegistry)));
    }

    private ClassTransform transformerFor(CachedClasspathTransformer.StandardTransform transform) {
        if (transform == CachedClasspathTransformer.StandardTransform.BuildLogic) {
            return new InstrumentingClassTransform();
        }
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private ClasspathFileTransformer fileTransformerFor(CachedClasspathTransformer.StandardTransform transform) {
        switch (transform) {
            case BuildLogic: {
                return this.instrumentingClasspathFileTransformerFor(this.classpathElementTransformFactoryForLegacy, new InstrumentingClassTransform());
            }
            case None: {
                return new CopyingClasspathFileTransformer(this.globalCacheLocations);
            }
        }
        throw new IllegalArgumentException();
    }

    private InstrumentingClasspathFileTransformer instrumentingClasspathFileTransformerFor(ClasspathElementTransformFactory classpathElementTransformFactory, ClassTransform transform) {
        return new InstrumentingClasspathFileTransformer(this.fileLockManager, locationSnapshot -> this.classpathFingerprinter.fingerprint((FileSystemSnapshot)locationSnapshot, null).getHash(), classpathElementTransformFactory, transform, this.gradleCoreInstrumentingRegistry);
    }

    private Optional<Either<URL, Callable<URL>>> cachedURL(URL original, ClasspathFileTransformer transformer, Set<HashCode> seen, InstrumentingTypeRegistry typeRegistry) {
        if (original.getProtocol().equals("file")) {
            return this.cachedFile(Convert.urlToFile(original), transformer, seen, typeRegistry).map(result -> (Either)result.fold(file -> Either.left((Object)Convert.fileToURL(file)), transform -> Either.right(() -> Convert.fileToURL((File)transform.call()))));
        }
        return Optional.of(Either.left((Object)original));
    }

    private Optional<Either<File, Callable<File>>> cachedFile(File original, ClasspathFileTransformer transformer, Set<HashCode> seen, InstrumentingTypeRegistry typeRegistry) {
        FileSystemLocationSnapshot snapshot = this.snapshotOf(original);
        if (snapshot.getType() == FileType.Missing) {
            return Optional.empty();
        }
        if (this.shouldUseFromCache(original)) {
            HashCode contentHash = snapshot.getHash();
            if (!seen.add(contentHash)) {
                return Optional.empty();
            }
            return Optional.of(Either.right(() -> this.transformFile(original, snapshot, transformer, typeRegistry)));
        }
        return Optional.of(Either.left((Object)original));
    }

    private File transformFile(File original, FileSystemLocationSnapshot snapshot, ClasspathFileTransformer transformer, InstrumentingTypeRegistry typeRegistry) {
        File result = transformer.transform(original, snapshot, this.cache.getBaseDir(), typeRegistry);
        this.markAccessed(result, original);
        return result;
    }

    private FileSystemLocationSnapshot snapshotOf(File file) {
        return this.fileSystemAccess.read(file.getAbsolutePath());
    }

    private boolean shouldUseFromCache(File original) {
        return !original.toPath().startsWith(this.cache.getBaseDir().toPath());
    }

    private void markAccessed(File result, File original) {
        if (!result.equals(original)) {
            this.fileAccessTracker.markAccessed(result);
        }
    }

    public static class Convert {
        public static File urlToFile(URL original) {
            return new File((URI)UncheckedException.unchecked(original::toURI));
        }

        public static URL fileToURL(File file) {
            return (URL)UncheckedException.unchecked(file.toURI()::toURL);
        }
    }

    @NonNullApi
    public static class ParallelTransformExecutor {
        private final PersistentCache cache;
        private final ManagedExecutor executor;

        public ParallelTransformExecutor(PersistentCache cache, ManagedExecutor executor) {
            this.cache = cache;
            this.executor = executor;
        }

        public <T, U> List<U> transformAll(Collection<T> inputs, ValueOrTransformProvider<T, U> valueOrTransformProvider) {
            assert (!inputs.isEmpty());
            return (List)this.cache.useCache(() -> {
                ArrayList results = new ArrayList(inputs.size());
                ArrayList transforms = new ArrayList(inputs.size());
                HashSet<HashCode> seen = new HashSet<HashCode>();
                for (Object input : inputs) {
                    valueOrTransformProvider.apply(input, seen).ifPresent(valueOrTransform -> valueOrTransform.apply(value -> results.add(value), transform -> {
                        int index = results.size();
                        results.add(null);
                        transforms.add(() -> {
                            results.set(index, UncheckedException.unchecked((Callable)transform));
                            return null;
                        });
                    }));
                }
                for (Future result : (List)UncheckedException.unchecked(() -> this.executor.invokeAll((Collection)transforms))) {
                    UncheckedException.unchecked(result::get);
                }
                return results;
            });
        }
    }

    @FunctionalInterface
    public static interface ValueOrTransformProvider<T, U> {
        public Optional<Either<U, Callable<U>>> apply(T var1, Set<HashCode> var2);
    }

    @FunctionalInterface
    private static interface TransformPipeline {
        public ClassPath transform(ClassPath var1);
    }
}

