/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSortedMap;
import java.time.Duration;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkInputListeners;
import org.gradle.internal.execution.history.impl.DefaultExecutionOutputState;
import org.gradle.internal.execution.steps.AbstractSkipEmptyWorkStep;
import org.gradle.internal.execution.steps.CachingResult;
import org.gradle.internal.execution.steps.PreviousExecutionContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.ValueSnapshot;

public class SkipEmptyNonIncrementalWorkStep
extends AbstractSkipEmptyWorkStep<PreviousExecutionContext> {
    private final UniqueId buildInvocationScopeId;

    public SkipEmptyNonIncrementalWorkStep(UniqueId buildInvocationScopeId, WorkInputListeners workInputListeners, Step<? super PreviousExecutionContext, ? extends CachingResult> delegate) {
        super(workInputListeners, delegate);
        this.buildInvocationScopeId = buildInvocationScopeId;
    }

    @Override
    protected PreviousExecutionContext recreateContextWithNewInputFiles(PreviousExecutionContext context, final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFiles) {
        return new PreviousExecutionContext(context){

            @Override
            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFileProperties() {
                return inputFiles;
            }
        };
    }

    @Override
    protected ImmutableSortedMap<String, ValueSnapshot> getKnownInputProperties(PreviousExecutionContext context) {
        return ImmutableSortedMap.of();
    }

    @Override
    protected ImmutableSortedMap<String, ? extends FileCollectionFingerprint> getKnownInputFileProperties(PreviousExecutionContext context) {
        return ImmutableSortedMap.of();
    }

    @Override
    protected CachingResult performSkip(UnitOfWork work, PreviousExecutionContext context) {
        OriginMetadata originMetadata = new OriginMetadata(this.buildInvocationScopeId.asString(), Duration.ZERO);
        DefaultExecutionOutputState emptyOutputState = new DefaultExecutionOutputState(true, (ImmutableSortedMap<String, FileSystemSnapshot>)ImmutableSortedMap.of(), originMetadata, false);
        return CachingResult.shortcutResult(Duration.ZERO, ExecutionEngine.Execution.skipped(ExecutionEngine.ExecutionOutcome.SHORT_CIRCUITED, work), emptyOutputState, null, null);
    }
}

