/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.io.Closeable;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.IoActions;
import org.gradle.util.internal.CollectionUtils;

public class TaskStatistics
implements Closeable {
    private static final Logger LOGGER = Logging.getLogger(TaskStatistics.class);
    private static final String TASK_STATISTICS_PROPERTY = "org.gradle.internal.tasks.stats";
    private final AtomicInteger eagerTasks = new AtomicInteger();
    private final AtomicInteger lazyTasks = new AtomicInteger();
    private final AtomicInteger lazyRealizedTasks = new AtomicInteger();
    private final Map<Class, Integer> typeCounts = new HashMap<Class, Integer>();
    private final Map<Class, Integer> realizedTypeCounts = new HashMap<Class, Integer>();
    private final boolean collectStatistics;
    private PrintWriter lazyTaskLog;

    public TaskStatistics() {
        String taskStatistics = System.getProperty(TASK_STATISTICS_PROPERTY);
        if (taskStatistics != null) {
            this.collectStatistics = true;
            if (!taskStatistics.isEmpty()) {
                try {
                    this.lazyTaskLog = new PrintWriter(new FileWriter(taskStatistics));
                }
                catch (IOException iOException) {}
            }
        } else {
            this.collectStatistics = false;
        }
    }

    public boolean isCollecting() {
        return this.collectStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eagerTask(Class<?> type) {
        if (this.collectStatistics) {
            this.eagerTasks.incrementAndGet();
            Map<Class, Integer> map = this.typeCounts;
            synchronized (map) {
                Integer count = this.typeCounts.get(type);
                count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                this.typeCounts.put(type, count);
            }
        }
    }

    public void lazyTask() {
        if (this.collectStatistics) {
            this.lazyTasks.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lazyTaskRealized(Class<?> type) {
        if (this.collectStatistics) {
            this.lazyRealizedTasks.incrementAndGet();
            Map<Class, Integer> map = this.realizedTypeCounts;
            synchronized (map) {
                Integer count = this.realizedTypeCounts.get(type);
                count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                this.realizedTypeCounts.put(type, count);
            }
            if (this.lazyTaskLog != null) {
                new Throwable().printStackTrace(this.lazyTaskLog);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.collectStatistics) {
            int eagerTaskCount = this.eagerTasks.getAndSet(0);
            int lazyTaskCount = this.lazyTasks.getAndSet(0);
            int lazyTaskCreatedCount = this.lazyRealizedTasks.getAndSet(0);
            int totalTaskCount = eagerTaskCount + lazyTaskCount;
            LOGGER.lifecycle("Task counts: Old API {}, New API {}, total {}", new Object[]{eagerTaskCount, lazyTaskCount, totalTaskCount});
            int createdTaskCount = lazyTaskCreatedCount + eagerTaskCount;
            LOGGER.lifecycle("Task counts: created {}, avoided {}, %-lazy {}", new Object[]{createdTaskCount, lazyTaskCount - lazyTaskCreatedCount, 100 - 100 * createdTaskCount / totalTaskCount});
            this.printTypeCounts("\nTask types that were created with the old API", this.typeCounts);
            this.printTypeCounts("\nTask types that were registered with the new API but were created anyways", this.realizedTypeCounts);
            IoActions.closeQuietly((Closeable)this.lazyTaskLog);
        }
    }

    private void printTypeCounts(String header, Map<Class, Integer> typeCounts) {
        if (!typeCounts.isEmpty()) {
            LOGGER.lifecycle(header);
            List sorted = CollectionUtils.sort(typeCounts.entrySet(), (Comparator)new Comparator<Map.Entry<Class, Integer>>(){

                @Override
                public int compare(Map.Entry<Class, Integer> a, Map.Entry<Class, Integer> b) {
                    return b.getValue().compareTo(a.getValue());
                }
            });
            for (Map.Entry typeCount : sorted) {
                LOGGER.lifecycle(typeCount.getKey() + " " + typeCount.getValue());
            }
        }
    }
}

