/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.LoggingContext;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhaseKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsLoweringPhasesKt;
import org.jetbrains.kotlin.ir.backend.js.dce.DceDumpNameCache;
import org.jetbrains.kotlin.ir.backend.js.dce.DceKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrIcClassModel;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrProgramFragment;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.js.backend.ast.JsClass;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.inline.clean.ClassPostProcessor;
import org.jetbrains.kotlin.js.inline.clean.FunctionPostProcessor;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a$\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"optimizeFragmentByJsAst", "", "fragment", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrProgramFragment;", "optimizeProgramByIr", "modules", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "removeUnusedAssociatedObjects", "", "backend.js"})
@SourceDebugExtension(value={"SMAP\noptimizations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 optimizations.kt\norg/jetbrains/kotlin/ir/backend/js/OptimizationsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1855#2,2:50\n1855#2:52\n1855#2,2:53\n1855#2,2:55\n1856#2:57\n*S KotlinDebug\n*F\n+ 1 optimizations.kt\norg/jetbrains/kotlin/ir/backend/js/OptimizationsKt\n*L\n43#1:50,2\n44#1:52\n45#1:53,2\n46#1:55,2\n44#1:57\n*E\n"})
public final class OptimizationsKt {
    public static final void optimizeProgramByIr(@NotNull Iterable<? extends IrModuleFragment> modules2, @NotNull JsIrBackendContext context2, boolean removeUnusedAssociatedObjects) {
        Intrinsics.checkNotNullParameter(modules2, (String)"modules");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        DceDumpNameCache dceDumpNameCache = new DceDumpNameCache();
        DceKt.eliminateDeadDeclarations(modules2, context2, removeUnusedAssociatedObjects, dceDumpNameCache);
        CompilerPhaseKt.invokeToplevel((CompilerPhase)JsLoweringPhasesKt.getJsOptimizationPhases(), new PhaseConfig(JsLoweringPhasesKt.getJsOptimizationPhases(), null, null, null, null, null, null, null, null, null, false, false, false, 8190, null), (LoggingContext)context2, modules2);
    }

    public static final void optimizeFragmentByJsAst(@NotNull JsIrProgramFragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        RecursiveJsVisitor optimizer2 = new RecursiveJsVisitor(){

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                super.visitFunction(x);
                new FunctionPostProcessor(x).apply();
            }

            public void visitClass(@NotNull JsClass x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                super.visitClass(x);
                new ClassPostProcessor(x).apply();
            }
        };
        List<JsStatement> list2 = fragment.getDeclarations().getStatements();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getStatements(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsStatement it = (JsStatement)element$iv;
            boolean bl = false;
            it.accept(optimizer2);
        }
        $this$forEach$iv = fragment.getClasses().values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsStatement it;
            JsIrIcClassModel klass = (JsIrIcClassModel)element$iv;
            boolean bl = false;
            List<JsStatement> list3 = klass.getPostDeclarationBlock().getStatements();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getStatements(...)");
            Iterable $this$forEach$iv2 = list3;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (JsStatement)element$iv2;
                boolean bl2 = false;
                it.accept(optimizer2);
            }
            List<JsStatement> list4 = klass.getPreDeclarationBlock().getStatements();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"getStatements(...)");
            $this$forEach$iv2 = list4;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (JsStatement)element$iv2;
                boolean bl3 = false;
                it.accept(optimizer2);
            }
        }
    }
}

