/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialization;

import java.io.Serializable;
import javax.annotation.Nullable;

public abstract class Transient<T>
implements Serializable {
    private static final Transient<Object> DISCARDED = new Discarded<Object>();

    public static <T> Transient<T> of(T value) {
        return new ImmutableTransient<T>(value);
    }

    public static <T> Var<T> varOf() {
        return Transient.varOf(null);
    }

    public static <T> Var<T> varOf(@Nullable T value) {
        return new MutableTransient<T>(value);
    }

    @Nullable
    public abstract T get();

    public boolean isPresent() {
        return true;
    }

    private static class Discarded<T>
    extends Var<T> {
        private Discarded() {
        }

        @Override
        public void set(T value) {
            throw new IllegalStateException("The value of this property cannot be set after it has been discarded during serialization.");
        }

        @Override
        public T get() {
            throw new IllegalStateException("The value of this property has been discarded during serialization.");
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        private Object readResolve() {
            return DISCARDED;
        }
    }

    private static class MutableTransient<T>
    extends Var<T> {
        @Nullable
        private T value;

        public MutableTransient(@Nullable T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public void set(T value) {
            this.value = value;
        }

        private Object writeReplace() {
            return DISCARDED;
        }
    }

    private static class ImmutableTransient<T>
    extends Transient<T> {
        private final T value;

        public ImmutableTransient(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }

        private Object writeReplace() {
            return DISCARDED;
        }
    }

    public static abstract class Var<T>
    extends Transient<T> {
        public abstract void set(T var1);
    }
}

