; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-macosx | FileCheck %s

define i32 @test_01(ptr %p, i64 %len, i32 %x) {
; CHECK-LABEL: test_01:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    .p2align 4
; CHECK-NEXT:  LBB0_1: ## %loop
; CHECK-NEXT:    ## =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    subq $1, %rsi
; CHECK-NEXT:    jb LBB0_4
; CHECK-NEXT:  ## %bb.2: ## %backedge
; CHECK-NEXT:    ## in Loop: Header=BB0_1 Depth=1
; CHECK-NEXT:    cmpl %edx, (%rdi,%rsi,4)
; CHECK-NEXT:    jne LBB0_1
; CHECK-NEXT:  ## %bb.3: ## %failure
; CHECK-NEXT:    ud2
; CHECK-NEXT:  LBB0_4: ## %exit
; CHECK-NEXT:    movl $-1, %eax
; CHECK-NEXT:    retq
entry:
  br label %loop

loop:                                             ; preds = %backedge, %entry
  %iv = phi i64 [ %iv.next, %backedge ], [ %len, %entry ]
  %iv.next = add nsw i64 %iv, -1
  %cond_1 = icmp eq i64 %iv, 0
  br i1 %cond_1, label %exit, label %backedge

backedge:                                         ; preds = %loop
  %addr = getelementptr inbounds i32, ptr %p, i64 %iv.next
  %loaded = load atomic i32, ptr %addr unordered, align 4
  %cond_2 = icmp eq i32 %loaded, %x
  br i1 %cond_2, label %failure, label %loop

exit:                                             ; preds = %loop
  ret i32 -1

failure:                                          ; preds = %backedge
  unreachable
}

; Similar to test_01, but we use offsetted pointer as base.
define i32 @test_01a(ptr %p, i64 %len, i32 %x) {
; CHECK-LABEL: test_01a:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    .p2align 4
; CHECK-NEXT:  LBB1_1: ## %loop
; CHECK-NEXT:    ## =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    subq $1, %rsi
; CHECK-NEXT:    jb LBB1_4
; CHECK-NEXT:  ## %bb.2: ## %backedge
; CHECK-NEXT:    ## in Loop: Header=BB1_1 Depth=1
; CHECK-NEXT:    cmpl %edx, -24(%rdi,%rsi,4)
; CHECK-NEXT:    jne LBB1_1
; CHECK-NEXT:  ## %bb.3: ## %failure
; CHECK-NEXT:    ud2
; CHECK-NEXT:  LBB1_4: ## %exit
; CHECK-NEXT:    movl $-1, %eax
; CHECK-NEXT:    retq
entry:
  %base = getelementptr inbounds i32, ptr %p, i64 -6
  br label %loop

loop:                                             ; preds = %backedge, %entry
  %iv = phi i64 [ %iv.next, %backedge ], [ %len, %entry ]
  %iv.next = add nsw i64 %iv, -1
  %cond_1 = icmp eq i64 %iv, 0
  br i1 %cond_1, label %exit, label %backedge

backedge:                                         ; preds = %loop
  %addr = getelementptr inbounds i32, ptr %base, i64 %iv.next
  %loaded = load atomic i32, ptr %addr unordered, align 4
  %cond_2 = icmp eq i32 %loaded, %x
  br i1 %cond_2, label %failure, label %loop

exit:                                             ; preds = %loop
  ret i32 -1

failure:                                          ; preds = %backedge
  unreachable
}

define i32 @test_02(ptr %p, i64 %len, i32 %x) {
; CHECK-LABEL: test_02:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    .p2align 4
; CHECK-NEXT:  LBB2_1: ## %loop
; CHECK-NEXT:    ## =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    subq $1, %rsi
; CHECK-NEXT:    jb LBB2_4
; CHECK-NEXT:  ## %bb.2: ## %backedge
; CHECK-NEXT:    ## in Loop: Header=BB2_1 Depth=1
; CHECK-NEXT:    cmpl %edx, (%rdi,%rsi,4)
; CHECK-NEXT:    jne LBB2_1
; CHECK-NEXT:  ## %bb.3: ## %failure
; CHECK-NEXT:    ud2
; CHECK-NEXT:  LBB2_4: ## %exit
; CHECK-NEXT:    movl $-1, %eax
; CHECK-NEXT:    retq
entry:
  %start = add i64 %len, -1
  br label %loop

loop:                                             ; preds = %backedge, %entry
  %iv = phi i64 [ %iv.next, %backedge ], [ %start, %entry ]
  %iv.next = add nsw i64 %iv, -1
  %iv.offset = add i64 %iv, 1
  %iv.next.offset = add i64 %iv.next, 1
  %cond_1 = icmp eq i64 %iv.offset, 0
  br i1 %cond_1, label %exit, label %backedge

backedge:                                         ; preds = %loop
  %addr = getelementptr inbounds i32, ptr %p, i64 %iv.next.offset
  %loaded = load atomic i32, ptr %addr unordered, align 4
  %cond_2 = icmp eq i32 %loaded, %x
  br i1 %cond_2, label %failure, label %loop

exit:                                             ; preds = %loop
  ret i32 -1

failure:                                          ; preds = %backedge
  unreachable
}

define i32 @test_03(ptr %p, i64 %len, i32 %x) {
; CHECK-LABEL: test_03:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    .p2align 4
; CHECK-NEXT:  LBB3_1: ## %loop
; CHECK-NEXT:    ## =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    subq $1, %rsi
; CHECK-NEXT:    jb LBB3_4
; CHECK-NEXT:  ## %bb.2: ## %backedge
; CHECK-NEXT:    ## in Loop: Header=BB3_1 Depth=1
; CHECK-NEXT:    cmpl %edx, (%rdi,%rsi,4)
; CHECK-NEXT:    jne LBB3_1
; CHECK-NEXT:  ## %bb.3: ## %failure
; CHECK-NEXT:    ud2
; CHECK-NEXT:  LBB3_4: ## %exit
; CHECK-NEXT:    movl $-1, %eax
; CHECK-NEXT:    retq
entry:
  %start = add i64 %len, -100
  br label %loop

loop:                                             ; preds = %backedge, %entry
  %iv = phi i64 [ %iv.next, %backedge ], [ %start, %entry ]
  %iv.next = add nsw i64 %iv, -1
  %iv.offset = add i64 %iv, 100
  %iv.next.offset = add i64 %iv.next, 100
  %cond_1 = icmp eq i64 %iv.offset, 0
  br i1 %cond_1, label %exit, label %backedge

backedge:                                         ; preds = %loop
  %addr = getelementptr inbounds i32, ptr %p, i64 %iv.next.offset
  %loaded = load atomic i32, ptr %addr unordered, align 4
  %cond_2 = icmp eq i32 %loaded, %x
  br i1 %cond_2, label %failure, label %loop

exit:                                             ; preds = %loop
  ret i32 -1

failure:                                          ; preds = %backedge
  unreachable
}

define void @test_04(i32 %arg) {
; CHECK-LABEL: test_04:
; CHECK:       ## %bb.0: ## %bb
; CHECK-NEXT:    ud2
bb:
  br label %bb1

bb1:                                              ; preds = %bb10, %bb
  %tmp = phi i64 [ 1, %bb ], [ %tmp2, %bb10 ]
  %tmp2 = add nuw nsw i64 %tmp, 1
  br i1 poison, label %bb21, label %bb7

bb7:                                              ; preds = %bb1
  %tmp8 = add nsw i64 %tmp, -1
  %tmp9 = getelementptr inbounds i32, ptr addrspace(1) undef, i64 %tmp8
  store atomic i32 undef, ptr addrspace(1) %tmp9 unordered, align 4
  br label %bb11

bb10:                                             ; preds = %bb16
  br label %bb1

bb11:                                             ; preds = %bb16, %bb7
  switch i32 %arg, label %bb19 [
    i32 0, label %bb17
    i32 1, label %bb16
    i32 2, label %bb15
    i32 3, label %bb14
    i32 4, label %bb12
  ]

bb12:                                             ; preds = %bb11
  unreachable

bb14:                                             ; preds = %bb11
  unreachable

bb15:                                             ; preds = %bb11
  unreachable

bb16:                                             ; preds = %bb11
  br i1 poison, label %bb10, label %bb11

bb17:                                             ; preds = %bb11
  unreachable

bb19:                                             ; preds = %bb11
  unreachable

bb21:                                             ; preds = %bb1
  unreachable
}
