/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.DefaultExclude;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ivy.IvyDependencyDescriptor;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;

public class IvyModuleDescriptorConverter {
    private static final String CLASSIFIER = "classifier";
    private static final Field DEPENDENCY_CONFIG_FIELD;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    public IvyModuleDescriptorConverter(ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    public Map<NamespaceId, String> extractExtraAttributes(ModuleDescriptor ivyDescriptor) {
        Map extraInfo = ivyDescriptor.getExtraInfo();
        return extraInfo.entrySet().stream().collect(Collectors.toMap(e -> NamespaceId.decode((String)e.getKey()), Map.Entry::getValue));
    }

    public List<Exclude> extractExcludes(ModuleDescriptor ivyDescriptor) {
        ArrayList<Exclude> result = new ArrayList<Exclude>(ivyDescriptor.getAllExcludeRules().length);
        for (ExcludeRule excludeRule : ivyDescriptor.getAllExcludeRules()) {
            result.add(this.forIvyExclude(excludeRule));
        }
        return result;
    }

    public List<IvyDependencyDescriptor> extractDependencies(ModuleDescriptor ivyDescriptor) {
        ArrayList<IvyDependencyDescriptor> result = new ArrayList<IvyDependencyDescriptor>(ivyDescriptor.getDependencies().length);
        for (DependencyDescriptor dependencyDescriptor : ivyDescriptor.getDependencies()) {
            this.addDependency(result, dependencyDescriptor);
        }
        return result;
    }

    public List<org.gradle.internal.component.external.descriptor.Configuration> extractConfigurations(ModuleDescriptor ivyDescriptor) {
        ArrayList<org.gradle.internal.component.external.descriptor.Configuration> result = new ArrayList<org.gradle.internal.component.external.descriptor.Configuration>(ivyDescriptor.getConfigurations().length);
        for (Configuration ivyConfiguration : ivyDescriptor.getConfigurations()) {
            IvyModuleDescriptorConverter.addConfiguration(result, ivyConfiguration);
        }
        return result;
    }

    private static void addConfiguration(List<org.gradle.internal.component.external.descriptor.Configuration> result, Configuration configuration) {
        String name = configuration.getName();
        boolean transitive = configuration.isTransitive();
        boolean visible = configuration.getVisibility() == Configuration.Visibility.PUBLIC;
        ArrayList extendsFrom = Lists.newArrayList((Object[])configuration.getExtends());
        result.add(new org.gradle.internal.component.external.descriptor.Configuration(name, transitive, visible, extendsFrom));
    }

    private void addDependency(List<IvyDependencyDescriptor> result, DependencyDescriptor dependencyDescriptor) {
        ModuleRevisionId revisionId = dependencyDescriptor.getDependencyRevisionId();
        ModuleComponentSelector requested = DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(revisionId.getOrganisation(), revisionId.getName()), new DefaultImmutableVersionConstraint(revisionId.getRevision()));
        ArrayListMultimap configMappings = ArrayListMultimap.create();
        for (Map.Entry<String, List<String>> entry : IvyModuleDescriptorConverter.readConfigMappings(dependencyDescriptor).entrySet()) {
            configMappings.putAll((Object)entry.getKey(), (Iterable)entry.getValue());
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (DependencyArtifactDescriptor ivyArtifact : dependencyDescriptor.getAllDependencyArtifacts()) {
            DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(ivyArtifact.getName(), ivyArtifact.getType(), ivyArtifact.getExt(), (String)ivyArtifact.getExtraAttributes().get(CLASSIFIER));
            artifacts.add(new Artifact(ivyArtifactName, Sets.newHashSet((Object[])ivyArtifact.getConfigurations())));
        }
        ArrayList<Exclude> arrayList = new ArrayList<Exclude>();
        for (ExcludeRule excludeRule : dependencyDescriptor.getAllExcludeRules()) {
            arrayList.add(this.forIvyExclude(excludeRule));
        }
        result.add(new IvyDependencyDescriptor(requested, dependencyDescriptor.getDynamicConstraintDependencyRevisionId().getRevision(), dependencyDescriptor.isChanging(), dependencyDescriptor.isTransitive(), false, (Multimap<String, String>)configMappings, artifacts, arrayList));
    }

    private Exclude forIvyExclude(ExcludeRule excludeRule) {
        ArtifactId id = excludeRule.getId();
        IvyArtifactName artifactExclusion = this.artifactForIvyExclude(id);
        return new DefaultExclude(this.moduleIdentifierFactory.module(id.getModuleId().getOrganisation(), id.getModuleId().getName()), artifactExclusion, excludeRule.getConfigurations(), excludeRule.getMatcher().getName());
    }

    private IvyArtifactName artifactForIvyExclude(ArtifactId id) {
        if ("*".equals(id.getName()) && "*".equals(id.getType()) && "*".equals(id.getExt())) {
            return null;
        }
        return new DefaultIvyArtifactName(id.getName(), id.getType(), id.getExt());
    }

    private static Map<String, List<String>> readConfigMappings(DependencyDescriptor dependencyDescriptor) {
        if (dependencyDescriptor instanceof DefaultDependencyDescriptor) {
            try {
                return (Map)DEPENDENCY_CONFIG_FIELD.get(dependencyDescriptor);
            }
            catch (IllegalAccessException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        String[] modConfs = dependencyDescriptor.getModuleConfigurations();
        LinkedHashMap<String, List<String>> results = new LinkedHashMap<String, List<String>>();
        for (String modConf : modConfs) {
            results.put(modConf, Arrays.asList(dependencyDescriptor.getDependencyConfigurations(modConfs)));
        }
        return results;
    }

    static {
        try {
            DEPENDENCY_CONFIG_FIELD = DefaultDependencyDescriptor.class.getDeclaredField("confs");
            DEPENDENCY_CONFIG_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

