/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.LinkedHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStage;
import org.jetbrains.kotlin.fir.resolve.calls.TypeArgumentMapping;
import org.jetbrains.kotlin.fir.resolve.inference.ConstraintSystemCompleterKt;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.inference.TypeParameterBasedTypeVariable;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariable;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/PostponedVariablesInitializerResolutionStage;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionStage;", "()V", "BUILDER_INFERENCE_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hasBuilderInferenceMarker", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "resolve"})
public final class PostponedVariablesInitializerResolutionStage
extends ResolutionStage {
    @NotNull
    public static final PostponedVariablesInitializerResolutionStage INSTANCE = new PostponedVariablesInitializerResolutionStage();
    @NotNull
    private static final ClassId BUILDER_INFERENCE_CLASS_ID;

    private PostponedVariablesInitializerResolutionStage() {
    }

    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Continuation<? super Unit> $completion) {
        LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = candidate2.getArgumentMapping();
        if (linkedHashMap == null) {
            return Unit.INSTANCE;
        }
        LinkedHashMap<FirExpression, FirValueParameter> argumentMapping = linkedHashMap;
        if (candidate2.getTypeArgumentMapping() instanceof TypeArgumentMapping.Mapped) {
            return Unit.INSTANCE;
        }
        for (FirValueParameter parameter : argumentMapping.values()) {
            ConeKotlinType type2;
            Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
            if (!this.hasBuilderInferenceMarker(parameter)) continue;
            FirTypeRef $this$coneType$iv = parameter.getReturnTypeRef();
            boolean $i$f$getConeType = false;
            FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeUnsafe = false;
            if (((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType() == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            ConeKotlinType coneKotlinType = InferenceUtilsKt.receiverType(type2, callInfo.getSession());
            if (coneKotlinType == null) continue;
            ConeKotlinType receiverType = coneKotlinType;
            for (ConeTypeVariable freshVariable : candidate2.getFreshVariables()) {
                FirTypeParameterSymbol typeParameterSymbol;
                boolean typeHasVariable2;
                if (ConstraintSystemCompleterKt.getCsBuilder(candidate2).isPostponedTypeVariable(freshVariable) || !(freshVariable instanceof TypeParameterBasedTypeVariable) || !(typeHasVariable2 = ConeTypeUtilsKt.contains(receiverType, (Function1<? super ConeKotlinType, Boolean>)((Function1)new Function1<ConeKotlinType, Boolean>(typeParameterSymbol = ((TypeParameterBasedTypeVariable)freshVariable).getTypeParameterSymbol()){
                    final /* synthetic */ FirTypeParameterSymbol $typeParameterSymbol;
                    {
                        this.$typeParameterSymbol = $typeParameterSymbol;
                        super(1);
                    }

                    public final boolean invoke(@NotNull ConeKotlinType it) {
                        ConeTypeParameterLookupTag coneTypeParameterLookupTag;
                        ConeTypeParameterType coneTypeParameterType;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ConeTypeParameterType coneTypeParameterType2 = coneTypeParameterType = it instanceof ConeTypeParameterType ? (ConeTypeParameterType)it : null;
                        return Intrinsics.areEqual(coneTypeParameterType == null ? null : ((coneTypeParameterLookupTag = coneTypeParameterType.getLookupTag()) == null ? null : coneTypeParameterLookupTag.getTypeParameterSymbol()), (Object)this.$typeParameterSymbol);
                    }
                })))) continue;
                ConstraintSystemCompleterKt.getCsBuilder(candidate2).markPostponedVariable(freshVariable);
            }
        }
        return Unit.INSTANCE;
    }

    private final boolean hasBuilderInferenceMarker(FirValueParameter $this$hasBuilderInferenceMarker) {
        return FirAnnotationUtilsKt.hasAnnotation($this$hasBuilderInferenceMarker, BUILDER_INFERENCE_CLASS_ID);
    }

    static {
        ClassId classId = ClassId.fromString("kotlin/BuilderInference");
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"fromString(\"kotlin/BuilderInference\")");
        BUILDER_INFERENCE_CLASS_ID = classId;
    }
}

