/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import java.util.function.BiFunction;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultGroovySourceSet;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmEcosystemUtilities;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.GroovyRuntime;
import org.gradle.api.tasks.GroovySourceDirectorySet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.javadoc.Groovydoc;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;

public class GroovyBasePlugin
implements Plugin<Project> {
    public static final String GROOVY_RUNTIME_EXTENSION_NAME = "groovyRuntime";
    private final ObjectFactory objectFactory;
    private final ModuleRegistry moduleRegistry;
    private final JvmPluginServices jvmPluginServices;
    private Project project;
    private GroovyRuntime groovyRuntime;

    @Inject
    public GroovyBasePlugin(ObjectFactory objectFactory, ModuleRegistry moduleRegistry, JvmEcosystemUtilities jvmPluginServices) {
        this.objectFactory = objectFactory;
        this.moduleRegistry = moduleRegistry;
        this.jvmPluginServices = (JvmPluginServices)jvmPluginServices;
    }

    public void apply(Project project) {
        this.project = project;
        project.getPluginManager().apply(JavaBasePlugin.class);
        this.configureGroovyRuntimeExtension();
        this.configureCompileDefaults();
        this.configureSourceSetDefaults();
        this.configureGroovydoc();
    }

    private void configureGroovyRuntimeExtension() {
        this.groovyRuntime = (GroovyRuntime)this.project.getExtensions().create(GROOVY_RUNTIME_EXTENSION_NAME, GroovyRuntime.class, new Object[]{this.project});
    }

    private void configureCompileDefaults() {
        this.project.getTasks().withType(GroovyCompile.class).configureEach(compile -> compile.getConventionMapping().map("groovyClasspath", () -> this.groovyRuntime.inferGroovyClasspath((Iterable<File>)compile.getClasspath())));
    }

    private void configureSourceSetDefaults() {
        ((JavaPluginExtension)this.project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().all(sourceSet -> {
            DefaultGroovySourceSet groovySourceSet = new DefaultGroovySourceSet("groovy", ((DefaultSourceSet)sourceSet).getDisplayName(), this.objectFactory);
            new DslObject(sourceSet).getConvention().getPlugins().put("groovy", groovySourceSet);
            sourceSet.getExtensions().add(GroovySourceDirectorySet.class, "groovy", (Object)groovySourceSet.getGroovy());
            GroovySourceDirectorySet groovySource = groovySourceSet.getGroovy();
            groovySource.srcDir("src/" + sourceSet.getName() + "/groovy");
            GroovySourceDirectorySet groovySourceFiles = groovySource;
            sourceSet.getResources().getFilter().exclude(SerializableLambdas.spec(arg_0 -> GroovyBasePlugin.lambda$configureSourceSetDefaults$c5b9db87$1((FileCollection)groovySourceFiles, arg_0)));
            sourceSet.getAllJava().source((SourceDirectorySet)groovySource);
            sourceSet.getAllSource().source((SourceDirectorySet)groovySource);
            TaskProvider compileTask = this.project.getTasks().register(sourceSet.getCompileTaskName("groovy"), GroovyCompile.class, compile -> {
                JvmPluginsHelper.configureForSourceSet(sourceSet, groovySource, (AbstractCompile)compile, compile.getOptions(), this.project);
                compile.setDescription("Compiles the " + sourceSet.getName() + " Groovy source.");
                compile.setSource((FileTree)groovySource);
                compile.getJavaLauncher().convention(this.getToolchainTool(this.project, JavaToolchainService::launcherFor));
            });
            JvmPluginsHelper.configureOutputDirectoryForSourceSet(sourceSet, (SourceDirectorySet)groovySource, this.project, (TaskProvider<? extends AbstractCompile>)compileTask, (Provider<CompileOptions>)compileTask.map(GroovyCompile::getOptions));
            this.jvmPluginServices.useDefaultTargetPlatformInference(this.project.getConfigurations().getByName(sourceSet.getCompileClasspathConfigurationName()), compileTask);
            this.jvmPluginServices.useDefaultTargetPlatformInference(this.project.getConfigurations().getByName(sourceSet.getRuntimeClasspathConfigurationName()), compileTask);
            this.project.getTasks().named(sourceSet.getClassesTaskName(), task -> task.dependsOn(new Object[]{compileTask}));
            this.project.getConfigurations().getByName(sourceSet.getCompileClasspathConfigurationName()).attributes(attrs -> attrs.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)this.project.getObjects().named(LibraryElements.class, "classes+resources"))));
        });
    }

    private void configureGroovydoc() {
        this.project.getTasks().withType(Groovydoc.class).configureEach(groovydoc -> {
            groovydoc.getConventionMapping().map("groovyClasspath", () -> {
                FileCollection groovyClasspath = this.groovyRuntime.inferGroovyClasspath((Iterable<File>)groovydoc.getClasspath());
                ConfigurableFileCollection jansi = this.project.getObjects().fileCollection().from(new Object[]{this.moduleRegistry.getExternalModule("jansi").getImplementationClasspath().getAsFiles()});
                return groovyClasspath.plus((FileCollection)jansi);
            });
            groovydoc.getConventionMapping().map("destinationDir", () -> ((Directory)((JavaPluginExtension)this.project.getExtensions().getByType(JavaPluginExtension.class)).getDocsDir().dir("groovydoc").get()).getAsFile());
            groovydoc.getConventionMapping().map("docTitle", () -> ((ReportingExtension)this.project.getExtensions().getByType(ReportingExtension.class)).getApiDocTitle());
            groovydoc.getConventionMapping().map("windowTitle", () -> ((ReportingExtension)this.project.getExtensions().getByType(ReportingExtension.class)).getApiDocTitle());
        });
    }

    private <T> Provider<T> getToolchainTool(Project project, BiFunction<JavaToolchainService, JavaToolchainSpec, Provider<T>> toolMapper) {
        JavaPluginExtension extension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        JavaToolchainService service = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class);
        return toolMapper.apply(service, extension.getToolchain());
    }

    private static /* synthetic */ boolean lambda$configureSourceSetDefaults$c5b9db87$1(FileCollection groovySourceFiles, FileTreeElement element) {
        return groovySourceFiles.contains(element.getFile());
    }
}

