/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.composite;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.initialization.SettingsLoader;
import org.gradle.internal.build.BuildIncluder;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.composite.IncludedRootBuild;

public class ChildBuildRegisteringSettingsLoader
implements SettingsLoader {
    private final SettingsLoader delegate;
    private final BuildStateRegistry buildRegistry;
    private final BuildIncluder buildIncluder;

    public ChildBuildRegisteringSettingsLoader(SettingsLoader delegate, BuildStateRegistry buildRegistry, BuildIncluder buildIncluder) {
        this.delegate = delegate;
        this.buildRegistry = buildRegistry;
        this.buildIncluder = buildIncluder;
    }

    @Override
    public SettingsInternal findAndLoadSettings(GradleInternal gradle) {
        SettingsInternal settings = this.delegate.findAndLoadSettings(gradle);
        List<IncludedBuildSpec> includedBuilds = settings.getIncludedBuilds();
        if (!includedBuilds.isEmpty()) {
            LinkedHashSet<IncludedBuild> children = new LinkedHashSet<IncludedBuild>(includedBuilds.size());
            RootBuildState rootBuild = this.buildRegistry.getRootBuild();
            for (IncludedBuildSpec includedBuildSpec : includedBuilds) {
                if (!includedBuildSpec.rootDir.equals(rootBuild.getBuildRootDir())) {
                    IncludedBuildState includedBuild = this.buildIncluder.includeBuild(includedBuildSpec, gradle);
                    children.add(includedBuild.getModel());
                    continue;
                }
                this.buildRegistry.registerSubstitutionsForRootBuild();
                children.add(new IncludedRootBuild((CompositeBuildParticipantBuildState)((Object)this.buildRegistry.getRootBuild())));
            }
            gradle.setIncludedBuilds(children);
        } else {
            gradle.setIncludedBuilds(Collections.emptyList());
        }
        return settings;
    }
}

