/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.gradle.api.Describable;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformDependencies;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformListener;
import org.gradle.api.internal.artifacts.transform.CacheableInvocation;
import org.gradle.api.internal.artifacts.transform.TransformException;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.api.internal.artifacts.transform.TransformationWorkspaceServices;
import org.gradle.api.internal.artifacts.transform.Transformer;
import org.gradle.api.internal.artifacts.transform.TransformerInvocationFactory;
import org.gradle.api.internal.file.DefaultFileSystemLocation;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Try;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.execution.DeferredExecutionHandler;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingDisabledReasonCategory;
import org.gradle.internal.execution.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.execution.fingerprint.InputFingerprinter;
import org.gradle.internal.execution.fingerprint.impl.DefaultFileNormalizationSpec;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.workspace.WorkspaceProvider;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.internal.vfs.FileSystemAccess;
import org.gradle.work.InputChanges;

public class DefaultTransformerInvocationFactory
implements TransformerInvocationFactory {
    private static final CachingDisabledReason NOT_CACHEABLE = new CachingDisabledReason(CachingDisabledReasonCategory.NOT_CACHEABLE, "Caching not enabled.");
    private static final String INPUT_ARTIFACT_PROPERTY_NAME = "inputArtifact";
    private static final String INPUT_ARTIFACT_PATH_PROPERTY_NAME = "inputArtifactPath";
    private static final String INPUT_ARTIFACT_SNAPSHOT_PROPERTY_NAME = "inputArtifactSnapshot";
    private static final String DEPENDENCIES_PROPERTY_NAME = "inputArtifactDependencies";
    private static final String SECONDARY_INPUTS_HASH_PROPERTY_NAME = "inputPropertiesHash";
    private static final String OUTPUT_DIRECTORY_PROPERTY_NAME = "outputDirectory";
    private static final String RESULTS_FILE_PROPERTY_NAME = "resultsFile";
    private static final String INPUT_FILE_PATH_PREFIX = "i/";
    private static final String OUTPUT_FILE_PATH_PREFIX = "o/";
    private final ExecutionEngine executionEngine;
    private final FileSystemAccess fileSystemAccess;
    private final ArtifactTransformListener artifactTransformListener;
    private final TransformationWorkspaceServices immutableWorkspaceProvider;
    private final FileCollectionFactory fileCollectionFactory;
    private final ProjectStateRegistry projectStateRegistry;
    private final BuildOperationExecutor buildOperationExecutor;

    public DefaultTransformerInvocationFactory(ExecutionEngine executionEngine, FileSystemAccess fileSystemAccess, ArtifactTransformListener artifactTransformListener, TransformationWorkspaceServices immutableWorkspaceProvider, FileCollectionFactory fileCollectionFactory, ProjectStateRegistry projectStateRegistry, BuildOperationExecutor buildOperationExecutor) {
        this.executionEngine = executionEngine;
        this.fileSystemAccess = fileSystemAccess;
        this.artifactTransformListener = artifactTransformListener;
        this.immutableWorkspaceProvider = immutableWorkspaceProvider;
        this.fileCollectionFactory = fileCollectionFactory;
        this.projectStateRegistry = projectStateRegistry;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public CacheableInvocation<ImmutableList<File>> createInvocation(final Transformer transformer, File inputArtifact, ArtifactTransformDependencies dependencies, final TransformationSubject subject, InputFingerprinter inputFingerprinter) {
        ProjectInternal producerProject = this.determineProducerProject(subject);
        TransformationWorkspaceServices workspaceServices = this.determineWorkspaceServices(producerProject);
        final AbstractTransformerExecution execution = producerProject == null ? new ImmutableTransformerExecution(transformer, inputArtifact, dependencies, this.buildOperationExecutor, this.fileCollectionFactory, inputFingerprinter, this.fileSystemAccess, workspaceServices) : new MutableTransformerExecution(transformer, inputArtifact, dependencies, this.buildOperationExecutor, this.fileCollectionFactory, inputFingerprinter, workspaceServices);
        return (CacheableInvocation)this.executionEngine.createRequest((UnitOfWork)execution).withIdentityCache(workspaceServices.getIdentityCache()).getOrDeferExecution((DeferredExecutionHandler)new DeferredExecutionHandler<ImmutableList<File>, CacheableInvocation<ImmutableList<File>>>(){

            public CacheableInvocation<ImmutableList<File>> processCachedOutput(Try<ImmutableList<File>> cachedOutput) {
                return CacheableInvocation.cached(this.mapResult(cachedOutput));
            }

            public CacheableInvocation<ImmutableList<File>> processDeferredOutput(Supplier<Try<ImmutableList<File>>> deferredExecution) {
                return CacheableInvocation.nonCached(() -> (Try)DefaultTransformerInvocationFactory.this.fireTransformListeners(transformer, subject, () -> this.lambda$processDeferredOutput$0((Supplier)deferredExecution)));
            }

            @Nonnull
            private Try<ImmutableList<File>> mapResult(Try<ImmutableList<File>> cachedOutput) {
                return cachedOutput.mapFailure(failure -> new TransformException(String.format("Execution failed for %s.", execution.getDisplayName()), (Throwable)failure));
            }

            private /* synthetic */ Try lambda$processDeferredOutput$0(Supplier deferredExecution) {
                return this.mapResult((Try<ImmutableList<File>>)((Try)deferredExecution.get()));
            }
        });
    }

    private TransformationWorkspaceServices determineWorkspaceServices(@Nullable ProjectInternal producerProject) {
        if (producerProject == null) {
            return this.immutableWorkspaceProvider;
        }
        return (TransformationWorkspaceServices)producerProject.getServices().get(TransformationWorkspaceServices.class);
    }

    @Nullable
    private ProjectInternal determineProducerProject(TransformationSubject subject) {
        ComponentIdentifier componentIdentifier = subject.getInitialComponentIdentifier();
        if (componentIdentifier instanceof ProjectComponentIdentifier) {
            return this.projectStateRegistry.stateFor((ProjectComponentIdentifier)componentIdentifier).getMutableModel();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T fireTransformListeners(Transformer transformer, TransformationSubject subject, Supplier<T> execution) {
        this.artifactTransformListener.beforeTransformerInvocation((Describable)transformer, (Describable)subject);
        try {
            T t = execution.get();
            return t;
        }
        finally {
            this.artifactTransformListener.afterTransformerInvocation((Describable)transformer, (Describable)subject);
        }
    }

    public static class MutableTransformationWorkspaceIdentity
    implements UnitOfWork.Identity {
        private final String inputArtifactAbsolutePath;
        private final ValueSnapshot secondaryInputsSnapshot;
        private final HashCode dependenciesHash;

        public MutableTransformationWorkspaceIdentity(String inputArtifactAbsolutePath, ValueSnapshot secondaryInputsSnapshot, HashCode dependenciesHash) {
            this.inputArtifactAbsolutePath = inputArtifactAbsolutePath;
            this.secondaryInputsSnapshot = secondaryInputsSnapshot;
            this.dependenciesHash = dependenciesHash;
        }

        public String getUniqueId() {
            Hasher hasher = Hashing.newHasher();
            hasher.putString((CharSequence)this.inputArtifactAbsolutePath);
            this.secondaryInputsSnapshot.appendToHasher(hasher);
            hasher.putHash(this.dependenciesHash);
            return hasher.hash().toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MutableTransformationWorkspaceIdentity that = (MutableTransformationWorkspaceIdentity)o;
            if (!this.secondaryInputsSnapshot.equals(that.secondaryInputsSnapshot)) {
                return false;
            }
            if (!this.dependenciesHash.equals((Object)that.dependenciesHash)) {
                return false;
            }
            return this.inputArtifactAbsolutePath.equals(that.inputArtifactAbsolutePath);
        }

        public int hashCode() {
            int result = this.inputArtifactAbsolutePath.hashCode();
            result = 31 * result + this.secondaryInputsSnapshot.hashCode();
            result = 31 * result + this.dependenciesHash.hashCode();
            return result;
        }
    }

    private static class ImmutableTransformationWorkspaceIdentity
    implements UnitOfWork.Identity {
        private final ValueSnapshot inputArtifactPath;
        private final ValueSnapshot inputArtifactSnapshot;
        private final ValueSnapshot secondaryInputSnapshot;
        private final HashCode dependenciesHash;

        public ImmutableTransformationWorkspaceIdentity(ValueSnapshot inputArtifactPath, ValueSnapshot inputArtifactSnapshot, ValueSnapshot secondaryInputSnapshot, HashCode dependenciesHash) {
            this.inputArtifactPath = inputArtifactPath;
            this.inputArtifactSnapshot = inputArtifactSnapshot;
            this.secondaryInputSnapshot = secondaryInputSnapshot;
            this.dependenciesHash = dependenciesHash;
        }

        public String getUniqueId() {
            Hasher hasher = Hashing.newHasher();
            this.inputArtifactPath.appendToHasher(hasher);
            this.inputArtifactSnapshot.appendToHasher(hasher);
            this.secondaryInputSnapshot.appendToHasher(hasher);
            hasher.putHash(this.dependenciesHash);
            return hasher.hash().toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImmutableTransformationWorkspaceIdentity that = (ImmutableTransformationWorkspaceIdentity)o;
            if (!this.inputArtifactPath.equals(that.inputArtifactPath)) {
                return false;
            }
            if (!this.inputArtifactSnapshot.equals(that.inputArtifactSnapshot)) {
                return false;
            }
            if (!this.secondaryInputSnapshot.equals(that.secondaryInputSnapshot)) {
                return false;
            }
            return this.dependenciesHash.equals((Object)that.dependenciesHash);
        }

        public int hashCode() {
            int result = this.inputArtifactPath.hashCode();
            result = 31 * result + this.inputArtifactSnapshot.hashCode();
            result = 31 * result + this.secondaryInputSnapshot.hashCode();
            result = 31 * result + this.dependenciesHash.hashCode();
            return result;
        }
    }

    private static abstract class AbstractTransformerExecution
    implements UnitOfWork {
        protected final Transformer transformer;
        protected final File inputArtifact;
        private final ArtifactTransformDependencies dependencies;
        private final BuildOperationExecutor buildOperationExecutor;
        private final FileCollectionFactory fileCollectionFactory;
        private final Timer executionTimer;
        private final Provider<FileSystemLocation> inputArtifactProvider;
        protected final InputFingerprinter inputFingerprinter;
        private final TransformationWorkspaceServices workspaceServices;

        public AbstractTransformerExecution(Transformer transformer, File inputArtifact, ArtifactTransformDependencies dependencies, BuildOperationExecutor buildOperationExecutor, FileCollectionFactory fileCollectionFactory, InputFingerprinter inputFingerprinter, TransformationWorkspaceServices workspaceServices) {
            this.transformer = transformer;
            this.inputArtifact = inputArtifact;
            this.dependencies = dependencies;
            this.executionTimer = Time.startTimer();
            this.inputArtifactProvider = Providers.of((Object)new DefaultFileSystemLocation(inputArtifact));
            this.buildOperationExecutor = buildOperationExecutor;
            this.fileCollectionFactory = fileCollectionFactory;
            this.inputFingerprinter = inputFingerprinter;
            this.workspaceServices = workspaceServices;
        }

        public UnitOfWork.WorkOutput execute(final UnitOfWork.ExecutionRequest executionRequest) {
            final ImmutableList result = (ImmutableList)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<ImmutableList<File>>(){

                public ImmutableList<File> call(BuildOperationContext context) {
                    File workspace = executionRequest.getWorkspace();
                    InputChangesInternal inputChanges = executionRequest.getInputChanges().orElse(null);
                    ImmutableList<File> result = transformer.transform((Provider<FileSystemLocation>)inputArtifactProvider, AbstractTransformerExecution.getOutputDir(workspace), dependencies, (InputChanges)inputChanges);
                    this.writeResultsFile(workspace, (ImmutableList<File>)result);
                    return result;
                }

                public BuildOperationDescriptor.Builder description() {
                    String displayName = transformer.getDisplayName() + " " + inputArtifact.getName();
                    return BuildOperationDescriptor.displayName((String)displayName).progressDisplayName(displayName);
                }
            });
            return new UnitOfWork.WorkOutput(){

                public UnitOfWork.WorkResult getDidWork() {
                    return UnitOfWork.WorkResult.DID_WORK;
                }

                public Object getOutput() {
                    return result;
                }
            };
        }

        public Object loadRestoredOutput(File workspace) {
            return this.readResultsFile(workspace);
        }

        public WorkspaceProvider getWorkspaceProvider() {
            return this.workspaceServices.getWorkspaceProvider();
        }

        public InputFingerprinter getInputFingerprinter() {
            return this.inputFingerprinter;
        }

        private void writeResultsFile(File workspace, ImmutableList<File> result) {
            File outputDir = AbstractTransformerExecution.getOutputDir(workspace);
            String outputDirPrefix = outputDir.getPath() + File.separator;
            String inputFilePrefix = this.inputArtifact.getPath() + File.separator;
            Stream<String> relativePaths = result.stream().map(file -> {
                if (file.equals(outputDir)) {
                    return DefaultTransformerInvocationFactory.OUTPUT_FILE_PATH_PREFIX;
                }
                if (file.equals(this.inputArtifact)) {
                    return DefaultTransformerInvocationFactory.INPUT_FILE_PATH_PREFIX;
                }
                String absolutePath = file.getAbsolutePath();
                if (absolutePath.startsWith(outputDirPrefix)) {
                    return DefaultTransformerInvocationFactory.OUTPUT_FILE_PATH_PREFIX + RelativePath.parse((boolean)true, (String)absolutePath.substring(outputDirPrefix.length())).getPathString();
                }
                if (absolutePath.startsWith(inputFilePrefix)) {
                    return DefaultTransformerInvocationFactory.INPUT_FILE_PATH_PREFIX + RelativePath.parse((boolean)true, (String)absolutePath.substring(inputFilePrefix.length())).getPathString();
                }
                throw new IllegalStateException("Invalid result path: " + absolutePath);
            });
            UncheckedException.unchecked(() -> Files.write(AbstractTransformerExecution.getResultsFile(workspace).toPath(), relativePaths::iterator, new OpenOption[0]));
        }

        private ImmutableList<File> readResultsFile(File workspace) {
            Path transformerResultsPath = AbstractTransformerExecution.getResultsFile(workspace).toPath();
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                List<String> paths = Files.readAllLines(transformerResultsPath, StandardCharsets.UTF_8);
                for (String path : paths) {
                    if (path.startsWith(DefaultTransformerInvocationFactory.OUTPUT_FILE_PATH_PREFIX)) {
                        builder.add((Object)new File(AbstractTransformerExecution.getOutputDir(workspace), path.substring(2)));
                        continue;
                    }
                    if (path.startsWith(DefaultTransformerInvocationFactory.INPUT_FILE_PATH_PREFIX)) {
                        builder.add((Object)new File(this.inputArtifact, path.substring(2)));
                        continue;
                    }
                    throw new IllegalStateException("Cannot parse result path string: " + path);
                }
                return builder.build();
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }

        private static File getOutputDir(File workspace) {
            return new File(workspace, "transformed");
        }

        private static File getResultsFile(File workspace) {
            return new File(workspace, "results.bin");
        }

        public Optional<Duration> getTimeout() {
            return Optional.empty();
        }

        public UnitOfWork.InputChangeTrackingStrategy getInputChangeTrackingStrategy() {
            return this.transformer.requiresInputChanges() ? UnitOfWork.InputChangeTrackingStrategy.INCREMENTAL_PARAMETERS : UnitOfWork.InputChangeTrackingStrategy.NONE;
        }

        public void visitImplementations(UnitOfWork.ImplementationVisitor visitor) {
            visitor.visitImplementation(this.transformer.getImplementationClass());
        }

        @OverridingMethodsMustInvokeSuper
        public void visitIdentityInputs(InputFingerprinter.InputVisitor visitor) {
            visitor.visitInputProperty(DefaultTransformerInvocationFactory.SECONDARY_INPUTS_HASH_PROPERTY_NAME, this.transformer::getSecondaryInputHash);
            visitor.visitInputFileProperty(DefaultTransformerInvocationFactory.DEPENDENCIES_PROPERTY_NAME, InputFingerprinter.InputPropertyType.NON_INCREMENTAL, new InputFingerprinter.FileValueSupplier((Object)this.dependencies, this.transformer.getInputArtifactDependenciesNormalizer(), this.transformer.getInputArtifactDependenciesDirectorySensitivity(), () -> this.dependencies.getFiles().orElse((FileCollection)this.fileCollectionFactory.empty())));
        }

        @OverridingMethodsMustInvokeSuper
        public void visitRegularInputs(InputFingerprinter.InputVisitor visitor) {
            visitor.visitInputFileProperty(DefaultTransformerInvocationFactory.INPUT_ARTIFACT_PROPERTY_NAME, InputFingerprinter.InputPropertyType.PRIMARY, new InputFingerprinter.FileValueSupplier(this.inputArtifactProvider, this.transformer.getInputArtifactNormalizer(), this.transformer.getInputArtifactDirectorySensitivity(), () -> this.fileCollectionFactory.fixed(new File[]{this.inputArtifact})));
        }

        public void visitOutputs(File workspace, UnitOfWork.OutputVisitor visitor) {
            File outputDir = AbstractTransformerExecution.getOutputDir(workspace);
            File resultsFile = AbstractTransformerExecution.getResultsFile(workspace);
            visitor.visitOutputProperty(DefaultTransformerInvocationFactory.OUTPUT_DIRECTORY_PROPERTY_NAME, TreeType.DIRECTORY, outputDir, (FileCollection)this.fileCollectionFactory.fixed(new File[]{outputDir}));
            visitor.visitOutputProperty(DefaultTransformerInvocationFactory.RESULTS_FILE_PROPERTY_NAME, TreeType.FILE, resultsFile, (FileCollection)this.fileCollectionFactory.fixed(new File[]{resultsFile}));
        }

        public long markExecutionTime() {
            return this.executionTimer.getElapsedMillis();
        }

        public Optional<CachingDisabledReason> shouldDisableCaching(@Nullable OverlappingOutputs detectedOverlappingOutputs) {
            return this.transformer.isCacheable() ? Optional.empty() : Optional.of(NOT_CACHEABLE);
        }

        public String getDisplayName() {
            return this.transformer.getDisplayName() + ": " + this.inputArtifact;
        }
    }

    private static class MutableTransformerExecution
    extends AbstractTransformerExecution {
        public MutableTransformerExecution(Transformer transformer, File inputArtifact, ArtifactTransformDependencies dependencies, BuildOperationExecutor buildOperationExecutor, FileCollectionFactory fileCollectionFactory, InputFingerprinter inputFingerprinter, TransformationWorkspaceServices workspaceServices) {
            super(transformer, inputArtifact, dependencies, buildOperationExecutor, fileCollectionFactory, inputFingerprinter, workspaceServices);
        }

        public UnitOfWork.Identity identify(Map<String, ValueSnapshot> identityInputs, Map<String, CurrentFileCollectionFingerprint> identityFileInputs) {
            return new MutableTransformationWorkspaceIdentity(this.inputArtifact.getAbsolutePath(), identityInputs.get(DefaultTransformerInvocationFactory.SECONDARY_INPUTS_HASH_PROPERTY_NAME), identityFileInputs.get(DefaultTransformerInvocationFactory.DEPENDENCIES_PROPERTY_NAME).getHash());
        }
    }

    private static class ImmutableTransformerExecution
    extends AbstractTransformerExecution {
        private final FileSystemAccess fileSystemAccess;

        public ImmutableTransformerExecution(Transformer transformer, File inputArtifact, ArtifactTransformDependencies dependencies, BuildOperationExecutor buildOperationExecutor, FileCollectionFactory fileCollectionFactory, InputFingerprinter inputFingerprinter, FileSystemAccess fileSystemAccess, TransformationWorkspaceServices workspaceServices) {
            super(transformer, inputArtifact, dependencies, buildOperationExecutor, fileCollectionFactory, inputFingerprinter, workspaceServices);
            this.fileSystemAccess = fileSystemAccess;
        }

        @Override
        public void visitIdentityInputs(InputFingerprinter.InputVisitor visitor) {
            super.visitIdentityInputs(visitor);
            FileSystemLocationSnapshot inputArtifactSnapshot = (FileSystemLocationSnapshot)this.fileSystemAccess.read(this.inputArtifact.getAbsolutePath(), Function.identity());
            visitor.visitInputProperty(DefaultTransformerInvocationFactory.INPUT_ARTIFACT_PATH_PROPERTY_NAME, () -> {
                FileCollectionFingerprinter inputArtifactFingerprinter = this.inputFingerprinter.getFingerprinterRegistry().getFingerprinter(DefaultFileNormalizationSpec.from(this.transformer.getInputArtifactNormalizer(), (DirectorySensitivity)this.transformer.getInputArtifactDirectorySensitivity()));
                return inputArtifactFingerprinter.normalizePath(inputArtifactSnapshot);
            });
            visitor.visitInputProperty(DefaultTransformerInvocationFactory.INPUT_ARTIFACT_SNAPSHOT_PROPERTY_NAME, () -> ((FileSystemLocationSnapshot)inputArtifactSnapshot).getHash());
        }

        public UnitOfWork.Identity identify(Map<String, ValueSnapshot> identityInputs, Map<String, CurrentFileCollectionFingerprint> identityFileInputs) {
            return new ImmutableTransformationWorkspaceIdentity(identityInputs.get(DefaultTransformerInvocationFactory.INPUT_ARTIFACT_PATH_PROPERTY_NAME), identityInputs.get(DefaultTransformerInvocationFactory.INPUT_ARTIFACT_SNAPSHOT_PROPERTY_NAME), identityInputs.get(DefaultTransformerInvocationFactory.SECONDARY_INPUTS_HASH_PROPERTY_NAME), identityFileInputs.get(DefaultTransformerInvocationFactory.DEPENDENCIES_PROPERTY_NAME).getHash());
        }
    }
}

