/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.validation;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.DefaultSolutionBuilder;
import org.gradle.internal.reflect.validation.PropertyProblemBuilder;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.SolutionBuilder;
import org.gradle.internal.reflect.validation.TypeValidationProblem;
import org.gradle.internal.reflect.validation.UserManualReference;
import org.gradle.internal.reflect.validation.ValidationProblemBuilder;
import org.gradle.plugin.use.PluginId;
import org.gradle.problems.Solution;

abstract class AbstractValidationProblemBuilder<T extends ValidationProblemBuilder<T>>
implements ValidationProblemBuilder<T> {
    protected final DocumentationRegistry documentationRegistry;
    protected final PluginId pluginId;
    protected ValidationProblemId problemId = null;
    protected Severity severity = Severity.WARNING;
    protected Supplier<String> shortProblemDescription;
    protected Supplier<String> longDescription = () -> null;
    protected Supplier<String> reason = () -> null;
    protected UserManualReference userManualReference;
    protected final List<Supplier<Solution>> possibleSolutions = Lists.newArrayListWithExpectedSize((int)1);
    protected boolean cacheabilityProblemOnly = false;
    protected boolean typeIrrelevantInErrorMessage = false;

    public AbstractValidationProblemBuilder(DocumentationRegistry documentationRegistry, @Nullable PluginId pluginId) {
        this.documentationRegistry = documentationRegistry;
        this.pluginId = pluginId;
    }

    @Override
    public T withId(ValidationProblemId id) {
        this.problemId = id;
        return (T)((ValidationProblemBuilder)Cast.uncheckedCast((Object)this));
    }

    @Override
    public T withDescription(Supplier<String> message) {
        this.shortProblemDescription = message;
        return (T)((ValidationProblemBuilder)Cast.uncheckedCast((Object)this));
    }

    @Override
    public T reportAs(Severity severity) {
        this.severity = severity;
        return (T)((ValidationProblemBuilder)Cast.uncheckedCast((Object)this));
    }

    @Override
    public T happensBecause(Supplier<String> message) {
        this.reason = message;
        return (T)((ValidationProblemBuilder)Cast.uncheckedCast((Object)this));
    }

    @Override
    public T withLongDescription(Supplier<String> longDescription) {
        this.longDescription = longDescription;
        return (T)((ValidationProblemBuilder)Cast.uncheckedCast((Object)this));
    }

    @Override
    public T documentedAt(String id, String section) {
        this.userManualReference = new UserManualReference(this.documentationRegistry, id, section);
        return (T)((ValidationProblemBuilder)Cast.uncheckedCast((Object)this));
    }

    @Override
    public T addPossibleSolution(Supplier<String> solution, Action<? super SolutionBuilder> solutionSpec) {
        DefaultSolutionBuilder builder = new DefaultSolutionBuilder(this.documentationRegistry, solution);
        solutionSpec.execute((Object)builder);
        this.possibleSolutions.add(builder.build());
        return (T)((ValidationProblemBuilder)Cast.uncheckedCast((Object)this));
    }

    @Override
    public T onlyAffectsCacheableWork() {
        this.cacheabilityProblemOnly = true;
        return (T)((ValidationProblemBuilder)Cast.uncheckedCast((Object)this));
    }

    @Override
    public PropertyProblemBuilder typeIsIrrelevantInErrorMessage() {
        this.typeIrrelevantInErrorMessage = true;
        return (PropertyProblemBuilder)Cast.uncheckedCast((Object)this);
    }

    public abstract TypeValidationProblem build();
}

