/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.tasks.diagnostics.ProjectBasedReportTask;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.GUtil;

public class ProjectReportTask
extends ProjectBasedReportTask {
    private final TextReportRenderer renderer = new TextReportRenderer();

    @Override
    protected TextReportRenderer getRenderer() {
        return this.renderer;
    }

    @Inject
    public BuildStateRegistry getBuildStateRegistry() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void generate(Project project) {
        BuildClientMetaData metaData = this.getClientMetaData();
        StyledTextOutput textOutput = this.getRenderer().getTextOutput();
        this.render(project, new GraphRenderer(textOutput), true, textOutput);
        if (project.getChildProjects().isEmpty()) {
            textOutput.withStyle(StyledTextOutput.Style.Info).text((Object)"No sub-projects");
            textOutput.println();
        }
        if (project == project.getRootProject()) {
            int i = 0;
            Collection includedBuilds = this.getBuildStateRegistry().getIncludedBuilds();
            if (!includedBuilds.isEmpty()) {
                GraphRenderer renderer = new GraphRenderer(textOutput);
                textOutput.println();
                textOutput.text((Object)"Included builds");
                textOutput.println();
                renderer.startChildren();
                for (IncludedBuildState includedBuildState : includedBuilds) {
                    renderer.visit(text -> textOutput.text((Object)("Included build '" + includedBuildState.getIdentityPath() + "'")), i + 1 == includedBuilds.size());
                    ++i;
                }
                renderer.completeChildren();
            }
        }
        textOutput.println();
        textOutput.text((Object)"To see a list of the tasks of a project, run ");
        metaData.describeCommand((Appendable)textOutput.withStyle(StyledTextOutput.Style.UserInput), new String[]{"<project-path>:tasks"});
        textOutput.println();
        textOutput.text((Object)"For example, try running ");
        Project exampleProject = project.getChildProjects().isEmpty() ? project : this.getChildren(project).get(0);
        metaData.describeCommand((Appendable)textOutput.withStyle(StyledTextOutput.Style.UserInput), new String[]{exampleProject.absoluteProjectPath("tasks")});
        textOutput.println();
        if (project != project.getRootProject()) {
            textOutput.println();
            textOutput.text((Object)"To see a list of all the projects in this build, run ");
            metaData.describeCommand((Appendable)textOutput.withStyle(StyledTextOutput.Style.UserInput), new String[]{project.getRootProject().absoluteProjectPath("projects")});
            textOutput.println();
        }
    }

    private void render(Project project, GraphRenderer renderer, boolean lastChild, StyledTextOutput textOutput) {
        renderer.visit(styledTextOutput -> {
            styledTextOutput.text((Object)StringUtils.capitalize((String)project.getDisplayName()));
            if (GUtil.isTrue((Object)project.getDescription())) {
                String description = project.getDescription().trim();
                int newlineInDescription = description.indexOf(10);
                if (newlineInDescription > 0) {
                    textOutput.withStyle(StyledTextOutput.Style.Description).text((Object)(" - " + description.substring(0, newlineInDescription) + "..."));
                } else {
                    textOutput.withStyle(StyledTextOutput.Style.Description).text((Object)(" - " + description));
                }
            }
        }, lastChild);
        renderer.startChildren();
        List<Project> children = this.getChildren(project);
        for (Project child : children) {
            this.render(child, renderer, child == children.get(children.size() - 1), textOutput);
        }
        renderer.completeChildren();
    }

    private List<Project> getChildren(Project project) {
        return CollectionUtils.sort(project.getChildProjects().values());
    }
}

