/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.scala.MinimalScalaCompilerDaemonForkOptions;
import org.gradle.api.tasks.scala.IncrementalCompileOptions;
import org.gradle.language.scala.tasks.BaseScalaCompileOptions;

public class MinimalScalaCompileOptions
implements Serializable {
    private boolean failOnError = true;
    private boolean deprecation = true;
    private boolean unchecked = true;
    private String debugLevel;
    private boolean optimize;
    private String encoding;
    private boolean force;
    private List<String> additionalParameters;
    private boolean listFiles;
    private String loggingLevel;
    private List<String> loggingPhases;
    private MinimalScalaCompilerDaemonForkOptions forkOptions;
    private transient IncrementalCompileOptions incrementalOptions;

    public MinimalScalaCompileOptions(BaseScalaCompileOptions compileOptions) {
        this.failOnError = compileOptions.isFailOnError();
        this.deprecation = compileOptions.isDeprecation();
        this.unchecked = compileOptions.isUnchecked();
        this.debugLevel = compileOptions.getDebugLevel();
        this.optimize = compileOptions.isOptimize();
        this.encoding = compileOptions.getEncoding();
        this.force = compileOptions.isForce();
        this.additionalParameters = compileOptions.getAdditionalParameters() == null ? null : ImmutableList.copyOf(compileOptions.getAdditionalParameters());
        this.listFiles = compileOptions.isListFiles();
        this.loggingLevel = compileOptions.getLoggingLevel();
        this.loggingPhases = compileOptions.getLoggingPhases() == null ? null : ImmutableList.copyOf(compileOptions.getLoggingPhases());
        this.forkOptions = new MinimalScalaCompilerDaemonForkOptions(compileOptions.getForkOptions());
        this.incrementalOptions = compileOptions.getIncrementalOptions();
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean isDeprecation() {
        return this.deprecation;
    }

    public void setDeprecation(boolean deprecation) {
        this.deprecation = deprecation;
    }

    public boolean isUnchecked() {
        return this.unchecked;
    }

    public void setUnchecked(boolean unchecked) {
        this.unchecked = unchecked;
    }

    @Nullable
    public String getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(@Nullable String debugLevel) {
        this.debugLevel = debugLevel;
    }

    public boolean isOptimize() {
        return this.optimize;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    @Nullable
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(@Nullable String encoding) {
        this.encoding = encoding;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    @Nullable
    public List<String> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public void setAdditionalParameters(@Nullable List<String> additionalParameters) {
        this.additionalParameters = additionalParameters;
    }

    public boolean isListFiles() {
        return this.listFiles;
    }

    public void setListFiles(boolean listFiles) {
        this.listFiles = listFiles;
    }

    public String getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(String loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public List<String> getLoggingPhases() {
        return this.loggingPhases;
    }

    public void setLoggingPhases(List<String> loggingPhases) {
        this.loggingPhases = loggingPhases;
    }

    public MinimalScalaCompilerDaemonForkOptions getForkOptions() {
        return this.forkOptions;
    }

    public void setForkOptions(MinimalScalaCompilerDaemonForkOptions forkOptions) {
        this.forkOptions = forkOptions;
    }

    public IncrementalCompileOptions getIncrementalOptions() {
        return this.incrementalOptions;
    }

    public void setIncrementalOptions(IncrementalCompileOptions incrementalOptions) {
        this.incrementalOptions = incrementalOptions;
    }
}

