/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.InstallationSupplier;

public abstract class AutoDetectingInstallationSupplier
implements InstallationSupplier {
    public static final String AUTO_DETECT = "org.gradle.java.installations.auto-detect";
    private final ProviderFactory factory;
    private final Provider<Boolean> detectionEnabled;

    @Inject
    public AutoDetectingInstallationSupplier(ProviderFactory factory) {
        this.detectionEnabled = factory.gradleProperty(AUTO_DETECT).forUseAtConfigurationTime().map(Boolean::parseBoolean);
        this.factory = factory;
    }

    @Override
    public Set<InstallationLocation> get() {
        if (this.isAutoDetectionEnabled()) {
            return this.findCandidates();
        }
        return Collections.emptySet();
    }

    protected Provider<String> getEnvironmentProperty(String propertyName) {
        return this.factory.environmentVariable(propertyName).forUseAtConfigurationTime();
    }

    protected Provider<String> getSystemProperty(String propertyName) {
        return this.factory.systemProperty(propertyName).forUseAtConfigurationTime();
    }

    protected abstract Set<InstallationLocation> findCandidates();

    protected boolean isAutoDetectionEnabled() {
        return (Boolean)this.detectionEnabled.getOrElse((Object)true);
    }
}

