# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_svg2pdf_global_optspecs
	string join \n v/verbosity dpi= t/text-to-paths raster-scale= h/help V/version
end

function __fish_svg2pdf_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_svg2pdf_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_svg2pdf_using_subcommand
	set -l cmd (__fish_svg2pdf_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c svg2pdf -n "__fish_svg2pdf_needs_command" -l dpi -d 'The number of SVG pixels per PDF points' -r
complete -c svg2pdf -n "__fish_svg2pdf_needs_command" -l raster-scale -d 'How much raster images of rasterized effects should be scaled up' -r
complete -c svg2pdf -n "__fish_svg2pdf_needs_command" -s v -l verbosity -d 'Sets the level of logging verbosity: -v = warning & error, -vv = info, -vvv = debug, -vvvv = trace'
complete -c svg2pdf -n "__fish_svg2pdf_needs_command" -s t -l text-to-paths -d 'Whether text should be converted to paths before embedding it into the PDF'
complete -c svg2pdf -n "__fish_svg2pdf_needs_command" -s h -l help -d 'Print help'
complete -c svg2pdf -n "__fish_svg2pdf_needs_command" -s V -l version -d 'Print version'
complete -c svg2pdf -n "__fish_svg2pdf_needs_command" -a "fonts" -d 'Lists all discovered fonts in system'
complete -c svg2pdf -n "__fish_svg2pdf_needs_command" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c svg2pdf -n "__fish_svg2pdf_using_subcommand fonts" -l all -d 'Also lists style variants of each font family'
complete -c svg2pdf -n "__fish_svg2pdf_using_subcommand fonts" -s h -l help -d 'Print help'
complete -c svg2pdf -n "__fish_svg2pdf_using_subcommand help; and not __fish_seen_subcommand_from fonts help" -f -a "fonts" -d 'Lists all discovered fonts in system'
complete -c svg2pdf -n "__fish_svg2pdf_using_subcommand help; and not __fish_seen_subcommand_from fonts help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
