-- mod-version:3
local syntax = require "core.syntax"

syntax.add {
  name = "Haskell",
  files = { "%.hs$" },
  comment = "--",
  block_comment = {"{-", "-}"},
  patterns = {
    { pattern = "%-%-.*",               type = "comment"  },
    { pattern = { "{%-", "%-}" },       type = "comment"  },
    { pattern = { '"', '"', '\\' },     type = "string"   },
    { pattern = { "'", "'", '\\' },     type = "string"   },
    { pattern = "-?0x%x+",              type = "number"   },
    { pattern = "-?%d+[%d%.eE]*f?",     type = "number"   },
    { pattern = "-?%.?%d+f?",           type = "number"   },
    { pattern = "[!%#%$%%&*+./%<=>%?@\\%^|%-~:]", type = "operator" },
    { pattern = "[%a_'][%w_']*",          type = "symbol"   },
  },
  symbols = {
    ["as"] = "keyword",
    ["case"] = "keyword",
    ["of"] = "keyword",
    ["class"] = "keyword",
    ["data"] = "keyword",
    ["default"] = "keyword",
    ["deriving"] = "keyword",
    ["do"] = "keyword",
    ["forall"] = "keyword",
    ["foreign"] = "keyword",
    ["hiding"] = "keyword",
    ["if"] = "keyword",
    ["then"] = "keyword",
    ["else"] = "keyword",
    ["import"] = "keyword",
    ["infix"] = "keyword",
    ["infixl"] = "keyword",
    ["infixr"] = "keyword",
    ["let"] = "keyword",
    ["in"] = "keyword",
    ["mdo"] = "keyword",
    ["module"] = "keyword",
    ["newtype"] = "keyword",
    ["qualified"] = "keyword",
    ["type"] = "keyword",
    ["where"] = "keyword",
  },
}
