-- mod-version:3
local syntax = require "core.syntax"

syntax.add {
  name = "Dart",
  files = { "%.dart$" },
  comment = "//",
  patterns = {
    { pattern = "//.-\n",                   type = "comment"  },
    { pattern = "///.-\n",                  type = "comment"  },
    { pattern = { "/%*", "%*/" },           type = "comment"  },
    { pattern = { '"', '"', '\\' },         type = "string"   },
    { pattern = { "'", "'", '\\' },         type = "string"   },
    { pattern = "-?0x%x+",                  type = "number"   },
    { pattern = "-?%d+[%d%.eE]*f?",         type = "number"   },
    { pattern = "-?%.?%d+f?",               type = "number"   },
    { pattern = "[%+%-=/%*%^%%<>!~|&]",     type = "operator" },
    { pattern = "%?%?",                     type = "operator" },
    { pattern = "%?%.",                     type = "operator" },
    { pattern = { "[%$%@]?\"", '"', '\\' }, type = "string"   },
    { pattern = "'\\x%x?%x?%x?%x'",         type = "string"   },
    { pattern = "[%a_][%w_]*%f[(]",         type = "function" },
    { pattern = "[%a_][%w_]*",              type = "symbol"   },
  },
  symbols = {
    ["await"]    = "keyword",
    ["bool"]     = "keyword2",
    ["break"]    = "keyword",
    ["case"]     = "keyword",
    ["class"]    = "keyword",
    ["const"]    = "keyword",
    ["continue"] = "keyword",
    ["default"]  = "keyword",
    ["do"]       = "keyword",
    ["double"]   = "keyword2",
    ["dynamic"]  = "keyword2",
    ["else"]     = "keyword",
    ["enum"]     = "keyword",
    ["false"]    = "literal",
    ["final"]    = "keyword",
    ["finally"]  = "keyword",
    ["for"]      = "keyword",
    ["Function"] = "keyword2",
    ["if"]       = "keyword",
    ["in"]       = "keyword",
    ["int"]      = "keyword2",
    ["List"]     = "keyword2",
    ["Map"]      = "keyword2",
    ["new"]      = "keyword",
    ["null"]     = "literal",
    ["part of"]  = "keyword",
    ["print"]    = "keyword",
    ["return"]   = "keyword",
    ["static"]   = "keyword",
    ["String"]   = "keyword2",
    ["switch"]   = "keyword",
    ["then"]     = "keyword",
    ["this"]     = "keyword2",
    ["true"]     = "literal",
    ["void"]     = "keyword",
    ["while"]    = "keyword",
  },
}

