#ifndef _SIGHANDLER_H_INCLUDED_
#define _SIGHANDLER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// SigHandler.h
// ------------
// Signal handler class
//                                                         
// Design and Implementation by Bjoern Lemke               
//
// (C)opyright 2000-2013 Bjoern Lemke                        
//                                                         
// INTERFACE MODULE
//
// Class: SigHandler
// 
// Description: Signal handler utility class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES
#include <signal.h>

class SigHandler {
    
public:

    SigHandler();
    virtual ~SigHandler();

    void init();

    virtual void sigCatch(int sig) = 0;
    void install(int sig);
    
private:
    
    static void handleSig(int sig);

};
#endif
