/////////////////////////////////////////////////////////////////////////////
// Name:        language.h
// Purpose:     wxLanguage enum
// Author:      wxWidgets team
// Licence:     wxWindows licence
/////////////////////////////////////////////////////////////////////////////


/**
    The languages supported by wxLocale.

    All language constants known to wxLocale.
*/

// --- --- --- generated code begins here --- --- ---

enum wxLanguage
{
    /// User's default/preferred language as got from OS.
    wxLANGUAGE_DEFAULT,

    /// Unknown language, returned if wxLocale::GetSystemLanguage fails.
    wxLANGUAGE_UNKNOWN,

    wxLANGUAGE_ABKHAZIAN,
    wxLANGUAGE_AFAR,
    wxLANGUAGE_AFAR_DJIBOUTI,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_AFAR_ERITREA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_AFAR_ETHIOPIA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_AFRIKAANS,
    wxLANGUAGE_AFRIKAANS_NAMIBIA,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_AFRIKAANS_SOUTH_AFRICA,                       ///< @since_wx{3.1.6}
    wxLANGUAGE_AGHEM,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_AGHEM_CAMEROON,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_AKAN,                                         ///< @since_wx{3.1.6}
    wxLANGUAGE_AKAN_GHANA,                                   ///< @since_wx{3.1.6}
    wxLANGUAGE_ALBANIAN,
    wxLANGUAGE_ALBANIAN_ALBANIA,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_ALBANIAN_KOSOVO,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_ALBANIAN_NORTH_MACEDONIA,                     ///< @since_wx{3.1.6}
    wxLANGUAGE_ALSATIAN_FRANCE,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_AMHARIC,
    wxLANGUAGE_AMHARIC_ETHIOPIA,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_ARABIC,
    wxLANGUAGE_ARABIC_ALGERIA,
    wxLANGUAGE_ARABIC_BAHRAIN,
    wxLANGUAGE_ARABIC_CHAD,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_ARABIC_COMOROS,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_ARABIC_DJIBOUTI,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_ARABIC_EGYPT,
    wxLANGUAGE_ARABIC_ERITREA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_ARABIC_IRAQ,
    wxLANGUAGE_ARABIC_ISRAEL,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_ARABIC_JORDAN,
    wxLANGUAGE_ARABIC_KUWAIT,
    wxLANGUAGE_ARABIC_LEBANON,
    wxLANGUAGE_ARABIC_LIBYA,
    wxLANGUAGE_ARABIC_MAURITANIA,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_ARABIC_MOROCCO,
    wxLANGUAGE_ARABIC_OMAN,
    wxLANGUAGE_ARABIC_PALESTINIAN_AUTHORITY,                 ///< @since_wx{3.1.6}
    wxLANGUAGE_ARABIC_QATAR,
    wxLANGUAGE_ARABIC_SAUDI_ARABIA,
    wxLANGUAGE_ARABIC_SOMALIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_ARABIC_SOUTH_SUDAN,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_ARABIC_SUDAN,
    wxLANGUAGE_ARABIC_SYRIA,
    wxLANGUAGE_ARABIC_TUNISIA,
    wxLANGUAGE_ARABIC_UAE,
    wxLANGUAGE_ARABIC_WORLD,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_ARABIC_YEMEN,
    wxLANGUAGE_ARMENIAN,
    wxLANGUAGE_ARMENIAN_ARMENIA,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_ASSAMESE,
    wxLANGUAGE_ASSAMESE_INDIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_ASTURIAN,                                     ///< @since_wx{3.0.0}
    wxLANGUAGE_ASTURIAN_SPAIN,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_ASU,                                          ///< @since_wx{3.1.6}
    wxLANGUAGE_ASU_TANZANIA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_AYMARA,
    wxLANGUAGE_AZERBAIJANI,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_AZERBAIJANI_CYRILLIC,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_AZERBAIJANI_CYRILLIC_AZERBAIJAN,              ///< @since_wx{3.1.6}
    wxLANGUAGE_AZERBAIJANI_LATIN,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_AZERBAIJANI_LATIN_AZERBAIJAN,                 ///< @since_wx{3.1.6}
    wxLANGUAGE_BAFIA,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_BAFIA_CAMEROON,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_BAMANANKAN,                                   ///< @since_wx{3.1.6}
    wxLANGUAGE_BAMANANKAN_LATIN,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_BAMANANKAN_LATIN_MALI,                        ///< @since_wx{3.1.6}
    wxLANGUAGE_BANGLA,                                       ///< @since_wx{3.1.6}
    wxLANGUAGE_BANGLA_BANGLADESH,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_BANGLA_INDIA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_BASAA,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_BASAA_CAMEROON,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_BASHKIR,
    wxLANGUAGE_BASHKIR_RUSSIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_BASQUE,
    wxLANGUAGE_BASQUE_SPAIN,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_BELARUSIAN,
    wxLANGUAGE_BELARUSIAN_BELARUS,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_BEMBA,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_BEMBA_ZAMBIA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_BENA,                                         ///< @since_wx{3.1.6}
    wxLANGUAGE_BENA_TANZANIA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_BIHARI,
    wxLANGUAGE_BISLAMA,
    wxLANGUAGE_BLIN,                                         ///< @since_wx{3.1.6}
    wxLANGUAGE_BLIN_ERITREA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_BODO,                                         ///< @since_wx{3.1.6}
    wxLANGUAGE_BODO_INDIA,                                   ///< @since_wx{3.1.6}
    wxLANGUAGE_BOSNIAN,                                      ///< @since_wx{3.0.0}
    wxLANGUAGE_BOSNIAN_CYRILLIC,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_BOSNIAN_CYRILLIC_BOSNIA_AND_HERZEGOVINA,      ///< @since_wx{3.1.6}
    wxLANGUAGE_BOSNIAN_LATIN,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_BOSNIAN_LATIN_BOSNIA_AND_HERZEGOVINA,         ///< @since_wx{3.1.6}
    wxLANGUAGE_BRETON,
    wxLANGUAGE_BRETON_FRANCE,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_BULGARIAN,
    wxLANGUAGE_BULGARIAN_BULGARIA,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_BURMESE,
    wxLANGUAGE_BURMESE_MYANMAR,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_CATALAN,
    wxLANGUAGE_CATALAN_ANDORRA,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_CATALAN_FRANCE,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_CATALAN_ITALY,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_CATALAN_SPAIN,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_CEBUANO,                                      ///< @since_wx{3.1.6}
    wxLANGUAGE_CEBUANO_LATIN,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_CEBUANO_LATIN_PHILIPPINES,                    ///< @since_wx{3.1.6}
    wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT,                      ///< @since_wx{3.1.6}
    wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_ARABIC,               ///< @since_wx{3.1.6}
    wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_ARABIC_MOROCCO,       ///< @since_wx{3.1.6}
    wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_LATIN,                ///< @since_wx{3.1.6}
    wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_LATIN_ALGERIA,        ///< @since_wx{3.1.6}
    wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_LATIN_MOROCCO,        ///< @since_wx{3.1.6}
    wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_TIFINAGH,             ///< @since_wx{3.1.6}
    wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_TIFINAGH_MOROCCO,     ///< @since_wx{3.1.6}
    wxLANGUAGE_CENTRAL_KURDISH,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_CENTRAL_KURDISH_ARABIC,                       ///< @since_wx{3.1.6}
    wxLANGUAGE_CENTRAL_KURDISH_ARABIC_IRAQ,                  ///< @since_wx{3.1.6}
    wxLANGUAGE_CHAKMA,                                       ///< @since_wx{3.1.6}
    wxLANGUAGE_CHAKMA_CHAKMA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_CHAKMA_CHAKMA_BANGLADESH,                     ///< @since_wx{3.1.6}
    wxLANGUAGE_CHAKMA_CHAKMA_INDIA,                          ///< @since_wx{3.1.6}
    wxLANGUAGE_CHECHEN,                                      ///< @since_wx{3.1.6}
    wxLANGUAGE_CHECHEN_RUSSIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_CHEROKEE,                                     ///< @since_wx{3.1.6}
    wxLANGUAGE_CHEROKEE_CHEROKEE,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_CHEROKEE_US,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_CHIGA,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_CHIGA_UGANDA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_CHINESE,
    wxLANGUAGE_CHINESE_CHINA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_CHINESE_HONGKONG,
    wxLANGUAGE_CHINESE_MACAO,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_CHINESE_SIMPLIFIED_EXPLICIT,                  ///< @since_wx{3.1.6}
    wxLANGUAGE_CHINESE_SIMPLIFIED_HONGKONG,                  ///< @since_wx{3.1.6}
    wxLANGUAGE_CHINESE_SIMPLIFIED_MACAO,                     ///< @since_wx{3.1.6}
    wxLANGUAGE_CHINESE_SINGAPORE,
    wxLANGUAGE_CHINESE_TAIWAN,
    wxLANGUAGE_CHINESE_TRADITIONAL_EXPLICIT,                 ///< @since_wx{3.1.6}
    wxLANGUAGE_CHURCH_SLAVIC,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_CHURCH_SLAVIC_RUSSIA,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_COLOGNIAN,                                    ///< @since_wx{3.1.6}
    wxLANGUAGE_COLOGNIAN_GERMANY,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_CORNISH,                                      ///< @since_wx{3.1.6}
    wxLANGUAGE_CORNISH_UK,                                   ///< @since_wx{3.1.6}
    wxLANGUAGE_CORSICAN,
    wxLANGUAGE_CORSICAN_FRANCE,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_CROATIAN,
    wxLANGUAGE_CROATIAN_BOSNIA_AND_HERZEGOVINA,              ///< @since_wx{3.1.6}
    wxLANGUAGE_CROATIAN_CROATIA,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_CZECH,
    wxLANGUAGE_CZECH_CZECHIA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_DANISH,
    wxLANGUAGE_DANISH_DENMARK,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_DANISH_GREENLAND,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_DIVEHI,                                       ///< @since_wx{3.1.6}
    wxLANGUAGE_DIVEHI_MALDIVES,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_DOGRI,                                        ///< @since_wx{3.3.0}
    wxLANGUAGE_DOGRI_DEVANAGARI,                             ///< @since_wx{3.3.0}
    wxLANGUAGE_DOGRI_DEVANAGARI_INDIA,                       ///< @since_wx{3.3.0}
    wxLANGUAGE_DUALA,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_DUALA_CAMEROON,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_DUTCH,
    wxLANGUAGE_DUTCH_ARUBA,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_DUTCH_BELGIAN,
    wxLANGUAGE_DUTCH_BONAIRE_SINT_EUSTATIUS_AND_SABA,        ///< @since_wx{3.1.6}
    wxLANGUAGE_DUTCH_CURACAO,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_DUTCH_NETHERLANDS,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_DUTCH_SINT_MAARTEN,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_DUTCH_SURINAME,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_DZONGKHA,                                     ///< @since_wx{3.1.6}
    wxLANGUAGE_DZONGKHA_BHUTAN,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_EDO,                                          ///< @since_wx{3.1.6}
    wxLANGUAGE_EDO_NIGERIA,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_EMBU,                                         ///< @since_wx{3.1.6}
    wxLANGUAGE_EMBU_KENYA,                                   ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH,
    wxLANGUAGE_ENGLISH_AMERICAN_SAMOA,                       ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_ANGUILLA,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_ANTIGUA_AND_BARBUDA,                  ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_AUSTRALIA,
    wxLANGUAGE_ENGLISH_AUSTRIA,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_BAHAMAS,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_BARBADOS,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_BELGIUM,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_BELIZE,
    wxLANGUAGE_ENGLISH_BERMUDA,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_BOTSWANA,
    wxLANGUAGE_ENGLISH_BRITISH_INDIAN_OCEAN_TERRITORY,       ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_BRITISH_VIRGIN_ISLANDS,               ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_BURUNDI,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_CAMEROON,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_CANADA,
    wxLANGUAGE_ENGLISH_CARIBBEAN,
    wxLANGUAGE_ENGLISH_CARIBBEAN_CB,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_CAYMAN_ISLANDS,                       ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_CHRISTMAS_ISLAND,                     ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_COCOS_KEELING_ISLANDS,                ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_COOK_ISLANDS,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_CYPRUS,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_DENMARK,
    wxLANGUAGE_ENGLISH_DOMINICA,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_EIRE,
    wxLANGUAGE_ENGLISH_ERITREA,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_ESWATINI,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_EUROPE,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_FALKLAND_ISLANDS,                     ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_FIJI,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_FINLAND,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_GAMBIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_GERMANY,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_GHANA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_GIBRALTAR,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_GRENADA,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_GUAM,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_GUERNSEY,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_GUYANA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_HONG_KONG_SAR,                        ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_INDIA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_INDONESIA,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_ISLE_OF_MAN,                          ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_ISRAEL,
    wxLANGUAGE_ENGLISH_JAMAICA,
    wxLANGUAGE_ENGLISH_JERSEY,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_KENYA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_KIRIBATI,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_LESOTHO,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_LIBERIA,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_MACAO_SAR,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_MADAGASCAR,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_MALAWI,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_MALAYSIA,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_MALTA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_MARSHALL_ISLANDS,                     ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_MAURITIUS,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_MICRONESIA,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_MONTSERRAT,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_NAMIBIA,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_NAURU,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_NETHERLANDS,                          ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_NEW_ZEALAND,
    wxLANGUAGE_ENGLISH_NIGERIA,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_NIUE,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_NORFOLK_ISLAND,                       ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_NORTHERN_MARIANA_ISLANDS,             ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_PAKISTAN,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_PALAU,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_PAPUA_NEW_GUINEA,                     ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_PHILIPPINES,
    wxLANGUAGE_ENGLISH_PITCAIRN_ISLANDS,                     ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_PUERTO_RICO,                          ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_RWANDA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_SAMOA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_SEYCHELLES,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_SIERRA_LEONE,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_SINGAPORE,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_SINT_MAARTEN,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_SLOVENIA,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_SOLOMON_ISLANDS,                      ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_SOUTH_AFRICA,
    wxLANGUAGE_ENGLISH_SOUTH_SUDAN,                          ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_ST_HELENA_ASCENSION_TRISTAN_DA_CUNHA, ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_ST_KITTS_AND_NEVIS,                   ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_ST_LUCIA,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_ST_VINCENT_AND_GRENADINES,            ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_SUDAN,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_SWEDEN,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_SWITZERLAND,                          ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_TANZANIA,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_TOKELAU,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_TONGA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_TRINIDAD,
    wxLANGUAGE_ENGLISH_TURKS_AND_CAICOS_ISLANDS,             ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_TUVALU,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_UGANDA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_UK,
    wxLANGUAGE_ENGLISH_UNITED_ARAB_EMIRATES,                 ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_US,
    wxLANGUAGE_ENGLISH_US_OUTLYING_ISLANDS,                  ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_US_VIRGIN_ISLANDS,                    ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_VANUATU,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_WORLD,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_ZAMBIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_ENGLISH_ZIMBABWE,
    wxLANGUAGE_ESPERANTO,
    wxLANGUAGE_ESPERANTO_WORLD,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_ESTONIAN,
    wxLANGUAGE_ESTONIAN_ESTONIA,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_EWE,                                          ///< @since_wx{3.1.6}
    wxLANGUAGE_EWE_GHANA,                                    ///< @since_wx{3.1.6}
    wxLANGUAGE_EWE_TOGO,                                     ///< @since_wx{3.1.6}
    wxLANGUAGE_EWONDO,                                       ///< @since_wx{3.1.6}
    wxLANGUAGE_EWONDO_CAMEROON,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_FAEROESE,
    wxLANGUAGE_FAEROESE_DENMARK,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_FAEROESE_FAROE_ISLANDS,                       ///< @since_wx{3.1.6}
    wxLANGUAGE_FIJI,
    wxLANGUAGE_FILIPINO,                                     ///< @since_wx{3.1.6}
    wxLANGUAGE_FILIPINO_PHILIPPINES,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_FINNISH,
    wxLANGUAGE_FINNISH_FINLAND,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH,
    wxLANGUAGE_FRENCH_ALGERIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_BELGIAN,
    wxLANGUAGE_FRENCH_BENIN,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_BURKINA_FASO,                          ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_BURUNDI,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_CAMEROON,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_CANADIAN,
    wxLANGUAGE_FRENCH_CARIBBEAN,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_CENTRAL_AFRICAN_REPUBLIC,              ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_CHAD,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_COMOROS,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_CONGO,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_CONGO_DRC,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_COTE_DIVOIRE,                          ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_DJIBOUTI,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_EQUATORIAL_GUINEA,                     ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_FRANCE,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_FRENCH_GUIANA,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_FRENCH_POLYNESIA,                      ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_GABON,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_GUADELOUPE,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_GUINEA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_HAITI,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_LUXEMBOURG,
    wxLANGUAGE_FRENCH_MADAGASCAR,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_MALI,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_MARTINIQUE,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_MAURITANIA,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_MAURITIUS,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_MAYOTTE,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_MONACO,
    wxLANGUAGE_FRENCH_MOROCCO,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_NEW_CALEDONIA,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_NIGER,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_REUNION,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_RWANDA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_SENEGAL,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_SEYCHELLES,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_ST_BARTHELEMY,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_ST_MARTIN,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_ST_PIERRE_AND_MIQUELON,                ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_SWISS,
    wxLANGUAGE_FRENCH_SYRIA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_TOGO,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_TUNISIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_VANUATU,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_FRENCH_WALLIS_AND_FUTUNA,                     ///< @since_wx{3.1.6}
    wxLANGUAGE_FRISIAN,
    wxLANGUAGE_FRISIAN_NETHERLANDS,                          ///< @since_wx{3.1.6}
    wxLANGUAGE_FRIULIAN,                                     ///< @since_wx{3.1.6}
    wxLANGUAGE_FRIULIAN_ITALY,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_FULAH,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_FULAH_ADLAM,                                  ///< @since_wx{3.3.0}
    wxLANGUAGE_FULAH_ADLAM_BURKINA_FASO,                     ///< @since_wx{3.3.0}
    wxLANGUAGE_FULAH_ADLAM_CAMEROON,                         ///< @since_wx{3.3.0}
    wxLANGUAGE_FULAH_ADLAM_GAMBIA,                           ///< @since_wx{3.3.0}
    wxLANGUAGE_FULAH_ADLAM_GHANA,                            ///< @since_wx{3.3.0}
    wxLANGUAGE_FULAH_ADLAM_GUINEA,                           ///< @since_wx{3.3.0}
    wxLANGUAGE_FULAH_ADLAM_GUINEA_BISSAU,                    ///< @since_wx{3.3.0}
    wxLANGUAGE_FULAH_ADLAM_LIBERIA,                          ///< @since_wx{3.3.0}
    wxLANGUAGE_FULAH_ADLAM_MAURITANIA,                       ///< @since_wx{3.3.0}
    wxLANGUAGE_FULAH_ADLAM_NIGER,                            ///< @since_wx{3.3.0}
    wxLANGUAGE_FULAH_ADLAM_NIGERIA,                          ///< @since_wx{3.3.0}
    wxLANGUAGE_FULAH_ADLAM_SENEGAL,                          ///< @since_wx{3.3.0}
    wxLANGUAGE_FULAH_ADLAM_SIERRA_LEONE,                     ///< @since_wx{3.3.0}
    wxLANGUAGE_FULAH_LATIN,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_FULAH_LATIN_BURKINA_FASO,                     ///< @since_wx{3.1.6}
    wxLANGUAGE_FULAH_LATIN_CAMEROON,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_FULAH_LATIN_GAMBIA,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_FULAH_LATIN_GHANA,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_FULAH_LATIN_GUINEA,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_FULAH_LATIN_GUINEA_BISSAU,                    ///< @since_wx{3.1.6}
    wxLANGUAGE_FULAH_LATIN_LIBERIA,                          ///< @since_wx{3.1.6}
    wxLANGUAGE_FULAH_LATIN_MAURITANIA,                       ///< @since_wx{3.1.6}
    wxLANGUAGE_FULAH_LATIN_NIGER,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_FULAH_LATIN_NIGERIA,                          ///< @since_wx{3.1.6}
    wxLANGUAGE_FULAH_LATIN_SENEGAL,                          ///< @since_wx{3.1.6}
    wxLANGUAGE_FULAH_LATIN_SIERRA_LEONE,                     ///< @since_wx{3.1.6}
    wxLANGUAGE_GALICIAN,
    wxLANGUAGE_GALICIAN_SPAIN,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_GANDA,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_GANDA_UGANDA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_GEORGIAN,
    wxLANGUAGE_GEORGIAN_GEORGIA,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_GERMAN,
    wxLANGUAGE_GERMAN_AUSTRIAN,
    wxLANGUAGE_GERMAN_BELGIUM,
    wxLANGUAGE_GERMAN_GERMANY,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_GERMAN_ITALY,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_GERMAN_LIECHTENSTEIN,
    wxLANGUAGE_GERMAN_LUXEMBOURG,
    wxLANGUAGE_GERMAN_SWISS,
    wxLANGUAGE_GREEK,
    wxLANGUAGE_GREEK_CYPRUS,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_GREEK_GREECE,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_GUARANI,
    wxLANGUAGE_GUARANI_PARAGUAY,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_GUJARATI,
    wxLANGUAGE_GUJARATI_INDIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_GUSII,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_GUSII_KENYA,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_HAUSA,
    wxLANGUAGE_HAUSA_LATIN,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_HAUSA_LATIN_GHANA,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_HAUSA_LATIN_NIGER,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_HAUSA_LATIN_NIGERIA,                          ///< @since_wx{3.1.6}
    wxLANGUAGE_HAWAIIAN,                                     ///< @since_wx{3.1.6}
    wxLANGUAGE_HAWAIIAN_US,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_HEBREW,
    wxLANGUAGE_HEBREW_ISRAEL,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_HINDI,
    wxLANGUAGE_HINDI_INDIA,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_HUNGARIAN,
    wxLANGUAGE_HUNGARIAN_HUNGARY,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_IBIBIO,                                       ///< @since_wx{3.1.6}
    wxLANGUAGE_IBIBIO_NIGERIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_ICELANDIC,
    wxLANGUAGE_ICELANDIC_ICELAND,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_IGBO,                                         ///< @since_wx{3.1.6}
    wxLANGUAGE_IGBO_NIGERIA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_INDONESIAN,
    wxLANGUAGE_INDONESIAN_INDONESIA,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_INTERLINGUA,
    wxLANGUAGE_INTERLINGUA_WORLD,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_INTERLINGUE,
    wxLANGUAGE_INUKTITUT,
    wxLANGUAGE_INUKTITUT_LATIN,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_INUKTITUT_LATIN_CANADA,                       ///< @since_wx{3.1.6}
    wxLANGUAGE_INUKTITUT_SYLLABICS,                          ///< @since_wx{3.1.6}
    wxLANGUAGE_INUKTITUT_SYLLABICS_CANADA,                   ///< @since_wx{3.1.6}
    wxLANGUAGE_INUPIAK,
    wxLANGUAGE_IRISH,
    wxLANGUAGE_IRISH_IRELAND,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_IRISH_UNITED_KINGDOM,                         ///< @since_wx{3.3.0}
    wxLANGUAGE_ITALIAN,
    wxLANGUAGE_ITALIAN_ITALY,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_ITALIAN_SAN_MARINO,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_ITALIAN_SWISS,
    wxLANGUAGE_ITALIAN_VATICAN_CITY,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_JAPANESE,
    wxLANGUAGE_JAPANESE_JAPAN,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_JAVANESE,
    wxLANGUAGE_JAVANESE_JAVANESE,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_JAVANESE_JAVANESE_INDONESIA,                  ///< @since_wx{3.1.6}
    wxLANGUAGE_JAVANESE_LATIN,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_JAVANESE_LATIN_INDONESIA,                     ///< @since_wx{3.1.6}
    wxLANGUAGE_JOLA_FONYI,                                   ///< @since_wx{3.1.6}
    wxLANGUAGE_JOLA_FONYI_SENEGAL,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_KABUVERDIANU,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_KABUVERDIANU_CABO_VERDE,                      ///< @since_wx{3.1.6}
    wxLANGUAGE_KABYLE,                                       ///< @since_wx{3.0.2}
    wxLANGUAGE_KABYLE_ALGERIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_KAKO,                                         ///< @since_wx{3.1.6}
    wxLANGUAGE_KAKO_CAMEROON,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_KALAALLISUT,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_KALAALLISUT_GREENLAND,
    wxLANGUAGE_KALENJIN,                                     ///< @since_wx{3.1.6}
    wxLANGUAGE_KALENJIN_KENYA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_KAMBA,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_KAMBA_KENYA,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_KANNADA,
    wxLANGUAGE_KANNADA_INDIA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_KANURI,                                       ///< @since_wx{3.1.6}
    wxLANGUAGE_KANURI_LATIN,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_KANURI_LATIN_NIGERIA,                         ///< @since_wx{3.3.0}
    wxLANGUAGE_KASHMIRI,
    wxLANGUAGE_KASHMIRI_ARABIC,                              ///< @since_wx{3.3.0}
    wxLANGUAGE_KASHMIRI_ARABIC_INDIA,                        ///< @since_wx{3.3.0}
    wxLANGUAGE_KASHMIRI_DEVANAGARI,                          ///< @since_wx{3.1.6}
    wxLANGUAGE_KASHMIRI_DEVANAGARI_INDIA,                    ///< @since_wx{3.1.6}
    wxLANGUAGE_KASHMIRI_INDIA,
    wxLANGUAGE_KAZAKH,
    wxLANGUAGE_KAZAKH_KAZAKHSTAN,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_KHMER,
    wxLANGUAGE_KHMER_CAMBODIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_KICHE,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_KICHE_LATIN,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_KICHE_LATIN_GUATEMALA,                        ///< @since_wx{3.1.6}
    wxLANGUAGE_KIKUYU,                                       ///< @since_wx{3.1.6}
    wxLANGUAGE_KIKUYU_KENYA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_KINYARWANDA,
    wxLANGUAGE_KINYARWANDA_RWANDA,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_KIRGHIZ,
    wxLANGUAGE_KIRGHIZ_KYRGYZSTAN,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_KIRUNDI,
    wxLANGUAGE_KIRUNDI_BURUNDI,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_KONKANI,
    wxLANGUAGE_KONKANI_INDIA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_KOREAN,
    wxLANGUAGE_KOREAN_KOREA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_KOREAN_NORTH_KOREA,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_KOYRABORO_SENNI,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_KOYRABORO_SENNI_MALI,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_KOYRA_CHIINI,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_KOYRA_CHIINI_MALI,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_KURDISH,
    wxLANGUAGE_KURDISH_ARABIC_IRAN,                          ///< @since_wx{3.3.0}
    wxLANGUAGE_KWASIO,                                       ///< @since_wx{3.1.6}
    wxLANGUAGE_KWASIO_CAMEROON,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_LAKOTA,                                       ///< @since_wx{3.1.6}
    wxLANGUAGE_LAKOTA_US,                                    ///< @since_wx{3.1.6}
    wxLANGUAGE_LANGI,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_LANGI_TANZANIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_LAOTHIAN,
    wxLANGUAGE_LAOTHIAN_LAOS,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_LATIN,
    wxLANGUAGE_LATIN_VATICAN_CITY,                           ///< @since_wx{3.3.0}
    wxLANGUAGE_LATIN_WORLD,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_LATVIAN,
    wxLANGUAGE_LATVIAN_LATVIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_LINGALA,
    wxLANGUAGE_LINGALA_ANGOLA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_LINGALA_CENTRAL_AFRICAN_REPUBLIC,             ///< @since_wx{3.1.6}
    wxLANGUAGE_LINGALA_CONGO,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_LINGALA_CONGO_DRC,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_LITHUANIAN,
    wxLANGUAGE_LITHUANIAN_LITHUANIA,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_LOWER_SORBIAN,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_LOWER_SORBIAN_GERMANY,                        ///< @since_wx{3.1.6}
    wxLANGUAGE_LOW_GERMAN,                                   ///< @since_wx{3.1.6}
    wxLANGUAGE_LOW_GERMAN_GERMANY,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_LOW_GERMAN_NETHERLANDS,                       ///< @since_wx{3.1.6}
    wxLANGUAGE_LUBA_KATANGA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_LUBA_KATANGA_CONGO_DRC,                       ///< @since_wx{3.1.6}
    wxLANGUAGE_LUO,                                          ///< @since_wx{3.1.6}
    wxLANGUAGE_LUO_KENYA,                                    ///< @since_wx{3.1.6}
    wxLANGUAGE_LUXEMBOURGISH,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_LUXEMBOURGISH_LUXEMBOURG,                     ///< @since_wx{3.1.6}
    wxLANGUAGE_LUYIA,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_LUYIA_KENYA,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_MACEDONIAN,
    wxLANGUAGE_MACEDONIAN_NORTH_MACEDONIA,                   ///< @since_wx{3.1.6}
    wxLANGUAGE_MACHAME,                                      ///< @since_wx{3.1.6}
    wxLANGUAGE_MACHAME_TANZANIA,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_MAITHILI,                                     ///< @since_wx{3.3.0}
    wxLANGUAGE_MAITHILI_INDIA,                               ///< @since_wx{3.3.0}
    wxLANGUAGE_MAKHUWA_MEETTO,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_MAKHUWA_MEETTO_MOZAMBIQUE,                    ///< @since_wx{3.1.6}
    wxLANGUAGE_MAKONDE,                                      ///< @since_wx{3.1.6}
    wxLANGUAGE_MAKONDE_TANZANIA,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_MALAGASY,
    wxLANGUAGE_MALAGASY_MADAGASCAR,                          ///< @since_wx{3.1.6}
    wxLANGUAGE_MALAY,
    wxLANGUAGE_MALAYALAM,
    wxLANGUAGE_MALAYALAM_INDIA,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_MALAY_BRUNEI,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_MALAY_INDONESIA,                              ///< @since_wx{3.3.0}
    wxLANGUAGE_MALAY_MALAYSIA,
    wxLANGUAGE_MALAY_SINGAPORE,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_MALTESE,
    wxLANGUAGE_MALTESE_MALTA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_MANIPURI,
    wxLANGUAGE_MANIPURI_BENGALI,                             ///< @since_wx{3.3.0}
    wxLANGUAGE_MANIPURI_INDIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_MANX,                                         ///< @since_wx{3.1.6}
    wxLANGUAGE_MANX_ISLE_OF_MAN,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_MAORI,
    wxLANGUAGE_MAORI_NEW_ZEALAND,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_MAPUCHE,                                      ///< @since_wx{3.1.6}
    wxLANGUAGE_MAPUCHE_CHILE,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_MARATHI,
    wxLANGUAGE_MARATHI_INDIA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_MASAI,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_MASAI_KENYA,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_MASAI_TANZANIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_MAZANDERANI,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_MAZANDERANI_IRAN,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_MERU,                                         ///< @since_wx{3.1.6}
    wxLANGUAGE_MERU_KENYA,                                   ///< @since_wx{3.1.6}
    wxLANGUAGE_META,                                         ///< @since_wx{3.1.6}
    wxLANGUAGE_META_CAMEROON,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_MOHAWK,                                       ///< @since_wx{3.1.6}
    wxLANGUAGE_MOHAWK_CANADA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_MOLDAVIAN,
    wxLANGUAGE_MONGOLIAN,
    wxLANGUAGE_MONGOLIAN_CYRILLIC,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_MONGOLIAN_MONGOLIA,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_MONGOLIAN_TRADITIONAL,                        ///< @since_wx{3.1.6}
    wxLANGUAGE_MONGOLIAN_TRADITIONAL_CHINA,                  ///< @since_wx{3.1.6}
    wxLANGUAGE_MONGOLIAN_TRADITIONAL_MONGOLIA,               ///< @since_wx{3.1.6}
    wxLANGUAGE_MORISYEN,                                     ///< @since_wx{3.1.6}
    wxLANGUAGE_MORISYEN_MAURITIUS,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_MUNDANG,                                      ///< @since_wx{3.1.6}
    wxLANGUAGE_MUNDANG_CAMEROON,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_NAMA,                                         ///< @since_wx{3.1.6}
    wxLANGUAGE_NAMA_NAMIBIA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_NAURU,
    wxLANGUAGE_NEPALI,
    wxLANGUAGE_NEPALI_INDIA,
    wxLANGUAGE_NEPALI_NEPAL,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_NGIEMBOON,                                    ///< @since_wx{3.1.6}
    wxLANGUAGE_NGIEMBOON_CAMEROON,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_NGOMBA,                                       ///< @since_wx{3.1.6}
    wxLANGUAGE_NGOMBA_CAMEROON,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_NIGERIAN_PIDGIN,                              ///< @since_wx{3.3.0}
    wxLANGUAGE_NIGERIAN_PIDGIN_LATIN,                        ///< @since_wx{3.3.0}
    wxLANGUAGE_NIGERIAN_PIDGIN_LATIN_NIGERIA,                ///< @since_wx{3.3.0}
    wxLANGUAGE_NKO,                                          ///< @since_wx{3.1.6}
    wxLANGUAGE_NKO_GUINEA,                                   ///< @since_wx{3.1.6}
    wxLANGUAGE_NORTHERN_LURI,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_NORTHERN_LURI_IRAN,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_NORTHERN_LURI_IRAQ,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_NORTH_NDEBELE,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_NORTH_NDEBELE_ZIMBABWE,                       ///< @since_wx{3.1.6}
    wxLANGUAGE_NORWEGIAN,                                    ///< @since_wx{3.1.6}
    wxLANGUAGE_NORWEGIAN_BOKMAL,
    wxLANGUAGE_NORWEGIAN_BOKMAL_NORWAY,                      ///< @since_wx{3.1.6}
    wxLANGUAGE_NORWEGIAN_BOKMAL_SVALBARD_AND_JAN_MAYEN,      ///< @since_wx{3.1.6}
    wxLANGUAGE_NORWEGIAN_NYNORSK,
    wxLANGUAGE_NORWEGIAN_NYNORSK_NORWAY,                     ///< @since_wx{3.1.6}
    wxLANGUAGE_NUER,                                         ///< @since_wx{3.1.6}
    wxLANGUAGE_NUER_SOUTH_SUDAN,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_NYANKOLE,                                     ///< @since_wx{3.1.6}
    wxLANGUAGE_NYANKOLE_UGANDA,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_OCCITAN,
    wxLANGUAGE_OCCITAN_FRANCE,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_ODIA,                                         ///< @since_wx{3.1.6}
    wxLANGUAGE_ODIA_INDIA,                                   ///< @since_wx{3.1.6}
    wxLANGUAGE_OROMO,
    wxLANGUAGE_OROMO_ETHIOPIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_OROMO_KENYA,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_OSSETIC,                                      ///< @since_wx{3.1.6}
    wxLANGUAGE_OSSETIC_GEORGIA,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_OSSETIC_RUSSIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_PAPIAMENTO,                                   ///< @since_wx{3.1.6}
    wxLANGUAGE_PAPIAMENTO_CARIBBEAN,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_PASHTO,
    wxLANGUAGE_PASHTO_AFGHANISTAN,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_PASHTO_PAKISTAN,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_PERSIAN,
    wxLANGUAGE_PERSIAN_AFGHANISTAN,                          ///< @since_wx{3.3.0}
    wxLANGUAGE_PERSIAN_IRAN,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_POLISH,
    wxLANGUAGE_POLISH_POLAND,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_PORTUGUESE,
    wxLANGUAGE_PORTUGUESE_ANGOLA,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_PORTUGUESE_BRAZILIAN,
    wxLANGUAGE_PORTUGUESE_CABO_VERDE,                        ///< @since_wx{3.1.6}
    wxLANGUAGE_PORTUGUESE_EQUATORIAL_GUINEA,                 ///< @since_wx{3.1.6}
    wxLANGUAGE_PORTUGUESE_GUINEA_BISSAU,                     ///< @since_wx{3.1.6}
    wxLANGUAGE_PORTUGUESE_LUXEMBOURG,                        ///< @since_wx{3.1.6}
    wxLANGUAGE_PORTUGUESE_MACAO_SAR,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_PORTUGUESE_MOZAMBIQUE,                        ///< @since_wx{3.1.6}
    wxLANGUAGE_PORTUGUESE_PORTUGAL,                          ///< @since_wx{3.1.6}
    wxLANGUAGE_PORTUGUESE_SAO_TOME_AND_PRINCIPE,             ///< @since_wx{3.1.6}
    wxLANGUAGE_PORTUGUESE_SWITZERLAND,                       ///< @since_wx{3.1.6}
    wxLANGUAGE_PORTUGUESE_TIMOR_LESTE,                       ///< @since_wx{3.1.6}
    wxLANGUAGE_PRUSSIAN,                                     ///< @since_wx{3.1.6}
    wxLANGUAGE_PRUSSIAN_WORLD,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_PUNJABI,
    wxLANGUAGE_PUNJABI_ARABIC,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_PUNJABI_GURMUKHI,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_PUNJABI_INDIA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_PUNJABI_PAKISTAN,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_QUECHUA,
    wxLANGUAGE_QUECHUA_BOLIVIA,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_QUECHUA_ECUADOR,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_QUECHUA_MACRO,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_QUECHUA_PERU,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_RHAETO_ROMANCE,
    wxLANGUAGE_RHAETO_ROMANCE_SWITZERLAND,                   ///< @since_wx{3.1.6}
    wxLANGUAGE_ROMANIAN,
    wxLANGUAGE_ROMANIAN_MOLDOVA,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_ROMANIAN_ROMANIA,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_ROMBO,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_ROMBO_TANZANIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_RUSSIAN,
    wxLANGUAGE_RUSSIAN_BELARUS,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_RUSSIAN_KAZAKHSTAN,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_RUSSIAN_KYRGYZSTAN,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_RUSSIAN_MOLDOVA,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_RUSSIAN_RUSSIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_RUSSIAN_UKRAINE,
    wxLANGUAGE_RWA,                                          ///< @since_wx{3.1.6}
    wxLANGUAGE_RWA_TANZANIA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_SAHO,                                         ///< @since_wx{3.1.6}
    wxLANGUAGE_SAHO_ERITREA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_SAKHA,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_SAKHA_RUSSIA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_SAMBURU,                                      ///< @since_wx{3.1.6}
    wxLANGUAGE_SAMBURU_KENYA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_SAMI,                                         ///< @since_wx{2.8.8}
    wxLANGUAGE_SAMI_FINLAND,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_SAMI_INARI,                                   ///< @since_wx{3.1.6}
    wxLANGUAGE_SAMI_INARI_FINLAND,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_SAMI_LULE,                                    ///< @since_wx{3.1.6}
    wxLANGUAGE_SAMI_LULE_NORWAY,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_SAMI_LULE_SWEDEN,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_SAMI_NORWAY,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_SAMI_SKOLT,                                   ///< @since_wx{3.1.6}
    wxLANGUAGE_SAMI_SKOLT_FINLAND,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_SAMI_SOUTHERN,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_SAMI_SOUTHERN_NORWAY,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_SAMI_SOUTHERN_SWEDEN,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_SAMI_SWEDEN,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_SAMOAN,
    wxLANGUAGE_SANGHO,
    wxLANGUAGE_SANGHO_CENTRAL_AFRICAN_REPUBLIC,              ///< @since_wx{3.1.6}
    wxLANGUAGE_SANGU,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_SANGU_TANZANIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_SANSKRIT,
    wxLANGUAGE_SANSKRIT_INDIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_SANTALI,                                      ///< @since_wx{3.3.0}
    wxLANGUAGE_SANTALI_OL_CHIKI,                             ///< @since_wx{3.3.0}
    wxLANGUAGE_SANTALI_OL_CHIKI_INDIA,                       ///< @since_wx{3.3.0}
    wxLANGUAGE_SCOTS_GAELIC,
    wxLANGUAGE_SCOTS_GAELIC_UK,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_SENA,                                         ///< @since_wx{3.1.6}
    wxLANGUAGE_SENA_MOZAMBIQUE,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_SERBIAN,
    wxLANGUAGE_SERBIAN_CYRILLIC,
    wxLANGUAGE_SERBIAN_CYRILLIC_BOSNIA_AND_HERZEGOVINA,      ///< @since_wx{3.1.6}
    wxLANGUAGE_SERBIAN_CYRILLIC_KOSOVO,                      ///< @since_wx{3.1.6}
    wxLANGUAGE_SERBIAN_CYRILLIC_MONTENEGRO,                  ///< @since_wx{3.1.6}
    wxLANGUAGE_SERBIAN_CYRILLIC_SERBIA,                      ///< @since_wx{3.1.6}
    wxLANGUAGE_SERBIAN_CYRILLIC_YU,
    wxLANGUAGE_SERBIAN_LATIN,
    wxLANGUAGE_SERBIAN_LATIN_BOSNIA_AND_HERZEGOVINA,         ///< @since_wx{3.1.6}
    wxLANGUAGE_SERBIAN_LATIN_KOSOVO,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_SERBIAN_LATIN_MONTENEGRO,                     ///< @since_wx{3.1.6}
    wxLANGUAGE_SERBIAN_LATIN_SERBIA,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_SERBIAN_LATIN_YU,
    wxLANGUAGE_SERBIAN_SERBIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_SERBIAN_YU,                                   ///< @since_wx{3.1.6}
    wxLANGUAGE_SERBO_CROATIAN,
    wxLANGUAGE_SESOTHO,
    wxLANGUAGE_SESOTHO_LESOTHO,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_SESOTHO_SA_LEBOA,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_SESOTHO_SA_LEBOA_SOUTH_AFRICA,                ///< @since_wx{3.1.6}
    wxLANGUAGE_SESOTHO_SOUTH_AFRICA,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_SETSWANA,
    wxLANGUAGE_SETSWANA_BOTSWANA,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_SETSWANA_SOUTH_AFRICA,                        ///< @since_wx{3.1.6}
    wxLANGUAGE_SHAMBALA,                                     ///< @since_wx{3.1.6}
    wxLANGUAGE_SHAMBALA_TANZANIA,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_SHONA,
    wxLANGUAGE_SHONA_LATIN,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_SHONA_LATIN_ZIMBABWE,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_SINDHI,
    wxLANGUAGE_SINDHI_ARABIC,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_SINDHI_DEVANAGARI,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_SINDHI_DEVANAGARI_INDIA,                      ///< @since_wx{3.1.6}
    wxLANGUAGE_SINDHI_PAKISTAN,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_SINHALESE,
    wxLANGUAGE_SINHALESE_SRI_LANKA,                          ///< @since_wx{3.1.6}
    wxLANGUAGE_SISWATI,
    wxLANGUAGE_SISWATI_ESWATINI,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_SISWATI_SOUTH_AFRICA,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_SLOVAK,
    wxLANGUAGE_SLOVAK_SLOVAKIA,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_SLOVENIAN,
    wxLANGUAGE_SLOVENIAN_SLOVENIA,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_SOGA,                                         ///< @since_wx{3.1.6}
    wxLANGUAGE_SOGA_UGANDA,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_SOMALI,
    wxLANGUAGE_SOMALI_DJIBOUTI,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_SOMALI_ETHIOPIA,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_SOMALI_KENYA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_SOMALI_SOMALIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_SOUTH_NDEBELE,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_SOUTH_NDEBELE_SOUTH_AFRICA,                   ///< @since_wx{3.1.6}
    wxLANGUAGE_SPANISH,
    wxLANGUAGE_SPANISH_ARGENTINA,
    wxLANGUAGE_SPANISH_BELIZE,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_SPANISH_BOLIVIA,
    wxLANGUAGE_SPANISH_BRAZIL,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_SPANISH_CHILE,
    wxLANGUAGE_SPANISH_COLOMBIA,
    wxLANGUAGE_SPANISH_COSTA_RICA,
    wxLANGUAGE_SPANISH_CUBA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_SPANISH_DOMINICAN_REPUBLIC,
    wxLANGUAGE_SPANISH_ECUADOR,
    wxLANGUAGE_SPANISH_EL_SALVADOR,
    wxLANGUAGE_SPANISH_EQUATORIAL_GUINEA,                    ///< @since_wx{3.1.6}
    wxLANGUAGE_SPANISH_GUATEMALA,
    wxLANGUAGE_SPANISH_HONDURAS,
    wxLANGUAGE_SPANISH_LATIN_AMERICA,                        ///< @since_wx{3.1.6}
    wxLANGUAGE_SPANISH_MEXICAN,
    wxLANGUAGE_SPANISH_NICARAGUA,
    wxLANGUAGE_SPANISH_PANAMA,
    wxLANGUAGE_SPANISH_PARAGUAY,
    wxLANGUAGE_SPANISH_PERU,
    wxLANGUAGE_SPANISH_PHILIPPINES,                          ///< @since_wx{3.1.6}
    wxLANGUAGE_SPANISH_PUERTO_RICO,
    wxLANGUAGE_SPANISH_SPAIN,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_SPANISH_URUGUAY,
    wxLANGUAGE_SPANISH_US,
    wxLANGUAGE_SPANISH_VENEZUELA,
    wxLANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT,                  ///< @since_wx{3.1.6}
    wxLANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT_TIFINAGH,         ///< @since_wx{3.1.6}
    wxLANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT_TIFINAGH_MOROCCO, ///< @since_wx{3.1.6}
    wxLANGUAGE_SUNDANESE,
    wxLANGUAGE_SUNDANESE_LATIN,                              ///< @since_wx{3.3.0}
    wxLANGUAGE_SUNDANESE_LATIN_INDONESIA,                    ///< @since_wx{3.3.0}
    wxLANGUAGE_SWAHILI,
    wxLANGUAGE_SWAHILI_CONGO_DRC,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_SWAHILI_KENYA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_SWAHILI_TANZANIA,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_SWAHILI_UGANDA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_SWEDISH,
    wxLANGUAGE_SWEDISH_ALAND_ISLANDS,                        ///< @since_wx{3.1.6}
    wxLANGUAGE_SWEDISH_FINLAND,
    wxLANGUAGE_SWEDISH_SWEDEN,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_SWISS_GERMAN,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_SWISS_GERMAN_LIECHTENSTEIN,                   ///< @since_wx{3.1.6}
    wxLANGUAGE_SWISS_GERMAN_SWITZERLAND,                     ///< @since_wx{3.1.6}
    wxLANGUAGE_SYRIAC,                                       ///< @since_wx{3.1.6}
    wxLANGUAGE_SYRIAC_SYRIA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_TACHELHIT,                                    ///< @since_wx{3.1.6}
    wxLANGUAGE_TACHELHIT_LATIN,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_TACHELHIT_LATIN_MOROCCO,                      ///< @since_wx{3.1.6}
    wxLANGUAGE_TACHELHIT_TIFINAGH,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_TACHELHIT_TIFINAGH_MOROCCO,                   ///< @since_wx{3.1.6}
    wxLANGUAGE_TAGALOG,                                      ///< @since_wx{3.3.0}
    wxLANGUAGE_TAGALOG_PHILIPPINES,
    wxLANGUAGE_TAITA,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_TAITA_KENYA,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_TAJIK,
    wxLANGUAGE_TAJIK_CYRILLIC,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_TAJIK_CYRILLIC_TAJIKISTAN,                    ///< @since_wx{3.1.6}
    wxLANGUAGE_TAMIL,
    wxLANGUAGE_TAMIL_INDIA,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_TAMIL_MALAYSIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_TAMIL_SINGAPORE,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_TAMIL_SRI_LANKA,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_TASAWAQ,                                      ///< @since_wx{3.1.6}
    wxLANGUAGE_TASAWAQ_NIGER,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_TATAR,
    wxLANGUAGE_TATAR_RUSSIA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_TELUGU,
    wxLANGUAGE_TELUGU_INDIA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_TESO,                                         ///< @since_wx{3.1.6}
    wxLANGUAGE_TESO_KENYA,                                   ///< @since_wx{3.1.6}
    wxLANGUAGE_TESO_UGANDA,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_THAI,
    wxLANGUAGE_THAI_THAILAND,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_TIBETAN,
    wxLANGUAGE_TIBETAN_CHINA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_TIBETAN_INDIA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_TIGRE,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_TIGRE_ERITREA,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_TIGRINYA,
    wxLANGUAGE_TIGRINYA_ERITREA,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_TIGRINYA_ETHIOPIA,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_TONGA,
    wxLANGUAGE_TONGA_TONGA,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_TSONGA,
    wxLANGUAGE_TSONGA_SOUTH_AFRICA,                          ///< @since_wx{3.1.6}
    wxLANGUAGE_TURKISH,
    wxLANGUAGE_TURKISH_CYPRUS,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_TURKISH_TURKIYE,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_TURKMEN,
    wxLANGUAGE_TURKMEN_TURKMENISTAN,                         ///< @since_wx{3.1.6}
    wxLANGUAGE_TWI,
    wxLANGUAGE_UIGHUR,
    wxLANGUAGE_UIGHUR_CHINA,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_UKRAINIAN,
    wxLANGUAGE_UKRAINIAN_UKRAINE,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_UPPER_SORBIAN,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_UPPER_SORBIAN_GERMANY,                        ///< @since_wx{3.1.6}
    wxLANGUAGE_URDU,
    wxLANGUAGE_URDU_INDIA,
    wxLANGUAGE_URDU_PAKISTAN,
    wxLANGUAGE_UZBEK,
    wxLANGUAGE_UZBEK_ARABIC,                                 ///< @since_wx{3.3.0}
    wxLANGUAGE_UZBEK_ARABIC_AFGHANISTAN,                     ///< @since_wx{3.3.0}
    wxLANGUAGE_UZBEK_CYRILLIC,
    wxLANGUAGE_UZBEK_CYRILLIC_UZBEKISTAN,                    ///< @since_wx{3.1.6}
    wxLANGUAGE_UZBEK_LATIN,
    wxLANGUAGE_UZBEK_LATIN_UZBEKISTAN,                       ///< @since_wx{3.1.6}
    wxLANGUAGE_VAI,                                          ///< @since_wx{3.1.6}
    wxLANGUAGE_VAI_LATIN,                                    ///< @since_wx{3.1.6}
    wxLANGUAGE_VAI_LATIN_LIBERIA,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_VAI_VAI,                                      ///< @since_wx{3.1.6}
    wxLANGUAGE_VAI_VAI_LIBERIA,                              ///< @since_wx{3.1.6}
    wxLANGUAGE_VALENCIAN,                                    ///< @since_wx{2.8.8}
    wxLANGUAGE_VENDA,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_VENDA_SOUTH_AFRICA,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_VIETNAMESE,
    wxLANGUAGE_VIETNAMESE_VIETNAM,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_VOLAPUK,
    wxLANGUAGE_VOLAPUK_WORLD,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_VUNJO,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_VUNJO_TANZANIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_WALSER,                                       ///< @since_wx{3.1.6}
    wxLANGUAGE_WALSER_SWITZERLAND,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_WELSH,
    wxLANGUAGE_WELSH_UK,                                     ///< @since_wx{3.1.6}
    wxLANGUAGE_WOLAYTTA,                                     ///< @since_wx{3.1.6}
    wxLANGUAGE_WOLAYTTA_ETHIOPIA,                            ///< @since_wx{3.1.6}
    wxLANGUAGE_WOLOF,
    wxLANGUAGE_WOLOF_SENEGAL,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_XHOSA,
    wxLANGUAGE_XHOSA_SOUTH_AFRICA,                           ///< @since_wx{3.1.6}
    wxLANGUAGE_YANGBEN,                                      ///< @since_wx{3.1.6}
    wxLANGUAGE_YANGBEN_CAMEROON,                             ///< @since_wx{3.1.6}
    wxLANGUAGE_YI,                                           ///< @since_wx{3.1.6}
    wxLANGUAGE_YIDDISH,
    wxLANGUAGE_YIDDISH_WORLD,                                ///< @since_wx{3.1.6}
    wxLANGUAGE_YI_CHINA,                                     ///< @since_wx{3.1.6}
    wxLANGUAGE_YORUBA,
    wxLANGUAGE_YORUBA_BENIN,                                 ///< @since_wx{3.1.6}
    wxLANGUAGE_YORUBA_NIGERIA,                               ///< @since_wx{3.1.6}
    wxLANGUAGE_ZARMA,                                        ///< @since_wx{3.1.6}
    wxLANGUAGE_ZARMA_NIGER,                                  ///< @since_wx{3.1.6}
    wxLANGUAGE_ZHUANG,
    wxLANGUAGE_ZULU,
    wxLANGUAGE_ZULU_SOUTH_AFRICA,                            ///< @since_wx{3.1.6}

    /// For custom, user-defined languages.
    wxLANGUAGE_USER_DEFINED,

    wxLANGUAGE_AZERI,                          ///< Synonym for wxLANGUAGE_AZERBAIJANI.
    wxLANGUAGE_AZERI_CYRILLIC,                 ///< Synonym for wxLANGUAGE_AZERBAIJANI_CYRILLIC.
    wxLANGUAGE_AZERI_LATIN,                    ///< Synonym for wxLANGUAGE_AZERBAIJANI_LATIN.
    wxLANGUAGE_BENGALI,                        ///< Synonym for wxLANGUAGE_BANGLA.
    wxLANGUAGE_BENGALI_BANGLADESH,             ///< Synonym for wxLANGUAGE_BANGLA_BANGLADESH.
    wxLANGUAGE_BENGALI_INDIA,                  ///< Synonym for wxLANGUAGE_BANGLA_INDIA.
    wxLANGUAGE_BHUTANI,                        ///< Synonym for wxLANGUAGE_DZONGKHA.
    wxLANGUAGE_CAMBODIAN,                      ///< Synonym for wxLANGUAGE_KHMER.
    wxLANGUAGE_CHINESE_MACAU,                  ///< Synonym for wxLANGUAGE_CHINESE_MACAO.
    wxLANGUAGE_CHINESE_SIMPLIFIED,             ///< Synonym for wxLANGUAGE_CHINESE_CHINA.
    wxLANGUAGE_CHINESE_TRADITIONAL,            ///< Synonym for wxLANGUAGE_CHINESE_TAIWAN.
    wxLANGUAGE_DARI,                           ///< Synonym for wxLANGUAGE_PERSIAN. @since_wx{3.1.6}
    wxLANGUAGE_DARI_AFGHANISTAN,               ///< Synonym for wxLANGUAGE_PERSIAN_AFGHANISTAN. @since_wx{3.1.6}
    wxLANGUAGE_FARSI,                          ///< Synonym for wxLANGUAGE_PERSIAN.
    wxLANGUAGE_GREENLANDIC,                    ///< Synonym for wxLANGUAGE_KALAALLISUT_GREENLAND.
    wxLANGUAGE_KANURI_NIGERIA,                 ///< Synonym for wxLANGUAGE_KANURI_LATIN_NIGERIA.
    wxLANGUAGE_KASHMIRI_PERSO_ARABIC,          ///< Synonym for wxLANGUAGE_KASHMIRI_ARABIC. @since_wx{3.1.6}
    wxLANGUAGE_KASHMIRI_PERSO_ARABIC_INDIA,    ///< Synonym for wxLANGUAGE_KASHMIRI_ARABIC_INDIA. @since_wx{3.1.6}
    wxLANGUAGE_KERNEWEK,                       ///< Synonym for wxLANGUAGE_CORNISH.
    wxLANGUAGE_KICHE_GUATEMALA,                ///< Synonym for wxLANGUAGE_KICHE_LATIN_GUATEMALA. @since_wx{3.1.6}
    wxLANGUAGE_KURDISH_PERSO_ARABIC_IRAN,      ///< Synonym for wxLANGUAGE_KURDISH_ARABIC_IRAN.
    wxLANGUAGE_MALAY_BRUNEI_DARUSSALAM,        ///< Synonym for wxLANGUAGE_MALAY_BRUNEI.
    wxLANGUAGE_ORIYA,                          ///< Synonym for wxLANGUAGE_ODIA.
    wxLANGUAGE_ORIYA_INDIA,                    ///< Synonym for wxLANGUAGE_ODIA_INDIA.
    wxLANGUAGE_SPANISH_MODERN,                 ///< Synonym for wxLANGUAGE_SPANISH.
    wxLANGUAGE_TURKISH_TURKEY,                 ///< Synonym for wxLANGUAGE_TURKISH_TURKIYE. @since_wx{3.1.6}
    wxLANGUAGE_UZBEK_PERSO_ARABIC,             ///< Synonym for wxLANGUAGE_UZBEK_ARABIC. @since_wx{3.1.6}
    wxLANGUAGE_UZBEK_PERSO_ARABIC_AFGHANISTAN, ///< Synonym for wxLANGUAGE_UZBEK_ARABIC_AFGHANISTAN. @since_wx{3.1.6}
};

// --- --- --- generated code ends here --- --- ---

