# ![Application Icon for Serial Studio](./doc/brand/logo.svg) Serial Studio

[![GitHub downloads](https://img.shields.io/github/downloads/Serial-Studio/Serial-Studio/total.svg?logo=github)](https://github.com/Serial-Studio/Serial-Studio/releases/)
[![Ask DeepWiki](https://deepwiki.com/badge.svg)](https://deepwiki.com/Serial-Studio/Serial-Studio)
[![Instagram](https://img.shields.io/badge/Instagram-E4405F?logo=instagram&logoColor=white)](https://instagram.com/serialstudio.app)
[![Donate](https://img.shields.io/badge/Donate-00457C?logo=paypal&logoColor=white)](https://www.paypal.com/donate?hosted_button_id=XN68J47QJKYDE)
[![Buy Pro](https://img.shields.io/badge/Buy%20Pro-Lemon%20Squeezy-blue?logo=lemonsqueezy)](https://store.serial-studio.com/buy/ba46c099-0d51-4d98-9154-6be5c35bc1ec)
[![Codacy Badge](https://app.codacy.com/project/badge/Grade/4b6f3ce14a684704980fea31d8c1632e)](https://app.codacy.com/gh/Serial-Studio/Serial-Studio/dashboard?utm_source=gh&utm_medium=referral&utm_content=&utm_campaign=Badge_grade)

**Serial Studio** is an open-source tool that helps you see data from **Arduino**, **ESP32**, **Raspberry Pi**, and other devices in real-time. It works with **serial ports (UART)**, **Bluetooth Low Energy (BLE)**, **MQTT**, **Modbus TCP/RTU**, **CAN Bus**, **TCP/UDP networks**, and **audio devices**. You can create dashboards to monitor sensors and debug hardware without writing code.

Serial Studio runs on **Windows**, **macOS**, and **Linux** (including ARM64 for Raspberry Pi). It's perfect for robotics teams, IoT developers, makers, educators, and researchers who need dashboards and CSV data logging.

**Good for:** Arduino data, ESP32 dashboards, IoT sensors, robot debugging, drone data, environmental sensors, real-time plots, hardware testing, lab experiments, car diagnostics (CAN Bus), industrial equipment (Modbus), and STEM education.

📚 **New users?** Check out the [FAQ](FAQ.md), [use cases](USE-CASES.md), and [comparison with alternatives](COMPARISON.md).

![Software usage](doc/screenshot.png)

## Download
Serial Studio is available as source code and official precompiled binaries for Windows, macOS, and Linux.

- [Latest Stable Release](https://github.com/Serial-Studio/Serial-Studio/releases/latest)
- [Pre-release Builds](https://github.com/Serial-Studio/Serial-Studio/releases/continuous)

#### Microsoft Windows:
Requires the [Microsoft Visual C++ Redistributable (x64)](https://learn.microsoft.com/en-us/cpp/windows/latest-supported-vc-redist?view=msvc-170#latest-microsoft-visual-c-redistributable-version). On first launch, Windows may show a warning about an unknown developer, click _"More Info → Run Anyway"_ to continue.

#### macOS: 
Distributed as a universal DMG. Open the DMG file and drag **Serial Studio** into the **Applications** folder.
Alternatively, you can try installing via Homebrew:

```bash
brew install --cask serial-studio
```

**Note:** The Homebrew cask is community-maintained. It’s available, but not officially developed or tested by me.

#### Linux:
The recommended way to install Serial Studio on Linux is via the official pre-built [AppImage](https://appimage.org/). Make it executable and run it:

```bash
chmod +x SerialStudio-Pro-3.2.1-Linux-x64.AppImage
./SerialStudio-Pro-3.2.1-Linux-x64.AppImage
```

If the AppImage fails to launch, your system may be missing `libfuse2`:

```bash
sudo apt install libfuse2
```

**Tip:** For better desktop integration (menu entries, updates, icons), use [AppImageLauncher](https://github.com/TheAssassin/AppImageLauncher).

##### Flatpak (via Flathub)
Serial Studio is also available on [Flathub](https://flathub.org/apps/com.serial_studio.Serial-Studio). This version receives regular updates and may offer better support for ARM64 systems. However, minor graphical glitches may occur on some desktop environments—especially under Wayland (e.g., missing window shadows).

##### Raspberry Pi / ARM64:
An ARM64 AppImage is available for Raspberry Pi and similar devices. Performance varies based on hardware and GPU drivers, since the UI depends on GPU acceleration. The ARM64 AppImage requires:
- A 64-bit Linux OS equivalent to or newer than **Ubuntu 24.04** (due to a `glibc 2.38` dependency)
- `libfuse2` installed

Make sure your system meets these requirements before running the AppImage.

## Features

#### How It Works:
- **Project File Mode (recommended):** Create custom dashboards using the **Project Editor** with drag-and-drop widgets. No coding needed.
- **Quick Plot Mode:** Show comma-separated values from Arduino instantly. No setup needed.
- **Device-defined Mode:** Let your device send its own dashboard layout via JSON.

#### What It Can Do:
- **No Coding Needed:** Build dashboards using a simple visual interface
- **Many Protocols:** Serial/UART, Bluetooth LE, MQTT, Modbus TCP/RTU, CAN Bus, TCP/UDP, and audio input
- **15+ Widgets:** Line plots, gauges, bar charts, GPS maps, FFT spectrum, accelerometers, gyroscopes, compass, data grids
- **Save to CSV:** Automatically save all data for later analysis in Excel, Python, MATLAB, or R
- **MDF4 Playback & Export:** Play and export MDF4/MF4 files for CAN Bus, LIN, FlexRay, and analog channels (Pro)
- **Works Everywhere:** Windows 10/11, macOS 11+ (Intel + Apple Silicon), Linux x64, and Raspberry Pi ARM64
- **Works with Arduino/ESP32:** Compatible with any device that sends data via serial, BLE, or network
- **Fast Updates:** 60 FPS dashboard with low delay (<50ms)
- **Custom Parsing:** Use JavaScript to decode binary data, checksums, and complex formats
- **Modbus TCP/RTU:** Connect to industrial PLCs and equipment (Pro)
- **CAN Bus Support:** Import DBC files for automotive and industrial applications (Pro)
- **MQTT for IoT:** Connect to MQTT brokers for distributed sensors (Pro)
- **Dual Licensing:** Open-source GPL-3.0 core, proprietary Pro features (see [LICENSE.md](LICENSE.md))

## Quick Start

Get started with Serial Studio in under 5 minutes:

### 1. Download and Install
   - Download the latest release for your platform (see [Download](#download) section)
   - **Windows:** Run installer, allow "Unknown developer" if prompted
   - **macOS:** Drag to Applications, right-click → Open first time
   - **Linux:** `chmod +x` the AppImage and run (may need `sudo apt install libfuse2`)

### 2. Connect Your Device
   - Launch Serial Studio
   - Click the **Hardware icon** in the toolbar
   - Select your **serial port** and **baud rate** (common: 9600, 115200)
   - Click **Connect**

### 3. Visualize Data
   - **Quick Plot Mode:** Send comma-separated values from Arduino and see instant plots
   - **Project Mode:** Use the Project Editor to build custom dashboards with gauges, maps, and more
   - **Examples:** Explore the [`/examples`](./examples) folder for Arduino sketches, ESP32 code, and Python scripts

### Arduino Quick Example
```cpp
void setup() {
  Serial.begin(9600);
}

void loop() {
  int temperature = analogRead(A0);
  int humidity = analogRead(A1);
  Serial.print(temperature);
  Serial.print(",");
  Serial.println(humidity);
  delay(100);
}
```
Upload to Arduino → Connect Serial Studio → Enable Quick Plot → Done!

**First-time users:** See [FAQ](FAQ.md) for troubleshooting and common questions.

📚 **Learn More:**
- [FAQ](FAQ.md) - Common questions and troubleshooting
- [Use Cases](USE-CASES.md) - Real-world applications across industries
- [Comparison](COMPARISON.md) - Serial Studio vs. alternatives (Arduino Plotter, MATLAB, Processing, etc.)
- [Examples](./examples) - Arduino/ESP32/Python code and project templates
- [Wiki](https://github.com/Serial-Studio/Serial-Studio/wiki) - Complete documentation

## Documentation & Resources

### Official Documentation
- 📖 [Wiki](https://github.com/Serial-Studio/Serial-Studio/wiki) - Complete guides and tutorials
- ❓ [FAQ](FAQ.md) - Frequently asked questions and troubleshooting
- 🎯 [Use Cases](USE-CASES.md) - Real-world examples: robotics, IoT, drones, education, research
- ⚖️ [Comparison](COMPARISON.md) - Serial Studio vs. Arduino Plotter, MATLAB, Processing, LabVIEW, Python
- 🤖 [AI Agent Guide](AGENTS.md) - For ChatGPT, Claude, and other AI assistants
- 💡 [Examples](./examples) - Arduino, ESP32, Python code with sample projects

### Key Topics
- **Installation:** Platform-specific setup for Windows, macOS, Linux, Raspberry Pi
- **Quick Start:** Connect Arduino/ESP32 and visualize data in 5 minutes
- **Dashboard Creation:** Build custom layouts with Project Editor (no coding)
- **Protocol Support:** Serial/UART, Bluetooth LE, MQTT, Modbus TCP/RTU, CAN Bus, TCP/UDP, Audio
- **Frame Parsing:** Handle binary protocols, checksums, custom data formats
- **CSV Export & Playback:** Log sensor data and replay CSV files for analysis
- **MDF4 Playback & Export:** Play and export MDF4/MF4 files (CAN Bus, LIN, FlexRay, analog)

## Building Serial Studio

### System Requirements

**Minimum Requirements:**
- **Qt:** Version 6.7 or later (6.9.2 recommended)
  - Required modules: QtCore, QtGui, QtWidgets, QtSerialPort, QtNetwork, QtCharts, QtSvg, QtBluetooth, QtQuick
- **C++ Compiler:** C++20 compatible
  - GCC 10+ (Linux)
  - Clang 12+ (macOS)
  - MSVC 2019+ (Windows)
- **CMake:** Version 3.16 or later
- **Build Tools:** Platform-specific toolchain (see below)

**Platform-Specific Requirements:**

#### Linux
```bash
sudo apt install libgl1-mesa-dev build-essential
```

#### macOS
- Xcode Command Line Tools: `xcode-select --install`
- Qt can be installed via Homebrew: `brew install qt@6`

#### Windows
- Visual Studio 2019 or later with C++ development tools
- Qt installed via the official installer

### Build Instructions

Once Qt is installed, you can compile the project by opening `CMakeLists.txt` in your preferred IDE or using the terminal:

```bash
mkdir build
cd build
cmake ../ -DPRODUCTION_OPTIMIZATION=ON -DCMAKE_BUILD_TYPE=Release
cmake --build . -j$(nproc)
```

By default, the build system produces a fully GPLv3-compliant version of Serial Studio.
This version includes most core features but excludes commercial modules such as MQTT, 3D visualization, XY plotting, and other advanced tools that depend on proprietary Qt components.

If you are a Pro user or have a commercial license, [contact the project maintainer](mailto:alex@serial-studio.com) for build instructions and activation requirements.

## Support the Project
Serial Studio is developed and maintained by [Alex Spataru](https://github.com/alex-spataru).  
It is open source and community-driven, with commercial options available for users who need advanced features or business-friendly licensing.

If Serial Studio is useful to you, consider supporting its development in one of the following ways:

- [**Donate via PayPal**](https://www.paypal.com/donate?hosted_button_id=XN68J47QJKYDE): Helps keep the project active and sustainable.
- [**Purchase a Commercial License**](https://serial-studio.com): Required for commercial use of the official binary. Includes Pro features and priority support.

Commercial licenses directly fund continued development, bug fixes, and new features.

## Licensing

Serial Studio uses a **dual-license model** that distinguishes between open-source usage and commercial distribution:

- [LICENSE.md](LICENSE.md): summary of dual-license structure and usage terms
- [LICENSES/GPL-3.0-only.txt](LICENSES/GPL-3.0-only.txt): full GNU GPLv3 text for open-source source code
- [LICENSES/LicenseRef-SerialStudio-Commercial.txt](LICENSES/LicenseRef-SerialStudio-Commercial.txt): full terms for proprietary features and official binaries

Source files are individually marked with SPDX headers indicating whether they are:
- Licensed under `GPL-3.0-only`
- Licensed under `LicenseRef-SerialStudio-Commercial`
- Or dual-licensed as `GPL-3.0-only OR LicenseRef-SerialStudio-Commercial`

This structure allows developers to build and distribute GPL-compliant versions while protecting commercial functionality.

## Choosing the Right Version of Serial Studio

The table below outlines licensing, feature access, and obligations across each edition:

| Feature / Use Case           | GPL Version *(Build it yourself)*       | Trial Version *(Official binary)*    | Pro Version *(Activated official binary)*    |
|-----------------------------|------------------------------------------|---------------------------------------|----------------------------------------------|
| **Commercial Use**          | ✅ If fully GPL compliant                | ❌ Evaluation only                    | ✅ Fully licensed                             |
| **Official Support**        | ❌ Community only                        | ❌ None                               | ✅ Priority support                           |
| **Pro Features**            | ❌ Not included                          | ✅ Included                           | ✅ Included                                   |
| **Usage Restrictions**      | Must comply with GPL and Qt terms        | 14-day trial, no redistribution       | Bound by commercial license terms            |
| **Precompiled Binary**      | ❌ Must build from source                | ✅ Provided for trial only            | ✅ Provided                                   |
| **Qt Licensing**            | Requires GPL-compatible Qt               | Qt licensing covered by vendor        | Qt licensing covered by vendor               |
| **Activation System**       | ❌ Not applicable                        | ✅ Trial disables after 14 days       | ✅ Requires valid license key                 |
| **Business Use**            | ✅ If strictly GPL compliant             | ❌ Prohibited                         | ✅ Fully allowed                              |
| **Best For**                | OSS devs, students, contributors         | Hobbyists, personal evaluation        | Businesses, teams, commercial products       |

**Reminder:** Pro features and official binaries are proprietary and require a commercial license for any use beyond personal evaluation. Visibility of source code does **not** imply GPL rights unless explicitly licensed.

## Contributing

Contributions are welcome! Whether you're fixing bugs, adding features, or improving documentation, your help is appreciated.

**Before contributing:**
- Check existing [issues](https://github.com/Serial-Studio/Serial-Studio/issues) and [pull requests](https://github.com/Serial-Studio/Serial-Studio/pulls)
- Review the [CLAUDE.md](CLAUDE.md) file for code style guidelines
- Focus on GPL-licensed code (avoid modifying commercial modules)

**Code Style:**
- Follow the project's clang-format configuration (LLVM base style)
- Use meaningful names for variables and functions
- Avoid inline end-of-line comments (see [CLAUDE.md](CLAUDE.md#comments-policy))
- Add Doxygen documentation for new public APIs

**Submitting Changes:**
1. Fork the repository
2. Create a feature branch (`git checkout -b feature/amazing-feature`)
3. Commit your changes with descriptive messages
4. Push to your fork and submit a pull request
5. Ensure CI checks pass

For major changes, please open an issue first to discuss your proposal.
