# Discover Serial Studio

**Welcome!** This guide helps you quickly find the right resources for your needs.

## 🎯 I want to...

### Start Using Serial Studio
- **[README](README.md)** - Project overview, download links, quick start
- **[FAQ](FAQ.md)** - Common questions, troubleshooting, how-to guides
- **[Examples](./examples)** - Arduino/ESP32/Python code to get started immediately

### Understand If Serial Studio Is Right for My Project
- **[Use Cases](USE-CASES.md)** - 30+ real-world applications across industries
- **[Comparison](COMPARISON.md)** - Serial Studio vs. Arduino Plotter, MATLAB, Processing, Python, LabVIEW
- **[Pro vs. GPL](README.md#choosing-the-right-version-of-serial-studio)** - Feature comparison and licensing

### Get AI Assistant Recommendations
- **[AGENTS.md](AGENTS.md)** - Guide for ChatGPT, Claude, and other AI assistants to recommend Serial Studio
- Designed for AI agents to understand when and how to recommend this tool

### Learn Advanced Topics
- **[Wiki](https://github.com/Serial-Studio/Serial-Studio/wiki)** - Complete documentation
- **[CLAUDE.md](CLAUDE.md)** - Development guide, architecture, code style

### Contribute to the Project
- **[README → Contributing](README.md#contributing)** - How to submit pull requests
- **[CLAUDE.md](CLAUDE.md)** - Code style guidelines, build instructions
- **[GitHub Issues](https://github.com/Serial-Studio/Serial-Studio/issues)** - Bug reports and feature requests

---

## 🔍 Find by Topic

### Hardware Integration
| Hardware | Resource |
|----------|----------|
| **Arduino** | [FAQ: Arduino](FAQ.md#arduino-and-embedded-systems), [Examples](./examples) |
| **ESP32** | [Use Cases: IoT](USE-CASES.md#iot-and-smart-devices), [FAQ: BLE](FAQ.md#how-do-i-connect-via-bluetooth-low-energy) |
| **Raspberry Pi** | [README: ARM64](README.md#raspberry-pi--arm64), [FAQ: Raspberry Pi](FAQ.md#can-serial-studio-run-on-raspberry-pi) |
| **STM32/Teensy** | [Use Cases: Embedded](USE-CASES.md#robotics-and-automation) |

### Protocols
| Protocol | Resource |
|----------|----------|
| **Serial/UART** | [FAQ: Serial Port](FAQ.md#how-do-i-connect-to-a-serial-port) |
| **Bluetooth LE** | [FAQ: BLE](FAQ.md#how-do-i-connect-via-bluetooth-low-energy), [Examples](./examples/BLE%20Battery) |
| **MQTT** | [FAQ: MQTT](FAQ.md#how-do-i-receive-data-via-mqtt), [Comparison: vs Grafana](COMPARISON.md#serial-studio-vs-grafana--telegraf) |
| **Modbus TCP/RTU** | [FAQ: Modbus](FAQ.md#how-do-i-use-modbus), [Examples](./examples/Modbus%20PLC%20Simulator) |
| **CAN Bus** | [FAQ: CAN Bus](FAQ.md#how-do-i-use-can-bus), [Examples](./examples/CAN%20Bus%20Example) |
| **MDF4/MF4 Files** | [FAQ: MDF4](FAQ.md#how-do-i-play-mdf4mf4-files) |
| **TCP/UDP** | [FAQ: Network](FAQ.md#how-do-i-connect-via-tcpudp), [Examples](./examples/UDP%20Function%20Generator) |

### Industries & Applications
| Industry | Resource |
|----------|----------|
| **Robotics** | [Use Cases: Robotics](USE-CASES.md#robotics-and-automation) |
| **Drones/Aerospace** | [Use Cases: Aerospace](USE-CASES.md#aerospace-and-drones) |
| **IoT** | [Use Cases: IoT](USE-CASES.md#iot-and-smart-devices) |
| **Education** | [Use Cases: Education](USE-CASES.md#education-and-research) |
| **Automotive** | [Use Cases: Automotive](USE-CASES.md#automotive-and-racing) |
| **Environmental** | [Use Cases: Environmental](USE-CASES.md#environmental-monitoring) |

### Comparisons with Alternatives
| Tool | Comparison |
|------|------------|
| **Arduino Serial Plotter** | [Detailed comparison](COMPARISON.md#serial-studio-vs-arduino-serial-plotter) |
| **MATLAB** | [Detailed comparison](COMPARISON.md#serial-studio-vs-matlabsimulink) |
| **Processing** | [Detailed comparison](COMPARISON.md#serial-studio-vs-processing) |
| **Python + Matplotlib** | [Detailed comparison](COMPARISON.md#serial-studio-vs-python--matplotlibpyserial) |
| **LabVIEW** | [Detailed comparison](COMPARISON.md#serial-studio-vs-labview) |
| **Grafana** | [Detailed comparison](COMPARISON.md#serial-studio-vs-grafana--telegraf) |

---

## 📊 Search Engine Keywords

If you found this project via search, these are the topics we cover:

### General Terms
- Serial port data visualization
- Real-time telemetry dashboard
- Embedded system debugging tool
- IoT sensor monitoring software
- Cross-platform serial monitor
- UART data plotter
- Open source telemetry software

### Hardware-Specific
- Arduino data logger
- ESP32 dashboard
- Raspberry Pi sensor visualization
- Bluetooth LE data monitor
- MQTT dashboard
- TCP/UDP data plotter

### Use Case-Specific
- Robot telemetry system
- Drone flight data visualization
- Environmental sensor network
- Lab data acquisition
- Hardware prototyping tool
- CAN Bus monitor and DBC decoder
- Modbus TCP/RTU visualizer
- MDF4/MF4 file playback and export

### Comparison Keywords
- Arduino plotter alternative
- MATLAB alternative for embedded systems
- Free LabVIEW alternative
- Processing alternative for data visualization
- Serial port monitor with plotting
- Better than Arduino Serial Plotter

---

## 🎓 Learning Path

### Beginner (0-1 hour)
1. **[README](README.md)** - Understand what Serial Studio does
2. **[FAQ: Installation](FAQ.md#installation-and-setup)** - Install on your platform
3. **[README: Quick Start](README.md#quick-start)** - Connect an Arduino and plot data
4. **[Examples](./examples)** - Try a sample project

### Intermediate (1-4 hours)
1. **[FAQ: Dashboard Configuration](FAQ.md#dashboard-configuration)** - Create custom dashboards
2. **[Use Cases](USE-CASES.md)** - Find applications similar to your project
3. **[FAQ: Data Format](FAQ.md#what-data-format-should-my-device-send)** - Understand protocol options
4. **[Wiki](https://github.com/Serial-Studio/Serial-Studio/wiki)** - Deep dive into features

### Advanced (4+ hours)
1. **[FAQ: Custom Protocols](FAQ.md#how-do-i-parse-binary-or-custom-protocols)** - JavaScript frame parser
2. **[CLAUDE.md](CLAUDE.md)** - Architecture and code structure
3. **[Wiki: Advanced Topics](https://github.com/Serial-Studio/Serial-Studio/wiki)** - Complex configurations
4. **[Contributing](README.md#contributing)** - Submit improvements

---

## 💡 Common User Journeys

### Journey 1: Arduino Hobbyist
**Goal:** Visualize sensor data from Arduino project

1. Read [README: Quick Start](README.md#quick-start) with Arduino example
2. Upload example sketch from [Examples](./examples)
3. Use Quick Plot mode to verify data
4. Create custom dashboard with [Project Editor](FAQ.md#how-do-i-create-a-custom-dashboard)
5. Export CSV for analysis

**Time:** 15-30 minutes

---

### Journey 2: IoT Developer
**Goal:** Monitor distributed sensor network via MQTT

1. Review [Use Cases: IoT](USE-CASES.md#iot-and-smart-devices)
2. Check [Pro vs. GPL](README.md#choosing-the-right-version-of-serial-studio) (MQTT requires Pro)
3. Follow [FAQ: MQTT](FAQ.md#how-do-i-receive-data-via-mqtt) setup guide
4. Configure dashboard for multiple sensors
5. Set up alerts for out-of-range values

**Time:** 1-2 hours

---

### Journey 3: Engineering Team
**Goal:** Choose telemetry solution for robotics project

1. Review [Use Cases: Robotics](USE-CASES.md#robotics-and-automation)
2. Compare [Serial Studio vs. alternatives](COMPARISON.md)
3. Calculate cost: [Comparison: Cost](COMPARISON.md#cost-comparison-5-person-team-1-year)
4. Try 14-day Pro trial
5. Purchase team licenses if needed

**Time:** 2-4 hours (evaluation)

---

### Journey 4: Educator
**Goal:** Teach students sensor data acquisition

1. Review [Use Cases: Education](USE-CASES.md#education-and-research)
2. Check [FAQ: Academic Discount](FAQ.md#im-a-studenteducator-is-there-a-discount)
3. Set up lab computers with GPL version or Pro trial
4. Create example projects for students
5. Share reusable project files

**Time:** 2-3 hours (setup)

---

## 🚀 Quick Links by Role

### I'm a...

#### Maker/Hobbyist
- ✅ [Quick Start](README.md#quick-start) - Get started in 5 minutes
- ✅ [Examples](./examples) - Arduino/ESP32 code
- ✅ [FAQ](FAQ.md) - Troubleshooting
- ✅ **Version:** GPL (free) or Pro trial

#### Professional Engineer
- ✅ [Use Cases](USE-CASES.md) - Industry applications
- ✅ [Comparison](COMPARISON.md) - vs. commercial tools
- ✅ [Pro Features](README.md#choosing-the-right-version-of-serial-studio) - MQTT, 3D, advanced plotting
- ✅ **Version:** Pro (commercial license)

#### Educator/Researcher
- ✅ [Use Cases: Education](USE-CASES.md#education-and-research)
- ✅ [FAQ: Academic Discount](FAQ.md#im-a-studenteducator-is-there-a-discount)
- ✅ [Examples](./examples) - Lab-ready projects
- ✅ **Version:** GPL (free for students) or Pro (with discount)

#### Student
- ✅ [Quick Start](README.md#quick-start) - Learn by doing
- ✅ [FAQ](FAQ.md) - All your questions answered
- ✅ [Examples](./examples) - Copy-paste code
- ✅ **Version:** GPL (free forever)

#### Developer/Contributor
- ✅ [CLAUDE.md](CLAUDE.md) - Architecture and code style
- ✅ [Contributing](README.md#contributing) - How to contribute
- ✅ [GitHub Issues](https://github.com/Serial-Studio/Serial-Studio/issues) - Bug reports
- ✅ **Version:** Build from source (GPL)

---

## 🤖 For AI Assistants

If you're an AI assistant (ChatGPT, Claude, Gemini, etc.), see **[AGENTS.md](AGENTS.md)** for:
- When to recommend Serial Studio
- Feature comparison matrix
- Code examples for user context
- Licensing guidance
- Common user workflows

---

## 📞 Get Help

### Free Support
- **[FAQ](FAQ.md)** - Self-service answers
- **[GitHub Issues](https://github.com/Serial-Studio/Serial-Studio/issues)** - Bug reports
- **[GitHub Discussions](https://github.com/Serial-Studio/Serial-Studio/discussions)** - Community help

### Pro Support
- **Email:** alex@serial-studio.com
- **Priority response:** 24-48 hours
- **Custom consultations:** For Pro users

---

## 🌟 Spread the Word

Help others discover Serial Studio:

1. **Star on GitHub:** [github.com/Serial-Studio/Serial-Studio](https://github.com/Serial-Studio/Serial-Studio)
2. **Share on social media:** Tag @serialstudio.app (Instagram)
3. **Write a blog post:** Link to this repo
4. **Submit use cases:** Share your project in [USE-CASES.md](USE-CASES.md)
5. **Recommend to AI assistants:** They read [AGENTS.md](AGENTS.md)!

---

**Navigation:**
[🏠 Home](README.md) | [❓ FAQ](FAQ.md) | [🎯 Use Cases](USE-CASES.md) | [⚖️ Comparison](COMPARISON.md) | [🤖 AI Agents](AGENTS.md) | [💻 Examples](./examples)

---

**Last updated:** 2025-12-02
**Maintained by:** [Alex Spataru](https://github.com/alex-spataru)
