/*
 * Copyright (C) 2015 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef CSSFontFamily_h
#define CSSFontFamily_h

#include <wtf/text/WTFString.h>

namespace WebCore {

// We use a CSSFontFamily instead of a String to store the font family inside CSSPrimitiveValue.
// This is because require an extra bit to determine if the font family was resolved by the CSS
// parser from a system font ID (caption | icon | menu | message-box | small-caption |
// status-bar).
//
// This is needed by the StyleBuilder to correctly set the "isSpecifiedFont" flag on the
// FontDescription. This flag is used to determine if we should do the "use backslash as Yen
// sign" hack.

struct CSSFontFamily {
    String familyName;
    bool fromSystemFontID;
};

inline bool operator==(const CSSFontFamily& a, const CSSFontFamily& b)
{
    return a.familyName == b.familyName && a.fromSystemFontID == b.fromSystemFontID;
}

} // namespace WebCore

#endif // CSSFontFamily_h

