/***************************************************************************
                         qgsalgorithmsplitlineantimeridian.h
                         -----------------------------------
    begin                : January 2019
    copyright            : (C) 2019 by Nyall Dawson
    email                : nyall dot dawson at gmail dot com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QGSALGORITHMSPLITLINEANTIMERIDIAN_H
#define QGSALGORITHMSPLITLINEANTIMERIDIAN_H

#define SIP_NO_FILE

#include "qgis_sip.h"
#include "qgsprocessingalgorithm.h"
#include "qgsdistancearea.h"

///@cond PRIVATE

/**
 * Native split geometry at antimeridian algorithm.
 */
class QgsSplitGeometryAtAntimeridianAlgorithm : public QgsProcessingFeatureBasedAlgorithm
{

  public:

    QgsSplitGeometryAtAntimeridianAlgorithm() = default;
    QString name() const override;
    QString displayName() const override;
    QStringList tags() const override;
    QString group() const override;
    QString groupId() const override;
    QString shortDescription() const override;
    QString shortHelpString() const override;
    QList<int> inputLayerTypes() const override;
    Qgis::ProcessingSourceType outputLayerType() const override;
    QgsSplitGeometryAtAntimeridianAlgorithm *createInstance() const override SIP_FACTORY;

  protected:
    QString outputName() const override;
    Qgis::WkbType outputWkbType( Qgis::WkbType inputWkbType ) const override;
    QgsCoordinateReferenceSystem outputCrs( const QgsCoordinateReferenceSystem &inputCrs ) const override;
    bool prepareAlgorithm( const QVariantMap &parameters, QgsProcessingContext &context, QgsProcessingFeedback *feedback ) override;
    QgsFeatureList processFeature( const QgsFeature &feature,  QgsProcessingContext &context, QgsProcessingFeedback *feedback ) override;

  private:
    mutable QgsDistanceArea mDa;
    QgsCoordinateTransformContext mTransformContext;

};

///@endcond PRIVATE

#endif // QGSALGORITHMSPLITLINEANTIMERIDIAN_H


