#[allow(non_camel_case_types)]
#[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub enum Opcode {
  PHI,
  INLINEASM,
  INLINEASM_BR,
  CFI_INSTRUCTION,
  EH_LABEL,
  GC_LABEL,
  ANNOTATION_LABEL,
  KILL,
  EXTRACT_SUBREG,
  INSERT_SUBREG,
  IMPLICIT_DEF,
  INIT_UNDEF,
  SUBREG_TO_REG,
  COPY_TO_REGCLASS,
  DBG_VALUE,
  DBG_VALUE_LIST,
  DBG_INSTR_REF,
  DBG_PHI,
  DBG_LABEL,
  REG_SEQUENCE,
  COPY,
  BUNDLE,
  LIFETIME_START,
  LIFETIME_END,
  PSEUDO_PROBE,
  ARITH_FENCE,
  STACKMAP,
  FENTRY_CALL,
  PATCHPOINT,
  LOAD_STACK_GUARD,
  PREALLOCATED_SETUP,
  PREALLOCATED_ARG,
  STATEPOINT,
  LOCAL_ESCAPE,
  FAULTING_OP,
  PATCHABLE_OP,
  PATCHABLE_FUNCTION_ENTER,
  PATCHABLE_RET,
  PATCHABLE_FUNCTION_EXIT,
  PATCHABLE_TAIL_CALL,
  PATCHABLE_EVENT_CALL,
  PATCHABLE_TYPED_EVENT_CALL,
  ICALL_BRANCH_FUNNEL,
  FAKE_USE,
  MEMBARRIER,
  JUMP_TABLE_DEBUG_INFO,
  CONVERGENCECTRL_ENTRY,
  CONVERGENCECTRL_ANCHOR,
  CONVERGENCECTRL_LOOP,
  CONVERGENCECTRL_GLUE,
  G_ASSERT_SEXT,
  G_ASSERT_ZEXT,
  G_ASSERT_ALIGN,
  G_ADD,
  G_SUB,
  G_MUL,
  G_SDIV,
  G_UDIV,
  G_SREM,
  G_UREM,
  G_SDIVREM,
  G_UDIVREM,
  G_AND,
  G_OR,
  G_XOR,
  G_ABDS,
  G_ABDU,
  G_IMPLICIT_DEF,
  G_PHI,
  G_FRAME_INDEX,
  G_GLOBAL_VALUE,
  G_PTRAUTH_GLOBAL_VALUE,
  G_CONSTANT_POOL,
  G_EXTRACT,
  G_UNMERGE_VALUES,
  G_INSERT,
  G_MERGE_VALUES,
  G_BUILD_VECTOR,
  G_BUILD_VECTOR_TRUNC,
  G_CONCAT_VECTORS,
  G_PTRTOINT,
  G_INTTOPTR,
  G_BITCAST,
  G_FREEZE,
  G_CONSTANT_FOLD_BARRIER,
  G_INTRINSIC_FPTRUNC_ROUND,
  G_INTRINSIC_TRUNC,
  G_INTRINSIC_ROUND,
  G_INTRINSIC_LRINT,
  G_INTRINSIC_LLRINT,
  G_INTRINSIC_ROUNDEVEN,
  G_READCYCLECOUNTER,
  G_READSTEADYCOUNTER,
  G_LOAD,
  G_SEXTLOAD,
  G_ZEXTLOAD,
  G_INDEXED_LOAD,
  G_INDEXED_SEXTLOAD,
  G_INDEXED_ZEXTLOAD,
  G_STORE,
  G_INDEXED_STORE,
  G_ATOMIC_CMPXCHG_WITH_SUCCESS,
  G_ATOMIC_CMPXCHG,
  G_ATOMICRMW_XCHG,
  G_ATOMICRMW_ADD,
  G_ATOMICRMW_SUB,
  G_ATOMICRMW_AND,
  G_ATOMICRMW_NAND,
  G_ATOMICRMW_OR,
  G_ATOMICRMW_XOR,
  G_ATOMICRMW_MAX,
  G_ATOMICRMW_MIN,
  G_ATOMICRMW_UMAX,
  G_ATOMICRMW_UMIN,
  G_ATOMICRMW_FADD,
  G_ATOMICRMW_FSUB,
  G_ATOMICRMW_FMAX,
  G_ATOMICRMW_FMIN,
  G_ATOMICRMW_FMAXIMUM,
  G_ATOMICRMW_FMINIMUM,
  G_ATOMICRMW_UINC_WRAP,
  G_ATOMICRMW_UDEC_WRAP,
  G_ATOMICRMW_USUB_COND,
  G_ATOMICRMW_USUB_SAT,
  G_FENCE,
  G_PREFETCH,
  G_BRCOND,
  G_BRINDIRECT,
  G_INVOKE_REGION_START,
  G_INTRINSIC,
  G_INTRINSIC_W_SIDE_EFFECTS,
  G_INTRINSIC_CONVERGENT,
  G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
  G_ANYEXT,
  G_TRUNC,
  G_TRUNC_SSAT_S,
  G_TRUNC_SSAT_U,
  G_TRUNC_USAT_U,
  G_CONSTANT,
  G_FCONSTANT,
  G_VASTART,
  G_VAARG,
  G_SEXT,
  G_SEXT_INREG,
  G_ZEXT,
  G_SHL,
  G_LSHR,
  G_ASHR,
  G_FSHL,
  G_FSHR,
  G_ROTR,
  G_ROTL,
  G_ICMP,
  G_FCMP,
  G_SCMP,
  G_UCMP,
  G_SELECT,
  G_UADDO,
  G_UADDE,
  G_USUBO,
  G_USUBE,
  G_SADDO,
  G_SADDE,
  G_SSUBO,
  G_SSUBE,
  G_UMULO,
  G_SMULO,
  G_UMULH,
  G_SMULH,
  G_UADDSAT,
  G_SADDSAT,
  G_USUBSAT,
  G_SSUBSAT,
  G_USHLSAT,
  G_SSHLSAT,
  G_SMULFIX,
  G_UMULFIX,
  G_SMULFIXSAT,
  G_UMULFIXSAT,
  G_SDIVFIX,
  G_UDIVFIX,
  G_SDIVFIXSAT,
  G_UDIVFIXSAT,
  G_FADD,
  G_FSUB,
  G_FMUL,
  G_FMA,
  G_FMAD,
  G_FDIV,
  G_FREM,
  G_FPOW,
  G_FPOWI,
  G_FEXP,
  G_FEXP2,
  G_FEXP10,
  G_FLOG,
  G_FLOG2,
  G_FLOG10,
  G_FLDEXP,
  G_FFREXP,
  G_FNEG,
  G_FPEXT,
  G_FPTRUNC,
  G_FPTOSI,
  G_FPTOUI,
  G_SITOFP,
  G_UITOFP,
  G_FPTOSI_SAT,
  G_FPTOUI_SAT,
  G_FABS,
  G_FCOPYSIGN,
  G_IS_FPCLASS,
  G_FCANONICALIZE,
  G_FMINNUM,
  G_FMAXNUM,
  G_FMINNUM_IEEE,
  G_FMAXNUM_IEEE,
  G_FMINIMUM,
  G_FMAXIMUM,
  G_FMINIMUMNUM,
  G_FMAXIMUMNUM,
  G_GET_FPENV,
  G_SET_FPENV,
  G_RESET_FPENV,
  G_GET_FPMODE,
  G_SET_FPMODE,
  G_RESET_FPMODE,
  G_GET_ROUNDING,
  G_PTR_ADD,
  G_PTRMASK,
  G_SMIN,
  G_SMAX,
  G_UMIN,
  G_UMAX,
  G_ABS,
  G_LROUND,
  G_LLROUND,
  G_BR,
  G_BRJT,
  G_VSCALE,
  G_INSERT_SUBVECTOR,
  G_EXTRACT_SUBVECTOR,
  G_INSERT_VECTOR_ELT,
  G_EXTRACT_VECTOR_ELT,
  G_SHUFFLE_VECTOR,
  G_SPLAT_VECTOR,
  G_STEP_VECTOR,
  G_VECTOR_COMPRESS,
  G_CTTZ,
  G_CTTZ_ZERO_UNDEF,
  G_CTLZ,
  G_CTLZ_ZERO_UNDEF,
  G_CTPOP,
  G_BSWAP,
  G_BITREVERSE,
  G_FCEIL,
  G_FCOS,
  G_FSIN,
  G_FSINCOS,
  G_FTAN,
  G_FACOS,
  G_FASIN,
  G_FATAN,
  G_FATAN2,
  G_FCOSH,
  G_FSINH,
  G_FTANH,
  G_FSQRT,
  G_FFLOOR,
  G_FRINT,
  G_FNEARBYINT,
  G_ADDRSPACE_CAST,
  G_BLOCK_ADDR,
  G_JUMP_TABLE,
  G_DYN_STACKALLOC,
  G_STACKSAVE,
  G_STACKRESTORE,
  G_STRICT_FADD,
  G_STRICT_FSUB,
  G_STRICT_FMUL,
  G_STRICT_FDIV,
  G_STRICT_FREM,
  G_STRICT_FMA,
  G_STRICT_FSQRT,
  G_STRICT_FLDEXP,
  G_READ_REGISTER,
  G_WRITE_REGISTER,
  G_MEMCPY,
  G_MEMCPY_INLINE,
  G_MEMMOVE,
  G_MEMSET,
  G_BZERO,
  G_TRAP,
  G_DEBUGTRAP,
  G_UBSANTRAP,
  G_VECREDUCE_SEQ_FADD,
  G_VECREDUCE_SEQ_FMUL,
  G_VECREDUCE_FADD,
  G_VECREDUCE_FMUL,
  G_VECREDUCE_FMAX,
  G_VECREDUCE_FMIN,
  G_VECREDUCE_FMAXIMUM,
  G_VECREDUCE_FMINIMUM,
  G_VECREDUCE_ADD,
  G_VECREDUCE_MUL,
  G_VECREDUCE_AND,
  G_VECREDUCE_OR,
  G_VECREDUCE_XOR,
  G_VECREDUCE_SMAX,
  G_VECREDUCE_SMIN,
  G_VECREDUCE_UMAX,
  G_VECREDUCE_UMIN,
  G_SBFX,
  G_UBFX,
  ADJCALLSTACKDOWN,
  ADJCALLSTACKUP,
  FI_ri,
  MEMCPY,
  Select,
  Select_32,
  Select_32_64,
  Select_64_32,
  Select_Ri,
  Select_Ri_32,
  Select_Ri_32_64,
  Select_Ri_64_32,
  ADDR_SPACE_CAST,
  ADD_ri,
  ADD_ri_32,
  ADD_rr,
  ADD_rr_32,
  AND_ri,
  AND_ri_32,
  AND_rr,
  AND_rr_32,
  BE16,
  BE32,
  BE64,
  BSWAP16,
  BSWAP32,
  BSWAP64,
  CMPXCHGD,
  CMPXCHGW32,
  CORE_LD32,
  CORE_LD64,
  CORE_SHIFT,
  CORE_ST,
  DIV_ri,
  DIV_ri_32,
  DIV_rr,
  DIV_rr_32,
  JAL,
  JALX,
  JCOND,
  JEQ_ri,
  JEQ_ri_32,
  JEQ_rr,
  JEQ_rr_32,
  JMP,
  JMPL,
  JNE_ri,
  JNE_ri_32,
  JNE_rr,
  JNE_rr_32,
  JSET_ri,
  JSET_ri_32,
  JSET_rr,
  JSET_rr_32,
  JSGE_ri,
  JSGE_ri_32,
  JSGE_rr,
  JSGE_rr_32,
  JSGT_ri,
  JSGT_ri_32,
  JSGT_rr,
  JSGT_rr_32,
  JSLE_ri,
  JSLE_ri_32,
  JSLE_rr,
  JSLE_rr_32,
  JSLT_ri,
  JSLT_ri_32,
  JSLT_rr,
  JSLT_rr_32,
  JUGE_ri,
  JUGE_ri_32,
  JUGE_rr,
  JUGE_rr_32,
  JUGT_ri,
  JUGT_ri_32,
  JUGT_rr,
  JUGT_rr_32,
  JULE_ri,
  JULE_ri_32,
  JULE_rr,
  JULE_rr_32,
  JULT_ri,
  JULT_ri_32,
  JULT_rr,
  JULT_rr_32,
  LDB,
  LDB32,
  LDBACQ32,
  LDBSX,
  LDD,
  LDDACQ,
  LDH,
  LDH32,
  LDHACQ32,
  LDHSX,
  LDW,
  LDW32,
  LDWACQ32,
  LDWSX,
  LD_ABS_B,
  LD_ABS_H,
  LD_ABS_W,
  LD_IND_B,
  LD_IND_H,
  LD_IND_W,
  LD_imm64,
  LD_pseudo,
  LE16,
  LE32,
  LE64,
  MOD_ri,
  MOD_ri_32,
  MOD_rr,
  MOD_rr_32,
  MOVSX_rr_16,
  MOVSX_rr_32,
  MOVSX_rr_32_16,
  MOVSX_rr_32_8,
  MOVSX_rr_8,
  MOV_32_64,
  MOV_ri,
  MOV_ri_32,
  MOV_rr,
  MOV_rr_32,
  MUL_ri,
  MUL_ri_32,
  MUL_rr,
  MUL_rr_32,
  NEG_32,
  NEG_64,
  NOP,
  OR_ri,
  OR_ri_32,
  OR_rr,
  OR_rr_32,
  RET,
  SDIV_ri,
  SDIV_ri_32,
  SDIV_rr,
  SDIV_rr_32,
  SLL_ri,
  SLL_ri_32,
  SLL_rr,
  SLL_rr_32,
  SMOD_ri,
  SMOD_ri_32,
  SMOD_rr,
  SMOD_rr_32,
  SRA_ri,
  SRA_ri_32,
  SRA_rr,
  SRA_rr_32,
  SRL_ri,
  SRL_ri_32,
  SRL_rr,
  SRL_rr_32,
  STB,
  STB32,
  STBREL32,
  STB_imm,
  STD,
  STDREL,
  STD_imm,
  STH,
  STH32,
  STHREL32,
  STH_imm,
  STW,
  STW32,
  STWREL32,
  STW_imm,
  SUB_ri,
  SUB_ri_32,
  SUB_rr,
  SUB_rr_32,
  XADDD,
  XADDW,
  XADDW32,
  XANDD,
  XANDW32,
  XCHGD,
  XCHGW32,
  XFADDD,
  XFADDW32,
  XFANDD,
  XFANDW32,
  XFORD,
  XFORW32,
  XFXORD,
  XFXORW32,
  XORD,
  XORW32,
  XOR_ri,
  XOR_ri_32,
  XOR_rr,
  XOR_rr_32,
  XXORD,
  XXORW32,
  INSTRUCTION_LIST_END,
  UNKNOWN(u64),
}

impl From<u64> for Opcode {
    fn from(value: u64) -> Self {
        match value {
          0 => Opcode::PHI,
          1 => Opcode::INLINEASM,
          2 => Opcode::INLINEASM_BR,
          3 => Opcode::CFI_INSTRUCTION,
          4 => Opcode::EH_LABEL,
          5 => Opcode::GC_LABEL,
          6 => Opcode::ANNOTATION_LABEL,
          7 => Opcode::KILL,
          8 => Opcode::EXTRACT_SUBREG,
          9 => Opcode::INSERT_SUBREG,
          10 => Opcode::IMPLICIT_DEF,
          11 => Opcode::INIT_UNDEF,
          12 => Opcode::SUBREG_TO_REG,
          13 => Opcode::COPY_TO_REGCLASS,
          14 => Opcode::DBG_VALUE,
          15 => Opcode::DBG_VALUE_LIST,
          16 => Opcode::DBG_INSTR_REF,
          17 => Opcode::DBG_PHI,
          18 => Opcode::DBG_LABEL,
          19 => Opcode::REG_SEQUENCE,
          20 => Opcode::COPY,
          21 => Opcode::BUNDLE,
          22 => Opcode::LIFETIME_START,
          23 => Opcode::LIFETIME_END,
          24 => Opcode::PSEUDO_PROBE,
          25 => Opcode::ARITH_FENCE,
          26 => Opcode::STACKMAP,
          27 => Opcode::FENTRY_CALL,
          28 => Opcode::PATCHPOINT,
          29 => Opcode::LOAD_STACK_GUARD,
          30 => Opcode::PREALLOCATED_SETUP,
          31 => Opcode::PREALLOCATED_ARG,
          32 => Opcode::STATEPOINT,
          33 => Opcode::LOCAL_ESCAPE,
          34 => Opcode::FAULTING_OP,
          35 => Opcode::PATCHABLE_OP,
          36 => Opcode::PATCHABLE_FUNCTION_ENTER,
          37 => Opcode::PATCHABLE_RET,
          38 => Opcode::PATCHABLE_FUNCTION_EXIT,
          39 => Opcode::PATCHABLE_TAIL_CALL,
          40 => Opcode::PATCHABLE_EVENT_CALL,
          41 => Opcode::PATCHABLE_TYPED_EVENT_CALL,
          42 => Opcode::ICALL_BRANCH_FUNNEL,
          43 => Opcode::FAKE_USE,
          44 => Opcode::MEMBARRIER,
          45 => Opcode::JUMP_TABLE_DEBUG_INFO,
          46 => Opcode::CONVERGENCECTRL_ENTRY,
          47 => Opcode::CONVERGENCECTRL_ANCHOR,
          48 => Opcode::CONVERGENCECTRL_LOOP,
          49 => Opcode::CONVERGENCECTRL_GLUE,
          50 => Opcode::G_ASSERT_SEXT,
          51 => Opcode::G_ASSERT_ZEXT,
          52 => Opcode::G_ASSERT_ALIGN,
          53 => Opcode::G_ADD,
          54 => Opcode::G_SUB,
          55 => Opcode::G_MUL,
          56 => Opcode::G_SDIV,
          57 => Opcode::G_UDIV,
          58 => Opcode::G_SREM,
          59 => Opcode::G_UREM,
          60 => Opcode::G_SDIVREM,
          61 => Opcode::G_UDIVREM,
          62 => Opcode::G_AND,
          63 => Opcode::G_OR,
          64 => Opcode::G_XOR,
          65 => Opcode::G_ABDS,
          66 => Opcode::G_ABDU,
          67 => Opcode::G_IMPLICIT_DEF,
          68 => Opcode::G_PHI,
          69 => Opcode::G_FRAME_INDEX,
          70 => Opcode::G_GLOBAL_VALUE,
          71 => Opcode::G_PTRAUTH_GLOBAL_VALUE,
          72 => Opcode::G_CONSTANT_POOL,
          73 => Opcode::G_EXTRACT,
          74 => Opcode::G_UNMERGE_VALUES,
          75 => Opcode::G_INSERT,
          76 => Opcode::G_MERGE_VALUES,
          77 => Opcode::G_BUILD_VECTOR,
          78 => Opcode::G_BUILD_VECTOR_TRUNC,
          79 => Opcode::G_CONCAT_VECTORS,
          80 => Opcode::G_PTRTOINT,
          81 => Opcode::G_INTTOPTR,
          82 => Opcode::G_BITCAST,
          83 => Opcode::G_FREEZE,
          84 => Opcode::G_CONSTANT_FOLD_BARRIER,
          85 => Opcode::G_INTRINSIC_FPTRUNC_ROUND,
          86 => Opcode::G_INTRINSIC_TRUNC,
          87 => Opcode::G_INTRINSIC_ROUND,
          88 => Opcode::G_INTRINSIC_LRINT,
          89 => Opcode::G_INTRINSIC_LLRINT,
          90 => Opcode::G_INTRINSIC_ROUNDEVEN,
          91 => Opcode::G_READCYCLECOUNTER,
          92 => Opcode::G_READSTEADYCOUNTER,
          93 => Opcode::G_LOAD,
          94 => Opcode::G_SEXTLOAD,
          95 => Opcode::G_ZEXTLOAD,
          96 => Opcode::G_INDEXED_LOAD,
          97 => Opcode::G_INDEXED_SEXTLOAD,
          98 => Opcode::G_INDEXED_ZEXTLOAD,
          99 => Opcode::G_STORE,
          100 => Opcode::G_INDEXED_STORE,
          101 => Opcode::G_ATOMIC_CMPXCHG_WITH_SUCCESS,
          102 => Opcode::G_ATOMIC_CMPXCHG,
          103 => Opcode::G_ATOMICRMW_XCHG,
          104 => Opcode::G_ATOMICRMW_ADD,
          105 => Opcode::G_ATOMICRMW_SUB,
          106 => Opcode::G_ATOMICRMW_AND,
          107 => Opcode::G_ATOMICRMW_NAND,
          108 => Opcode::G_ATOMICRMW_OR,
          109 => Opcode::G_ATOMICRMW_XOR,
          110 => Opcode::G_ATOMICRMW_MAX,
          111 => Opcode::G_ATOMICRMW_MIN,
          112 => Opcode::G_ATOMICRMW_UMAX,
          113 => Opcode::G_ATOMICRMW_UMIN,
          114 => Opcode::G_ATOMICRMW_FADD,
          115 => Opcode::G_ATOMICRMW_FSUB,
          116 => Opcode::G_ATOMICRMW_FMAX,
          117 => Opcode::G_ATOMICRMW_FMIN,
          118 => Opcode::G_ATOMICRMW_FMAXIMUM,
          119 => Opcode::G_ATOMICRMW_FMINIMUM,
          120 => Opcode::G_ATOMICRMW_UINC_WRAP,
          121 => Opcode::G_ATOMICRMW_UDEC_WRAP,
          122 => Opcode::G_ATOMICRMW_USUB_COND,
          123 => Opcode::G_ATOMICRMW_USUB_SAT,
          124 => Opcode::G_FENCE,
          125 => Opcode::G_PREFETCH,
          126 => Opcode::G_BRCOND,
          127 => Opcode::G_BRINDIRECT,
          128 => Opcode::G_INVOKE_REGION_START,
          129 => Opcode::G_INTRINSIC,
          130 => Opcode::G_INTRINSIC_W_SIDE_EFFECTS,
          131 => Opcode::G_INTRINSIC_CONVERGENT,
          132 => Opcode::G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
          133 => Opcode::G_ANYEXT,
          134 => Opcode::G_TRUNC,
          135 => Opcode::G_TRUNC_SSAT_S,
          136 => Opcode::G_TRUNC_SSAT_U,
          137 => Opcode::G_TRUNC_USAT_U,
          138 => Opcode::G_CONSTANT,
          139 => Opcode::G_FCONSTANT,
          140 => Opcode::G_VASTART,
          141 => Opcode::G_VAARG,
          142 => Opcode::G_SEXT,
          143 => Opcode::G_SEXT_INREG,
          144 => Opcode::G_ZEXT,
          145 => Opcode::G_SHL,
          146 => Opcode::G_LSHR,
          147 => Opcode::G_ASHR,
          148 => Opcode::G_FSHL,
          149 => Opcode::G_FSHR,
          150 => Opcode::G_ROTR,
          151 => Opcode::G_ROTL,
          152 => Opcode::G_ICMP,
          153 => Opcode::G_FCMP,
          154 => Opcode::G_SCMP,
          155 => Opcode::G_UCMP,
          156 => Opcode::G_SELECT,
          157 => Opcode::G_UADDO,
          158 => Opcode::G_UADDE,
          159 => Opcode::G_USUBO,
          160 => Opcode::G_USUBE,
          161 => Opcode::G_SADDO,
          162 => Opcode::G_SADDE,
          163 => Opcode::G_SSUBO,
          164 => Opcode::G_SSUBE,
          165 => Opcode::G_UMULO,
          166 => Opcode::G_SMULO,
          167 => Opcode::G_UMULH,
          168 => Opcode::G_SMULH,
          169 => Opcode::G_UADDSAT,
          170 => Opcode::G_SADDSAT,
          171 => Opcode::G_USUBSAT,
          172 => Opcode::G_SSUBSAT,
          173 => Opcode::G_USHLSAT,
          174 => Opcode::G_SSHLSAT,
          175 => Opcode::G_SMULFIX,
          176 => Opcode::G_UMULFIX,
          177 => Opcode::G_SMULFIXSAT,
          178 => Opcode::G_UMULFIXSAT,
          179 => Opcode::G_SDIVFIX,
          180 => Opcode::G_UDIVFIX,
          181 => Opcode::G_SDIVFIXSAT,
          182 => Opcode::G_UDIVFIXSAT,
          183 => Opcode::G_FADD,
          184 => Opcode::G_FSUB,
          185 => Opcode::G_FMUL,
          186 => Opcode::G_FMA,
          187 => Opcode::G_FMAD,
          188 => Opcode::G_FDIV,
          189 => Opcode::G_FREM,
          190 => Opcode::G_FPOW,
          191 => Opcode::G_FPOWI,
          192 => Opcode::G_FEXP,
          193 => Opcode::G_FEXP2,
          194 => Opcode::G_FEXP10,
          195 => Opcode::G_FLOG,
          196 => Opcode::G_FLOG2,
          197 => Opcode::G_FLOG10,
          198 => Opcode::G_FLDEXP,
          199 => Opcode::G_FFREXP,
          200 => Opcode::G_FNEG,
          201 => Opcode::G_FPEXT,
          202 => Opcode::G_FPTRUNC,
          203 => Opcode::G_FPTOSI,
          204 => Opcode::G_FPTOUI,
          205 => Opcode::G_SITOFP,
          206 => Opcode::G_UITOFP,
          207 => Opcode::G_FPTOSI_SAT,
          208 => Opcode::G_FPTOUI_SAT,
          209 => Opcode::G_FABS,
          210 => Opcode::G_FCOPYSIGN,
          211 => Opcode::G_IS_FPCLASS,
          212 => Opcode::G_FCANONICALIZE,
          213 => Opcode::G_FMINNUM,
          214 => Opcode::G_FMAXNUM,
          215 => Opcode::G_FMINNUM_IEEE,
          216 => Opcode::G_FMAXNUM_IEEE,
          217 => Opcode::G_FMINIMUM,
          218 => Opcode::G_FMAXIMUM,
          219 => Opcode::G_FMINIMUMNUM,
          220 => Opcode::G_FMAXIMUMNUM,
          221 => Opcode::G_GET_FPENV,
          222 => Opcode::G_SET_FPENV,
          223 => Opcode::G_RESET_FPENV,
          224 => Opcode::G_GET_FPMODE,
          225 => Opcode::G_SET_FPMODE,
          226 => Opcode::G_RESET_FPMODE,
          227 => Opcode::G_GET_ROUNDING,
          228 => Opcode::G_PTR_ADD,
          229 => Opcode::G_PTRMASK,
          230 => Opcode::G_SMIN,
          231 => Opcode::G_SMAX,
          232 => Opcode::G_UMIN,
          233 => Opcode::G_UMAX,
          234 => Opcode::G_ABS,
          235 => Opcode::G_LROUND,
          236 => Opcode::G_LLROUND,
          237 => Opcode::G_BR,
          238 => Opcode::G_BRJT,
          239 => Opcode::G_VSCALE,
          240 => Opcode::G_INSERT_SUBVECTOR,
          241 => Opcode::G_EXTRACT_SUBVECTOR,
          242 => Opcode::G_INSERT_VECTOR_ELT,
          243 => Opcode::G_EXTRACT_VECTOR_ELT,
          244 => Opcode::G_SHUFFLE_VECTOR,
          245 => Opcode::G_SPLAT_VECTOR,
          246 => Opcode::G_STEP_VECTOR,
          247 => Opcode::G_VECTOR_COMPRESS,
          248 => Opcode::G_CTTZ,
          249 => Opcode::G_CTTZ_ZERO_UNDEF,
          250 => Opcode::G_CTLZ,
          251 => Opcode::G_CTLZ_ZERO_UNDEF,
          252 => Opcode::G_CTPOP,
          253 => Opcode::G_BSWAP,
          254 => Opcode::G_BITREVERSE,
          255 => Opcode::G_FCEIL,
          256 => Opcode::G_FCOS,
          257 => Opcode::G_FSIN,
          258 => Opcode::G_FSINCOS,
          259 => Opcode::G_FTAN,
          260 => Opcode::G_FACOS,
          261 => Opcode::G_FASIN,
          262 => Opcode::G_FATAN,
          263 => Opcode::G_FATAN2,
          264 => Opcode::G_FCOSH,
          265 => Opcode::G_FSINH,
          266 => Opcode::G_FTANH,
          267 => Opcode::G_FSQRT,
          268 => Opcode::G_FFLOOR,
          269 => Opcode::G_FRINT,
          270 => Opcode::G_FNEARBYINT,
          271 => Opcode::G_ADDRSPACE_CAST,
          272 => Opcode::G_BLOCK_ADDR,
          273 => Opcode::G_JUMP_TABLE,
          274 => Opcode::G_DYN_STACKALLOC,
          275 => Opcode::G_STACKSAVE,
          276 => Opcode::G_STACKRESTORE,
          277 => Opcode::G_STRICT_FADD,
          278 => Opcode::G_STRICT_FSUB,
          279 => Opcode::G_STRICT_FMUL,
          280 => Opcode::G_STRICT_FDIV,
          281 => Opcode::G_STRICT_FREM,
          282 => Opcode::G_STRICT_FMA,
          283 => Opcode::G_STRICT_FSQRT,
          284 => Opcode::G_STRICT_FLDEXP,
          285 => Opcode::G_READ_REGISTER,
          286 => Opcode::G_WRITE_REGISTER,
          287 => Opcode::G_MEMCPY,
          288 => Opcode::G_MEMCPY_INLINE,
          289 => Opcode::G_MEMMOVE,
          290 => Opcode::G_MEMSET,
          291 => Opcode::G_BZERO,
          292 => Opcode::G_TRAP,
          293 => Opcode::G_DEBUGTRAP,
          294 => Opcode::G_UBSANTRAP,
          295 => Opcode::G_VECREDUCE_SEQ_FADD,
          296 => Opcode::G_VECREDUCE_SEQ_FMUL,
          297 => Opcode::G_VECREDUCE_FADD,
          298 => Opcode::G_VECREDUCE_FMUL,
          299 => Opcode::G_VECREDUCE_FMAX,
          300 => Opcode::G_VECREDUCE_FMIN,
          301 => Opcode::G_VECREDUCE_FMAXIMUM,
          302 => Opcode::G_VECREDUCE_FMINIMUM,
          303 => Opcode::G_VECREDUCE_ADD,
          304 => Opcode::G_VECREDUCE_MUL,
          305 => Opcode::G_VECREDUCE_AND,
          306 => Opcode::G_VECREDUCE_OR,
          307 => Opcode::G_VECREDUCE_XOR,
          308 => Opcode::G_VECREDUCE_SMAX,
          309 => Opcode::G_VECREDUCE_SMIN,
          310 => Opcode::G_VECREDUCE_UMAX,
          311 => Opcode::G_VECREDUCE_UMIN,
          312 => Opcode::G_SBFX,
          313 => Opcode::G_UBFX,
          314 => Opcode::ADJCALLSTACKDOWN,
          315 => Opcode::ADJCALLSTACKUP,
          316 => Opcode::FI_ri,
          317 => Opcode::MEMCPY,
          318 => Opcode::Select,
          319 => Opcode::Select_32,
          320 => Opcode::Select_32_64,
          321 => Opcode::Select_64_32,
          322 => Opcode::Select_Ri,
          323 => Opcode::Select_Ri_32,
          324 => Opcode::Select_Ri_32_64,
          325 => Opcode::Select_Ri_64_32,
          326 => Opcode::ADDR_SPACE_CAST,
          327 => Opcode::ADD_ri,
          328 => Opcode::ADD_ri_32,
          329 => Opcode::ADD_rr,
          330 => Opcode::ADD_rr_32,
          331 => Opcode::AND_ri,
          332 => Opcode::AND_ri_32,
          333 => Opcode::AND_rr,
          334 => Opcode::AND_rr_32,
          335 => Opcode::BE16,
          336 => Opcode::BE32,
          337 => Opcode::BE64,
          338 => Opcode::BSWAP16,
          339 => Opcode::BSWAP32,
          340 => Opcode::BSWAP64,
          341 => Opcode::CMPXCHGD,
          342 => Opcode::CMPXCHGW32,
          343 => Opcode::CORE_LD32,
          344 => Opcode::CORE_LD64,
          345 => Opcode::CORE_SHIFT,
          346 => Opcode::CORE_ST,
          347 => Opcode::DIV_ri,
          348 => Opcode::DIV_ri_32,
          349 => Opcode::DIV_rr,
          350 => Opcode::DIV_rr_32,
          351 => Opcode::JAL,
          352 => Opcode::JALX,
          353 => Opcode::JCOND,
          354 => Opcode::JEQ_ri,
          355 => Opcode::JEQ_ri_32,
          356 => Opcode::JEQ_rr,
          357 => Opcode::JEQ_rr_32,
          358 => Opcode::JMP,
          359 => Opcode::JMPL,
          360 => Opcode::JNE_ri,
          361 => Opcode::JNE_ri_32,
          362 => Opcode::JNE_rr,
          363 => Opcode::JNE_rr_32,
          364 => Opcode::JSET_ri,
          365 => Opcode::JSET_ri_32,
          366 => Opcode::JSET_rr,
          367 => Opcode::JSET_rr_32,
          368 => Opcode::JSGE_ri,
          369 => Opcode::JSGE_ri_32,
          370 => Opcode::JSGE_rr,
          371 => Opcode::JSGE_rr_32,
          372 => Opcode::JSGT_ri,
          373 => Opcode::JSGT_ri_32,
          374 => Opcode::JSGT_rr,
          375 => Opcode::JSGT_rr_32,
          376 => Opcode::JSLE_ri,
          377 => Opcode::JSLE_ri_32,
          378 => Opcode::JSLE_rr,
          379 => Opcode::JSLE_rr_32,
          380 => Opcode::JSLT_ri,
          381 => Opcode::JSLT_ri_32,
          382 => Opcode::JSLT_rr,
          383 => Opcode::JSLT_rr_32,
          384 => Opcode::JUGE_ri,
          385 => Opcode::JUGE_ri_32,
          386 => Opcode::JUGE_rr,
          387 => Opcode::JUGE_rr_32,
          388 => Opcode::JUGT_ri,
          389 => Opcode::JUGT_ri_32,
          390 => Opcode::JUGT_rr,
          391 => Opcode::JUGT_rr_32,
          392 => Opcode::JULE_ri,
          393 => Opcode::JULE_ri_32,
          394 => Opcode::JULE_rr,
          395 => Opcode::JULE_rr_32,
          396 => Opcode::JULT_ri,
          397 => Opcode::JULT_ri_32,
          398 => Opcode::JULT_rr,
          399 => Opcode::JULT_rr_32,
          400 => Opcode::LDB,
          401 => Opcode::LDB32,
          402 => Opcode::LDBACQ32,
          403 => Opcode::LDBSX,
          404 => Opcode::LDD,
          405 => Opcode::LDDACQ,
          406 => Opcode::LDH,
          407 => Opcode::LDH32,
          408 => Opcode::LDHACQ32,
          409 => Opcode::LDHSX,
          410 => Opcode::LDW,
          411 => Opcode::LDW32,
          412 => Opcode::LDWACQ32,
          413 => Opcode::LDWSX,
          414 => Opcode::LD_ABS_B,
          415 => Opcode::LD_ABS_H,
          416 => Opcode::LD_ABS_W,
          417 => Opcode::LD_IND_B,
          418 => Opcode::LD_IND_H,
          419 => Opcode::LD_IND_W,
          420 => Opcode::LD_imm64,
          421 => Opcode::LD_pseudo,
          422 => Opcode::LE16,
          423 => Opcode::LE32,
          424 => Opcode::LE64,
          425 => Opcode::MOD_ri,
          426 => Opcode::MOD_ri_32,
          427 => Opcode::MOD_rr,
          428 => Opcode::MOD_rr_32,
          429 => Opcode::MOVSX_rr_16,
          430 => Opcode::MOVSX_rr_32,
          431 => Opcode::MOVSX_rr_32_16,
          432 => Opcode::MOVSX_rr_32_8,
          433 => Opcode::MOVSX_rr_8,
          434 => Opcode::MOV_32_64,
          435 => Opcode::MOV_ri,
          436 => Opcode::MOV_ri_32,
          437 => Opcode::MOV_rr,
          438 => Opcode::MOV_rr_32,
          439 => Opcode::MUL_ri,
          440 => Opcode::MUL_ri_32,
          441 => Opcode::MUL_rr,
          442 => Opcode::MUL_rr_32,
          443 => Opcode::NEG_32,
          444 => Opcode::NEG_64,
          445 => Opcode::NOP,
          446 => Opcode::OR_ri,
          447 => Opcode::OR_ri_32,
          448 => Opcode::OR_rr,
          449 => Opcode::OR_rr_32,
          450 => Opcode::RET,
          451 => Opcode::SDIV_ri,
          452 => Opcode::SDIV_ri_32,
          453 => Opcode::SDIV_rr,
          454 => Opcode::SDIV_rr_32,
          455 => Opcode::SLL_ri,
          456 => Opcode::SLL_ri_32,
          457 => Opcode::SLL_rr,
          458 => Opcode::SLL_rr_32,
          459 => Opcode::SMOD_ri,
          460 => Opcode::SMOD_ri_32,
          461 => Opcode::SMOD_rr,
          462 => Opcode::SMOD_rr_32,
          463 => Opcode::SRA_ri,
          464 => Opcode::SRA_ri_32,
          465 => Opcode::SRA_rr,
          466 => Opcode::SRA_rr_32,
          467 => Opcode::SRL_ri,
          468 => Opcode::SRL_ri_32,
          469 => Opcode::SRL_rr,
          470 => Opcode::SRL_rr_32,
          471 => Opcode::STB,
          472 => Opcode::STB32,
          473 => Opcode::STBREL32,
          474 => Opcode::STB_imm,
          475 => Opcode::STD,
          476 => Opcode::STDREL,
          477 => Opcode::STD_imm,
          478 => Opcode::STH,
          479 => Opcode::STH32,
          480 => Opcode::STHREL32,
          481 => Opcode::STH_imm,
          482 => Opcode::STW,
          483 => Opcode::STW32,
          484 => Opcode::STWREL32,
          485 => Opcode::STW_imm,
          486 => Opcode::SUB_ri,
          487 => Opcode::SUB_ri_32,
          488 => Opcode::SUB_rr,
          489 => Opcode::SUB_rr_32,
          490 => Opcode::XADDD,
          491 => Opcode::XADDW,
          492 => Opcode::XADDW32,
          493 => Opcode::XANDD,
          494 => Opcode::XANDW32,
          495 => Opcode::XCHGD,
          496 => Opcode::XCHGW32,
          497 => Opcode::XFADDD,
          498 => Opcode::XFADDW32,
          499 => Opcode::XFANDD,
          500 => Opcode::XFANDW32,
          501 => Opcode::XFORD,
          502 => Opcode::XFORW32,
          503 => Opcode::XFXORD,
          504 => Opcode::XFXORW32,
          505 => Opcode::XORD,
          506 => Opcode::XORW32,
          507 => Opcode::XOR_ri,
          508 => Opcode::XOR_ri_32,
          509 => Opcode::XOR_rr,
          510 => Opcode::XOR_rr_32,
          511 => Opcode::XXORD,
          512 => Opcode::XXORW32,
          513 => Opcode::INSTRUCTION_LIST_END,
          _ => Opcode::UNKNOWN(value),
        }
    }
}
