// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <ExtrudedVolPluginInfo.h>
#include <avtExtrudedVolFileFormat.h>
#include <avtSTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>
#include <avtExtrudedVolOptions.h>

// ****************************************************************************
//  Method:  ExtrudedVolCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a ExtrudedVol database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
DatabaseType
ExtrudedVolCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STMD;
}

// ****************************************************************************
//  Method: ExtrudedVolCommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a ExtrudedVol database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A ExtrudedVol database from list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
avtDatabase *
ExtrudedVolCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTMDFileFormat **ffl = new avtSTMDFileFormat*[nList];
    for (int i = 0; i < nList; i++)
    {
        ffl[i] = new avtExtrudedVolFileFormat(list[i], readOptions);
    }
    avtSTMDFileFormatInterface *inter
           = new avtSTMDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}

// ****************************************************************************
//  Method: ExtrudedVolCommonPluginInfo::GetReadOptions
//
//  Purpose:
//      Gets the read options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
ExtrudedVolCommonPluginInfo::GetReadOptions() const
{
    return GetExtrudedVolReadOptions();
}

// ****************************************************************************
//  Method: ExtrudedVolCommonPluginInfo::GetWriteOptions
//
//  Purpose:
//      Gets the write options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
ExtrudedVolCommonPluginInfo::GetWriteOptions() const
{
    return GetExtrudedVolWriteOptions();
}

