#!/usr/bin/env python3

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.

import sh4lt as s
import time

frame_duration_ms = 10
client_has_connected = False
server_has_disconnected = False


def on_data(data, size, time_info):
    assert len(data) == size
    assert "are belong to us".startswith(data.decode(encoding="utf-8"))
    assert 0 == (time_info.buffer_date % time_info.buffer_duration)
    assert time_info.buffer_duration == frame_duration_ms * 1000000


def on_server_connected(shtype):
    assert shtype.media() == "text/x-raw"


def on_server_disconnected():
    global server_has_disconnected
    server_has_disconnected = True


def on_client_connected(num):
    global client_has_connected
    client_has_connected = True


def on_client_disconnected(num):
    pass


# Create a Sh4lt description (a ShType object)
shtype = s.ShType("text/x-raw", "text", s.ShType.default_group())
assert shtype

# Create a log for both the Writer and the Follower
log = s.PyLogger()
assert log

# Create a Sh4lt Follower
follower = s.Follower(shtype.path(), on_data, on_server_connected, on_server_disconnected, log)
assert follower

# Create a Sh4lt Writer
writer = s.Writer(shtype, 1, log, on_client_connected, on_client_disconnected, 0o0660)
assert writer
data = bytearray("are belong to us", encoding="utf-8")
i = 0
while i < len(data):
    time.sleep(frame_duration_ms / 1000)
    i += 1
    assert writer.copy_to_shm(data, i * frame_duration_ms * 1000000, frame_duration_ms * 1000000)
    assert 1 == writer.num_of_followers()
    assert follower.is_connected()

writer = None
# wait for the follower to  handle writer disconnection
time.sleep(0.1)
follower = None
assert server_has_disconnected
assert client_has_connected
