/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/YlOrRd.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 128, 0, 38, 255, 189, 0, 38, 255, 227, 26, 28, 255, 252, 78, 42, 255, 253, 141, 60, 255, 254, 178, 76, 255, 254, 217, 118, 255, 255, 237, 160, 255, 255, 255, 204, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_YlOrRd_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 127, 0, 37, 0, 128, 0, 38, 7, 128, 0, 38, 14, 129, 0, 38, 22, 129, 0, 38, 29, 130, 0, 38, 37, 130, 0, 38, 44, 131, 0, 38, 52, 131, 0, 38, 59, 132, 0, 38, 67, 132, 0, 38, 74, 133, 0, 38, 82, 133, 0, 38, 89, 134, 0, 38, 97, 134, 0, 38, 104, 135, 0, 38, 112, 135, 0, 38, 119, 136, 0, 38, 127, 136, 0, 38, 134, 137, 0, 38, 141, 137, 0, 38, 149, 138, 0, 38, 156, 138, 0, 38, 164, 138, 0, 38, 171, 139, 0, 38, 179, 139, 0, 38, 186, 140, 0, 39, 194, 140, 0, 39, 201, 141, 0, 39, 209, 141, 0, 39, 216, 142, 0, 39, 224, 142, 0, 39, 231, 143, 0, 39, 239, 143, 0, 39, 246, 144, 0, 39, 254, 144, 0, 39, 255, 145, 0, 39, 255, 145, 0, 39, 255, 146, 0, 39, 255, 146, 0, 39, 255, 147, 0, 39, 255, 147, 0, 39, 255, 148, 0, 39, 255, 148, 0, 39, 255, 149, 0, 39, 255, 149, 0, 39, 255, 150, 0, 39, 255, 150, 0, 39, 255, 150, 0, 39, 255, 151, 0, 39, 255, 151, 0, 39, 255, 152, 0, 39, 255, 152, 0, 39, 255, 153, 0, 39, 255, 153, 0, 39, 255, 154, 0, 39, 255, 154, 0, 39, 255, 155, 0, 39, 255, 155, 0, 39, 255, 156, 0, 39, 255, 156, 0, 39, 255, 157, 0, 39, 255, 157, 0, 39, 255, 158, 0, 39, 255, 158, 0, 39, 255, 159, 0, 39, 255, 159, 0, 39, 255, 160, 0, 39, 255, 160, 0, 39, 255, 161, 0, 39, 255, 161, 0, 39, 255, 161, 0, 39, 255, 162, 0, 39, 255, 162, 0, 39, 255, 163, 0, 39, 255, 163, 0, 39, 255, 164, 0, 39, 255, 164, 0, 39, 255, 165, 0, 39, 255, 165, 0, 39, 255, 166, 0, 39, 255, 166, 0, 39, 255, 167, 0, 39, 255, 167, 0, 39, 255, 168, 0, 39, 255, 168, 0, 39, 255, 169, 0, 39, 255, 169, 0, 39, 255, 170, 0, 39, 255, 170, 0, 39, 255, 171, 0, 39, 255, 171, 0, 39, 255, 171, 0, 39, 255, 172, 0, 39, 255, 172, 0, 39, 255, 173, 0, 39, 255, 173, 0, 39, 255, 174, 0, 39, 255, 174, 0, 39, 255, 175, 0, 39, 255, 175, 0, 39, 255, 176, 0, 39, 255, 176, 0, 39, 255, 177, 0, 39, 255, 177, 0, 39, 255, 178, 0, 38, 255, 178, 0, 38, 255, 179, 0, 38, 255, 179, 0, 38, 255, 180, 0, 38, 255, 180, 0, 38, 255, 180, 0, 38, 255, 181, 0, 38, 255, 181, 0, 38, 255, 182, 0, 38, 255, 182, 0, 38, 255, 183, 0, 38, 255, 183, 0, 38, 255, 184, 0, 38, 255, 184, 0, 38, 255, 185, 0, 38, 255, 185, 0, 38, 255, 186, 0, 38, 255, 186, 0, 38, 255, 187, 0, 38, 255, 187, 0, 38, 255, 188, 0, 38, 255, 188, 0, 38, 255, 188, 0, 37, 255, 189, 0, 37, 255, 189, 0, 37, 255, 189, 0, 37, 255, 190, 0, 37, 255, 190, 0, 37, 255, 190, 0, 37, 255, 191, 0, 37, 255, 191, 1, 37, 255, 191, 1, 37, 255, 192, 1, 37, 255, 192, 1, 37, 255, 192, 1, 37, 255, 192, 1, 37, 255, 193, 1, 37, 255, 193, 2, 37, 255, 193, 2, 37, 255, 194, 2, 37, 255, 194, 2, 37, 255, 194, 2, 37, 255, 195, 2, 37, 255, 195, 2, 37, 255, 195, 3, 36, 255, 195, 3, 36, 255, 196, 3, 36, 255, 196, 3, 36, 255, 196, 3, 36, 255, 197, 3, 36, 255, 197, 4, 36, 255, 197, 4, 36, 255, 198, 4, 36, 255, 198, 4, 36, 255, 198, 4, 36, 255, 199, 5, 36, 255, 199, 5, 36, 255, 199, 5, 36, 255, 199, 5, 36, 255, 200, 5, 36, 255, 200, 6, 36, 255, 200, 6, 35, 255, 201, 6, 35, 255, 201, 6, 35, 255, 201, 6, 35, 255, 202, 7, 35, 255, 202, 7, 35, 255, 202, 7, 35, 255, 202, 7, 35, 255, 203, 7, 35, 255, 203, 8, 35, 255, 203, 8, 35, 255, 204, 8, 35, 255, 204, 8, 35, 255, 204, 8, 35, 255, 205, 9, 35, 255, 205, 9, 35, 255, 205, 9, 34, 255, 205, 9, 34, 255, 206, 10, 34, 255, 206, 10, 34, 255, 206, 10, 34, 255, 207, 10, 34, 255, 207, 11, 34, 255, 207, 11, 34, 255, 207, 11, 34, 255, 208, 11, 34, 255, 208, 12, 34, 255, 208, 12, 34, 255, 209, 12, 34, 255, 209, 12, 33, 255, 209, 12, 33, 255, 210, 13, 33, 255, 210, 13, 33, 255, 210, 13, 33, 255, 210, 13, 33, 255, 211, 14, 33, 255, 211, 14, 33, 255, 211, 14, 33, 255, 212, 14, 33, 255, 212, 15, 33, 255, 212, 15, 33, 255, 213, 15, 33, 255, 213, 15, 32, 255, 213, 15, 32, 255, 213, 16, 32, 255, 214, 16, 32, 255, 214, 16, 32, 255, 214, 16, 32, 255, 215, 17, 32, 255, 215, 17, 32, 255, 215, 17, 32, 255, 215, 17, 32, 255, 216, 17, 32, 255, 216, 18, 31, 255, 216, 18, 31, 255, 217, 18, 31, 255, 217, 18, 31, 255, 217, 19, 31, 255, 218, 19, 31, 255, 218, 19, 31, 255, 218, 19, 31, 255, 218, 19, 31, 255, 219, 20, 31, 255, 219, 20, 30, 255, 219, 20, 30, 255, 220, 20, 30, 255, 220, 20, 30, 255, 220, 21, 30, 255, 220, 21, 30, 255, 221, 21, 30, 255, 221, 21, 30, 255, 221, 22, 30, 255, 222, 22, 29, 255, 222, 22, 29, 255, 222, 22, 29, 255, 222, 22, 29, 255, 223, 23, 29, 255, 223, 23, 29, 255, 223, 23, 29, 255, 224, 23, 29, 255, 224, 24, 29, 255, 224, 24, 28, 255, 224, 24, 28, 255, 225, 24, 28, 255, 225, 24, 28, 255, 225, 25, 28, 255, 226, 25, 28, 255, 226, 25, 28, 255, 226, 25, 28, 255, 226, 26, 27, 255, 227, 26, 28, 255, 227, 27, 28, 255, 227, 27, 28, 255, 227, 28, 28, 255, 227, 29, 28, 255, 228, 29, 28, 255, 228, 30, 28, 255, 228, 30, 28, 255, 228, 31, 28, 255, 228, 32, 28, 255, 229, 32, 29, 255, 229, 33, 29, 255, 229, 33, 29, 255, 229, 34, 29, 255, 229, 34, 29, 255, 230, 35, 29, 255, 230, 35, 29, 255, 230, 36, 29, 255, 230, 36, 29, 255, 230, 37, 29, 255, 231, 37, 30, 255, 231, 38, 30, 255, 231, 38, 30, 255, 231, 39, 30, 255, 231, 39, 30, 255, 232, 40, 30, 255, 232, 40, 30, 255, 232, 41, 30, 255, 232, 41, 30, 255, 232, 42, 31, 255, 233, 42, 31, 255, 233, 42, 31, 255, 233, 43, 31, 255, 233, 43, 31, 255, 233, 44, 31, 255, 234, 44, 31, 255, 234, 45, 31, 255, 234, 45, 31, 255, 234, 46, 31, 255, 234, 46, 32, 255, 235, 46, 32, 255, 235, 47, 32, 255, 235, 47, 32, 255, 235, 48, 32, 255, 235, 48, 32, 255, 236, 48, 32, 255, 236, 49, 32, 255, 236, 49, 32, 255, 236, 50, 33, 255, 236, 50, 33, 255, 237, 51, 33, 255, 237, 51, 33, 255, 237, 51, 33, 255, 237, 52, 33, 255, 237, 52, 33, 255, 238, 53, 33, 255, 238, 53, 33, 255, 238, 53, 33, 255, 238, 54, 34, 255, 238, 54, 34, 255, 238, 54, 34, 255, 239, 55, 34, 255, 239, 55, 34, 255, 239, 56, 34, 255, 239, 56, 34, 255, 239, 56, 34, 255, 240, 57, 34, 255, 240, 57, 35, 255, 240, 57, 35, 255, 240, 58, 35, 255, 240, 58, 35, 255, 241, 59, 35, 255, 241, 59, 35, 255, 241, 59, 35, 255, 241, 60, 35, 255, 241, 60, 35, 255, 242, 60, 36, 255, 242, 61, 36, 255, 242, 61, 36, 255, 242, 61, 36, 255, 242, 62, 36, 255, 243, 62, 36, 255, 243, 63, 36, 255, 243, 63, 36, 255, 243, 63, 36, 255, 243, 64, 37, 255, 244, 64, 37, 255, 244, 64, 37, 255, 244, 65, 37, 255, 244, 65, 37, 255, 244, 65, 37, 255, 245, 66, 37, 255, 245, 66, 37, 255, 245, 66, 38, 255, 245, 67, 38, 255, 245, 67, 38, 255, 246, 67, 38, 255, 246, 68, 38, 255, 246, 68, 38, 255, 246, 68, 38, 255, 246, 69, 38, 255, 246, 69, 38, 255, 247, 69, 39, 255, 247, 70, 39, 255, 247, 70, 39, 255, 247, 70, 39, 255, 247, 71, 39, 255, 248, 71, 39, 255, 248, 71, 39, 255, 248, 72, 39, 255, 248, 72, 39, 255, 248, 72, 40, 255, 249, 73, 40, 255, 249, 73, 40, 255, 249, 73, 40, 255, 249, 74, 40, 255, 249, 74, 40, 255, 250, 74, 40, 255, 250, 75, 40, 255, 250, 75, 41, 255, 250, 75, 41, 255, 250, 76, 41, 255, 251, 76, 41, 255, 251, 76, 41, 255, 251, 77, 41, 255, 251, 77, 41, 255, 251, 77, 41, 255, 251, 78, 41, 255, 252, 78, 42, 255, 252, 79, 42, 255, 252, 79, 42, 255, 252, 80, 42, 255, 252, 81, 42, 255, 252, 81, 42, 255, 252, 82, 42, 255, 252, 82, 42, 255, 252, 83, 42, 255, 252, 84, 42, 255, 252, 84, 42, 255, 252, 85, 42, 255, 252, 85, 42, 255, 252, 86, 42, 255, 252, 87, 42, 255, 252, 87, 42, 255, 252, 88, 42, 255, 252, 88, 42, 255, 252, 89, 42, 255, 252, 89, 42, 255, 252, 90, 42, 255, 252, 91, 43, 255, 252, 91, 43, 255, 252, 92, 43, 255, 252, 92, 43, 255, 252, 93, 43, 255, 252, 93, 43, 255, 252, 94, 43, 255, 252, 94, 43, 255, 252, 95, 43, 255, 252, 95, 43, 255, 252, 96, 43, 255, 252, 97, 43, 255, 252, 97, 43, 255, 252, 98, 44, 255, 252, 98, 44, 255, 252, 99, 44, 255, 252, 99, 44, 255, 252, 100, 44, 255, 252, 100, 44, 255, 252, 101, 44, 255, 252, 101, 44, 255, 252, 102, 44, 255, 252, 102, 44, 255, 252, 103, 45, 255, 252, 103, 45, 255, 252, 104, 45, 255, 252, 104, 45, 255, 252, 105, 45, 255, 252, 105, 45, 255, 252, 106, 45, 255, 252, 106, 45, 255, 252, 107, 45, 255, 252, 107, 46, 255, 252, 108, 46, 255, 252, 108, 46, 255, 252, 109, 46, 255, 252, 109, 46, 255, 252, 110, 46, 255, 252, 110, 46, 255, 252, 111, 46, 255, 252, 111, 47, 255, 252, 112, 47, 255, 252, 112, 47, 255, 252, 113, 47, 255, 252, 113, 47, 255, 252, 114, 47, 255, 252, 114, 47, 255, 252, 114, 48, 255, 252, 115, 48, 255, 252, 115, 48, 255, 252, 116, 48, 255, 252, 116, 48, 255, 252, 117, 48, 255, 252, 117, 49, 255, 252, 118, 49, 255, 252, 118, 49, 255, 252, 119, 49, 255, 252, 119, 49, 255, 252, 120, 49, 255, 252, 120, 50, 255, 252, 121, 50, 255, 252, 121, 50, 255, 252, 121, 50, 255, 252, 122, 50, 255, 252, 122, 50, 255, 252, 123, 51, 255, 252, 123, 51, 255, 252, 124, 51, 255, 252, 124, 51, 255, 252, 125, 51, 255, 252, 125, 52, 255, 252, 125, 52, 255, 252, 126, 52, 255, 252, 126, 52, 255, 252, 127, 52, 255, 252, 127, 53, 255, 252, 128, 53, 255, 253, 128, 53, 255, 253, 129, 53, 255, 253, 129, 53, 255, 253, 129, 54, 255, 253, 130, 54, 255, 253, 130, 54, 255, 253, 131, 54, 255, 253, 131, 54, 255, 253, 132, 55, 255, 253, 132, 55, 255, 253, 132, 55, 255, 253, 133, 55, 255, 253, 133, 55, 255, 253, 134, 56, 255, 253, 134, 56, 255, 253, 135, 56, 255, 253, 135, 56, 255, 253, 135, 57, 255, 253, 136, 57, 255, 253, 136, 57, 255, 253, 137, 57, 255, 253, 137, 58, 255, 253, 138, 58, 255, 253, 138, 58, 255, 253, 138, 58, 255, 253, 139, 59, 255, 253, 139, 59, 255, 253, 140, 59, 255, 253, 140, 59, 255, 252, 141, 59, 255, 253, 141, 60, 255, 253, 141, 60, 255, 253, 141, 60, 255, 253, 142, 60, 255, 253, 142, 60, 255, 253, 142, 60, 255, 253, 143, 60, 255, 253, 143, 60, 255, 253, 143, 60, 255, 253, 144, 60, 255, 253, 144, 60, 255, 253, 144, 60, 255, 253, 144, 61, 255, 253, 145, 61, 255, 253, 145, 61, 255, 253, 145, 61, 255, 253, 146, 61, 255, 253, 146, 61, 255, 253, 146, 61, 255, 253, 147, 61, 255, 253, 147, 61, 255, 253, 147, 61, 255, 253, 147, 61, 255, 253, 148, 61, 255, 253, 148, 62, 255, 253, 148, 62, 255, 253, 149, 62, 255, 253, 149, 62, 255, 253, 149, 62, 255, 253, 149, 62, 255, 253, 150, 62, 255, 253, 150, 62, 255, 253, 150, 62, 255, 253, 151, 62, 255, 253, 151, 63, 255, 253, 151, 63, 255, 253, 152, 63, 255, 253, 152, 63, 255, 253, 152, 63, 255, 253, 152, 63, 255, 253, 153, 63, 255, 253, 153, 63, 255, 253, 153, 63, 255, 253, 154, 63, 255, 253, 154, 64, 255, 253, 154, 64, 255, 253, 154, 64, 255, 253, 155, 64, 255, 253, 155, 64, 255, 253, 155, 64, 255, 253, 156, 64, 255, 253, 156, 64, 255, 253, 156, 65, 255, 253, 156, 65, 255, 253, 157, 65, 255, 253, 157, 65, 255, 253, 157, 65, 255, 253, 158, 65, 255, 253, 158, 65, 255, 253, 158, 65, 255, 253, 159, 65, 255, 253, 159, 66, 255, 253, 159, 66, 255, 253, 159, 66, 255, 253, 160, 66, 255, 253, 160, 66, 255, 253, 160, 66, 255, 253, 161, 66, 255, 253, 161, 66, 255, 253, 161, 67, 255, 253, 161, 67, 255, 253, 162, 67, 255, 253, 162, 67, 255, 253, 162, 67, 255, 253, 163, 67, 255, 253, 163, 67, 255, 253, 163, 68, 255, 253, 163, 68, 255, 253, 164, 68, 255, 253, 164, 68, 255, 253, 164, 68, 255, 253, 165, 68, 255, 253, 165, 68, 255, 253, 165, 69, 255, 253, 165, 69, 255, 253, 166, 69, 255, 253, 166, 69, 255, 253, 166, 69, 255, 253, 167, 69, 255, 253, 167, 69, 255, 253, 167, 70, 255, 253, 167, 70, 255, 253, 168, 70, 255, 253, 168, 70, 255, 253, 168, 70, 255, 253, 169, 70, 255, 253, 169, 70, 255, 253, 169, 71, 255, 253, 169, 71, 255, 253, 170, 71, 255, 253, 170, 71, 255, 253, 170, 71, 255, 253, 171, 71, 255, 253, 171, 72, 255, 253, 171, 72, 255, 253, 171, 72, 255, 253, 172, 72, 255, 253, 172, 72, 255, 253, 172, 72, 255, 253, 172, 72, 255, 253, 173, 73, 255, 253, 173, 73, 255, 253, 173, 73, 255, 253, 174, 73, 255, 253, 174, 73, 255, 254, 174, 73, 255, 254, 174, 74, 255, 254, 175, 74, 255, 254, 175, 74, 255, 254, 175, 74, 255, 254, 176, 74, 255, 254, 176, 74, 255, 254, 176, 75, 255, 254, 176, 75, 255, 254, 177, 75, 255, 254, 177, 75, 255, 254, 177, 75, 255, 253, 178, 75, 255, 253, 178, 76, 255, 253, 178, 76, 255, 253, 178, 76, 255, 253, 179, 77, 255, 253, 179, 77, 255, 253, 179, 77, 255, 253, 180, 77, 255, 253, 180, 78, 255, 253, 180, 78, 255, 253, 181, 78, 255, 253, 181, 79, 255, 253, 181, 79, 255, 253, 182, 79, 255, 253, 182, 80, 255, 253, 182, 80, 255, 253, 183, 80, 255, 253, 183, 80, 255, 253, 183, 81, 255, 253, 184, 81, 255, 253, 184, 81, 255, 253, 184, 82, 255, 253, 184, 82, 255, 253, 185, 82, 255, 253, 185, 82, 255, 253, 185, 83, 255, 253, 186, 83, 255, 253, 186, 83, 255, 253, 186, 84, 255, 253, 187, 84, 255, 253, 187, 84, 255, 253, 187, 85, 255, 253, 188, 85, 255, 253, 188, 85, 255, 253, 188, 86, 255, 253, 189, 86, 255, 253, 189, 86, 255, 253, 189, 86, 255, 253, 190, 87, 255, 253, 190, 87, 255, 253, 190, 87, 255, 253, 190, 88, 255, 253, 191, 88, 255, 253, 191, 88, 255, 253, 191, 89, 255, 253, 192, 89, 255, 253, 192, 89, 255, 253, 192, 90, 255, 253, 193, 90, 255, 253, 193, 90, 255, 253, 193, 91, 255, 253, 194, 91, 255, 253, 194, 91, 255, 253, 194, 92, 255, 253, 194, 92, 255, 253, 195, 92, 255, 253, 195, 93, 255, 253, 195, 93, 255, 253, 196, 93, 255, 253, 196, 93, 255, 253, 196, 94, 255, 253, 197, 94, 255, 253, 197, 94, 255, 253, 197, 95, 255, 253, 197, 95, 255, 253, 198, 95, 255, 253, 198, 96, 255, 253, 198, 96, 255, 253, 199, 96, 255, 253, 199, 97, 255, 253, 199, 97, 255, 253, 200, 97, 255, 253, 200, 98, 255, 253, 200, 98, 255, 253, 201, 98, 255, 253, 201, 99, 255, 253, 201, 99, 255, 253, 201, 99, 255, 253, 202, 100, 255, 253, 202, 100, 255, 253, 202, 100, 255, 253, 203, 101, 255, 253, 203, 101, 255, 253, 203, 102, 255, 253, 204, 102, 255, 253, 204, 102, 255, 253, 204, 103, 255, 253, 204, 103, 255, 253, 205, 103, 255, 253, 205, 104, 255, 253, 205, 104, 255, 253, 206, 104, 255, 253, 206, 105, 255, 253, 206, 105, 255, 253, 207, 105, 255, 253, 207, 106, 255, 253, 207, 106, 255, 253, 207, 106, 255, 253, 208, 107, 255, 253, 208, 107, 255, 253, 208, 107, 255, 253, 209, 108, 255, 253, 209, 108, 255, 253, 209, 108, 255, 253, 209, 109, 255, 253, 210, 109, 255, 253, 210, 110, 255, 253, 210, 110, 255, 253, 211, 110, 255, 253, 211, 111, 255, 253, 211, 111, 255, 253, 212, 111, 255, 253, 212, 112, 255, 253, 212, 112, 255, 253, 212, 112, 255, 253, 213, 113, 255, 253, 213, 113, 255, 253, 213, 113, 255, 253, 214, 114, 255, 253, 214, 114, 255, 253, 214, 115, 255, 253, 214, 115, 255, 253, 215, 115, 255, 253, 215, 116, 255, 253, 215, 116, 255, 253, 216, 116, 255, 253, 216, 117, 255, 253, 216, 117, 255, 253, 217, 117, 255, 253, 217, 118, 255, 253, 217, 118, 255, 253, 217, 118, 255, 253, 217, 119, 255, 253, 217, 119, 255, 253, 217, 119, 255, 253, 218, 120, 255, 253, 218, 120, 255, 253, 218, 120, 255, 253, 218, 121, 255, 253, 218, 121, 255, 253, 218, 121, 255, 253, 219, 122, 255, 253, 219, 122, 255, 253, 219, 122, 255, 253, 219, 123, 255, 253, 219, 123, 255, 253, 219, 123, 255, 253, 220, 124, 255, 253, 220, 124, 255, 253, 220, 124, 255, 253, 220, 125, 255, 253, 220, 125, 255, 253, 220, 125, 255, 253, 221, 126, 255, 253, 221, 126, 255, 253, 221, 126, 255, 253, 221, 127, 255, 253, 221, 127, 255, 253, 221, 127, 255, 253, 222, 128, 255, 253, 222, 128, 255, 253, 222, 128, 255, 253, 222, 129, 255, 253, 222, 129, 255, 253, 222, 129, 255, 253, 222, 130, 255, 253, 223, 130, 255, 253, 223, 130, 255, 253, 223, 131, 255, 253, 223, 131, 255, 253, 223, 131, 255, 254, 223, 132, 255, 254, 224, 132, 255, 254, 224, 132, 255, 254, 224, 133, 255, 254, 224, 133, 255, 254, 224, 133, 255, 254, 224, 133, 255, 254, 225, 134, 255, 254, 225, 134, 255, 254, 225, 134, 255, 254, 225, 135, 255, 254, 225, 135, 255, 254, 225, 135, 255, 254, 225, 136, 255, 254, 226, 136, 255, 254, 226, 136, 255, 254, 226, 137, 255, 254, 226, 137, 255, 254, 226, 137, 255, 254, 226, 138, 255, 254, 227, 138, 255, 254, 227, 138, 255, 254, 227, 139, 255, 254, 227, 139, 255, 254, 227, 139, 255, 254, 227, 140, 255, 254, 228, 140, 255, 254, 228, 140, 255, 254, 228, 141, 255, 254, 228, 141, 255, 254, 228, 141, 255, 254, 228, 142, 255, 254, 228, 142, 255, 254, 229, 142, 255, 254, 229, 143, 255, 254, 229, 143, 255, 254, 229, 143, 255, 254, 229, 144, 255, 254, 229, 144, 255, 254, 230, 144, 255, 254, 230, 145, 255, 254, 230, 145, 255, 254, 230, 145, 255, 254, 230, 146, 255, 254, 230, 146, 255, 254, 230, 146, 255, 254, 231, 147, 255, 254, 231, 147, 255, 254, 231, 147, 255, 254, 231, 148, 255, 254, 231, 148, 255, 254, 231, 148, 255, 254, 232, 149, 255, 254, 232, 149, 255, 254, 232, 149, 255, 254, 232, 150, 255, 254, 232, 150, 255, 254, 232, 150, 255, 254, 232, 151, 255, 254, 233, 151, 255, 254, 233, 151, 255, 254, 233, 152, 255, 254, 233, 152, 255, 254, 233, 152, 255, 254, 233, 153, 255, 254, 233, 153, 255, 254, 234, 153, 255, 254, 234, 154, 255, 254, 234, 154, 255, 254, 234, 154, 255, 254, 234, 155, 255, 254, 234, 155, 255, 254, 235, 155, 255, 254, 235, 156, 255, 254, 235, 156, 255, 254, 235, 156, 255, 254, 235, 157, 255, 254, 235, 157, 255, 254, 235, 157, 255, 254, 236, 158, 255, 254, 236, 158, 255, 254, 236, 158, 255, 254, 236, 159, 255, 254, 236, 159, 255, 254, 236, 159, 255, 254, 237, 159, 255, 254, 237, 160, 255, 254, 237, 160, 255, 254, 237, 161, 255, 254, 237, 161, 255, 254, 237, 161, 255, 254, 237, 162, 255, 254, 238, 162, 255, 254, 238, 162, 255, 254, 238, 163, 255, 254, 238, 163, 255, 254, 238, 163, 255, 254, 238, 164, 255, 254, 238, 164, 255, 254, 239, 164, 255, 254, 239, 165, 255, 254, 239, 165, 255, 254, 239, 165, 255, 254, 239, 166, 255, 254, 239, 166, 255, 254, 240, 166, 255, 254, 240, 167, 255, 254, 240, 167, 255, 254, 240, 167, 255, 254, 240, 168, 255, 254, 240, 168, 255, 254, 240, 168, 255, 254, 241, 169, 255, 254, 241, 169, 255, 254, 241, 169, 255, 254, 241, 170, 255, 254, 241, 170, 255, 254, 241, 170, 255, 254, 241, 171, 255, 254, 242, 171, 255, 254, 242, 171, 255, 254, 242, 172, 255, 254, 242, 172, 255, 254, 242, 172, 255, 254, 242, 173, 255, 254, 242, 173, 255, 254, 243, 174, 255, 254, 243, 174, 255, 254, 243, 174, 255, 254, 243, 175, 255, 254, 243, 175, 255, 254, 243, 175, 255, 254, 243, 176, 255, 254, 244, 176, 255, 254, 244, 176, 255, 254, 244, 177, 255, 254, 244, 177, 255, 254, 244, 177, 255, 254, 244, 178, 255, 254, 244, 178, 255, 254, 245, 178, 255, 254, 245, 179, 255, 254, 245, 179, 255, 254, 245, 179, 255, 254, 245, 180, 255, 254, 245, 180, 255, 254, 245, 180, 255, 254, 246, 181, 255, 254, 246, 181, 255, 254, 246, 181, 255, 254, 246, 182, 255, 254, 246, 182, 255, 254, 246, 182, 255, 254, 246, 183, 255, 254, 247, 183, 255, 254, 247, 184, 255, 254, 247, 184, 255, 254, 247, 184, 255, 254, 247, 185, 255, 254, 247, 185, 255, 254, 247, 185, 255, 254, 248, 186, 255, 254, 248, 186, 255, 254, 248, 186, 255, 254, 248, 187, 255, 254, 248, 187, 255, 254, 248, 187, 255, 254, 248, 188, 255, 254, 249, 188, 255, 254, 249, 188, 255, 254, 249, 189, 255, 254, 249, 189, 255, 254, 249, 189, 255, 254, 249, 190, 255, 254, 249, 190, 255, 254, 249, 190, 255, 254, 250, 191, 255, 254, 250, 191, 255, 254, 250, 191, 255, 254, 250, 192, 255, 254, 250, 192, 255, 254, 250, 192, 255, 254, 250, 193, 255, 254, 251, 193, 255, 254, 251, 194, 255, 254, 251, 194, 255, 254, 251, 194, 255, 254, 251, 195, 255, 254, 251, 195, 255, 254, 251, 195, 255, 254, 251, 196, 255, 254, 252, 196, 255, 254, 252, 196, 255, 254, 252, 197, 255, 254, 252, 197, 255, 254, 252, 197, 255, 254, 252, 198, 255, 254, 252, 198, 255, 254, 253, 198, 255, 254, 253, 199, 255, 254, 253, 199, 255, 254, 253, 199, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 201, 255, 254, 254, 201, 255, 254, 254, 201, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 203, 255, 254, 254, 203, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_YlOrRd_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 127, 0, 37, 0, 128, 0, 38, 7, 128, 0, 38, 14, 129, 0, 38, 22, 129, 0, 38, 29, 129, 0, 38, 37, 130, 0, 38, 44, 130, 0, 38, 52, 131, 0, 38, 59, 131, 0, 38, 67, 131, 0, 38, 74, 132, 0, 38, 82, 132, 0, 38, 89, 132, 0, 38, 97, 133, 0, 38, 104, 133, 0, 38, 112, 134, 0, 38, 119, 134, 0, 38, 127, 134, 0, 38, 134, 135, 0, 38, 141, 135, 0, 38, 149, 136, 0, 38, 156, 136, 0, 38, 164, 136, 0, 38, 171, 137, 0, 38, 179, 137, 0, 38, 186, 137, 0, 38, 194, 138, 0, 38, 201, 138, 0, 38, 209, 139, 0, 38, 216, 139, 0, 38, 224, 139, 0, 38, 231, 140, 0, 38, 239, 140, 0, 38, 246, 141, 0, 38, 254, 141, 0, 38, 255, 141, 0, 39, 255, 142, 0, 39, 255, 142, 0, 39, 255, 142, 0, 39, 255, 143, 0, 39, 255, 143, 0, 39, 255, 144, 0, 39, 255, 144, 0, 39, 255, 144, 0, 39, 255, 145, 0, 39, 255, 145, 0, 39, 255, 145, 0, 39, 255, 146, 0, 39, 255, 146, 0, 39, 255, 147, 0, 39, 255, 147, 0, 39, 255, 147, 0, 39, 255, 148, 0, 39, 255, 148, 0, 39, 255, 149, 0, 39, 255, 149, 0, 39, 255, 149, 0, 39, 255, 150, 0, 39, 255, 150, 0, 39, 255, 150, 0, 39, 255, 151, 0, 39, 255, 151, 0, 39, 255, 152, 0, 39, 255, 164, 0, 39, 255, 165, 0, 39, 255, 165, 0, 39, 255, 165, 0, 39, 255, 166, 0, 39, 255, 166, 0, 39, 255, 166, 0, 39, 255, 167, 0, 39, 255, 167, 0, 39, 255, 168, 0, 39, 255, 168, 0, 39, 255, 168, 0, 39, 255, 169, 0, 39, 255, 169, 0, 39, 255, 170, 0, 39, 255, 170, 0, 39, 255, 170, 0, 39, 255, 171, 0, 39, 255, 171, 0, 39, 255, 171, 0, 39, 255, 172, 0, 39, 255, 172, 0, 39, 255, 173, 0, 39, 255, 173, 0, 39, 255, 173, 0, 39, 255, 174, 0, 39, 255, 174, 0, 39, 255, 174, 0, 39, 255, 175, 0, 39, 255, 175, 0, 39, 255, 176, 0, 39, 255, 176, 0, 39, 255, 176, 0, 38, 255, 177, 0, 38, 255, 177, 0, 38, 255, 178, 0, 38, 255, 178, 0, 38, 255, 178, 0, 38, 255, 179, 0, 38, 255, 179, 0, 38, 255, 179, 0, 38, 255, 180, 0, 38, 255, 180, 0, 38, 255, 181, 0, 38, 255, 181, 0, 38, 255, 181, 0, 38, 255, 182, 0, 38, 255, 182, 0, 38, 255, 182, 0, 38, 255, 183, 0, 38, 255, 183, 0, 38, 255, 184, 0, 38, 255, 184, 0, 38, 255, 184, 0, 38, 255, 185, 0, 38, 255, 185, 0, 38, 255, 185, 0, 38, 255, 186, 0, 38, 255, 186, 0, 38, 255, 187, 0, 38, 255, 187, 0, 38, 255, 187, 0, 38, 255, 188, 0, 38, 255, 188, 0, 38, 255, 188, 0, 37, 255, 189, 0, 37, 255, 189, 0, 37, 255, 189, 0, 37, 255, 189, 0, 37, 255, 190, 0, 37, 255, 190, 0, 37, 255, 190, 0, 37, 255, 190, 0, 37, 255, 191, 0, 37, 255, 191, 1, 37, 255, 191, 1, 37, 255, 191, 1, 37, 255, 192, 1, 37, 255, 192, 1, 37, 255, 192, 1, 37, 255, 192, 1, 37, 255, 193, 1, 37, 255, 193, 1, 37, 255, 193, 2, 37, 255, 193, 2, 37, 255, 194, 2, 37, 255, 194, 2, 37, 255, 194, 2, 37, 255, 194, 2, 37, 255, 195, 2, 37, 255, 195, 3, 36, 255, 195, 3, 36, 255, 195, 3, 36, 255, 196, 3, 36, 255, 196, 3, 36, 255, 196, 3, 36, 255, 196, 3, 36, 255, 197, 4, 36, 255, 197, 4, 36, 255, 197, 4, 36, 255, 197, 4, 36, 255, 197, 4, 36, 255, 198, 4, 36, 255, 198, 4, 36, 255, 198, 5, 36, 255, 198, 5, 36, 255, 199, 5, 36, 255, 199, 5, 36, 255, 199, 5, 36, 255, 199, 5, 36, 255, 200, 6, 36, 255, 200, 6, 35, 255, 200, 6, 35, 255, 200, 6, 35, 255, 201, 6, 35, 255, 201, 7, 35, 255, 201, 7, 35, 255, 201, 7, 35, 255, 202, 7, 35, 255, 202, 7, 35, 255, 202, 7, 35, 255, 202, 8, 35, 255, 202, 8, 35, 255, 203, 8, 35, 255, 203, 8, 35, 255, 203, 8, 35, 255, 203, 9, 35, 255, 204, 9, 35, 255, 212, 14, 33, 255, 212, 14, 32, 255, 212, 15, 32, 255, 212, 15, 32, 255, 212, 15, 32, 255, 213, 15, 32, 255, 213, 15, 32, 255, 213, 15, 32, 255, 213, 16, 32, 255, 214, 16, 32, 255, 214, 16, 32, 255, 214, 16, 32, 255, 214, 16, 32, 255, 215, 17, 32, 255, 215, 17, 32, 255, 215, 17, 32, 255, 215, 17, 32, 255, 216, 17, 31, 255, 216, 17, 31, 255, 216, 18, 31, 255, 216, 18, 31, 255, 216, 18, 31, 255, 217, 18, 31, 255, 217, 18, 31, 255, 217, 18, 31, 255, 217, 19, 31, 255, 218, 19, 31, 255, 218, 19, 31, 255, 218, 19, 31, 255, 218, 19, 31, 255, 219, 20, 30, 255, 219, 20, 30, 255, 219, 20, 30, 255, 219, 20, 30, 255, 220, 20, 30, 255, 220, 20, 30, 255, 220, 21, 30, 255, 220, 21, 30, 255, 220, 21, 30, 255, 221, 21, 30, 255, 221, 21, 30, 255, 221, 21, 30, 255, 221, 22, 30, 255, 222, 22, 29, 255, 222, 22, 29, 255, 222, 22, 29, 255, 222, 22, 29, 255, 223, 23, 29, 255, 223, 23, 29, 255, 223, 23, 29, 255, 223, 23, 29, 255, 223, 23, 29, 255, 224, 23, 29, 255, 224, 24, 29, 255, 224, 24, 28, 255, 224, 24, 28, 255, 225, 24, 28, 255, 225, 24, 28, 255, 225, 24, 28, 255, 225, 25, 28, 255, 226, 25, 28, 255, 226, 25, 28, 255, 226, 25, 28, 255, 226, 25, 28, 255, 226, 26, 27, 255, 227, 26, 28, 255, 227, 27, 28, 255, 227, 27, 28, 255, 227, 28, 28, 255, 227, 28, 28, 255, 227, 28, 28, 255, 228, 29, 28, 255, 228, 29, 28, 255, 228, 30, 28, 255, 228, 30, 28, 255, 228, 31, 28, 255, 228, 31, 28, 255, 229, 32, 29, 255, 229, 32, 29, 255, 229, 32, 29, 255, 229, 33, 29, 255, 229, 33, 29, 255, 229, 34, 29, 255, 230, 34, 29, 255, 230, 35, 29, 255, 230, 35, 29, 255, 230, 35, 29, 255, 230, 36, 29, 255, 230, 36, 29, 255, 230, 36, 30, 255, 231, 37, 30, 255, 231, 37, 30, 255, 231, 38, 30, 255, 231, 38, 30, 255, 231, 38, 30, 255, 231, 39, 30, 255, 232, 39, 30, 255, 232, 39, 30, 255, 232, 40, 30, 255, 232, 40, 30, 255, 232, 40, 30, 255, 232, 41, 31, 255, 232, 41, 31, 255, 233, 42, 31, 255, 233, 42, 31, 255, 233, 42, 31, 255, 233, 43, 31, 255, 233, 43, 31, 255, 233, 43, 31, 255, 234, 44, 31, 255, 234, 44, 31, 255, 234, 44, 31, 255, 234, 45, 31, 255, 234, 45, 32, 255, 234, 45, 32, 255, 235, 46, 32, 255, 235, 46, 32, 255, 235, 46, 32, 255, 235, 46, 32, 255, 235, 47, 32, 255, 235, 47, 32, 255, 235, 47, 32, 255, 236, 48, 32, 255, 236, 48, 32, 255, 236, 48, 32, 255, 236, 49, 33, 255, 236, 49, 33, 255, 236, 49, 33, 255, 242, 60, 36, 255, 242, 60, 36, 255, 242, 61, 36, 255, 242, 61, 36, 255, 242, 61, 36, 255, 242, 61, 36, 255, 243, 62, 36, 255, 243, 62, 36, 255, 243, 62, 36, 255, 243, 63, 36, 255, 243, 63, 37, 255, 243, 63, 37, 255, 243, 64, 37, 255, 244, 64, 37, 255, 244, 64, 37, 255, 244, 64, 37, 255, 244, 65, 37, 255, 244, 65, 37, 255, 244, 65, 37, 255, 245, 66, 37, 255, 245, 66, 37, 255, 245, 66, 37, 255, 245, 66, 38, 255, 245, 67, 38, 255, 245, 67, 38, 255, 245, 67, 38, 255, 246, 67, 38, 255, 246, 68, 38, 255, 246, 68, 38, 255, 246, 68, 38, 255, 246, 69, 38, 255, 246, 69, 38, 255, 247, 69, 38, 255, 247, 69, 39, 255, 247, 70, 39, 255, 247, 70, 39, 255, 247, 70, 39, 255, 247, 70, 39, 255, 247, 71, 39, 255, 248, 71, 39, 255, 248, 71, 39, 255, 248, 72, 39, 255, 248, 72, 39, 255, 248, 72, 40, 255, 248, 72, 40, 255, 249, 73, 40, 255, 249, 73, 40, 255, 249, 73, 40, 255, 249, 73, 40, 255, 249, 74, 40, 255, 249, 74, 40, 255, 249, 74, 40, 255, 250, 74, 40, 255, 250, 75, 40, 255, 250, 75, 41, 255, 250, 75, 41, 255, 250, 75, 41, 255, 250, 76, 41, 255, 251, 76, 41, 255, 251, 76, 41, 255, 251, 76, 41, 255, 251, 77, 41, 255, 251, 77, 41, 255, 251, 77, 41, 255, 251, 78, 41, 255, 252, 78, 42, 255, 252, 79, 42, 255, 252, 79, 42, 255, 252, 79, 42, 255, 252, 80, 42, 255, 252, 80, 42, 255, 252, 81, 42, 255, 252, 81, 42, 255, 252, 82, 42, 255, 252, 82, 42, 255, 252, 83, 42, 255, 252, 83, 42, 255, 252, 84, 42, 255, 252, 84, 42, 255, 252, 85, 42, 255, 252, 85, 42, 255, 252, 86, 42, 255, 252, 86, 42, 255, 252, 87, 42, 255, 252, 87, 42, 255, 252, 87, 42, 255, 252, 88, 42, 255, 252, 88, 42, 255, 252, 89, 42, 255, 252, 89, 42, 255, 252, 90, 43, 255, 252, 90, 43, 255, 252, 91, 43, 255, 252, 91, 43, 255, 252, 91, 43, 255, 252, 92, 43, 255, 252, 92, 43, 255, 252, 93, 43, 255, 252, 93, 43, 255, 252, 94, 43, 255, 252, 94, 43, 255, 252, 94, 43, 255, 252, 95, 43, 255, 252, 95, 43, 255, 252, 96, 43, 255, 252, 96, 44, 255, 252, 96, 44, 255, 252, 97, 44, 255, 252, 97, 44, 255, 252, 98, 44, 255, 252, 98, 44, 255, 252, 99, 44, 255, 252, 99, 44, 255, 252, 99, 44, 255, 252, 100, 44, 255, 252, 100, 44, 255, 252, 101, 45, 255, 252, 101, 45, 255, 252, 101, 45, 255, 252, 102, 45, 255, 252, 102, 45, 255, 252, 102, 45, 255, 252, 103, 45, 255, 252, 103, 45, 255, 252, 104, 45, 255, 252, 104, 45, 255, 252, 104, 46, 255, 252, 105, 46, 255, 252, 118, 49, 255, 252, 118, 50, 255, 252, 119, 50, 255, 252, 119, 50, 255, 252, 119, 50, 255, 252, 120, 50, 255, 252, 120, 50, 255, 252, 120, 50, 255, 252, 121, 50, 255, 252, 121, 50, 255, 252, 122, 51, 255, 252, 122, 51, 255, 252, 122, 51, 255, 252, 123, 51, 255, 252, 123, 51, 255, 252, 123, 51, 255, 252, 124, 51, 255, 252, 124, 52, 255, 252, 125, 52, 255, 252, 125, 52, 255, 252, 125, 52, 255, 252, 126, 52, 255, 252, 126, 52, 255, 252, 126, 52, 255, 252, 127, 53, 255, 252, 127, 53, 255, 252, 127, 53, 255, 252, 128, 53, 255, 252, 128, 53, 255, 252, 128, 53, 255, 252, 129, 53, 255, 252, 129, 54, 255, 252, 130, 54, 255, 252, 130, 54, 255, 252, 130, 54, 255, 253, 131, 54, 255, 253, 131, 54, 255, 253, 131, 55, 255, 253, 132, 55, 255, 253, 132, 55, 255, 253, 132, 55, 255, 253, 133, 55, 255, 253, 133, 55, 255, 253, 133, 56, 255, 253, 134, 56, 255, 253, 134, 56, 255, 253, 134, 56, 255, 253, 135, 56, 255, 253, 135, 56, 255, 253, 135, 57, 255, 253, 136, 57, 255, 253, 136, 57, 255, 253, 136, 57, 255, 253, 137, 57, 255, 253, 137, 58, 255, 253, 137, 58, 255, 253, 138, 58, 255, 253, 138, 58, 255, 253, 138, 58, 255, 253, 139, 59, 255, 253, 139, 59, 255, 253, 140, 59, 255, 253, 140, 59, 255, 253, 140, 59, 255, 252, 141, 59, 255, 253, 141, 60, 255, 253, 141, 60, 255, 253, 141, 60, 255, 253, 141, 60, 255, 253, 142, 60, 255, 253, 142, 60, 255, 253, 142, 60, 255, 253, 142, 60, 255, 253, 143, 60, 255, 253, 143, 60, 255, 253, 143, 60, 255, 253, 143, 60, 255, 253, 144, 60, 255, 253, 144, 60, 255, 253, 144, 60, 255, 253, 144, 61, 255, 253, 145, 61, 255, 253, 145, 61, 255, 253, 145, 61, 255, 253, 145, 61, 255, 253, 146, 61, 255, 253, 146, 61, 255, 253, 146, 61, 255, 253, 146, 61, 255, 253, 146, 61, 255, 253, 147, 61, 255, 253, 147, 61, 255, 253, 147, 61, 255, 253, 147, 61, 255, 253, 148, 62, 255, 253, 148, 62, 255, 253, 148, 62, 255, 253, 148, 62, 255, 253, 149, 62, 255, 253, 149, 62, 255, 253, 149, 62, 255, 253, 149, 62, 255, 253, 150, 62, 255, 253, 150, 62, 255, 253, 150, 62, 255, 253, 150, 62, 255, 253, 150, 63, 255, 253, 151, 63, 255, 253, 151, 63, 255, 253, 151, 63, 255, 253, 151, 63, 255, 253, 152, 63, 255, 253, 152, 63, 255, 253, 152, 63, 255, 253, 152, 63, 255, 253, 153, 63, 255, 253, 153, 63, 255, 253, 153, 64, 255, 253, 153, 64, 255, 253, 154, 64, 255, 253, 154, 64, 255, 253, 154, 64, 255, 253, 154, 64, 255, 253, 154, 64, 255, 253, 155, 64, 255, 253, 155, 64, 255, 253, 155, 64, 255, 253, 155, 64, 255, 253, 163, 68, 255, 253, 163, 68, 255, 253, 163, 68, 255, 253, 164, 68, 255, 253, 164, 68, 255, 253, 164, 68, 255, 253, 164, 68, 255, 253, 165, 68, 255, 253, 165, 69, 255, 253, 165, 69, 255, 253, 165, 69, 255, 253, 166, 69, 255, 253, 166, 69, 255, 253, 166, 69, 255, 253, 166, 69, 255, 253, 166, 69, 255, 253, 167, 69, 255, 253, 167, 70, 255, 253, 167, 70, 255, 253, 167, 70, 255, 253, 168, 70, 255, 253, 168, 70, 255, 253, 168, 70, 255, 253, 168, 70, 255, 253, 169, 70, 255, 253, 169, 70, 255, 253, 169, 71, 255, 253, 169, 71, 255, 253, 169, 71, 255, 253, 170, 71, 255, 253, 170, 71, 255, 253, 170, 71, 255, 253, 170, 71, 255, 253, 171, 71, 255, 253, 171, 72, 255, 253, 171, 72, 255, 253, 171, 72, 255, 253, 171, 72, 255, 253, 172, 72, 255, 253, 172, 72, 255, 253, 172, 72, 255, 253, 172, 72, 255, 253, 173, 73, 255, 253, 173, 73, 255, 253, 173, 73, 255, 253, 173, 73, 255, 253, 173, 73, 255, 253, 174, 73, 255, 253, 174, 73, 255, 253, 174, 73, 255, 253, 174, 74, 255, 253, 175, 74, 255, 254, 175, 74, 255, 254, 175, 74, 255, 254, 175, 74, 255, 254, 175, 74, 255, 254, 176, 74, 255, 254, 176, 75, 255, 254, 176, 75, 255, 254, 176, 75, 255, 254, 177, 75, 255, 254, 177, 75, 255, 254, 177, 75, 255, 254, 177, 75, 255, 253, 178, 75, 255, 253, 178, 76, 255, 253, 178, 76, 255, 253, 178, 76, 255, 253, 179, 76, 255, 253, 179, 77, 255, 253, 179, 77, 255, 253, 179, 77, 255, 253, 180, 77, 255, 253, 180, 78, 255, 253, 180, 78, 255, 253, 180, 78, 255, 253, 181, 78, 255, 253, 181, 78, 255, 253, 181, 79, 255, 253, 181, 79, 255, 253, 182, 79, 255, 253, 182, 79, 255, 253, 182, 80, 255, 253, 182, 80, 255, 253, 183, 80, 255, 253, 183, 80, 255, 253, 183, 81, 255, 253, 183, 81, 255, 253, 184, 81, 255, 253, 184, 81, 255, 253, 184, 82, 255, 253, 184, 82, 255, 253, 185, 82, 255, 253, 185, 82, 255, 253, 185, 83, 255, 253, 185, 83, 255, 253, 186, 83, 255, 253, 186, 83, 255, 253, 186, 84, 255, 253, 186, 84, 255, 253, 187, 84, 255, 253, 187, 84, 255, 253, 187, 85, 255, 253, 187, 85, 255, 253, 188, 85, 255, 253, 188, 85, 255, 253, 188, 86, 255, 253, 188, 86, 255, 253, 189, 86, 255, 253, 189, 86, 255, 253, 189, 87, 255, 253, 189, 87, 255, 253, 190, 87, 255, 253, 190, 87, 255, 253, 190, 88, 255, 253, 190, 88, 255, 253, 191, 88, 255, 253, 191, 88, 255, 253, 191, 89, 255, 253, 191, 89, 255, 253, 192, 89, 255, 253, 192, 89, 255, 253, 192, 90, 255, 253, 192, 90, 255, 253, 193, 90, 255, 253, 193, 90, 255, 253, 193, 91, 255, 253, 193, 91, 255, 253, 201, 100, 255, 253, 202, 100, 255, 253, 202, 100, 255, 253, 202, 100, 255, 253, 202, 101, 255, 253, 203, 101, 255, 253, 203, 101, 255, 253, 203, 101, 255, 253, 203, 102, 255, 253, 203, 102, 255, 253, 204, 102, 255, 253, 204, 103, 255, 253, 204, 103, 255, 253, 204, 103, 255, 253, 205, 103, 255, 253, 205, 104, 255, 253, 205, 104, 255, 253, 205, 104, 255, 253, 206, 104, 255, 253, 206, 105, 255, 253, 206, 105, 255, 253, 206, 105, 255, 253, 207, 106, 255, 253, 207, 106, 255, 253, 207, 106, 255, 253, 207, 106, 255, 253, 208, 107, 255, 253, 208, 107, 255, 253, 208, 107, 255, 253, 208, 107, 255, 253, 209, 108, 255, 253, 209, 108, 255, 253, 209, 108, 255, 253, 209, 109, 255, 253, 209, 109, 255, 253, 210, 109, 255, 253, 210, 109, 255, 253, 210, 110, 255, 253, 210, 110, 255, 253, 211, 110, 255, 253, 211, 111, 255, 253, 211, 111, 255, 253, 211, 111, 255, 253, 212, 111, 255, 253, 212, 112, 255, 253, 212, 112, 255, 253, 212, 112, 255, 253, 213, 113, 255, 253, 213, 113, 255, 253, 213, 113, 255, 253, 213, 113, 255, 253, 213, 114, 255, 253, 214, 114, 255, 253, 214, 114, 255, 253, 214, 115, 255, 253, 214, 115, 255, 253, 215, 115, 255, 253, 215, 115, 255, 253, 215, 116, 255, 253, 215, 116, 255, 253, 216, 116, 255, 253, 216, 117, 255, 253, 216, 117, 255, 253, 216, 117, 255, 253, 217, 117, 255, 253, 217, 118, 255, 253, 217, 118, 255, 253, 217, 118, 255, 253, 217, 119, 255, 253, 217, 119, 255, 253, 217, 119, 255, 253, 217, 119, 255, 253, 218, 120, 255, 253, 218, 120, 255, 253, 218, 120, 255, 253, 218, 120, 255, 253, 218, 121, 255, 253, 218, 121, 255, 253, 218, 121, 255, 253, 218, 121, 255, 253, 219, 122, 255, 253, 219, 122, 255, 253, 219, 122, 255, 253, 219, 122, 255, 253, 219, 123, 255, 253, 219, 123, 255, 253, 219, 123, 255, 253, 219, 123, 255, 253, 220, 124, 255, 253, 220, 124, 255, 253, 220, 124, 255, 253, 220, 125, 255, 253, 220, 125, 255, 253, 220, 125, 255, 253, 220, 125, 255, 253, 221, 126, 255, 253, 221, 126, 255, 253, 221, 126, 255, 253, 221, 126, 255, 253, 221, 127, 255, 253, 221, 127, 255, 253, 221, 127, 255, 253, 221, 127, 255, 253, 222, 128, 255, 253, 222, 128, 255, 253, 222, 128, 255, 253, 222, 128, 255, 254, 222, 129, 255, 254, 222, 129, 255, 254, 222, 129, 255, 254, 222, 130, 255, 254, 223, 130, 255, 254, 223, 130, 255, 254, 223, 130, 255, 254, 223, 131, 255, 254, 223, 131, 255, 254, 223, 131, 255, 254, 223, 131, 255, 254, 223, 132, 255, 254, 224, 132, 255, 254, 224, 132, 255, 254, 224, 132, 255, 254, 224, 133, 255, 254, 224, 133, 255, 254, 224, 133, 255, 254, 224, 133, 255, 254, 224, 134, 255, 254, 225, 134, 255, 254, 229, 143, 255, 254, 229, 143, 255, 254, 229, 143, 255, 254, 229, 143, 255, 254, 229, 144, 255, 254, 229, 144, 255, 254, 229, 144, 255, 254, 230, 144, 255, 254, 230, 145, 255, 254, 230, 145, 255, 254, 230, 145, 255, 254, 230, 146, 255, 254, 230, 146, 255, 254, 230, 146, 255, 254, 230, 146, 255, 254, 231, 147, 255, 254, 231, 147, 255, 254, 231, 147, 255, 254, 231, 147, 255, 254, 231, 148, 255, 254, 231, 148, 255, 254, 231, 148, 255, 254, 231, 148, 255, 254, 232, 149, 255, 254, 232, 149, 255, 254, 232, 149, 255, 254, 232, 149, 255, 254, 232, 150, 255, 254, 232, 150, 255, 254, 232, 150, 255, 254, 232, 151, 255, 254, 233, 151, 255, 254, 233, 151, 255, 254, 233, 151, 255, 254, 233, 152, 255, 254, 233, 152, 255, 254, 233, 152, 255, 254, 233, 152, 255, 254, 233, 153, 255, 254, 233, 153, 255, 254, 234, 153, 255, 254, 234, 153, 255, 254, 234, 154, 255, 254, 234, 154, 255, 254, 234, 154, 255, 254, 234, 154, 255, 254, 234, 155, 255, 254, 234, 155, 255, 254, 235, 155, 255, 254, 235, 156, 255, 254, 235, 156, 255, 254, 235, 156, 255, 254, 235, 156, 255, 254, 235, 157, 255, 254, 235, 157, 255, 254, 235, 157, 255, 254, 236, 157, 255, 254, 236, 158, 255, 254, 236, 158, 255, 254, 236, 158, 255, 254, 236, 158, 255, 254, 236, 159, 255, 254, 236, 159, 255, 254, 236, 159, 255, 254, 237, 159, 255, 254, 237, 160, 255, 254, 237, 160, 255, 254, 237, 160, 255, 254, 237, 161, 255, 254, 237, 161, 255, 254, 237, 161, 255, 254, 237, 161, 255, 254, 237, 162, 255, 254, 238, 162, 255, 254, 238, 162, 255, 254, 238, 162, 255, 254, 238, 163, 255, 254, 238, 163, 255, 254, 238, 163, 255, 254, 238, 164, 255, 254, 238, 164, 255, 254, 239, 164, 255, 254, 239, 164, 255, 254, 239, 165, 255, 254, 239, 165, 255, 254, 239, 165, 255, 254, 239, 166, 255, 254, 239, 166, 255, 254, 239, 166, 255, 254, 240, 166, 255, 254, 240, 167, 255, 254, 240, 167, 255, 254, 240, 167, 255, 254, 240, 167, 255, 254, 240, 168, 255, 254, 240, 168, 255, 254, 240, 168, 255, 254, 240, 169, 255, 254, 241, 169, 255, 254, 241, 169, 255, 254, 241, 169, 255, 254, 241, 170, 255, 254, 241, 170, 255, 254, 241, 170, 255, 254, 241, 170, 255, 254, 241, 171, 255, 254, 241, 171, 255, 254, 242, 171, 255, 254, 242, 172, 255, 254, 242, 172, 255, 254, 242, 172, 255, 254, 242, 172, 255, 254, 242, 173, 255, 254, 242, 173, 255, 254, 242, 173, 255, 254, 243, 173, 255, 254, 243, 174, 255, 254, 243, 174, 255, 254, 243, 174, 255, 254, 243, 175, 255, 254, 243, 175, 255, 254, 243, 175, 255, 254, 243, 175, 255, 254, 243, 176, 255, 254, 244, 176, 255, 254, 244, 176, 255, 254, 244, 176, 255, 254, 244, 177, 255, 254, 248, 186, 255, 254, 248, 186, 255, 254, 248, 186, 255, 254, 248, 187, 255, 254, 248, 187, 255, 254, 248, 187, 255, 254, 248, 188, 255, 254, 248, 188, 255, 254, 249, 188, 255, 254, 249, 188, 255, 254, 249, 189, 255, 254, 249, 189, 255, 254, 249, 189, 255, 254, 249, 189, 255, 254, 249, 190, 255, 254, 249, 190, 255, 254, 249, 190, 255, 254, 249, 191, 255, 254, 250, 191, 255, 254, 250, 191, 255, 254, 250, 191, 255, 254, 250, 192, 255, 254, 250, 192, 255, 254, 250, 192, 255, 254, 250, 192, 255, 254, 250, 193, 255, 254, 250, 193, 255, 254, 251, 193, 255, 254, 251, 194, 255, 254, 251, 194, 255, 254, 251, 194, 255, 254, 251, 194, 255, 254, 251, 195, 255, 254, 251, 195, 255, 254, 251, 195, 255, 254, 251, 196, 255, 254, 252, 196, 255, 254, 252, 196, 255, 254, 252, 196, 255, 254, 252, 197, 255, 254, 252, 197, 255, 254, 252, 197, 255, 254, 252, 197, 255, 254, 252, 198, 255, 254, 252, 198, 255, 254, 253, 198, 255, 254, 253, 199, 255, 254, 253, 199, 255, 254, 253, 199, 255, 254, 253, 199, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 201, 255, 254, 254, 201, 255, 254, 254, 201, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_YlOrRd_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 127, 0, 37, 0, 131, 0, 38, 24, 135, 0, 38, 49, 139, 0, 38, 74, 143, 0, 39, 99, 146, 0, 39, 124, 150, 0, 39, 149, 166, 0, 39, 174, 169, 0, 39, 199, 173, 0, 39, 224, 176, 0, 38, 249, 180, 0, 38, 255, 183, 0, 38, 255, 187, 0, 38, 255, 189, 0, 37, 255, 192, 1, 37, 255, 194, 2, 37, 255, 196, 3, 36, 255, 198, 4, 36, 255, 200, 6, 35, 255, 202, 7, 35, 255, 204, 9, 35, 255, 213, 16, 32, 255, 215, 17, 31, 255, 217, 19, 31, 255, 219, 20, 30, 255, 221, 21, 30, 255, 223, 23, 29, 255, 225, 24, 28, 255, 226, 25, 28, 255, 228, 29, 28, 255, 229, 32, 29, 255, 230, 36, 29, 255, 231, 38, 30, 255, 232, 41, 31, 255, 234, 43, 31, 255, 235, 46, 32, 255, 236, 48, 32, 255, 242, 61, 36, 255, 243, 63, 36, 255, 244, 65, 37, 255, 245, 67, 38, 255, 246, 69, 38, 255, 247, 71, 39, 255, 248, 72, 40, 255, 249, 74, 40, 255, 250, 76, 41, 255, 251, 77, 41, 255, 252, 81, 42, 255, 252, 84, 42, 255, 252, 87, 42, 255, 252, 90, 43, 255, 252, 92, 43, 255, 252, 95, 43, 255, 252, 97, 44, 255, 252, 100, 44, 255, 252, 102, 45, 255, 252, 105, 46, 255, 252, 119, 50, 255, 252, 122, 51, 255, 252, 124, 51, 255, 252, 126, 52, 255, 252, 128, 53, 255, 252, 130, 54, 255, 253, 132, 55, 255, 253, 134, 56, 255, 253, 136, 57, 255, 253, 138, 58, 255, 253, 139, 59, 255, 253, 141, 60, 255, 253, 142, 60, 255, 253, 144, 60, 255, 253, 145, 61, 255, 253, 146, 61, 255, 253, 147, 61, 255, 253, 148, 62, 255, 253, 150, 62, 255, 253, 151, 63, 255, 253, 152, 63, 255, 253, 153, 64, 255, 253, 154, 64, 255, 253, 155, 64, 255, 253, 164, 68, 255, 253, 165, 69, 255, 253, 166, 69, 255, 253, 167, 70, 255, 253, 168, 70, 255, 253, 169, 71, 255, 253, 170, 71, 255, 253, 171, 72, 255, 253, 172, 72, 255, 253, 173, 73, 255, 253, 174, 73, 255, 254, 175, 74, 255, 254, 176, 75, 255, 254, 177, 75, 255, 253, 178, 76, 255, 253, 179, 77, 255, 253, 180, 78, 255, 253, 181, 79, 255, 253, 182, 80, 255, 253, 183, 80, 255, 253, 184, 81, 255, 253, 185, 82, 255, 253, 186, 83, 255, 253, 187, 84, 255, 253, 188, 85, 255, 253, 189, 86, 255, 253, 190, 87, 255, 253, 190, 88, 255, 253, 191, 89, 255, 253, 192, 90, 255, 253, 193, 91, 255, 253, 202, 100, 255, 253, 203, 101, 255, 253, 203, 102, 255, 253, 204, 103, 255, 253, 205, 104, 255, 253, 206, 105, 255, 253, 207, 106, 255, 253, 207, 107, 255, 253, 208, 107, 255, 253, 209, 108, 255, 253, 210, 109, 255, 253, 210, 110, 255, 253, 211, 111, 255, 253, 212, 112, 255, 253, 213, 113, 255, 253, 213, 114, 255, 253, 214, 114, 255, 253, 215, 115, 255, 253, 215, 116, 255, 253, 216, 117, 255, 253, 217, 118, 255, 253, 217, 119, 255, 253, 217, 119, 255, 253, 218, 120, 255, 253, 218, 121, 255, 253, 218, 121, 255, 253, 219, 122, 255, 253, 219, 123, 255, 253, 220, 124, 255, 253, 220, 124, 255, 253, 220, 125, 255, 253, 221, 126, 255, 253, 221, 126, 255, 253, 221, 127, 255, 253, 221, 128, 255, 253, 222, 128, 255, 254, 222, 129, 255, 254, 222, 129, 255, 254, 223, 130, 255, 254, 223, 131, 255, 254, 223, 131, 255, 254, 224, 132, 255, 254, 224, 133, 255, 254, 224, 133, 255, 254, 224, 134, 255, 254, 229, 143, 255, 254, 229, 143, 255, 254, 229, 144, 255, 254, 230, 144, 255, 254, 230, 145, 255, 254, 230, 146, 255, 254, 230, 146, 255, 254, 231, 147, 255, 254, 231, 147, 255, 254, 231, 148, 255, 254, 231, 148, 255, 254, 232, 149, 255, 254, 232, 149, 255, 254, 232, 150, 255, 254, 232, 150, 255, 254, 233, 151, 255, 254, 233, 151, 255, 254, 233, 152, 255, 254, 233, 152, 255, 254, 233, 153, 255, 254, 234, 153, 255, 254, 234, 154, 255, 254, 234, 154, 255, 254, 234, 155, 255, 254, 234, 155, 255, 254, 235, 156, 255, 254, 235, 156, 255, 254, 235, 156, 255, 254, 235, 157, 255, 254, 236, 157, 255, 254, 236, 158, 255, 254, 236, 158, 255, 254, 236, 159, 255, 254, 236, 159, 255, 254, 236, 159, 255, 254, 237, 160, 255, 254, 237, 160, 255, 254, 237, 161, 255, 254, 237, 161, 255, 254, 237, 161, 255, 254, 238, 162, 255, 254, 238, 162, 255, 254, 238, 163, 255, 254, 238, 163, 255, 254, 238, 163, 255, 254, 238, 164, 255, 254, 239, 164, 255, 254, 239, 164, 255, 254, 239, 165, 255, 254, 239, 165, 255, 254, 239, 166, 255, 254, 239, 166, 255, 254, 239, 166, 255, 254, 240, 167, 255, 254, 240, 167, 255, 254, 240, 167, 255, 254, 240, 168, 255, 254, 240, 168, 255, 254, 240, 168, 255, 254, 240, 169, 255, 254, 241, 169, 255, 254, 241, 169, 255, 254, 241, 170, 255, 254, 241, 170, 255, 254, 241, 170, 255, 254, 241, 170, 255, 254, 241, 171, 255, 254, 242, 171, 255, 254, 242, 171, 255, 254, 242, 172, 255, 254, 242, 172, 255, 254, 242, 172, 255, 254, 242, 173, 255, 254, 242, 173, 255, 254, 242, 173, 255, 254, 242, 173, 255, 254, 243, 174, 255, 254, 243, 174, 255, 254, 243, 174, 255, 254, 243, 174, 255, 254, 243, 175, 255, 254, 243, 175, 255, 254, 243, 175, 255, 254, 243, 175, 255, 254, 243, 176, 255, 254, 244, 176, 255, 254, 244, 176, 255, 254, 244, 176, 255, 254, 244, 177, 255, 254, 244, 177, 255, 254, 248, 186, 255, 254, 248, 186, 255, 254, 248, 186, 255, 254, 248, 187, 255, 254, 248, 187, 255, 254, 248, 187, 255, 254, 248, 187, 255, 254, 248, 187, 255, 254, 248, 188, 255, 254, 248, 188, 255, 254, 248, 188, 255, 254, 249, 188, 255, 254, 249, 188, 255, 254, 249, 189, 255, 254, 249, 189, 255, 254, 249, 189, 255, 254, 249, 189, 255, 254, 249, 189, 255, 254, 249, 190, 255, 254, 249, 190, 255, 254, 249, 190, 255, 254, 249, 190, 255, 254, 249, 190, 255, 254, 249, 190, 255, 254, 250, 191, 255, 254, 250, 191, 255, 254, 250, 191, 255, 254, 250, 191, 255, 254, 250, 191, 255, 254, 250, 191, 255, 254, 250, 192, 255, 254, 250, 192, 255, 254, 250, 192, 255, 254, 250, 192, 255, 254, 250, 192, 255, 254, 250, 192, 255, 254, 250, 193, 255, 254, 250, 193, 255, 254, 250, 193, 255, 254, 250, 193, 255, 254, 251, 193, 255, 254, 251, 193, 255, 254, 251, 193, 255, 254, 251, 194, 255, 254, 251, 194, 255, 254, 251, 194, 255, 254, 251, 194, 255, 254, 251, 194, 255, 254, 251, 194, 255, 254, 251, 194, 255, 254, 251, 194, 255, 254, 251, 195, 255, 254, 251, 195, 255, 254, 251, 195, 255, 254, 251, 195, 255, 254, 251, 195, 255, 254, 251, 195, 255, 254, 251, 195, 255, 254, 251, 195, 255, 254, 251, 196, 255, 254, 251, 196, 255, 254, 252, 196, 255, 254, 252, 196, 255, 254, 252, 196, 255, 254, 252, 196, 255, 254, 252, 196, 255, 254, 252, 196, 255, 254, 252, 196, 255, 254, 252, 196, 255, 254, 252, 197, 255, 254, 252, 197, 255, 254, 252, 197, 255, 254, 252, 197, 255, 254, 252, 197, 255, 254, 252, 197, 255, 254, 252, 197, 255, 254, 252, 197, 255, 254, 252, 197, 255, 254, 252, 197, 255, 254, 252, 197, 255, 254, 252, 198, 255, 254, 252, 198, 255, 254, 252, 198, 255, 254, 252, 198, 255, 254, 252, 198, 255, 254, 252, 198, 255, 254, 252, 198, 255, 254, 252, 198, 255, 254, 252, 198, 255, 254, 253, 198, 255, 254, 253, 198, 255, 254, 253, 198, 255, 254, 253, 199, 255, 254, 253, 199, 255, 254, 253, 199, 255, 254, 253, 199, 255, 254, 253, 199, 255, 254, 253, 199, 255, 254, 253, 199, 255, 254, 253, 199, 255, 254, 253, 199, 255, 254, 253, 199, 255, 254, 253, 199, 255, 254, 253, 199, 255, 254, 253, 199, 255, 254, 253, 199, 255, 254, 253, 199, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 200, 255, 254, 253, 201, 255, 254, 253, 201, 255, 254, 253, 201, 255, 254, 253, 201, 255, 254, 253, 201, 255, 254, 253, 201, 255, 254, 253, 201, 255, 254, 253, 201, 255, 254, 254, 201, 255, 254, 254, 201, 255, 254, 254, 201, 255, 254, 254, 201, 255, 254, 254, 201, 255, 254, 254, 201, 255, 254, 254, 201, 255, 254, 254, 201, 255, 254, 254, 201, 255, 254, 254, 201, 255, 254, 254, 201, 255, 254, 254, 201, 255, 254, 254, 201, 255, 254, 254, 201, 255, 254, 254, 201, 255, 254, 254, 201, 255, 254, 254, 201, 255, 254, 254, 201, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 202, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 254, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255, 254, 255, 203, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_YlOrRd_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
