/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/Blues.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 8, 48, 107, 255, 8, 81, 156, 255, 33, 113, 181, 255, 66, 146, 198, 255, 107, 174, 214, 255, 158, 202, 225, 255, 198, 219, 239, 255, 222, 235, 247, 255, 247, 251, 255, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Blues_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 8, 47, 107, 0, 8, 48, 107, 7, 8, 48, 107, 14, 8, 48, 108, 22, 8, 48, 108, 29, 8, 49, 108, 37, 8, 49, 109, 44, 8, 49, 109, 52, 8, 49, 109, 59, 8, 50, 110, 67, 8, 50, 110, 74, 8, 50, 111, 82, 8, 50, 111, 89, 8, 51, 111, 97, 8, 51, 112, 104, 8, 51, 112, 112, 8, 51, 112, 119, 8, 52, 113, 127, 9, 52, 113, 134, 9, 52, 114, 141, 9, 52, 114, 149, 9, 53, 114, 156, 9, 53, 115, 164, 9, 53, 115, 171, 9, 53, 115, 179, 9, 54, 116, 186, 9, 54, 116, 194, 9, 54, 117, 201, 9, 54, 117, 209, 9, 55, 117, 216, 9, 55, 118, 224, 9, 55, 118, 231, 9, 55, 118, 239, 9, 56, 119, 246, 9, 56, 119, 254, 9, 56, 120, 255, 9, 56, 120, 255, 9, 57, 120, 255, 9, 57, 121, 255, 9, 57, 121, 255, 9, 57, 121, 255, 10, 58, 122, 255, 10, 58, 122, 255, 10, 58, 123, 255, 10, 58, 123, 255, 10, 59, 123, 255, 10, 59, 124, 255, 10, 59, 124, 255, 10, 59, 124, 255, 10, 60, 125, 255, 10, 60, 125, 255, 10, 60, 126, 255, 10, 60, 126, 255, 10, 61, 126, 255, 10, 61, 127, 255, 10, 61, 127, 255, 10, 62, 128, 255, 10, 62, 128, 255, 10, 62, 128, 255, 10, 62, 129, 255, 10, 63, 129, 255, 10, 63, 129, 255, 10, 63, 130, 255, 10, 63, 130, 255, 10, 64, 131, 255, 10, 64, 131, 255, 10, 64, 131, 255, 10, 64, 132, 255, 10, 65, 132, 255, 10, 65, 133, 255, 10, 65, 133, 255, 10, 65, 133, 255, 10, 66, 134, 255, 10, 66, 134, 255, 10, 66, 134, 255, 10, 66, 135, 255, 10, 67, 135, 255, 10, 67, 136, 255, 10, 67, 136, 255, 10, 67, 136, 255, 10, 68, 137, 255, 10, 68, 137, 255, 10, 68, 138, 255, 10, 69, 138, 255, 10, 69, 138, 255, 10, 69, 139, 255, 10, 69, 139, 255, 10, 70, 139, 255, 10, 70, 140, 255, 10, 70, 140, 255, 10, 70, 141, 255, 10, 71, 141, 255, 10, 71, 141, 255, 10, 71, 142, 255, 10, 71, 142, 255, 10, 72, 143, 255, 10, 72, 143, 255, 10, 72, 143, 255, 10, 72, 144, 255, 9, 73, 144, 255, 9, 73, 145, 255, 9, 73, 145, 255, 9, 74, 145, 255, 9, 74, 146, 255, 9, 74, 146, 255, 9, 74, 146, 255, 9, 75, 147, 255, 9, 75, 147, 255, 9, 75, 148, 255, 9, 75, 148, 255, 9, 76, 148, 255, 9, 76, 149, 255, 9, 76, 149, 255, 9, 76, 150, 255, 9, 77, 150, 255, 9, 77, 150, 255, 9, 77, 151, 255, 8, 78, 151, 255, 8, 78, 152, 255, 8, 78, 152, 255, 8, 78, 152, 255, 8, 79, 153, 255, 8, 79, 153, 255, 8, 79, 154, 255, 8, 79, 154, 255, 8, 80, 154, 255, 8, 80, 155, 255, 8, 80, 155, 255, 8, 80, 156, 255, 8, 81, 156, 255, 8, 81, 156, 255, 8, 81, 156, 255, 8, 81, 156, 255, 8, 82, 157, 255, 8, 82, 157, 255, 9, 82, 157, 255, 9, 82, 157, 255, 9, 83, 157, 255, 9, 83, 158, 255, 9, 83, 158, 255, 9, 83, 158, 255, 9, 84, 158, 255, 10, 84, 158, 255, 10, 84, 159, 255, 10, 84, 159, 255, 10, 85, 159, 255, 10, 85, 159, 255, 11, 85, 159, 255, 11, 85, 160, 255, 11, 86, 160, 255, 11, 86, 160, 255, 11, 86, 160, 255, 11, 86, 160, 255, 12, 87, 161, 255, 12, 87, 161, 255, 12, 87, 161, 255, 12, 87, 161, 255, 12, 88, 161, 255, 12, 88, 162, 255, 13, 88, 162, 255, 13, 88, 162, 255, 13, 89, 162, 255, 13, 89, 162, 255, 13, 89, 163, 255, 14, 89, 163, 255, 14, 90, 163, 255, 14, 90, 163, 255, 14, 90, 163, 255, 14, 90, 164, 255, 15, 91, 164, 255, 15, 91, 164, 255, 15, 91, 164, 255, 15, 91, 164, 255, 15, 92, 165, 255, 15, 92, 165, 255, 16, 92, 165, 255, 16, 92, 165, 255, 16, 93, 165, 255, 16, 93, 166, 255, 16, 93, 166, 255, 17, 93, 166, 255, 17, 94, 166, 255, 17, 94, 166, 255, 17, 94, 167, 255, 17, 94, 167, 255, 18, 95, 167, 255, 18, 95, 167, 255, 18, 95, 167, 255, 18, 95, 168, 255, 18, 96, 168, 255, 19, 96, 168, 255, 19, 96, 168, 255, 19, 96, 168, 255, 19, 97, 168, 255, 19, 97, 169, 255, 20, 97, 169, 255, 20, 97, 169, 255, 20, 98, 169, 255, 20, 98, 169, 255, 20, 98, 170, 255, 21, 98, 170, 255, 21, 99, 170, 255, 21, 99, 170, 255, 21, 99, 170, 255, 21, 99, 171, 255, 22, 100, 171, 255, 22, 100, 171, 255, 22, 100, 171, 255, 22, 100, 171, 255, 22, 101, 172, 255, 23, 101, 172, 255, 23, 101, 172, 255, 23, 101, 172, 255, 23, 102, 172, 255, 23, 102, 173, 255, 24, 102, 173, 255, 24, 102, 173, 255, 24, 103, 173, 255, 24, 103, 173, 255, 24, 103, 174, 255, 25, 103, 174, 255, 25, 104, 174, 255, 25, 104, 174, 255, 25, 104, 174, 255, 26, 104, 174, 255, 26, 105, 175, 255, 26, 105, 175, 255, 26, 105, 175, 255, 26, 105, 175, 255, 27, 106, 175, 255, 27, 106, 176, 255, 27, 106, 176, 255, 27, 106, 176, 255, 27, 107, 176, 255, 28, 107, 176, 255, 28, 107, 177, 255, 28, 107, 177, 255, 28, 108, 177, 255, 29, 108, 177, 255, 29, 108, 177, 255, 29, 108, 178, 255, 29, 109, 178, 255, 29, 109, 178, 255, 30, 109, 178, 255, 30, 109, 178, 255, 30, 110, 178, 255, 30, 110, 179, 255, 31, 110, 179, 255, 31, 110, 179, 255, 31, 111, 179, 255, 31, 111, 179, 255, 31, 111, 180, 255, 32, 111, 180, 255, 32, 112, 180, 255, 32, 112, 180, 255, 32, 112, 180, 255, 33, 113, 181, 255, 33, 113, 181, 255, 33, 113, 181, 255, 33, 113, 181, 255, 33, 114, 181, 255, 33, 114, 181, 255, 34, 114, 181, 255, 34, 114, 182, 255, 34, 115, 182, 255, 34, 115, 182, 255, 34, 115, 182, 255, 35, 115, 182, 255, 35, 116, 182, 255, 35, 116, 182, 255, 35, 116, 183, 255, 35, 116, 183, 255, 36, 117, 183, 255, 36, 117, 183, 255, 36, 117, 183, 255, 36, 117, 183, 255, 37, 118, 183, 255, 37, 118, 184, 255, 37, 118, 184, 255, 37, 118, 184, 255, 37, 119, 184, 255, 38, 119, 184, 255, 38, 119, 184, 255, 38, 120, 184, 255, 38, 120, 185, 255, 39, 120, 185, 255, 39, 120, 185, 255, 39, 121, 185, 255, 39, 121, 185, 255, 39, 121, 185, 255, 40, 121, 185, 255, 40, 122, 186, 255, 40, 122, 186, 255, 40, 122, 186, 255, 41, 122, 186, 255, 41, 123, 186, 255, 41, 123, 186, 255, 41, 123, 186, 255, 42, 123, 186, 255, 42, 124, 187, 255, 42, 124, 187, 255, 42, 124, 187, 255, 43, 124, 187, 255, 43, 125, 187, 255, 43, 125, 187, 255, 43, 125, 187, 255, 44, 125, 188, 255, 44, 126, 188, 255, 44, 126, 188, 255, 44, 126, 188, 255, 45, 127, 188, 255, 45, 127, 188, 255, 45, 127, 188, 255, 45, 127, 189, 255, 46, 128, 189, 255, 46, 128, 189, 255, 46, 128, 189, 255, 46, 128, 189, 255, 47, 129, 189, 255, 47, 129, 189, 255, 47, 129, 189, 255, 47, 129, 190, 255, 48, 130, 190, 255, 48, 130, 190, 255, 48, 130, 190, 255, 49, 130, 190, 255, 49, 131, 190, 255, 49, 131, 190, 255, 49, 131, 191, 255, 50, 131, 191, 255, 50, 132, 191, 255, 50, 132, 191, 255, 50, 132, 191, 255, 51, 132, 191, 255, 51, 133, 191, 255, 51, 133, 191, 255, 51, 133, 192, 255, 52, 133, 192, 255, 52, 134, 192, 255, 52, 134, 192, 255, 53, 134, 192, 255, 53, 134, 192, 255, 53, 135, 192, 255, 53, 135, 192, 255, 54, 135, 193, 255, 54, 136, 193, 255, 54, 136, 193, 255, 55, 136, 193, 255, 55, 136, 193, 255, 55, 137, 193, 255, 55, 137, 193, 255, 56, 137, 193, 255, 56, 137, 194, 255, 56, 138, 194, 255, 57, 138, 194, 255, 57, 138, 194, 255, 57, 138, 194, 255, 57, 139, 194, 255, 58, 139, 194, 255, 58, 139, 194, 255, 58, 139, 195, 255, 59, 140, 195, 255, 59, 140, 195, 255, 59, 140, 195, 255, 60, 140, 195, 255, 60, 141, 195, 255, 60, 141, 195, 255, 60, 141, 195, 255, 61, 141, 196, 255, 61, 142, 196, 255, 61, 142, 196, 255, 62, 142, 196, 255, 62, 142, 196, 255, 62, 143, 196, 255, 62, 143, 196, 255, 63, 143, 196, 255, 63, 143, 197, 255, 63, 144, 197, 255, 64, 144, 197, 255, 64, 144, 197, 255, 64, 144, 197, 255, 65, 145, 197, 255, 65, 145, 197, 255, 65, 145, 197, 255, 66, 146, 198, 255, 66, 146, 198, 255, 66, 146, 198, 255, 67, 146, 198, 255, 67, 146, 198, 255, 67, 147, 198, 255, 68, 147, 198, 255, 68, 147, 198, 255, 68, 147, 199, 255, 69, 147, 199, 255, 69, 148, 199, 255, 69, 148, 199, 255, 70, 148, 199, 255, 70, 148, 199, 255, 70, 149, 199, 255, 71, 149, 199, 255, 71, 149, 200, 255, 71, 149, 200, 255, 72, 149, 200, 255, 72, 150, 200, 255, 72, 150, 200, 255, 73, 150, 200, 255, 73, 150, 200, 255, 73, 151, 200, 255, 74, 151, 201, 255, 74, 151, 201, 255, 74, 151, 201, 255, 74, 151, 201, 255, 75, 152, 201, 255, 75, 152, 201, 255, 75, 152, 201, 255, 76, 152, 201, 255, 76, 152, 202, 255, 76, 153, 202, 255, 77, 153, 202, 255, 77, 153, 202, 255, 77, 153, 202, 255, 78, 154, 202, 255, 78, 154, 202, 255, 78, 154, 202, 255, 79, 154, 203, 255, 79, 154, 203, 255, 79, 155, 203, 255, 80, 155, 203, 255, 80, 155, 203, 255, 80, 155, 203, 255, 81, 156, 203, 255, 81, 156, 203, 255, 81, 156, 204, 255, 82, 156, 204, 255, 82, 156, 204, 255, 82, 157, 204, 255, 83, 157, 204, 255, 83, 157, 204, 255, 83, 157, 204, 255, 84, 158, 204, 255, 84, 158, 205, 255, 84, 158, 205, 255, 84, 158, 205, 255, 85, 158, 205, 255, 85, 159, 205, 255, 85, 159, 205, 255, 86, 159, 205, 255, 86, 159, 205, 255, 86, 159, 206, 255, 87, 160, 206, 255, 87, 160, 206, 255, 87, 160, 206, 255, 88, 160, 206, 255, 88, 161, 206, 255, 88, 161, 206, 255, 89, 161, 206, 255, 89, 161, 207, 255, 89, 161, 207, 255, 90, 162, 207, 255, 90, 162, 207, 255, 90, 162, 207, 255, 91, 162, 207, 255, 91, 163, 207, 255, 91, 163, 207, 255, 91, 163, 208, 255, 92, 163, 208, 255, 92, 163, 208, 255, 92, 164, 208, 255, 93, 164, 208, 255, 93, 164, 208, 255, 93, 164, 208, 255, 94, 165, 208, 255, 94, 165, 209, 255, 94, 165, 209, 255, 95, 165, 209, 255, 95, 165, 209, 255, 95, 166, 209, 255, 96, 166, 209, 255, 96, 166, 209, 255, 96, 166, 209, 255, 97, 166, 210, 255, 97, 167, 210, 255, 97, 167, 210, 255, 97, 167, 210, 255, 98, 167, 210, 255, 98, 168, 210, 255, 98, 168, 210, 255, 99, 168, 210, 255, 99, 168, 211, 255, 99, 168, 211, 255, 100, 169, 211, 255, 100, 169, 211, 255, 100, 169, 211, 255, 101, 169, 211, 255, 101, 170, 211, 255, 101, 170, 211, 255, 102, 170, 211, 255, 102, 170, 212, 255, 102, 170, 212, 255, 102, 171, 212, 255, 103, 171, 212, 255, 103, 171, 212, 255, 103, 171, 212, 255, 104, 172, 212, 255, 104, 172, 212, 255, 104, 172, 213, 255, 105, 172, 213, 255, 105, 172, 213, 255, 105, 173, 213, 255, 106, 173, 213, 255, 106, 173, 213, 255, 106, 173, 213, 255, 107, 174, 214, 255, 107, 174, 214, 255, 107, 174, 214, 255, 108, 174, 214, 255, 108, 174, 214, 255, 109, 175, 214, 255, 109, 175, 214, 255, 109, 175, 214, 255, 110, 175, 214, 255, 110, 175, 214, 255, 111, 176, 214, 255, 111, 176, 214, 255, 111, 176, 214, 255, 112, 176, 215, 255, 112, 177, 215, 255, 113, 177, 215, 255, 113, 177, 215, 255, 113, 177, 215, 255, 114, 177, 215, 255, 114, 178, 215, 255, 115, 178, 215, 255, 115, 178, 215, 255, 115, 178, 215, 255, 116, 179, 215, 255, 116, 179, 215, 255, 117, 179, 216, 255, 117, 179, 216, 255, 117, 179, 216, 255, 118, 180, 216, 255, 118, 180, 216, 255, 119, 180, 216, 255, 119, 180, 216, 255, 120, 181, 216, 255, 120, 181, 216, 255, 120, 181, 216, 255, 121, 181, 216, 255, 121, 181, 216, 255, 122, 182, 217, 255, 122, 182, 217, 255, 122, 182, 217, 255, 123, 182, 217, 255, 123, 183, 217, 255, 124, 183, 217, 255, 124, 183, 217, 255, 124, 183, 217, 255, 125, 183, 217, 255, 125, 184, 217, 255, 126, 184, 217, 255, 126, 184, 217, 255, 126, 184, 218, 255, 127, 185, 218, 255, 127, 185, 218, 255, 128, 185, 218, 255, 128, 185, 218, 255, 128, 185, 218, 255, 129, 186, 218, 255, 129, 186, 218, 255, 129, 186, 218, 255, 130, 186, 218, 255, 130, 186, 218, 255, 131, 187, 218, 255, 131, 187, 219, 255, 131, 187, 219, 255, 132, 187, 219, 255, 132, 188, 219, 255, 133, 188, 219, 255, 133, 188, 219, 255, 133, 188, 219, 255, 134, 188, 219, 255, 134, 189, 219, 255, 135, 189, 219, 255, 135, 189, 219, 255, 135, 189, 220, 255, 136, 190, 220, 255, 136, 190, 220, 255, 137, 190, 220, 255, 137, 190, 220, 255, 137, 190, 220, 255, 138, 191, 220, 255, 138, 191, 220, 255, 139, 191, 220, 255, 139, 191, 220, 255, 139, 192, 220, 255, 140, 192, 220, 255, 140, 192, 221, 255, 141, 192, 221, 255, 141, 192, 221, 255, 141, 193, 221, 255, 142, 193, 221, 255, 142, 193, 221, 255, 143, 193, 221, 255, 143, 193, 221, 255, 143, 194, 221, 255, 144, 194, 221, 255, 144, 194, 221, 255, 145, 194, 222, 255, 145, 195, 222, 255, 145, 195, 222, 255, 146, 195, 222, 255, 146, 195, 222, 255, 146, 195, 222, 255, 147, 196, 222, 255, 147, 196, 222, 255, 148, 196, 222, 255, 148, 196, 222, 255, 148, 197, 222, 255, 149, 197, 223, 255, 149, 197, 223, 255, 150, 197, 223, 255, 150, 197, 223, 255, 150, 198, 223, 255, 151, 198, 223, 255, 151, 198, 223, 255, 152, 198, 223, 255, 152, 198, 223, 255, 152, 199, 223, 255, 153, 199, 223, 255, 153, 199, 223, 255, 154, 199, 224, 255, 154, 200, 224, 255, 154, 200, 224, 255, 155, 200, 224, 255, 155, 200, 224, 255, 156, 200, 224, 255, 156, 201, 224, 255, 156, 201, 224, 255, 157, 201, 224, 255, 157, 201, 224, 255, 157, 202, 224, 255, 158, 202, 225, 255, 158, 202, 225, 255, 158, 202, 225, 255, 159, 202, 225, 255, 159, 202, 225, 255, 159, 202, 225, 255, 160, 202, 225, 255, 160, 203, 226, 255, 160, 203, 226, 255, 161, 203, 226, 255, 161, 203, 226, 255, 161, 203, 226, 255, 162, 203, 226, 255, 162, 203, 226, 255, 162, 203, 226, 255, 163, 204, 227, 255, 163, 204, 227, 255, 163, 204, 227, 255, 164, 204, 227, 255, 164, 204, 227, 255, 164, 204, 227, 255, 165, 204, 227, 255, 165, 204, 227, 255, 165, 205, 227, 255, 166, 205, 228, 255, 166, 205, 228, 255, 166, 205, 228, 255, 167, 205, 228, 255, 167, 205, 228, 255, 167, 205, 228, 255, 168, 206, 228, 255, 168, 206, 228, 255, 168, 206, 229, 255, 169, 206, 229, 255, 169, 206, 229, 255, 169, 206, 229, 255, 170, 206, 229, 255, 170, 206, 229, 255, 170, 207, 229, 255, 171, 207, 229, 255, 171, 207, 229, 255, 171, 207, 230, 255, 172, 207, 230, 255, 172, 207, 230, 255, 172, 207, 230, 255, 173, 207, 230, 255, 173, 208, 230, 255, 173, 208, 230, 255, 173, 208, 230, 255, 174, 208, 230, 255, 174, 208, 231, 255, 174, 208, 231, 255, 175, 208, 231, 255, 175, 209, 231, 255, 175, 209, 231, 255, 176, 209, 231, 255, 176, 209, 231, 255, 176, 209, 231, 255, 177, 209, 231, 255, 177, 209, 232, 255, 177, 209, 232, 255, 178, 210, 232, 255, 178, 210, 232, 255, 178, 210, 232, 255, 179, 210, 232, 255, 179, 210, 232, 255, 179, 210, 232, 255, 179, 210, 232, 255, 180, 210, 233, 255, 180, 211, 233, 255, 180, 211, 233, 255, 181, 211, 233, 255, 181, 211, 233, 255, 181, 211, 233, 255, 182, 211, 233, 255, 182, 211, 233, 255, 182, 212, 233, 255, 183, 212, 234, 255, 183, 212, 234, 255, 183, 212, 234, 255, 183, 212, 234, 255, 184, 212, 234, 255, 184, 212, 234, 255, 184, 212, 234, 255, 185, 213, 234, 255, 185, 213, 234, 255, 185, 213, 234, 255, 186, 213, 235, 255, 186, 213, 235, 255, 186, 213, 235, 255, 187, 213, 235, 255, 187, 214, 235, 255, 187, 214, 235, 255, 187, 214, 235, 255, 188, 214, 235, 255, 188, 214, 235, 255, 188, 214, 235, 255, 189, 214, 236, 255, 189, 215, 236, 255, 189, 215, 236, 255, 190, 215, 236, 255, 190, 215, 236, 255, 190, 215, 236, 255, 190, 215, 236, 255, 191, 215, 236, 255, 191, 215, 236, 255, 191, 216, 236, 255, 192, 216, 237, 255, 192, 216, 237, 255, 192, 216, 237, 255, 193, 216, 237, 255, 193, 216, 237, 255, 193, 216, 237, 255, 193, 217, 237, 255, 194, 217, 237, 255, 194, 217, 237, 255, 194, 217, 237, 255, 195, 217, 238, 255, 195, 217, 238, 255, 195, 217, 238, 255, 195, 218, 238, 255, 196, 218, 238, 255, 196, 218, 238, 255, 196, 218, 238, 255, 197, 218, 238, 255, 197, 218, 238, 255, 197, 218, 238, 255, 197, 219, 238, 255, 198, 219, 239, 255, 198, 219, 239, 255, 198, 219, 239, 255, 198, 219, 239, 255, 198, 219, 239, 255, 199, 219, 239, 255, 199, 219, 239, 255, 199, 219, 239, 255, 199, 220, 239, 255, 199, 220, 239, 255, 200, 220, 239, 255, 200, 220, 239, 255, 200, 220, 239, 255, 200, 220, 239, 255, 200, 220, 239, 255, 200, 220, 239, 255, 201, 221, 240, 255, 201, 221, 240, 255, 201, 221, 240, 255, 201, 221, 240, 255, 201, 221, 240, 255, 202, 221, 240, 255, 202, 221, 240, 255, 202, 221, 240, 255, 202, 222, 240, 255, 202, 222, 240, 255, 203, 222, 240, 255, 203, 222, 240, 255, 203, 222, 240, 255, 203, 222, 240, 255, 203, 222, 240, 255, 203, 222, 240, 255, 204, 223, 241, 255, 204, 223, 241, 255, 204, 223, 241, 255, 204, 223, 241, 255, 204, 223, 241, 255, 205, 223, 241, 255, 205, 223, 241, 255, 205, 223, 241, 255, 205, 224, 241, 255, 205, 224, 241, 255, 206, 224, 241, 255, 206, 224, 241, 255, 206, 224, 241, 255, 206, 224, 241, 255, 206, 224, 241, 255, 206, 224, 241, 255, 207, 225, 242, 255, 207, 225, 242, 255, 207, 225, 242, 255, 207, 225, 242, 255, 207, 225, 242, 255, 208, 225, 242, 255, 208, 225, 242, 255, 208, 225, 242, 255, 208, 226, 242, 255, 208, 226, 242, 255, 209, 226, 242, 255, 209, 226, 242, 255, 209, 226, 242, 255, 209, 226, 242, 255, 209, 226, 242, 255, 209, 226, 242, 255, 210, 227, 243, 255, 210, 227, 243, 255, 210, 227, 243, 255, 210, 227, 243, 255, 210, 227, 243, 255, 211, 227, 243, 255, 211, 227, 243, 255, 211, 227, 243, 255, 211, 228, 243, 255, 211, 228, 243, 255, 212, 228, 243, 255, 212, 228, 243, 255, 212, 228, 243, 255, 212, 228, 243, 255, 212, 228, 243, 255, 212, 228, 243, 255, 213, 229, 244, 255, 213, 229, 244, 255, 213, 229, 244, 255, 213, 229, 244, 255, 213, 229, 244, 255, 214, 229, 244, 255, 214, 229, 244, 255, 214, 229, 244, 255, 214, 230, 244, 255, 214, 230, 244, 255, 215, 230, 244, 255, 215, 230, 244, 255, 215, 230, 244, 255, 215, 230, 244, 255, 215, 230, 244, 255, 215, 230, 244, 255, 216, 231, 245, 255, 216, 231, 245, 255, 216, 231, 245, 255, 216, 231, 245, 255, 216, 231, 245, 255, 217, 231, 245, 255, 217, 231, 245, 255, 217, 231, 245, 255, 217, 232, 245, 255, 217, 232, 245, 255, 218, 232, 245, 255, 218, 232, 245, 255, 218, 232, 245, 255, 218, 232, 245, 255, 218, 232, 245, 255, 218, 232, 245, 255, 219, 233, 246, 255, 219, 233, 246, 255, 219, 233, 246, 255, 219, 233, 246, 255, 219, 233, 246, 255, 220, 233, 246, 255, 220, 233, 246, 255, 220, 233, 246, 255, 220, 234, 246, 255, 220, 234, 246, 255, 221, 234, 246, 255, 221, 234, 246, 255, 221, 234, 246, 255, 221, 234, 246, 255, 221, 234, 246, 255, 221, 235, 246, 255, 222, 235, 247, 255, 222, 235, 247, 255, 222, 235, 247, 255, 222, 235, 247, 255, 222, 235, 247, 255, 223, 235, 247, 255, 223, 235, 247, 255, 223, 235, 247, 255, 223, 236, 247, 255, 223, 236, 247, 255, 224, 236, 247, 255, 224, 236, 247, 255, 224, 236, 247, 255, 224, 236, 247, 255, 224, 236, 247, 255, 225, 236, 248, 255, 225, 237, 248, 255, 225, 237, 248, 255, 225, 237, 248, 255, 225, 237, 248, 255, 226, 237, 248, 255, 226, 237, 248, 255, 226, 237, 248, 255, 226, 237, 248, 255, 226, 238, 248, 255, 227, 238, 248, 255, 227, 238, 248, 255, 227, 238, 248, 255, 227, 238, 248, 255, 227, 238, 248, 255, 228, 238, 248, 255, 228, 238, 249, 255, 228, 239, 249, 255, 228, 239, 249, 255, 228, 239, 249, 255, 229, 239, 249, 255, 229, 239, 249, 255, 229, 239, 249, 255, 229, 239, 249, 255, 229, 239, 249, 255, 230, 240, 249, 255, 230, 240, 249, 255, 230, 240, 249, 255, 230, 240, 249, 255, 230, 240, 249, 255, 231, 240, 249, 255, 231, 240, 249, 255, 231, 240, 250, 255, 231, 241, 250, 255, 231, 241, 250, 255, 232, 241, 250, 255, 232, 241, 250, 255, 232, 241, 250, 255, 232, 241, 250, 255, 232, 241, 250, 255, 233, 241, 250, 255, 233, 242, 250, 255, 233, 242, 250, 255, 233, 242, 250, 255, 233, 242, 250, 255, 233, 242, 250, 255, 234, 242, 250, 255, 234, 242, 250, 255, 234, 242, 251, 255, 234, 243, 251, 255, 234, 243, 251, 255, 235, 243, 251, 255, 235, 243, 251, 255, 235, 243, 251, 255, 235, 243, 251, 255, 235, 243, 251, 255, 236, 243, 251, 255, 236, 244, 251, 255, 236, 244, 251, 255, 236, 244, 251, 255, 236, 244, 251, 255, 237, 244, 251, 255, 237, 244, 251, 255, 237, 244, 251, 255, 237, 244, 252, 255, 237, 245, 252, 255, 238, 245, 252, 255, 238, 245, 252, 255, 238, 245, 252, 255, 238, 245, 252, 255, 238, 245, 252, 255, 239, 245, 252, 255, 239, 245, 252, 255, 239, 246, 252, 255, 239, 246, 252, 255, 239, 246, 252, 255, 240, 246, 252, 255, 240, 246, 252, 255, 240, 246, 252, 255, 240, 246, 252, 255, 240, 246, 253, 255, 240, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 242, 247, 253, 255, 242, 247, 253, 255, 242, 248, 253, 255, 242, 248, 253, 255, 242, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 245, 249, 254, 255, 245, 249, 254, 255, 245, 249, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Blues_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 8, 47, 107, 0, 8, 48, 107, 7, 8, 48, 107, 14, 8, 48, 107, 22, 8, 48, 108, 29, 8, 48, 108, 37, 8, 49, 108, 44, 8, 49, 109, 52, 8, 49, 109, 59, 8, 49, 109, 67, 8, 49, 109, 74, 8, 50, 110, 82, 8, 50, 110, 89, 8, 50, 110, 97, 8, 50, 111, 104, 8, 50, 111, 112, 8, 51, 111, 119, 8, 51, 112, 127, 8, 51, 112, 134, 8, 51, 112, 141, 8, 51, 112, 149, 8, 52, 113, 156, 8, 52, 113, 164, 9, 52, 113, 171, 9, 52, 114, 179, 9, 52, 114, 186, 9, 53, 114, 194, 9, 53, 115, 201, 9, 53, 115, 209, 9, 53, 115, 216, 9, 53, 115, 224, 9, 54, 116, 231, 9, 54, 116, 239, 9, 54, 116, 246, 9, 54, 117, 254, 9, 54, 117, 255, 9, 55, 117, 255, 9, 55, 118, 255, 9, 55, 118, 255, 9, 55, 118, 255, 9, 55, 118, 255, 9, 56, 119, 255, 9, 56, 119, 255, 9, 56, 119, 255, 9, 56, 120, 255, 9, 56, 120, 255, 9, 57, 120, 255, 9, 57, 121, 255, 9, 57, 121, 255, 9, 57, 121, 255, 9, 57, 122, 255, 9, 58, 122, 255, 9, 58, 122, 255, 9, 58, 122, 255, 9, 58, 123, 255, 9, 59, 123, 255, 9, 59, 123, 255, 9, 59, 124, 255, 9, 59, 124, 255, 9, 59, 124, 255, 9, 60, 125, 255, 9, 60, 125, 255, 9, 60, 125, 255, 9, 60, 125, 255, 10, 67, 136, 255, 10, 67, 136, 255, 10, 67, 136, 255, 10, 68, 136, 255, 10, 68, 137, 255, 10, 68, 137, 255, 10, 68, 137, 255, 10, 68, 138, 255, 10, 69, 138, 255, 10, 69, 138, 255, 10, 69, 139, 255, 10, 69, 139, 255, 10, 69, 139, 255, 10, 70, 140, 255, 10, 70, 140, 255, 9, 70, 140, 255, 9, 70, 141, 255, 9, 70, 141, 255, 9, 71, 141, 255, 9, 71, 141, 255, 9, 71, 142, 255, 9, 71, 142, 255, 9, 72, 142, 255, 9, 72, 143, 255, 9, 72, 143, 255, 9, 72, 143, 255, 9, 72, 144, 255, 9, 73, 144, 255, 9, 73, 144, 255, 9, 73, 145, 255, 9, 73, 145, 255, 9, 73, 145, 255, 9, 74, 145, 255, 9, 74, 146, 255, 9, 74, 146, 255, 9, 74, 146, 255, 9, 74, 147, 255, 9, 75, 147, 255, 9, 75, 147, 255, 9, 75, 148, 255, 9, 75, 148, 255, 9, 76, 148, 255, 9, 76, 149, 255, 9, 76, 149, 255, 9, 76, 149, 255, 9, 76, 150, 255, 9, 77, 150, 255, 9, 77, 150, 255, 9, 77, 150, 255, 8, 77, 151, 255, 8, 77, 151, 255, 8, 78, 151, 255, 8, 78, 152, 255, 8, 78, 152, 255, 8, 78, 152, 255, 8, 79, 153, 255, 8, 79, 153, 255, 8, 79, 153, 255, 8, 79, 154, 255, 8, 79, 154, 255, 8, 80, 154, 255, 8, 80, 155, 255, 8, 80, 155, 255, 8, 80, 155, 255, 8, 80, 156, 255, 8, 81, 156, 255, 8, 81, 156, 255, 8, 81, 156, 255, 8, 81, 156, 255, 8, 81, 156, 255, 8, 82, 156, 255, 8, 82, 157, 255, 8, 82, 157, 255, 9, 82, 157, 255, 9, 82, 157, 255, 9, 83, 157, 255, 9, 83, 157, 255, 9, 83, 158, 255, 9, 83, 158, 255, 9, 83, 158, 255, 9, 84, 158, 255, 10, 84, 158, 255, 10, 84, 158, 255, 10, 84, 159, 255, 10, 84, 159, 255, 10, 85, 159, 255, 10, 85, 159, 255, 10, 85, 159, 255, 11, 85, 159, 255, 11, 85, 160, 255, 11, 86, 160, 255, 11, 86, 160, 255, 11, 86, 160, 255, 11, 86, 160, 255, 11, 86, 160, 255, 12, 87, 161, 255, 12, 87, 161, 255, 12, 87, 161, 255, 12, 87, 161, 255, 12, 87, 161, 255, 12, 88, 161, 255, 13, 88, 161, 255, 13, 88, 162, 255, 13, 88, 162, 255, 13, 88, 162, 255, 13, 89, 162, 255, 13, 89, 162, 255, 13, 89, 162, 255, 14, 89, 163, 255, 14, 89, 163, 255, 14, 90, 163, 255, 14, 90, 163, 255, 14, 90, 163, 255, 14, 90, 163, 255, 14, 90, 164, 255, 15, 91, 164, 255, 15, 91, 164, 255, 15, 91, 164, 255, 15, 91, 164, 255, 15, 91, 164, 255, 15, 92, 164, 255, 16, 92, 165, 255, 16, 92, 165, 255, 16, 92, 165, 255, 16, 92, 165, 255, 16, 93, 165, 255, 16, 93, 165, 255, 17, 93, 166, 255, 22, 100, 171, 255, 22, 100, 171, 255, 22, 100, 171, 255, 22, 100, 171, 255, 22, 100, 171, 255, 22, 101, 172, 255, 23, 101, 172, 255, 23, 101, 172, 255, 23, 101, 172, 255, 23, 101, 172, 255, 23, 102, 172, 255, 23, 102, 172, 255, 24, 102, 173, 255, 24, 102, 173, 255, 24, 102, 173, 255, 24, 103, 173, 255, 24, 103, 173, 255, 24, 103, 173, 255, 25, 103, 174, 255, 25, 103, 174, 255, 25, 104, 174, 255, 25, 104, 174, 255, 25, 104, 174, 255, 25, 104, 174, 255, 26, 104, 174, 255, 26, 105, 175, 255, 26, 105, 175, 255, 26, 105, 175, 255, 26, 105, 175, 255, 26, 105, 175, 255, 27, 106, 175, 255, 27, 106, 176, 255, 27, 106, 176, 255, 27, 106, 176, 255, 27, 106, 176, 255, 27, 107, 176, 255, 28, 107, 176, 255, 28, 107, 176, 255, 28, 107, 177, 255, 28, 107, 177, 255, 28, 108, 177, 255, 28, 108, 177, 255, 29, 108, 177, 255, 29, 108, 177, 255, 29, 108, 177, 255, 29, 109, 178, 255, 29, 109, 178, 255, 30, 109, 178, 255, 30, 109, 178, 255, 30, 109, 178, 255, 30, 110, 178, 255, 30, 110, 179, 255, 30, 110, 179, 255, 31, 110, 179, 255, 31, 110, 179, 255, 31, 111, 179, 255, 31, 111, 179, 255, 31, 111, 179, 255, 31, 111, 180, 255, 32, 111, 180, 255, 32, 112, 180, 255, 32, 112, 180, 255, 32, 112, 180, 255, 32, 112, 180, 255, 33, 113, 181, 255, 33, 113, 181, 255, 33, 113, 181, 255, 33, 113, 181, 255, 33, 113, 181, 255, 33, 114, 181, 255, 33, 114, 181, 255, 34, 114, 181, 255, 34, 114, 181, 255, 34, 114, 182, 255, 34, 115, 182, 255, 34, 115, 182, 255, 34, 115, 182, 255, 35, 115, 182, 255, 35, 115, 182, 255, 35, 116, 182, 255, 35, 116, 182, 255, 35, 116, 182, 255, 35, 116, 183, 255, 36, 116, 183, 255, 36, 117, 183, 255, 36, 117, 183, 255, 36, 117, 183, 255, 36, 117, 183, 255, 36, 117, 183, 255, 37, 118, 183, 255, 37, 118, 184, 255, 37, 118, 184, 255, 37, 118, 184, 255, 37, 119, 184, 255, 38, 119, 184, 255, 38, 119, 184, 255, 38, 119, 184, 255, 38, 119, 184, 255, 38, 120, 184, 255, 38, 120, 185, 255, 39, 120, 185, 255, 39, 120, 185, 255, 39, 120, 185, 255, 39, 121, 185, 255, 39, 121, 185, 255, 40, 121, 185, 255, 40, 121, 185, 255, 40, 121, 185, 255, 40, 122, 186, 255, 40, 122, 186, 255, 41, 122, 186, 255, 41, 122, 186, 255, 41, 122, 186, 255, 41, 123, 186, 255, 41, 123, 186, 255, 42, 123, 186, 255, 42, 123, 186, 255, 42, 124, 186, 255, 42, 124, 187, 255, 42, 124, 187, 255, 43, 124, 187, 255, 43, 124, 187, 255, 43, 125, 187, 255, 43, 125, 187, 255, 43, 125, 187, 255, 44, 125, 187, 255, 44, 125, 187, 255, 44, 126, 188, 255, 51, 132, 191, 255, 51, 133, 191, 255, 51, 133, 191, 255, 51, 133, 191, 255, 52, 133, 191, 255, 52, 133, 192, 255, 52, 134, 192, 255, 52, 134, 192, 255, 53, 134, 192, 255, 53, 134, 192, 255, 53, 134, 192, 255, 53, 135, 192, 255, 53, 135, 192, 255, 54, 135, 192, 255, 54, 135, 193, 255, 54, 135, 193, 255, 54, 136, 193, 255, 55, 136, 193, 255, 55, 136, 193, 255, 55, 136, 193, 255, 55, 136, 193, 255, 55, 137, 193, 255, 56, 137, 193, 255, 56, 137, 193, 255, 56, 137, 194, 255, 56, 138, 194, 255, 57, 138, 194, 255, 57, 138, 194, 255, 57, 138, 194, 255, 57, 138, 194, 255, 57, 139, 194, 255, 58, 139, 194, 255, 58, 139, 194, 255, 58, 139, 194, 255, 58, 139, 195, 255, 59, 140, 195, 255, 59, 140, 195, 255, 59, 140, 195, 255, 59, 140, 195, 255, 60, 140, 195, 255, 60, 141, 195, 255, 60, 141, 195, 255, 60, 141, 195, 255, 60, 141, 195, 255, 61, 141, 196, 255, 61, 142, 196, 255, 61, 142, 196, 255, 61, 142, 196, 255, 62, 142, 196, 255, 62, 142, 196, 255, 62, 143, 196, 255, 62, 143, 196, 255, 63, 143, 196, 255, 63, 143, 196, 255, 63, 143, 197, 255, 63, 144, 197, 255, 64, 144, 197, 255, 64, 144, 197, 255, 64, 144, 197, 255, 64, 144, 197, 255, 65, 145, 197, 255, 65, 145, 197, 255, 65, 145, 197, 255, 65, 145, 197, 255, 66, 146, 198, 255, 66, 146, 198, 255, 66, 146, 198, 255, 66, 146, 198, 255, 67, 146, 198, 255, 67, 146, 198, 255, 67, 147, 198, 255, 67, 147, 198, 255, 68, 147, 198, 255, 68, 147, 198, 255, 68, 147, 199, 255, 68, 147, 199, 255, 69, 148, 199, 255, 69, 148, 199, 255, 69, 148, 199, 255, 70, 148, 199, 255, 70, 148, 199, 255, 70, 148, 199, 255, 70, 149, 199, 255, 71, 149, 199, 255, 71, 149, 200, 255, 71, 149, 200, 255, 71, 149, 200, 255, 72, 150, 200, 255, 72, 150, 200, 255, 72, 150, 200, 255, 72, 150, 200, 255, 73, 150, 200, 255, 73, 150, 200, 255, 73, 151, 200, 255, 73, 151, 201, 255, 74, 151, 201, 255, 74, 151, 201, 255, 74, 151, 201, 255, 75, 151, 201, 255, 75, 152, 201, 255, 75, 152, 201, 255, 75, 152, 201, 255, 76, 152, 201, 255, 76, 152, 201, 255, 76, 152, 202, 255, 76, 153, 202, 255, 77, 153, 202, 255, 77, 153, 202, 255, 77, 153, 202, 255, 77, 153, 202, 255, 78, 154, 202, 255, 78, 154, 202, 255, 78, 154, 202, 255, 78, 154, 202, 255, 79, 154, 203, 255, 79, 154, 203, 255, 79, 155, 203, 255, 79, 155, 203, 255, 80, 155, 203, 255, 80, 155, 203, 255, 80, 155, 203, 255, 80, 155, 203, 255, 81, 156, 203, 255, 81, 156, 203, 255, 81, 156, 204, 255, 81, 156, 204, 255, 82, 156, 204, 255, 82, 157, 204, 255, 90, 162, 207, 255, 91, 162, 207, 255, 91, 163, 207, 255, 91, 163, 207, 255, 91, 163, 208, 255, 92, 163, 208, 255, 92, 163, 208, 255, 92, 164, 208, 255, 92, 164, 208, 255, 93, 164, 208, 255, 93, 164, 208, 255, 93, 164, 208, 255, 93, 164, 208, 255, 94, 165, 208, 255, 94, 165, 209, 255, 94, 165, 209, 255, 94, 165, 209, 255, 95, 165, 209, 255, 95, 165, 209, 255, 95, 166, 209, 255, 95, 166, 209, 255, 96, 166, 209, 255, 96, 166, 209, 255, 96, 166, 209, 255, 96, 166, 210, 255, 97, 167, 210, 255, 97, 167, 210, 255, 97, 167, 210, 255, 97, 167, 210, 255, 98, 167, 210, 255, 98, 168, 210, 255, 98, 168, 210, 255, 99, 168, 210, 255, 99, 168, 210, 255, 99, 168, 211, 255, 99, 168, 211, 255, 100, 169, 211, 255, 100, 169, 211, 255, 100, 169, 211, 255, 100, 169, 211, 255, 101, 169, 211, 255, 101, 169, 211, 255, 101, 170, 211, 255, 101, 170, 211, 255, 102, 170, 212, 255, 102, 170, 212, 255, 102, 170, 212, 255, 102, 171, 212, 255, 103, 171, 212, 255, 103, 171, 212, 255, 103, 171, 212, 255, 103, 171, 212, 255, 104, 171, 212, 255, 104, 172, 212, 255, 104, 172, 212, 255, 104, 172, 213, 255, 105, 172, 213, 255, 105, 172, 213, 255, 105, 172, 213, 255, 105, 173, 213, 255, 106, 173, 213, 255, 106, 173, 213, 255, 106, 173, 213, 255, 106, 173, 213, 255, 107, 174, 214, 255, 107, 174, 214, 255, 107, 174, 214, 255, 107, 174, 214, 255, 108, 174, 214, 255, 108, 174, 214, 255, 108, 175, 214, 255, 109, 175, 214, 255, 109, 175, 214, 255, 109, 175, 214, 255, 110, 175, 214, 255, 110, 175, 214, 255, 110, 176, 214, 255, 111, 176, 214, 255, 111, 176, 214, 255, 111, 176, 214, 255, 112, 176, 215, 255, 112, 177, 215, 255, 112, 177, 215, 255, 113, 177, 215, 255, 113, 177, 215, 255, 113, 177, 215, 255, 114, 177, 215, 255, 114, 178, 215, 255, 114, 178, 215, 255, 115, 178, 215, 255, 115, 178, 215, 255, 115, 178, 215, 255, 116, 178, 215, 255, 116, 179, 215, 255, 116, 179, 215, 255, 117, 179, 216, 255, 117, 179, 216, 255, 117, 179, 216, 255, 118, 179, 216, 255, 118, 180, 216, 255, 118, 180, 216, 255, 119, 180, 216, 255, 119, 180, 216, 255, 119, 180, 216, 255, 119, 181, 216, 255, 120, 181, 216, 255, 120, 181, 216, 255, 120, 181, 216, 255, 121, 181, 216, 255, 121, 181, 216, 255, 121, 182, 217, 255, 122, 182, 217, 255, 122, 182, 217, 255, 122, 182, 217, 255, 123, 182, 217, 255, 123, 182, 217, 255, 123, 183, 217, 255, 124, 183, 217, 255, 124, 183, 217, 255, 124, 183, 217, 255, 125, 183, 217, 255, 125, 184, 217, 255, 125, 184, 217, 255, 126, 184, 217, 255, 126, 184, 217, 255, 126, 184, 218, 255, 126, 184, 218, 255, 127, 185, 218, 255, 137, 190, 220, 255, 138, 191, 220, 255, 138, 191, 220, 255, 138, 191, 220, 255, 139, 191, 220, 255, 139, 191, 220, 255, 139, 191, 220, 255, 140, 192, 220, 255, 140, 192, 221, 255, 140, 192, 221, 255, 140, 192, 221, 255, 141, 192, 221, 255, 141, 192, 221, 255, 141, 193, 221, 255, 142, 193, 221, 255, 142, 193, 221, 255, 142, 193, 221, 255, 143, 193, 221, 255, 143, 194, 221, 255, 143, 194, 221, 255, 144, 194, 221, 255, 144, 194, 221, 255, 144, 194, 221, 255, 145, 194, 222, 255, 145, 195, 222, 255, 145, 195, 222, 255, 146, 195, 222, 255, 146, 195, 222, 255, 146, 195, 222, 255, 146, 195, 222, 255, 147, 196, 222, 255, 147, 196, 222, 255, 147, 196, 222, 255, 148, 196, 222, 255, 148, 196, 222, 255, 148, 196, 222, 255, 149, 197, 222, 255, 149, 197, 223, 255, 149, 197, 223, 255, 150, 197, 223, 255, 150, 197, 223, 255, 150, 198, 223, 255, 151, 198, 223, 255, 151, 198, 223, 255, 151, 198, 223, 255, 152, 198, 223, 255, 152, 198, 223, 255, 152, 199, 223, 255, 152, 199, 223, 255, 153, 199, 223, 255, 153, 199, 223, 255, 153, 199, 224, 255, 154, 199, 224, 255, 154, 200, 224, 255, 154, 200, 224, 255, 155, 200, 224, 255, 155, 200, 224, 255, 155, 200, 224, 255, 156, 200, 224, 255, 156, 201, 224, 255, 156, 201, 224, 255, 157, 201, 224, 255, 157, 201, 224, 255, 157, 201, 224, 255, 157, 202, 224, 255, 158, 202, 225, 255, 158, 202, 225, 255, 158, 202, 225, 255, 159, 202, 225, 255, 159, 202, 225, 255, 159, 202, 225, 255, 159, 202, 225, 255, 160, 202, 225, 255, 160, 202, 225, 255, 160, 203, 226, 255, 160, 203, 226, 255, 161, 203, 226, 255, 161, 203, 226, 255, 161, 203, 226, 255, 161, 203, 226, 255, 162, 203, 226, 255, 162, 203, 226, 255, 162, 203, 226, 255, 163, 203, 226, 255, 163, 204, 226, 255, 163, 204, 227, 255, 163, 204, 227, 255, 164, 204, 227, 255, 164, 204, 227, 255, 164, 204, 227, 255, 164, 204, 227, 255, 165, 204, 227, 255, 165, 204, 227, 255, 165, 204, 227, 255, 165, 205, 227, 255, 166, 205, 228, 255, 166, 205, 228, 255, 166, 205, 228, 255, 166, 205, 228, 255, 167, 205, 228, 255, 167, 205, 228, 255, 167, 205, 228, 255, 167, 205, 228, 255, 168, 206, 228, 255, 168, 206, 228, 255, 168, 206, 228, 255, 168, 206, 229, 255, 169, 206, 229, 255, 169, 206, 229, 255, 169, 206, 229, 255, 170, 206, 229, 255, 170, 206, 229, 255, 170, 206, 229, 255, 170, 207, 229, 255, 171, 207, 229, 255, 171, 207, 229, 255, 171, 207, 229, 255, 171, 207, 230, 255, 172, 207, 230, 255, 172, 207, 230, 255, 172, 207, 230, 255, 172, 207, 230, 255, 173, 208, 230, 255, 173, 208, 230, 255, 173, 208, 230, 255, 173, 208, 230, 255, 174, 208, 230, 255, 174, 208, 230, 255, 182, 212, 233, 255, 182, 212, 233, 255, 183, 212, 234, 255, 183, 212, 234, 255, 183, 212, 234, 255, 183, 212, 234, 255, 184, 212, 234, 255, 184, 212, 234, 255, 184, 212, 234, 255, 184, 213, 234, 255, 185, 213, 234, 255, 185, 213, 234, 255, 185, 213, 234, 255, 185, 213, 234, 255, 186, 213, 235, 255, 186, 213, 235, 255, 186, 213, 235, 255, 186, 213, 235, 255, 187, 213, 235, 255, 187, 214, 235, 255, 187, 214, 235, 255, 187, 214, 235, 255, 187, 214, 235, 255, 188, 214, 235, 255, 188, 214, 235, 255, 188, 214, 235, 255, 188, 214, 236, 255, 189, 214, 236, 255, 189, 215, 236, 255, 189, 215, 236, 255, 189, 215, 236, 255, 190, 215, 236, 255, 190, 215, 236, 255, 190, 215, 236, 255, 190, 215, 236, 255, 191, 215, 236, 255, 191, 215, 236, 255, 191, 216, 236, 255, 191, 216, 236, 255, 192, 216, 237, 255, 192, 216, 237, 255, 192, 216, 237, 255, 192, 216, 237, 255, 193, 216, 237, 255, 193, 216, 237, 255, 193, 216, 237, 255, 193, 217, 237, 255, 194, 217, 237, 255, 194, 217, 237, 255, 194, 217, 237, 255, 194, 217, 237, 255, 194, 217, 238, 255, 195, 217, 238, 255, 195, 217, 238, 255, 195, 217, 238, 255, 195, 218, 238, 255, 196, 218, 238, 255, 196, 218, 238, 255, 196, 218, 238, 255, 196, 218, 238, 255, 197, 218, 238, 255, 197, 218, 238, 255, 197, 218, 238, 255, 197, 218, 238, 255, 197, 219, 238, 255, 198, 219, 239, 255, 198, 219, 239, 255, 198, 219, 239, 255, 198, 219, 239, 255, 198, 219, 239, 255, 198, 219, 239, 255, 199, 219, 239, 255, 199, 219, 239, 255, 199, 219, 239, 255, 199, 219, 239, 255, 199, 220, 239, 255, 199, 220, 239, 255, 199, 220, 239, 255, 200, 220, 239, 255, 200, 220, 239, 255, 200, 220, 239, 255, 200, 220, 239, 255, 200, 220, 239, 255, 200, 220, 239, 255, 200, 220, 239, 255, 201, 221, 240, 255, 201, 221, 240, 255, 201, 221, 240, 255, 201, 221, 240, 255, 201, 221, 240, 255, 201, 221, 240, 255, 202, 221, 240, 255, 202, 221, 240, 255, 202, 221, 240, 255, 202, 221, 240, 255, 202, 222, 240, 255, 202, 222, 240, 255, 202, 222, 240, 255, 203, 222, 240, 255, 203, 222, 240, 255, 203, 222, 240, 255, 203, 222, 240, 255, 203, 222, 240, 255, 203, 222, 240, 255, 203, 222, 240, 255, 204, 223, 241, 255, 204, 223, 241, 255, 204, 223, 241, 255, 204, 223, 241, 255, 204, 223, 241, 255, 204, 223, 241, 255, 205, 223, 241, 255, 205, 223, 241, 255, 205, 223, 241, 255, 205, 223, 241, 255, 205, 224, 241, 255, 205, 224, 241, 255, 205, 224, 241, 255, 206, 224, 241, 255, 206, 224, 241, 255, 206, 224, 241, 255, 206, 224, 241, 255, 206, 224, 241, 255, 206, 224, 241, 255, 206, 224, 241, 255, 207, 225, 242, 255, 207, 225, 242, 255, 207, 225, 242, 255, 212, 228, 243, 255, 212, 228, 243, 255, 212, 228, 243, 255, 212, 228, 243, 255, 212, 228, 243, 255, 213, 229, 244, 255, 213, 229, 244, 255, 213, 229, 244, 255, 213, 229, 244, 255, 213, 229, 244, 255, 213, 229, 244, 255, 214, 229, 244, 255, 214, 229, 244, 255, 214, 229, 244, 255, 214, 229, 244, 255, 214, 230, 244, 255, 214, 230, 244, 255, 214, 230, 244, 255, 215, 230, 244, 255, 215, 230, 244, 255, 215, 230, 244, 255, 215, 230, 244, 255, 215, 230, 244, 255, 215, 230, 244, 255, 215, 230, 244, 255, 216, 231, 245, 255, 216, 231, 245, 255, 216, 231, 245, 255, 216, 231, 245, 255, 216, 231, 245, 255, 216, 231, 245, 255, 217, 231, 245, 255, 217, 231, 245, 255, 217, 231, 245, 255, 217, 231, 245, 255, 217, 232, 245, 255, 217, 232, 245, 255, 217, 232, 245, 255, 218, 232, 245, 255, 218, 232, 245, 255, 218, 232, 245, 255, 218, 232, 245, 255, 218, 232, 245, 255, 218, 232, 245, 255, 218, 232, 245, 255, 219, 233, 246, 255, 219, 233, 246, 255, 219, 233, 246, 255, 219, 233, 246, 255, 219, 233, 246, 255, 219, 233, 246, 255, 220, 233, 246, 255, 220, 233, 246, 255, 220, 233, 246, 255, 220, 233, 246, 255, 220, 234, 246, 255, 220, 234, 246, 255, 220, 234, 246, 255, 221, 234, 246, 255, 221, 234, 246, 255, 221, 234, 246, 255, 221, 234, 246, 255, 221, 234, 246, 255, 221, 234, 246, 255, 221, 235, 246, 255, 222, 235, 247, 255, 222, 235, 247, 255, 222, 235, 247, 255, 222, 235, 247, 255, 222, 235, 247, 255, 222, 235, 247, 255, 223, 235, 247, 255, 223, 235, 247, 255, 223, 235, 247, 255, 223, 235, 247, 255, 223, 236, 247, 255, 223, 236, 247, 255, 224, 236, 247, 255, 224, 236, 247, 255, 224, 236, 247, 255, 224, 236, 247, 255, 224, 236, 247, 255, 224, 236, 247, 255, 224, 236, 247, 255, 225, 236, 248, 255, 225, 237, 248, 255, 225, 237, 248, 255, 225, 237, 248, 255, 225, 237, 248, 255, 225, 237, 248, 255, 226, 237, 248, 255, 226, 237, 248, 255, 226, 237, 248, 255, 226, 237, 248, 255, 226, 237, 248, 255, 226, 238, 248, 255, 227, 238, 248, 255, 227, 238, 248, 255, 227, 238, 248, 255, 227, 238, 248, 255, 227, 238, 248, 255, 227, 238, 248, 255, 227, 238, 248, 255, 228, 238, 248, 255, 228, 238, 249, 255, 228, 239, 249, 255, 228, 239, 249, 255, 228, 239, 249, 255, 228, 239, 249, 255, 229, 239, 249, 255, 229, 239, 249, 255, 229, 239, 249, 255, 229, 239, 249, 255, 229, 239, 249, 255, 229, 239, 249, 255, 230, 240, 249, 255, 230, 240, 249, 255, 230, 240, 249, 255, 230, 240, 249, 255, 230, 240, 249, 255, 230, 240, 249, 255, 230, 240, 249, 255, 231, 240, 249, 255, 231, 240, 249, 255, 231, 240, 250, 255, 231, 241, 250, 255, 231, 241, 250, 255, 231, 241, 250, 255, 237, 244, 251, 255, 237, 244, 251, 255, 237, 244, 251, 255, 237, 244, 251, 255, 237, 244, 252, 255, 237, 245, 252, 255, 237, 245, 252, 255, 238, 245, 252, 255, 238, 245, 252, 255, 238, 245, 252, 255, 238, 245, 252, 255, 238, 245, 252, 255, 238, 245, 252, 255, 239, 245, 252, 255, 239, 245, 252, 255, 239, 246, 252, 255, 239, 246, 252, 255, 239, 246, 252, 255, 239, 246, 252, 255, 240, 246, 252, 255, 240, 246, 252, 255, 240, 246, 252, 255, 240, 246, 252, 255, 240, 246, 252, 255, 240, 246, 253, 255, 240, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 242, 247, 253, 255, 242, 247, 253, 255, 242, 247, 253, 255, 242, 248, 253, 255, 242, 248, 253, 255, 242, 248, 253, 255, 242, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 245, 249, 254, 255, 245, 249, 254, 255, 245, 249, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Blues_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 8, 47, 107, 0, 8, 49, 109, 24, 8, 51, 112, 49, 9, 53, 115, 74, 9, 55, 118, 99, 9, 57, 121, 124, 9, 59, 124, 149, 10, 68, 137, 174, 10, 70, 140, 199, 9, 72, 143, 224, 9, 74, 145, 249, 9, 76, 148, 255, 8, 77, 151, 255, 8, 79, 154, 255, 8, 81, 156, 255, 9, 83, 158, 255, 10, 85, 159, 255, 11, 86, 160, 255, 13, 88, 162, 255, 14, 90, 163, 255, 15, 92, 164, 255, 17, 93, 166, 255, 23, 101, 172, 255, 24, 103, 173, 255, 26, 104, 174, 255, 27, 106, 176, 255, 28, 108, 177, 255, 30, 109, 178, 255, 31, 111, 179, 255, 32, 112, 180, 255, 34, 114, 181, 255, 35, 116, 182, 255, 36, 117, 183, 255, 38, 119, 184, 255, 39, 120, 185, 255, 40, 122, 186, 255, 42, 123, 186, 255, 43, 125, 187, 255, 51, 133, 191, 255, 53, 134, 192, 255, 54, 136, 193, 255, 56, 137, 193, 255, 58, 139, 194, 255, 59, 140, 195, 255, 61, 141, 196, 255, 62, 143, 196, 255, 64, 144, 197, 255, 65, 145, 197, 255, 67, 147, 198, 255, 69, 148, 199, 255, 71, 149, 199, 255, 72, 150, 200, 255, 74, 151, 201, 255, 76, 152, 201, 255, 77, 153, 202, 255, 79, 154, 203, 255, 80, 155, 203, 255, 82, 156, 204, 255, 92, 163, 208, 255, 93, 164, 208, 255, 95, 165, 209, 255, 96, 166, 209, 255, 97, 167, 210, 255, 99, 168, 210, 255, 100, 169, 211, 255, 102, 170, 212, 255, 103, 171, 212, 255, 104, 172, 213, 255, 106, 173, 213, 255, 107, 174, 214, 255, 109, 175, 214, 255, 111, 176, 214, 255, 112, 177, 215, 255, 114, 178, 215, 255, 116, 178, 215, 255, 117, 179, 216, 255, 119, 180, 216, 255, 121, 181, 216, 255, 122, 182, 217, 255, 124, 183, 217, 255, 125, 184, 217, 255, 127, 185, 218, 255, 138, 191, 220, 255, 140, 192, 221, 255, 141, 193, 221, 255, 143, 193, 221, 255, 144, 194, 221, 255, 146, 195, 222, 255, 147, 196, 222, 255, 149, 197, 222, 255, 150, 197, 223, 255, 151, 198, 223, 255, 153, 199, 223, 255, 154, 200, 224, 255, 155, 200, 224, 255, 157, 201, 224, 255, 158, 202, 225, 255, 159, 202, 225, 255, 160, 202, 225, 255, 161, 203, 226, 255, 162, 203, 226, 255, 163, 204, 227, 255, 164, 204, 227, 255, 165, 205, 227, 255, 166, 205, 228, 255, 167, 205, 228, 255, 168, 206, 228, 255, 169, 206, 229, 255, 170, 206, 229, 255, 171, 207, 229, 255, 172, 207, 230, 255, 173, 208, 230, 255, 174, 208, 230, 255, 183, 212, 234, 255, 183, 212, 234, 255, 184, 213, 234, 255, 185, 213, 234, 255, 186, 213, 235, 255, 187, 214, 235, 255, 188, 214, 235, 255, 188, 214, 235, 255, 189, 215, 236, 255, 190, 215, 236, 255, 191, 215, 236, 255, 191, 216, 237, 255, 192, 216, 237, 255, 193, 216, 237, 255, 194, 217, 237, 255, 194, 217, 237, 255, 195, 217, 238, 255, 196, 218, 238, 255, 196, 218, 238, 255, 197, 218, 238, 255, 198, 219, 239, 255, 198, 219, 239, 255, 199, 219, 239, 255, 199, 219, 239, 255, 199, 220, 239, 255, 200, 220, 239, 255, 200, 220, 239, 255, 201, 221, 240, 255, 201, 221, 240, 255, 201, 221, 240, 255, 202, 221, 240, 255, 202, 222, 240, 255, 203, 222, 240, 255, 203, 222, 240, 255, 203, 222, 240, 255, 204, 223, 241, 255, 204, 223, 241, 255, 204, 223, 241, 255, 205, 223, 241, 255, 205, 224, 241, 255, 205, 224, 241, 255, 206, 224, 241, 255, 206, 224, 241, 255, 206, 224, 241, 255, 207, 225, 242, 255, 212, 228, 243, 255, 212, 228, 243, 255, 213, 229, 244, 255, 213, 229, 244, 255, 213, 229, 244, 255, 214, 229, 244, 255, 214, 229, 244, 255, 214, 230, 244, 255, 214, 230, 244, 255, 215, 230, 244, 255, 215, 230, 244, 255, 215, 230, 244, 255, 216, 231, 245, 255, 216, 231, 245, 255, 216, 231, 245, 255, 217, 231, 245, 255, 217, 231, 245, 255, 217, 232, 245, 255, 217, 232, 245, 255, 218, 232, 245, 255, 218, 232, 245, 255, 218, 232, 245, 255, 218, 232, 245, 255, 219, 233, 246, 255, 219, 233, 246, 255, 219, 233, 246, 255, 219, 233, 246, 255, 220, 233, 246, 255, 220, 234, 246, 255, 220, 234, 246, 255, 220, 234, 246, 255, 221, 234, 246, 255, 221, 234, 246, 255, 221, 234, 246, 255, 221, 234, 246, 255, 222, 235, 247, 255, 222, 235, 247, 255, 222, 235, 247, 255, 222, 235, 247, 255, 223, 235, 247, 255, 223, 235, 247, 255, 223, 235, 247, 255, 223, 236, 247, 255, 224, 236, 247, 255, 224, 236, 247, 255, 224, 236, 247, 255, 224, 236, 247, 255, 224, 236, 247, 255, 225, 236, 247, 255, 225, 237, 248, 255, 225, 237, 248, 255, 225, 237, 248, 255, 225, 237, 248, 255, 226, 237, 248, 255, 226, 237, 248, 255, 226, 237, 248, 255, 226, 237, 248, 255, 226, 238, 248, 255, 227, 238, 248, 255, 227, 238, 248, 255, 227, 238, 248, 255, 227, 238, 248, 255, 227, 238, 248, 255, 227, 238, 248, 255, 228, 238, 248, 255, 228, 238, 249, 255, 228, 239, 249, 255, 228, 239, 249, 255, 228, 239, 249, 255, 229, 239, 249, 255, 229, 239, 249, 255, 229, 239, 249, 255, 229, 239, 249, 255, 229, 239, 249, 255, 229, 239, 249, 255, 229, 240, 249, 255, 230, 240, 249, 255, 230, 240, 249, 255, 230, 240, 249, 255, 230, 240, 249, 255, 230, 240, 249, 255, 230, 240, 249, 255, 230, 240, 249, 255, 231, 240, 249, 255, 231, 240, 249, 255, 231, 240, 250, 255, 231, 241, 250, 255, 231, 241, 250, 255, 231, 241, 250, 255, 231, 241, 250, 255, 237, 244, 251, 255, 237, 244, 251, 255, 237, 244, 251, 255, 237, 244, 251, 255, 237, 244, 251, 255, 237, 244, 252, 255, 237, 245, 252, 255, 237, 245, 252, 255, 238, 245, 252, 255, 238, 245, 252, 255, 238, 245, 252, 255, 238, 245, 252, 255, 238, 245, 252, 255, 238, 245, 252, 255, 238, 245, 252, 255, 238, 245, 252, 255, 238, 245, 252, 255, 239, 245, 252, 255, 239, 245, 252, 255, 239, 245, 252, 255, 239, 246, 252, 255, 239, 246, 252, 255, 239, 246, 252, 255, 239, 246, 252, 255, 239, 246, 252, 255, 239, 246, 252, 255, 239, 246, 252, 255, 240, 246, 252, 255, 240, 246, 252, 255, 240, 246, 252, 255, 240, 246, 252, 255, 240, 246, 252, 255, 240, 246, 252, 255, 240, 246, 252, 255, 240, 246, 252, 255, 240, 246, 252, 255, 240, 246, 253, 255, 240, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 241, 247, 253, 255, 242, 247, 253, 255, 242, 247, 253, 255, 242, 247, 253, 255, 242, 247, 253, 255, 242, 247, 253, 255, 242, 247, 253, 255, 242, 248, 253, 255, 242, 248, 253, 255, 242, 248, 253, 255, 242, 248, 253, 255, 242, 248, 253, 255, 242, 248, 253, 255, 242, 248, 253, 255, 242, 248, 253, 255, 242, 248, 253, 255, 242, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 253, 255, 243, 248, 254, 255, 243, 249, 254, 255, 243, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 244, 249, 254, 255, 245, 249, 254, 255, 245, 249, 254, 255, 245, 249, 254, 255, 245, 249, 254, 255, 245, 249, 254, 255, 245, 249, 254, 255, 245, 249, 254, 255, 245, 249, 254, 255, 245, 249, 254, 255, 245, 249, 254, 255, 245, 249, 254, 255, 245, 249, 254, 255, 245, 249, 254, 255, 245, 249, 254, 255, 245, 249, 254, 255, 245, 249, 254, 255, 245, 249, 254, 255, 245, 249, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 245, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 250, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255, 246, 251, 254, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Blues_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
