#version 120
precision mediump int;
precision mediump float;

varying vec2 uv;

uniform sampler2D inRTT;
uniform vec2 texelSize;

void main()
{
  vec3 accum = vec3(0.0, 0.0, 0.0);

	vec2 texOffset[16] =
  {
		-1.5, -1.5,
		-0.5, -1.5,
		 0.5, -1.5,
		 1.5, -1.5,
		 
		-1.5, -0.5,
		-0.5, -0.5,
		 0.5, -0.5,
		 1.5, -0.5,
		 
		-1.5, 0.5,
		-0.5, 0.5,
		 0.5, 0.5,
		 1.5, 0.5,
		 
		-1.5, 1.5,
		-0.5, 1.5,
		 0.5, 1.5,
		 1.5, 1.5
	};

	for( int i = 0; i < 16; i++ )
  {
    // Get colour from source
    accum += texture2D(inRTT, uv + texelSize * texOffset[i]);
  }
  
	// take average of 16 samples
	accum *= 0.0625;
  
  // Divide the sum to complete the average, and perform an exp() to complete
  // the average luminance calculation
  // min / max white
  return vec4(clamp(accum, 0.4, 0.7), 1.0);
}