; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt --mtriple=aarch64-unknown-linux -S -passes=instcombine < %s | FileCheck %s
; ARM64 neon intrinsic variants - <rdar://problem/12349617>

define <4 x i32> @mulByZeroARM64(<4 x i16> %x) nounwind readnone ssp {
; CHECK-LABEL: define <4 x i32> @mulByZeroARM64(
; CHECK-SAME: <4 x i16> [[X:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <4 x i32> zeroinitializer
;
entry:
  %a = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %x, <4 x i16> zeroinitializer) nounwind
  ret <4 x i32> %a
}

define <4 x i32> @mulByOneARM64(<4 x i16> %x) nounwind readnone ssp {
; CHECK-LABEL: define <4 x i32> @mulByOneARM64(
; CHECK-SAME: <4 x i16> [[X:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[A:%.*]] = sext <4 x i16> [[X]] to <4 x i32>
; CHECK-NEXT:    ret <4 x i32> [[A]]
;
entry:
  %a = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> %x, <4 x i16> <i16 1, i16 1, i16 1, i16 1>) nounwind
  ret <4 x i32> %a
}

define <4 x i32> @constantMulARM64() nounwind readnone ssp {
; CHECK-LABEL: define <4 x i32> @constantMulARM64(
; CHECK-SAME: ) #[[ATTR0]] {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <4 x i32> splat (i32 6)
;
entry:
  %a = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> <i16 3, i16 3, i16 3, i16 3>, <4 x i16> <i16 2, i16 2, i16 2, i16 2>) nounwind
  ret <4 x i32> %a
}

define <4 x i32> @constantMulSARM64() nounwind readnone ssp {
; CHECK-LABEL: define <4 x i32> @constantMulSARM64(
; CHECK-SAME: ) #[[ATTR0]] {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <4 x i32> splat (i32 -1)
;
entry:
  %b = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> <i16 -1, i16 -1, i16 -1, i16 -1>, <4 x i16> <i16 1, i16 1, i16 1, i16 1>) nounwind
  ret <4 x i32> %b
}

define <4 x i32> @constantMulUARM64() nounwind readnone ssp {
; CHECK-LABEL: define <4 x i32> @constantMulUARM64(
; CHECK-SAME: ) #[[ATTR0]] {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <4 x i32> splat (i32 65535)
;
entry:
  %b = tail call <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16> <i16 -1, i16 -1, i16 -1, i16 -1>, <4 x i16> <i16 1, i16 1, i16 1, i16 1>) nounwind
  ret <4 x i32> %b
}

define <4 x i32> @complex1ARM64(<4 x i16> %x) nounwind readnone ssp {
; CHECK-LABEL: define <4 x i32> @complex1ARM64(
; CHECK-SAME: <4 x i16> [[X:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[A:%.*]] = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> splat (i16 2), <4 x i16> [[X]]) #[[ATTR2:[0-9]+]]
; CHECK-NEXT:    ret <4 x i32> [[A]]
;
entry:
  %a = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> <i16 2, i16 2, i16 2, i16 2>, <4 x i16> %x) nounwind
  %b = add <4 x i32> zeroinitializer, %a
  ret <4 x i32> %b
}

define <4 x i32> @complex2ARM64(<4 x i32> %x) nounwind readnone ssp {
; CHECK-LABEL: define <4 x i32> @complex2ARM64(
; CHECK-SAME: <4 x i32> [[X:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[B:%.*]] = add <4 x i32> [[X]], splat (i32 6)
; CHECK-NEXT:    ret <4 x i32> [[B]]
;
entry:
  %a = tail call <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16> <i16 3, i16 3, i16 3, i16 3>, <4 x i16> <i16 2, i16 2, i16 2, i16 2>) nounwind
  %b = add <4 x i32> %x, %a
  ret <4 x i32> %b
}

declare <4 x i32> @llvm.aarch64.neon.smull.v4i32(<4 x i16>, <4 x i16>) nounwind readnone
declare <4 x i32> @llvm.aarch64.neon.umull.v4i32(<4 x i16>, <4 x i16>) nounwind readnone

; CHECK: attributes #0 = { nounwind ssp memory(none) }
; CHECK: attributes #1 = { nocallback nofree nosync nounwind willreturn memory(none) }
