; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64 -mattr=+sve < %s -o - | FileCheck --check-prefix=SVE %s
; RUN: llc -mtriple=aarch64 -mattr=+sve2 < %s -o - | FileCheck --check-prefix=SVE2 %s

define <vscale x 16 x i8> @eor3_nxv16i8_left(<vscale x 16 x i8> %0, <vscale x 16 x i8> %1, <vscale x 16 x i8> %2) {
; SVE-LABEL: eor3_nxv16i8_left:
; SVE:       // %bb.0:
; SVE-NEXT:    eor z0.d, z0.d, z1.d
; SVE-NEXT:    eor z0.d, z0.d, z2.d
; SVE-NEXT:    ret
;
; SVE2-LABEL: eor3_nxv16i8_left:
; SVE2:       // %bb.0:
; SVE2-NEXT:    eor3 z0.d, z0.d, z1.d, z2.d
; SVE2-NEXT:    ret
  %4 = xor <vscale x 16 x i8> %0, %1
  %5 = xor <vscale x 16 x i8> %4, %2
  ret <vscale x 16 x i8> %5
}

define <vscale x 16 x i8> @eor3_nxv16i8_right(<vscale x 16 x i8> %0, <vscale x 16 x i8> %1, <vscale x 16 x i8> %2) {
; SVE-LABEL: eor3_nxv16i8_right:
; SVE:       // %bb.0:
; SVE-NEXT:    eor z0.d, z0.d, z1.d
; SVE-NEXT:    eor z0.d, z2.d, z0.d
; SVE-NEXT:    ret
;
; SVE2-LABEL: eor3_nxv16i8_right:
; SVE2:       // %bb.0:
; SVE2-NEXT:    eor3 z2.d, z2.d, z0.d, z1.d
; SVE2-NEXT:    mov z0.d, z2.d
; SVE2-NEXT:    ret
  %4 = xor <vscale x 16 x i8> %0, %1
  %5 = xor <vscale x 16 x i8> %2, %4
  ret <vscale x 16 x i8> %5
}

define <vscale x 8 x i16> @eor3_nxv8i16_left(<vscale x 8 x i16> %0, <vscale x 8 x i16> %1, <vscale x 8 x i16> %2) {
; SVE-LABEL: eor3_nxv8i16_left:
; SVE:       // %bb.0:
; SVE-NEXT:    eor z0.d, z0.d, z1.d
; SVE-NEXT:    eor z0.d, z0.d, z2.d
; SVE-NEXT:    ret
;
; SVE2-LABEL: eor3_nxv8i16_left:
; SVE2:       // %bb.0:
; SVE2-NEXT:    eor3 z0.d, z0.d, z1.d, z2.d
; SVE2-NEXT:    ret
  %4 = xor <vscale x 8 x i16> %0, %1
  %5 = xor <vscale x 8 x i16> %4, %2
  ret <vscale x 8 x i16> %5
}

define <vscale x 8 x i16> @eor3_nxv8i16_right(<vscale x 8 x i16> %0, <vscale x 8 x i16> %1, <vscale x 8 x i16> %2) {
; SVE-LABEL: eor3_nxv8i16_right:
; SVE:       // %bb.0:
; SVE-NEXT:    eor z0.d, z0.d, z1.d
; SVE-NEXT:    eor z0.d, z2.d, z0.d
; SVE-NEXT:    ret
;
; SVE2-LABEL: eor3_nxv8i16_right:
; SVE2:       // %bb.0:
; SVE2-NEXT:    eor3 z2.d, z2.d, z0.d, z1.d
; SVE2-NEXT:    mov z0.d, z2.d
; SVE2-NEXT:    ret
  %4 = xor <vscale x 8 x i16> %0, %1
  %5 = xor <vscale x 8 x i16> %2, %4
  ret <vscale x 8 x i16> %5
}

define <vscale x 4 x i32> @eor3_nxv4i32_left(<vscale x 4 x i32> %0, <vscale x 4 x i32> %1, <vscale x 4 x i32> %2) {
; SVE-LABEL: eor3_nxv4i32_left:
; SVE:       // %bb.0:
; SVE-NEXT:    eor z0.d, z0.d, z1.d
; SVE-NEXT:    eor z0.d, z0.d, z2.d
; SVE-NEXT:    ret
;
; SVE2-LABEL: eor3_nxv4i32_left:
; SVE2:       // %bb.0:
; SVE2-NEXT:    eor3 z0.d, z0.d, z1.d, z2.d
; SVE2-NEXT:    ret
  %4 = xor <vscale x 4 x i32> %0, %1
  %5 = xor <vscale x 4 x i32> %4, %2
  ret <vscale x 4 x i32> %5
}

define <vscale x 4 x i32> @eor3_nxv4i32_right(<vscale x 4 x i32> %0, <vscale x 4 x i32> %1, <vscale x 4 x i32> %2) {
; SVE-LABEL: eor3_nxv4i32_right:
; SVE:       // %bb.0:
; SVE-NEXT:    eor z0.d, z0.d, z1.d
; SVE-NEXT:    eor z0.d, z2.d, z0.d
; SVE-NEXT:    ret
;
; SVE2-LABEL: eor3_nxv4i32_right:
; SVE2:       // %bb.0:
; SVE2-NEXT:    eor3 z2.d, z2.d, z0.d, z1.d
; SVE2-NEXT:    mov z0.d, z2.d
; SVE2-NEXT:    ret
  %4 = xor <vscale x 4 x i32> %0, %1
  %5 = xor <vscale x 4 x i32> %2, %4
  ret <vscale x 4 x i32> %5
}

define <vscale x 2 x i64> @eor3_nxv2i64_left(<vscale x 2 x i64> %0, <vscale x 2 x i64> %1, <vscale x 2 x i64> %2) {
; SVE-LABEL: eor3_nxv2i64_left:
; SVE:       // %bb.0:
; SVE-NEXT:    eor z0.d, z0.d, z1.d
; SVE-NEXT:    eor z0.d, z0.d, z2.d
; SVE-NEXT:    ret
;
; SVE2-LABEL: eor3_nxv2i64_left:
; SVE2:       // %bb.0:
; SVE2-NEXT:    eor3 z0.d, z0.d, z1.d, z2.d
; SVE2-NEXT:    ret
  %4 = xor <vscale x 2 x i64> %0, %1
  %5 = xor <vscale x 2 x i64> %4, %2
  ret <vscale x 2 x i64> %5
}

define <vscale x 2 x i64> @eor3_nxv2i64_right(<vscale x 2 x i64> %0, <vscale x 2 x i64> %1, <vscale x 2 x i64> %2) {
; SVE-LABEL: eor3_nxv2i64_right:
; SVE:       // %bb.0:
; SVE-NEXT:    eor z0.d, z0.d, z1.d
; SVE-NEXT:    eor z0.d, z2.d, z0.d
; SVE-NEXT:    ret
;
; SVE2-LABEL: eor3_nxv2i64_right:
; SVE2:       // %bb.0:
; SVE2-NEXT:    eor3 z2.d, z2.d, z0.d, z1.d
; SVE2-NEXT:    mov z0.d, z2.d
; SVE2-NEXT:    ret
  %4 = xor <vscale x 2 x i64> %0, %1
  %5 = xor <vscale x 2 x i64> %2, %4
  ret <vscale x 2 x i64> %5
}

define <vscale x 2 x i64> @eor3_vnot(<vscale x 2 x i64> %0, <vscale x 2 x i64> %1) {
; SVE-LABEL: eor3_vnot:
; SVE:       // %bb.0:
; SVE-NEXT:    eor z0.d, z0.d, z1.d
; SVE-NEXT:    ret
;
; SVE2-LABEL: eor3_vnot:
; SVE2:       // %bb.0:
; SVE2-NEXT:    eor z0.d, z0.d, z1.d
; SVE2-NEXT:    ret
  %3 = xor <vscale x 2 x i64> %0, zeroinitializer
  %4 = xor <vscale x 2 x i64> %3, %1
  ret <vscale x 2 x i64> %4
}

